uniform float z_fractal;
varying vec3 coord;

void main()
{
	const float xpos = -1.02224;
	const float ypos = 0.37265;

	float x0 = coord.x;
	float y0 = coord.y;

	const float iter = 32.0;
	const float iter2 = iter / 4.0;

	float z0_r = 0.0;
	float z0_i = 0.0;
	float z1_r = 0.0;
	float z1_i = 0.0;
	float p_r = (x0 + xpos * z_fractal) / z_fractal;
	float p_i = (y0 + ypos * z_fractal) / z_fractal;
	float d = 0.0;

	float n;
	for (n=0.0; n<iter; n++)
	{
		z1_r = z0_r * z0_r - z0_i * z0_i + p_r;
		z1_i = 2.0 * z0_r * z0_i + p_i;
		d = sqrt(z1_i * z1_i + z1_r * z1_r);
		z0_r = z1_r;
		z0_i = z1_i;
		if (d > iter2) break;
	}

	float c = (n / iter);
	if (c==1.0) c = 0.0;

	float dd = pow((x0*x0 + 0.75 * y0*y0), 4.0);
	float dc = (16777216.0 * 4.0 * 262144.0) / dd;
	if (dc > 1.0) dc = 1.0;

	float r = 2.0 * dc * c;
	float g = 1.5 * dc * c;
	float b = 0.75 * c;
	float a = 1.0 * dc * c;

	vec4 color = vec4(r, g, b, a);
	gl_FragColor = color;
}
