############################################################################################################################
#
#   Project   :	'Stars' - A parallax-scrolling starfield example.
#
#   Module    :	Makefile.mak
#
#   Function  :	OPUSMAKE control file; descriptions on how to build the project.
#
#   Comment   :	My screen column width is 125.
#
#   Tab Stops :	5 9 13 ...
#   |   |   | ...
#
#   Written by Bob Koon (bob@onemanband.com)
#
############################################################################################################################

.SILENT			:
.SUFFIXES		:
.SUFFIXES		: .gb .obj .asm .inc .bin

############################################################################################################################
#   Project Symbols
############################################################################################################################

### Project Environment ####################################################################################################

PROJECT_NAME	= Stars.gb

SOURCE_DIR		= 
OBJECT_DIR		= 

.PATH.asm		: $(SOURCE_DIR)
.PATH.inc		: $(SOURCE_DIR)
.PATH.obj		: $(OBJECT_DIR)

### Development Tools ######################################################################################################

ASSEMBLER		= rgbasm
ASSEMBLER_OPTS	= -q
LINKER			= xlink
LINKER_OPTS		= -zFF
CARTMAKER		= rgbfix
CARTMAKER_OPTS	= -v -p32 -q


############################################################################################################################
#   Object Files
############################################################################################################################

OBJECT_FILES	= Stars.obj

SOURCE_FILES	= $(OBJECT_FILES,B,>.asm)

ASSEMBLER_OPTS	+= -o$(OBJECT_FILES,B).obj


############################################################################################################################
##	Project Manipulation
############################################################################################################################

$(PROJECT_NAME)	: $(OBJECT_FILES)
	$(LINKER) $(LINKER_OPTS) -m$(.TARGET,B).map -n$(.TARGET,B).sym << LinkFile
[Objects]
$(OBJECT_FILES,W\n)
[Output]
$(.TARGET)
<< KEEP
	$(CARTMAKER) $(CARTMAKER_OPTS) $(PROJECT_NAME)
	echo $(.TARGET) has been made successfully.


############################################################################################################################
#   Erase everything that's built
############################################################################################################################

clean			:
	- @if exist *.obj erase *.obj
	- @if exist *.gb erase *.gb
	- @if exist *.map erase *.map
	- @if exist *.sym erase *.sym
	- @if exist LinkFile erase LinkFile


############################################################################################################################
#   Build the dependencies automatically.
############################################################################################################################

depend			:
	mkmf -f $(INPUTFILE) $(OBJECT_FILES,F)

### OPUS MKMF:  Do not remove this line!  Generated dependencies follow.

Stars.obj: Hardware.inc StarDataTest.asm
