//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_WINDOW_H_
#define _NULSTEIN_WINDOW_H_

#include "Sono.h"
#include "Frame.h"
#include "Game.h"

#include "TaskScheduler.h"


class CNulsteinWindow
{
public:
	CNulsteinWindow();
	~CNulsteinWindow();
	
	bool Create(
				LPCTSTR 	lpWindowName, 
				DWORD		dwStyle,
				int			x,
				int			y,
				int			nWidth,
				int			nHeight,
				HWND		hWndParent,
				HMENU		hMenu,
				HINSTANCE	hInstance);
	
	bool Frame();
	
public:	/* internal */ 
	LRESULT WndProc(UINT message, WPARAM wParam, LPARAM lParam);
	void	Destroy();
	
public:
	static ATOM RegisterClass(HINSTANCE hInstance);
	static LRESULT CALLBACK _WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	
public:
	HINSTANCE		m_hInst;
	HWND			m_hWnd;
	
	CTaskPool		m_Tasks;
	CSono			m_Sono;
	CGfx			m_Gfx;
	CFrame			m_Frame;
	CGame			m_Game;
	
	bool			m_bInFrame;
};

#endif // _NULSTEIN_WINDOW_H_