//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "StdAfx.h"

#include "Gfx.h"
#include "Gfx/GfxLight.h"
#include "VSHBasic.h"

static
#include "shaders\VSHbasic.h"

IMPLEMENT_VERTEXSHADER(CVSHBasic)

bool CVSHBasic::Setup(CGfx* pGfx, const CMatrix& MtxModelToWorld, const CMatrix& MtxModelToScreen, const CLight* Light, unsigned LightCount)
{
	bool		bOk;
	CVector4	C[12];
	
	/* load shader (& vtx decl)*/ 
	bOk = SetupGfx(pGfx);
	IF_FAILED_RETURN(bOk);
	
	/* Model to Screen transform (->position) */ 
	C[0] = CVector4(MtxModelToScreen.m11, MtxModelToScreen.m12, MtxModelToScreen.m13, MtxModelToScreen.m14);
	C[1] = CVector4(MtxModelToScreen.m21, MtxModelToScreen.m22, MtxModelToScreen.m23, MtxModelToScreen.m24);
	C[2] = CVector4(MtxModelToScreen.m31, MtxModelToScreen.m32, MtxModelToScreen.m33, MtxModelToScreen.m34);
	C[3] = CVector4(MtxModelToScreen.m41, MtxModelToScreen.m42, MtxModelToScreen.m43, MtxModelToScreen.m44);
	
	/* World to Model transform (lights -> Model space) */ 
	MtxTransposeMulPoint(&C[4], Light[0].Pos, MtxModelToWorld);
	MtxTransposeMulPoint(&C[5], Light[1].Pos, MtxModelToWorld);
	MtxTransposeMulPoint(&C[6], Light[2].Pos, MtxModelToWorld);
	MtxTransposeMulPoint(&C[7], Light[3].Pos, MtxModelToWorld);
	
	/* setup constants */ 
	bOk = SetupConstants(pGfx, C, 8);
	IF_FAILED_RETURN(bOk);
	
	return true;	
}

