//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "StdAfx.h"

#include "Gfx.h"
#include "PSHBasic.h"

static
#include "shaders/PSHBasic.h"

IMPLEMENT_PIXELSHADER(CPSHBasic)

bool CPSHBasic::Setup(CGfx* pGfx, const CVector4& Tint)
{
	bool		bOk;
	CVector4	PSC[1];
	
	/* load shader */ 	
	bOk = SetupGfx(pGfx);
	IF_FAILED_RETURN(bOk);
	
	/* setup constants */ 
	PSC[0] = Tint; 
	
	bOk = SetupConstants(pGfx, PSC, 1);
	IF_FAILED_RETURN(bOk);
	
	return true;
}

