//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "StdAfx.h"
#include "Gfx.h"
#include "Mesh.h"

CMesh::CMesh()
{
	Free();
}

bool CMesh::Allocate(CGfx *pGfx, int VertexCount, int FaceCount, int VertexSize)
{
	HRESULT								hr;
	CComPtr<IDirect3DVertexBuffer9>		spVB;
	CComPtr<IDirect3DIndexBuffer9>		spIB;

	/* allocate DirectX stuff */ 
	hr = pGfx->m_spDevice->CreateVertexBuffer(VertexCount*VertexSize, D3DUSAGE_WRITEONLY, 0/*FVF*/, D3DPOOL_MANAGED, &spVB, NULL);
	IF_FAILED_RETURN(hr);
	
	hr = pGfx->m_spDevice->CreateIndexBuffer(FaceCount*3*sizeof(WORD), D3DUSAGE_WRITEONLY, D3DFMT_INDEX16, D3DPOOL_MANAGED, &spIB, NULL);
	IF_FAILED_RETURN(hr);

	/* all good, save values */ 
	m_spVB			= spVB;
	m_spIB			= spIB;
	m_VertexSize	= VertexSize;
	m_VertexCount	= VertexCount;
	m_FaceCount		= FaceCount;
	return true;
}

void CMesh::Free()
{
	m_spVB			= NULL;
	m_spIB			= NULL;
	m_VertexSize	= 0;
	m_VertexCount	= 0;
	m_FaceCount		= 0;
}

bool	CMesh::LockVertices(void** ppVtx, DWORD D3DFlags)
{
	HRESULT hr;
	
	hr = m_spVB->Lock(0,0, ppVtx, D3DFlags);
	IF_FAILED_RETURN(hr);
	
	return true;
}

bool	CMesh::UnlockVertices()
{
	HRESULT hr;
	
	hr = m_spVB->Unlock();
	IF_FAILED_RETURN(hr);
	
	return true;
}

bool CMesh::LockIndices(WORD** ppIdx, DWORD D3DFlags)
{
	HRESULT hr;
	
	hr = m_spIB->Lock(0,0, (VOID**)ppIdx, D3DFlags);
	IF_FAILED_RETURN(hr);
	
	return true;
}

bool	CMesh::UnlockIndices()
{
	HRESULT hr;
	
	hr = m_spIB->Unlock();
	IF_FAILED_RETURN(hr);
	
	return true;
}

bool CMesh::Draw(CGfx* pGfx, const CMatrix &MtxModelToWorld, const CVector4& Tint) const
{
	HRESULT				hr;
	CMatrix				MtxModelToScreen;
	IDirect3DDevice9*	pDevice = pGfx->m_spDevice;

	/* compute matrixes */ 
	MtxMul(&MtxModelToScreen, MtxModelToWorld, pGfx->m_MtxWorldToScreen);

	/* setup input data */ 
	hr = pDevice->SetStreamSource(0, m_spVB, 0, UINT(m_VertexSize));
	IF_FAILED_RETURN(hr);
	
	hr = pDevice->SetIndices(m_spIB);
	IF_FAILED_RETURN(hr);
	
	/* setup shaders */ 
	hr = pGfx->m_VSHBasic.Setup(pGfx, MtxModelToWorld, MtxModelToScreen, pGfx->m_Light, pGfx->m_LightCount);
	IF_FAILED_RETURN(hr);
	
	hr = pGfx->m_PSHBasic.Setup(pGfx, Tint);
	IF_FAILED_RETURN(hr);

	/* draw */ 
	hr = pDevice->DrawIndexedPrimitive(D3DPT_TRIANGLELIST, 0, 0, m_VertexCount, 0, m_FaceCount);
	IF_FAILED_RETURN(hr);
	
	return true;
}