//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_exp_ps(__m128 x)
{
	__asm
	{
		minps	xmm0, _ps_exp_hi
		movaps	xmm1, _ps_exp_rln2
		maxps	xmm0, _ps_exp_lo
		mulps	xmm1, xmm0
		xorps	xmm7, xmm7
		mov		ecx, esp
		addps	xmm1, _ps_am_0p5

		movaps	xmm2, xmm1

		cvttps2pi	mm0, xmm1
		cmpltps	xmm2, xmm7
		ASM_MOVE_H2L(xmm1)
		andps	xmm2, _ps_am_1
		cvttps2pi	mm1, xmm1
		movq	mm5, _pi32_0x7f

		cvtps2pi	mm2, xmm2  // needn't truncate
		ASM_MOVE_H2L(xmm2)
		cvtps2pi	mm3, xmm2  // needn't truncate

		psubd	mm0, mm2
		psubd	mm1, mm3
		and		ecx, ~15

		cvtpi2ps	xmm1, mm1
		ASM_MOVE_L2H(xmm1)
		paddd	mm1, mm5
		cvtpi2ps	xmm1, mm0
		paddd	mm0, mm5

		movaps	xmm2, xmm1
		mulps	xmm1, _ps_exp_c1
		mulps	xmm2, _ps_exp_c2
		subps	xmm0, xmm1
		pslld	mm0, 23
		subps	xmm0, xmm2
		pslld	mm1, 23

		movaps	xmm2, xmm0
		movq	[ecx - 16], mm0
		mulps	xmm2, xmm2
		movq	[ecx - 16 + 8], mm1

		movaps	xmm6, _ps_exp_q0
		movaps	xmm4, _ps_exp_p0

		mulps	xmm6, xmm2
		movaps	xmm7, _ps_exp_q1
		mulps	xmm4, xmm2
		movaps	xmm5, _ps_exp_p1

		addps	xmm6, xmm7
		addps	xmm4, xmm5

		movaps	xmm7, _ps_exp_q2
		mulps	xmm6, xmm2
		mulps	xmm4, xmm2

		addps	xmm6, xmm7
		mulps	xmm4, xmm0

		movaps	xmm7, _ps_exp_q3
		mulps	xmm6, xmm2
		addps	xmm4, xmm0
		addps	xmm6, xmm7
		movaps	xmm0, [ecx - 16]

		subps	xmm6, xmm4
		movaps	xmm7, _ps_am_1
		rcpps	xmm6, xmm6  
		mulps	xmm4, xmm6
		addps	xmm4, xmm4
		addps	xmm4, xmm7

		mulps	xmm0, xmm4

		ret		16
	}
}

#endif