format zx81
;labelusenumeric
;LISTOFF

	// hardware options to be set and change defaults in ZX81DEF.INC
	MEMAVL	   =	   MEM_1K	   // can be MEM_1K, MEM_2K, MEM_4K, MEM_8K, MEM_16K, MEM_32K, MEM_48K
					   // default value is MEM_16K
	STARTMODE  EQU	   SLOW_MODE	   // SLOW or FAST
	DFILETYPE  EQU	   COLLAPSED	   // COLLAPSED or EXPANDED or AUTO
	include '..\SINCL-ZX\ZX81.INC'	   // definitions of constants
;LISTON

	AUTOLINE 1

	REM	_asm
;########
StartPos		db	0
Position		db	0
SinPosition		db	0
FrameCounter		db	0
StackSave		dw	0
BarCounter		db	0
PosOffset		db	0
AddrOffset		db	0
BarMaskData		dw	0
BarPatternData		dw	0
RasterDataOriginal	dw	0
RasterDataAddr		dw	0

;########
GenerateRaster:
	ld	r,a	;9 load RasterData adress LSB
	repeat 32	;32 NOPs = 256 pixels
		nop	;4
	end repeat
	jp	(hl)	;4 return
			;9 + 128 + 4 = 141

;########
TextData:	dbzx	'NOLLKOLLTROLL VBAR8 ZX81 1K 2015'
		db	$76

;########
	align	16
BarMaskTable:
	db	%00000000,%11111111
	db	%10000000,%01111111
	db	%11000000,%00111111
	db	%11100000,%00011111
	db	%11110000,%00001111
	db	%11111000,%00000111
	db	%11111100,%00000011
	db	%11111110,%00000001
BarPatternTable:
	db	%10000011,%00000000
	db	%01000001,%10000000
	db	%00100000,%11000000
	db	%00010000,%01100000
	db	%00001000,%00110000
	db	%00000100,%00011000
	db	%00000010,%00001100
	db	%00000001,%00000110

;########
	align	256
SineTable:     ;sine table with values 0-248
	db	124,127,130,133,136,139,142,145
	db	148,151,154,157,160,163,166,169
	db	171,174,177,180,182,185,188,190
	db	193,195,198,200,203,205,207,210
	db	212,214,216,218,220,222,224,225
	db	227,229,230,232,233,235,236,237
	db	239,240,241,242,243,244,244,245
	db	246,246,247,247,247,248,248,248
	db	248,248,248,248,247,247,247,246
	db	246,245,244,244,243,242,241,240
	db	239,237,236,235,233,232,230,229
	db	227,225,224,222,220,218,216,214
	db	212,210,207,205,203,200,198,195
	db	193,190,188,185,182,180,177,174
	db	171,169,166,163,160,157,154,151
	db	148,145,142,139,136,133,130,127
	db	124,121,118,115,112,109,106,103
	db	100,97,94,91,88,85,82,79
	db	77,74,71,68,66,63,60,58
	db	55,53,50,48,45,43,41,38
	db	36,34,32,30,28,26,24,23
	db	21,19,18,16,15,13,12,11
	db	9,8,7,6,5,4,4,3
	db	2,2,1,1,1,0,0,0
	db	0,0,0,0,1,1,1,2
	db	2,3,4,4,5,6,7,8
	db	9,11,12,13,15,16,18,19
	db	21,23,24,26,28,30,32,34
	db	36,38,41,43,45,48,50,53
	db	55,58,60,63,66,68,71,74
	db	77,79,82,85,88,91,94,97
	db	100,103,106,109,112,115,118,121

;########
	align	32
RasterData:
	repeat 32	;32 bytes = 256 pixels
		db	%00000000
	end repeat
		db	0, 0	 ;extra padding

;########
RasterMagic:
	ld	(StackSave),sp	;Save ordinary stack
	ld	b,2		;delay
DelayLoop:
	djnz	DelayLoop	;delay
	ld	c,(hl)		;7 delay
	ld	c,(hl)		;7 delay

	ld	hl,RasterData	;graphics is located in RasterData
	ld	a,h		;RasterData address MSB
	ld	i,a		;load MSB into I register
	ld	a,l		;RasterData address LSB, later loaded to R register
	ld	sp,RasterStack	;init the raster-stack
NewRaster:
	pop	hl		;10 address
	pop	de		;10 data
	ld	(hl),e		;7 write lsb
	inc	hl		;6 inc address
	ld	(hl),d		;7 write msb
	inc	hl		;6 delay
	ld	hl,RepeatRaster ;10 init return address
	jp	GenerateRaster + $8000	;10 draw the raster
				;40 + 14 + 12 = 66
RepeatRaster:
	inc	hl		;6 delay
	inc	hl		;6 delay
	ld	c,(hl)		;7 delay
	ld	c,21		;7 set RepeatCounter
RepeatAgain:
	inc	ix		;10 delay
	inc	ix		;10 delay
	ld	hl,Counting	;10 init return address
	jp	GenerateRaster + $8000	  ;10 draw the raster
Counting:
	inc	hl		;6 delay
	inc	hl		;6 delay
	dec	c		;4 RepeatCounter
	jp	nz,RepeatAgain	;10/10
	inc	ix		;10 delay
	inc	ix		;10 delay
	pop	hl		;10 init return address
	jp	GenerateRaster + $8000	  ;10 draw the raster

MagicDone:
	ld	sp,(StackSave)	;20 restore ordinary stack
				;FRAME is updated at VSYNC, which is not what the code needs...
	ld	a,(FrameCounter)
	inc	a
	ld	(FrameCounter),a

	inc	ix		;10 delay
	inc	ix		;10 delay
	inc	ix		;10 delay
	add	hl,bc		;11 delay

	ld	bc,$0108	;1 row, 8 rasters
	ld	hl,TextData + $8000
	ld	a,$1e		;standard ROM-patterns
	ld	i,a		;restore text
	ld	a,$f5		;SLOW-mode value
	call	$2b5		;generate text
ReturnToBackground:
	call	$0292		;return to application program
	call	$0220		;extra register PUSH and VSYNC
	ld	ix,RasterMagic	;load the HR vector
	jp	$02A4		;return to application program

;########
EnableHires:
	ld	ix,RasterMagic	;simple start of the hires mode
MainLoop:
	ld	hl,FrameCounter
	ld	a,(hl)
BarSync:
	cp	(hl)
	jr	z,BarSync	;wait for a new frame before continuing

	call	ClearRasterData ;init RasterData before creating the RasterStack
	call	GenerateBars
	call	ClearRasterData ;init RasterData before drawing a new frame
	jp	MainLoop

;########
ClearRasterData:
	ld	hl,RasterData
	ld	a,0
	ld	b,32
ClearLoop:
	ld	(hl),a
	inc	hl
	djnz	ClearLoop
	ret

;########
GenerateBars:
	ld	hl,RasterStack
	ld	a,(StartPos)
	ld	(Position),a
	ld	a,8		;nr of bars
	ld	(BarCounter),a
BarLoop:
BarAddress:
	push	hl		;RasterStackPtr
	ld	h,SineTable shr 8
	ld	a,(Position)
	ld	l,a
	ld	a,(hl)
	ld	b,a		; a = b = SineTable-value 0-248, converted from Position 0-255
	and	7
	ld	(PosOffset),a	;bit-position 0-7
	ld	a,b
	srl	a
	srl	a
	srl	a
	ld	(AddrOffset),a	;address 0-31


	ld	de,RasterData
	pop	hl		;RasterStackPtr
	ld	a,(AddrOffset)
	add	a,e
	ld	e,a
	ld	(RasterDataAddr),de
	ld	(hl),e		;addr for stack to write to
	inc	hl
	ld	(hl),d		;addr for stack to write to
	inc	hl
	push	hl		;RasterStackPtr
	ld	a,(de)
	ld	(RasterDataOriginal),a
	inc	de
	ld	a,(de)
	ld	(RasterDataOriginal+1),a

	ld	hl,BarMaskTable
	ld	a,(PosOffset)
	add	a,a
	add	a,l
	ld	l,a
	ld	a,(hl)
	ld	(BarMaskData),a
	inc	hl
	ld	a,(hl)
	ld	(BarMaskData+1),a

	ld	hl,BarPatternTable
	ld	a,(PosOffset)
	add	a,a
	add	a,l
	ld	l,a
	ld	a,(hl)
	ld	(BarPatternData),a
	inc	hl
	ld	a,(hl)
	ld	(BarPatternData+1),a

	ld	de,(RasterDataAddr)
	ld	hl,RasterDataOriginal
	ld	a,(hl)
	ld	hl,BarMaskData
	and	(hl)
	ld	hl,BarPatternData
	or	(hl)
	ld	(de),a
	inc	de
	pop	hl		;RasterStackPtr
	ld	(hl),a		;data for stack to write
	inc	hl
	push	hl		;RasterStackPtr
	ld	hl,RasterDataOriginal+1
	ld	a,(hl)
	ld	hl,BarMaskData+1
	and	(hl)
	ld	hl,BarPatternData+1
	or	(hl)
	ld	(de),a
	pop	hl		;RasterStackPtr
	ld	(hl),a		;data for stack to write
	inc	hl
	inc	hl
	inc	hl

	ld	a,(Position)
	add	a,13		;sine-table distance between bars
	ld	(Position),a

	ld	a,(BarCounter)
	dec	a
	ld	(BarCounter),a
	jp	nz,BarLoop	;check if all bars are done

	ld	a,(StartPos)
	inc	a	       ;bar-speed
	ld	(StartPos),a
	ret

;########
	align	2
RasterStack:
	dw	RasterData		;bar address
	db	0, 0			;bar-data
	dw	NewRaster		;return address
	dw	RasterData		;bar address
	db	0, 0			;bar-data
	dw	NewRaster		;return address
	dw	RasterData		;bar address
	db	0, 0			;bar-data
	dw	NewRaster		;return address
	dw	RasterData		;bar address
	db	0, 0			;bar-data
	dw	NewRaster		;return address
	dw	RasterData		;bar address
	db	0, 0			;bar-data
	dw	NewRaster		;return address
	dw	RasterData		;bar address
	db	0, 0			;bar-data
	dw	NewRaster		;return address
	dw	RasterData		;bar address
	db	0, 0			;bar-data
	dw	NewRaster		;return address
	dw	RasterData		;bar address
	db	0, 0			;bar-data
	dw	MagicDone		;return address

	end _asm
;########
AUTORUN:
	rand usr #EnableHires

	include '..\SINCL-ZX\ZX81DISP.INC'	;include D_FILE and needed memory areas

VARS_ADDR:
	db 80h			;DO NOT REMOVE!!!

WORKSPACE:

assert ($-MEMST)<MEMAVL
// end of program