VIDEO_256_ALIGN = 16
LINE_256_END = $e9 ;jp (hl)

;-------------------------------------
EffectCounter	db	1
EffectStackPtr	dw	EffectStack

InitVideoStack:
	ld	sp,(EffectStackPtr)		;20
	ld	hl,EffectCounter		;10
	dec	(hl)				;11
	jp	z,.EndWaste			;10/10 /51
;waste time
	and	(hl)				;7
	and	(hl)				;7
	ld	b,6				;7
	djnz	$				;13/8 /94
;save EffectStackPtr to next time
	ld	(EffectStackPtr),sp		;20
;restore VideoStack
	ld	sp,VideoStack			;10 /30
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
	jp	EmptyLine			;10 /32
						;== 207
.EndWaste:
	ret	nz				;5
	ld	b,9				;7
	djnz	$				;13/8 /124
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
GetEffectDataPtr = $ + 1
	jp	GetEffectDataSimple		;10 /32
						;== 207
;-------------------------------------
GetEffectDataSimple:
	pop	hl				;10
	ld	(EffectDuringBorderLower),hl	;16
	pop	hl				;10
	ld	(EffectDuringBorderUpper),hl	;16
	pop	hl				;10
	ld	(GetEffectDataPtr),hl		;16
	pop	hl				;10
	ld	a,l				;4
	ld	(EffectCounter),a		;13 /105
;waste time
	nop					;4
	nop					;4
	nop					;4
	ld	b,2				;7
	djnz	$				;13/8 /40
;save EffectStackPtr to next time
	ld	(EffectStackPtr),sp		;20
;restore VideoStack
	ld	sp,VideoStack			;10 /30
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
	ret					;10 /32
						;== 207
;-------------------------------------
GetEffectDataWobble:
	pop	hl				;10
	ld	a,h				;4
	or	l				;4
	jp	z,.InitLoop			;10/10 /28
;waste time
	nop					;4
	nop					;4
	nop					;4
	nop					;4
	jp	.GetData			;10 /26
.InitLoop:
	pop	hl				;10
	ld	sp,hl				;6
	pop	hl				;10 /26
.GetData:
	ld	a,l					    ;4
	ld	(EffectCounter),a			    ;13
	ld	a,h					    ;4
	ld	(WobbleEffectDuringBorderLower.Speed),a     ;13
	pop	hl					    ;10
	ld	a,l					    ;4
	ld	(WobbleEffectDuringBorderLower.NrOfPeaks),a ;13
	ld	a,h					    ;4
	ld	(WobbleEffectDuringBorderUpper.NrOfPeaks),a ;13 /78
;waste time
	dec	bc				;6
	or	(hl)				;7 /13
;save EffectStackPtr to next time
	ld	(EffectStackPtr),sp		;20
;restore VideoStack
	ld	sp,VideoStack			;10 /30
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
	ret					;10 /32
						;== 207
;-------------------------------------
ScrollEffectDuringBorderLower:
	exx					;4 use alternate registers
;waste time
	nop					;4
	and	(hl)				;7
	and	(hl)				;7
	ld	b,8				;7
	djnz	$				;13/8 /124

	ld	(SPSave),sp			;20 save SP
	ld	sp,PictureStack 		;10 the stack to be manipulated
	ld	de,33				;10 how much to add to each PictureLine address
	ld	b,PICTURE_HEIGHT / 6		;7 /47 nr of (PictureLines * 3) to change

	in	a,($fe) 			;11
	out	($ff),a 			;11
	jp	ScrollEffect			;10 /32
						;== 207
;-------------------------------------
ScrollEffectDuringBorderUpper:
	exx					;4 use alternate registers
;waste time
	nop					;4
	and	(hl)				;7
	and	(hl)				;7
	ld	b,8				;7
	djnz	$				;13/8 /124

	ld	(SPSave),sp			;20 save SP
	ld	sp,PictureStack + 4 * PICTURE_HEIGHT / 2 ;10 the stack to be manipulated
	ld	de,33				;10 how much to add to each PictureLine address
	ld	b,PICTURE_HEIGHT / 6		;7 /51 nr of (PictureLines * 3) to change

	in	a,($fe) 			;11
	out	($ff),a 			;11
	jp	ScrollEffect			;10 /32
						;== 207
;-------------------------------------
SPSave	dw	0

ScrollEffect:
.Loop:
	pop	hl				;10 ignore this data
	pop	hl				;10 old address to PictureLine
	add	hl,de				;11
	push	hl				;11 save new address to PictureLine
	pop	hl				;10 /52 line up SP again

	pop	hl				;10 ignore this data
	pop	hl				;10 old address to PictureLine
	add	hl,de				;11
	push	hl				;11 save new address to PictureLine
	pop	hl				;10 /52 line up SP again

	pop	hl				;10 ignore this data
	pop	hl				;10 old address to PictureLine
	add	hl,de				;11
	push	hl				;11 save new address to PictureLine
	pop	hl				;10 /52 line up SP again
;waste time
	and	(hl)				;7
	nop					;4
	nop					;4 /15

	dec	b				;4
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
	jp	nz,.Loop			;10/10 /36
						;== 207
;waste time:
	ld	b,11				;7
	djnz	$				;13/8
	dec	bc				;6 /151
;return to normal registers
	exx					;4
	ld	sp,(SPSave)			;20 restore SP
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;Do the job in the VideoStack
	ret					;10 /56
						;== 207
;-------------------------------------
GenerateVSync:
;empty raster and start of VSync
	nop					;4
	ld	b,13				;7
	djnz	$				;13/8
	in	a,($fe) 			;11 VSync start
	ld	h,1				;7
	ld	h,2				;7
	ld	h,3				;7 /207
;3 rasters worth of VSync
	nop					;4
	nop					;4
	nop					;4
	ld	b,44				;7
	ld	b,44				;7
	ld	b,44				;7
	djnz	$				;13/8
	out	($ff),a 			;11 VSync stop
	ret					;10
						;3 * 207 /621
						;== 207
;-------------------------------------
EmptyLine:
;waste time
	nop					;4
	ld	b,13				;7
	djnz	$				;13/8
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10 == 207

;-------------------------------------
PausePictureDuringBorder:
	ld	e,34				;7
	dec	e				;4 /11
;waste time
	dec	bc				;6
	ld	b,12				;7
	djnz	$				;13/8 /164
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
	jp	RasterLoop			;10 /32
						;== 207
;-------------------------------------
EmptyLines:
;get number of rasters to do
	pop	de				;10
;check if rasters done
	dec	e				;4
	jr	z,EndWaste			;12/7
;waste time
	nop					;4
	ret	z				;5
	ld	b,11				;7
	djnz	$				;13/8
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
	jp	RasterLoop			;10 timing
RasterLoop:
	dec	bc				;6 timing
	nop					;4 timing
;check if rasters done
	dec	e				;4
	jr	z,EndWaste			;12/7
;waste time
	ld	a,i				;9 timing, unchanged C
	ld	b,11				;7
	djnz	$				;13/8
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
	jp	RasterLoop			;10
						;== 207
EndWaste:
	ld	b,11				;7
	djnz	$				;13/8
;Clear carry, in preparation of video routines
	xor	a				;4
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10
						;== 207
;-------------------------------------
WobbleEffectDuringBorderLower:
	exx					;4 use alternate registers
;waste time
	ld	b,7				;7
	djnz	$				;13/8
	nop					;4
	nop					;4
	nop					;4
	nop					;4
.Counter = $ + 1
	ld	a,0				;7
.Speed = $ + 1
	add	a,0				;7
	ld	(.Counter),a			;13
	ld	e,a				;4
	ld	d,VideoShiftSineTable shr 8	;7
	ld	hl,PictureStack 		;10
	ld	b,PICTURE_HEIGHT / 6		;7 nr of rasters to wobble
.NrOfPeaks = $ + 1
	ld	c,0				;7 nr of wave-peaks / 256 lines
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
	jp	WobbleEffect			;10
						;== 207
;-------------------------------------
WobbleEffectDuringBorderUpper:
	exx					;4 use alternate registers
;waste time
	nop					;4
	nop					;4
	nop					;4
	ld	b,11				;7
	djnz	$				;13/8
	ld	b,PICTURE_HEIGHT / 6		;7 nr of rasters to wobble
.NrOfPeaks = $ + 1
	ld	c,0				;7 nr of wave-peaks / 256 lines
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
	jp	WobbleEffect			;10
						;== 207
;-------------------------------------
WobbleEffect:
;loop b times
.UpdateList:
	;Counter += NrOfPeaks
		ld	a,e			;4
		add	a,c			;4
		ld	e,a			;4
	;a = VideoShiftSineTable[Counter]
		ld	a,(de)			;7 get sine-value
	;VideoStack[i] = VideoShiftSineTable[Counter]
		ld	(hl),a			;7
		inc	hl			;6
		inc	hl			;6
		inc	hl			;6
		inc	hl			;6 VideoStack-ptr is pointing to next line
	;Counter += NrOfPeaks
		ld	a,e			;4
		add	a,c			;4
		ld	e,a			;4
	;a = VideoShiftSineTable[Counter]
		ld	a,(de)			;7 get sine-value
	;VideoStack[i] = VideoShiftSineTable[Counter]
		ld	(hl),a			;7
		inc	hl			;6
		inc	hl			;6
		inc	hl			;6
		inc	hl			;6 VideoStack-ptr is pointing to next line
	;Counter += NrOfPeaks
		ld	a,e			;4
		add	a,c			;4
		ld	e,a			;4
	;a = VideoShiftSineTable[Counter]
		ld	a,(de)			;7 get sine-value
	;VideoStack[i] = VideoShiftSineTable[Counter]
		ld	(hl),a			;7
		inc	hl			;6
		inc	hl			;6
		inc	hl			;6
		inc	hl			;6 VideoStack-ptr is pointing to next line
	dec	b				;4
	jp	z,.EndWaste			;10/10 /164
;waste time
	ld	a,b				;4
	ld	a,0				;7
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
	jp	.UpdateList			;10 /43
						;== 207
;end loop
.EndWaste:
	ld	a,0				;7
;return to normal registers
	exx					;4
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
	jp	EmptyLine			;10 /43
						;== 207
;-------------------------------------
align 256
VideoShiftSineTable:
	db	128, 128, 128, 128, 128, 128, 144, 144, 144, 144, 144, 144, 160, 160, 160, 160
	db	160, 160, 176, 176, 176, 176, 176, 176, 176, 192, 192, 192, 192, 192, 192, 192
	db	208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 224, 224, 224, 224, 224, 224
	db	224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 240, 240, 240, 240, 240, 240
	db	240, 240, 240, 240, 240, 240, 240, 224, 224, 224, 224, 224, 224, 224, 224, 224
	db	224, 224, 224, 224, 224, 224, 224, 208, 208, 208, 208, 208, 208, 208, 208, 208
	db	208, 192, 192, 192, 192, 192, 192, 192, 176, 176, 176, 176, 176, 176, 176, 160
	db	160, 160, 160, 160, 160, 144, 144, 144, 144, 144, 144, 128, 128, 128, 128, 128
	db	128, 112, 112, 112, 112, 112,  96,  96,  96,  96,  96,	96,  80,  80,  80,  80
	db	 80,  80,  64,	64,  64,  64,  64,  64,  64,  48,  48,	48,  48,  48,  48,  48
	db	 32,  32,  32,	32,  32,  32,  32,  32,  32,  32,  16,	16,  16,  16,  16,  16
	db	 16,  16,  16,	16,  16,  16,  16,  16,  16,  16,   0,	 0,   0,   0,	0,   0
	db	  0,   0,   0,	 0,   0,   0,	0,  16,  16,  16,  16,	16,  16,  16,  16,  16
	db	 16,  16,  16,	16,  16,  16,  16,  32,  32,  32,  32,	32,  32,  32,  32,  32
	db	 32,  48,  48,	48,  48,  48,  48,  48,  64,  64,  64,	64,  64,  64,  64,  80
	db	 80,  80,  80,	80,  80,  96,  96,  96,  96,  96,  96, 112, 112, 112, 112, 112

;-------------------------------------
;Carry flag is cleared during init, hl is initialized
;after first delay. The following opcodes are safe to
;use as delays in the video-routines.
;nop            ;4 delay
;ret    c       ;5 delay, never rets as C is clear
;dec    hl      ;6 delay, unchanged C
;and    (hl)    ;7 delay, clear carry
;ld     a,i     ;9 delay, unchanged C

align 256
;-------------------------------------
;delay 4, left 14 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_Shifted:
HiresVideo256Line_4:
;delay, left border
	nop					;4
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_4	;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_4:
	and	(hl)				;7
	dec	hl				;6
	dec	hl				;6
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 5, left 12 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_5:
;delay, left border
	ret	c				;5
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_5	;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_5:
	dec	hl				;6
	dec	hl				;6
	dec	hl				;6
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 6, left 10 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_6:
;delay, left border
	dec	hl				;6
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_6	;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_6:
	ld	a,i				;9
	nop					;4
	nop					;4
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 7, left 8 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_7:
;delay, left border
	and	(hl)				;7
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_7	;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_7:
	dec	hl				;6
	dec	hl				;6
	nop					;4
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 8, left 6 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_8:
;delay, left border
	nop					;4
	nop					;4
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_8	;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_8:
	ld	a,i				;9
	dec	hl				;6
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 9, left 4 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_9:
;delay, left border
	ld	a,i				;9
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_9	;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_9:
	dec	hl				;6
	nop					;4
	nop					;4
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 10, left 2 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_10:
;delay, left border
	dec	hl				;6
	nop					;4
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_10 ;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_10:
	dec	hl				;6
	and	(hl)				;7
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 11, neutral position
align	VIDEO_256_ALIGN
HiresVideo256Line:
HiresVideo256Line_11:
;left border, X dummy timing
	nop					;4
	and	(hl)				;7
;init return from video-memory
	ld	hl,HiresVideo256LineContinue	;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue:
;right border, (23 - X) dummy timing
	nop					;4
	nop					;4
	nop					;4
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 12, right 2 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_12:
;delay, left border
	dec	hl				;6
	dec	hl				;6
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_12 ;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_12:
	and	(hl)				;7
	nop					;4
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 13, right 4 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_13:
;delay, left border
	dec	hl				;6
	and	(hl)				;7
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_13 ;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_13:
	nop					;4
	dec	hl				;6
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 14, right 6 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_14:
;delay, left border
	and	(hl)				;7
	and	(hl)				;7
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_14 ;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_14:
	ld	a,i				;9
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 15, right 8 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_15:
;delay, left border
	and	(hl)				;7
	nop					;4
	nop					;4
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_15 ;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_15:
	nop					;4
	nop					;4
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 16, right 10 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_16:
;delay, left border
	dec	hl				;6
	dec	hl				;6
	nop					;4
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_16 ;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_16:
	and	(hl)				;7
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 17, right 12 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_17:
;delay, left border
	and	(hl)				;7
	dec	hl				;6
	nop					;4
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_17 ;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_17:
	dec	hl				;6
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 18, right 14 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_18:
;delay, left border
	dec	hl				;6
	dec	hl				;6
	dec	hl				;6
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_18 ;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_18:
;delay, right border
	ret	c				;5
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10

;-------------------------------------
;delay 19, right 16 pixels
align	VIDEO_256_ALIGN
HiresVideo256Line_19:
;delay, left border
	dec	hl				;6
	dec	hl				;6
	and	(hl)				;7
;init return from video-memory
	ld	hl,HiresVideo256LineContinue_19 ;10
;ret to video-memory + $8000
	ret					;10
;       draw 256 pixels, 32 * 4 cycles          ;128
;       jp      (hl)                            ;4
;target for jp from video-memory
HiresVideo256LineContinue_19:
;delay, right border
	nop					;4
;Clear line-counter and do HSync
	in	a,($fe) 			;11
	out	($ff),a 			;11
;return to next job in VideoStack
	ret					;10