;
; ZX81VARS.INC
; include file with variables used by Sinclair ZX81
; for FASMZ80 (flatassembler with Z80 instruction set)
;
; V1.1
;

virtual at MEMST

ERR_NR  db      ?       ; error number $ff is no error
FLAGS   db      ?       ; flags of system
ERR_SP  dw      ?       ; first item of machine stack
RAMTOP  dw      ?       ; top address of ram, first non-existing memory location
MODE    db      ?       ; cursor mode (K/L,F,G)
PPC     dw      ?       ; line number currently executed

SAVE_BEGIN:              ; start address of prgrams loaded into memory

end virtual

        ORG     SAVE_BEGIN

        VERSN   db 0            ; version, 0=ZX81 BASIC
        E_PPC   dw 0            ; number of current line with cursor (in listing)
        D_FILE  dw 0            ; begin of D_FILE (display file) in memory
        DF_CC   dw 0            ; current cursor position in D_FILE (used for print routine)
        VARS    dw 0            ; begin of variable section in memory
        DEST    dw 0            ; address of variable in assignment
        E_LINE  dw WORKSPACE    ; address of workspace
if defined AUTORUN
        CH_ADD  dw AUTORUN      ; address of next character to be interpreted
else
        CH_ADD  dw 0            ; address of next character to be interpreted
end if
        X_PTR   dw 0            ; address of character preceeding "S" marker
        STKBOT  dw WORKSPACE    ; stack botton (top-down)
        STKEND  dw WORKSPACE    ; end of stack (top)
        BERG    db 0            ; calculators b register, possibly write error, should be BREG :-)
        MEM     dw 0            ; address for calculator's memory
        UNUSED1 db 0            ; unused variable / space
        DF_SZ   db 2            ; no. of lines in lower part of screen including 1 blank line
        S_TOP   dw 0            ; no. of top program line in automatic listings
        LAST_K  dw 0            ; last key pressed
        DEBOUNCE db 0           ; debounce status of keyboard
        MARGIN  db PAL          ; margin value, could be used PAL or NTSC
if defined AUTORUN
        NXTLIN  dw AUTORUN      ; next line to be executed
else
        NXTLIN  dw 0            ; next line to be executed
end if
        OLDPPC  dw 0            ; line to jump when executing CONT (continue)
        FLAGX   db 0            ; internal flags
        STRLEN  dw 0            ; length of string, interally used
        T_ADDR  dw 0            ; next item in syntax (token) table
        SEED    dw 0            ; seed variable set by RAND
        FRAMES  dw 0            ; counter of frames sent to TV, used by PAUSE command
        COORDS  db 0            ; x coordinate of last point plotted
                db 0            ; y coordinate of last point plotted
        PR_CC   db $BC          ; LPRINT position used with real printer
        S_POSN  db 33           ; column no. for print position
                db 24           ; line no. for print position
match =FAST_MODE,STARTMODE {
        CDFLAG  db FAST_MODE
}
match =SLOW_MODE,STARTMODE {
        CDFLAG  db SLOW_MODE
}
match =STARTMODE,STARTMODE {
        CDFLAG  db SLOW_MODE
}
        assert  CDFLAG > -1
BASIC_AREA:
