
			DEVICE	ZXSPECTRUM48

			; 1-800-CALLNOW

			ORG #F000

begin:

	DEFINE BLACK
	;DEFINE MINI

	IFDEF BLACK

			ld hl,23296-1
			xor a
	IFDEF MINI
			out (254),a
	ENDIF
			ld (23624), a
cls:			ld (hl),a
			cp (hl)
			dec hl
			jr z,cls

	ENDIF

			ld l,low (callme-1)
	IFDEF MINI
			ld e,0
	ELSE
			ld e,a
	ENDIF

nextbyte:		inc l
			ld bc,9*256+high callme
			ld h,c

charloop:		dec b
			jr z,nextbyte

			rlc (hl)
			jr nc,emptychar

			ld d,high (16384+4096)
fillloop:		ld a,(de)
			or c
			ld (de),a
			inc d
			bit 3,d
			jr z,fillloop

emptychar:		ld a,c
			cpl
			ld c,a
			rrca
			jr c,charloop
			inc e
			jr nz,charloop

	IFDEF MINI
			ret
	ELSE
			ld d,e
reverse:		ld a,h;150/2

busytone:		exa
			inc e
			ld h,4
			call 949
			exa
			
			ld h,2+high 22528
	IFDEF BLACK
			ld c,%00000111
	ELSE
			ld c,%00111000
	ENDIF
			dec a
			jr nz,busytone
			
			halt
			halt

fader:			ld b,7
flashing:		halt

	IFDEF BLACK
direction:		dec c
	ELSE
direction:		inc c
	ENDIF

attrloop:		ld (hl),c
			inc l
			jr nz,attrloop

			djnz flashing

			ld a,(direction)
			xor 1			; change inc to dec etc
			ld (direction),a
	IFDEF BLACK
			jp pe,fader
	ELSE
			jp po,fader
	ENDIF
			jr reverse
	ENDIF

callme:
	db	%00001111,%10011111,%00100000,%01000000,%00100010,%01111100,%10001001,%01010000
	db	%00001000,%00010001,%00100000,%01000000,%00110010,%01000100,%10001001,%01010000
	db	%00001000,%00011111,%00100000,%01000000,%00101010,%01000100,%10101000,%00000000
	db	%00001111,%10010001,%00111110,%01111100,%00100110,%01111100,%11011001,%01010000

;
;  binary file generation
;

			IF _ERRORS = 0
			SAVESNA	"callnow.sna", begin
			DISPLAY	"total length: ", /D, $-begin, " bytes (", /D, $-begin-128, " bytes too many)"
			SAVEBIN	"callnow.bin", begin, $-begin
			ELSE
			SHELLEXEC "cmd /c del callnow.sna callnow.tap"
			ENDIF

