; "Life is Short, Release More"
; The first 456 bytes effect for the Amiga Vampire.
; Written by Franck 'hitchhikr' Charlet.

EXIT                    equ     0       ; Set to 1 to generate exit code.

WIDTH                   equ     320
HEIGHT                  equ     256

                        section program,code

start:
                        lea     $dff006,a5
        ifne EXIT
                        ; Save'em
                        move.w  $1c-6(a5),-(a7)
                        move.l  $dfe1ec,-(a7)
                        move.w  $dfe1f4,-(a7)
        else
                        move.w  #$7fff,$9a-6(a5)
        endc
                        ; Set 320x256x32
                        move.w  #$0305,$1f4-6(a5)

                        lea     temp_buf,a2
                        lea     (WIDTH*HEIGHT*2*4)(a2),a3

                        ; Play some shit
                        lea     4000.w,a4           ; Length
                        moveq   #4+1,d1             ; Stereo+16 bit
                        lea     $400-6(a5),a6

                        movem.l	a3/a4,(a6)          ; Buffer/Len
                        addq.l  #8,a6
                        move.w	#$3070,(a6)+        ; Right/left volumes
                        move.w	d1,(a6)+
                        move.w	#162,(a6)+          ; Period

                        addq.l  #2,a6
                        movem.l	a2/a4,(a6)
                        addq.l  #8,a6
                        move.w	#$7030,(a6)+
                        move.w	d1,(a6)+
                        move.w	#160,(a6)+

                        addq.l  #2,a6
                        movem.l	a2/a4,(a6)
                        addq.l  #8,a6
                        move.w	#$7070,(a6)+
                        move.w	d1,(a6)+
                        move.w	#164,(a6)

                        move.w	#$8207,$96-6(a5)
loop:                   
                        lea     screen_buffer,a0
                        bchg    #0,swap_scr(pc)
                        bne.b   swap_buffers
                        lea     (WIDTH*HEIGHT*4)(a0),a0
swap_buffers:           
                        pea     (a0)

                        add.b   (a5),d0
                        add.b   (a5),d1
                        muls.w  d1,d0
                        divs.w  #WIDTH,d0
                        swap    d0
                        add.b   (a5),d1
                        extb.l  d1
                        muls.w  #WIDTH*2,d1
                        add.w   d0,d1
                        st.b    (a2,d1.l)
                        st.b    1(a2,d1.l)
                        st.b    WIDTH(a2,d1.l)
                        st.b    1+WIDTH(a2,d1.l)
                        lea     (a2),a4
                        lea     (a3),a2
                        lea     (a4),a3
                        moveq   #0,d3
                        move.l  #WIDTH,d4
                        move.l  d4,d5
                        move.w  #HEIGHT-1,d6
drops_y:                move.w  #WIDTH-1,d7
drops_x:                moveq   #0,d0
                        move.b  -1(a2,d4.l),d0
                        add.b   1(a2,d4.l),d0
                        add.b   -WIDTH(a2,d4.l),d0
                        add.b   WIDTH(a2,d4.l),d0
                        asr.l   #1,d0
                        moveq   #0,d2
                        move.b  (a3,d4.l),d2
                        sub.l   d2,d0
                        move.l  d0,d1
                        moveq   #32,d2
                        asr.l   d2,d1
                        sub.l   d1,d0
                        bge.b   neg_col
                        neg.l   d0
neg_col:                move.b  d0,(a3,d5.l)
                        move.b  d0,2(a0,d3.l*4)
                        addq.l  #1,d3
                        addq.l  #1,d4
                        addq.l  #1,d5
                        dbf     d7,drops_x
                        addq.l  #2,d3
                        addq.l  #2,d4
                        addq.l  #2,d5
                        dbf     d6,drops_y

                        add.l   #(((((HEIGHT-6)/2))*WIDTH)+((WIDTH-(10*8))/2))*4,a0
                        lea     logo(pc),a1
                        moveq   #6-1,d6
copy_logo_y:            moveq   #10-1,d7
copy_logo_x:            moveq   #8-1,d5
copy_logo_nibble:       move.b  (a1),d0
                        btst    d5,d0
                        beq.b   no_logo_dot
                        moveq   #-1,d4
                        move.l  d4,(a0)
no_logo_dot:            addq.l  #4,a0
                        dbf     d5,copy_logo_nibble
                        addq.l  #1,a1
                        dbf     d7,copy_logo_x
                        lea     (WIDTH*4)-(10*8*4)(a0),a0
                        dbf     d6,copy_logo_y

                        move.l  (a7)+,$1ec-6(a5)
        ifne EXIT
                        btst    #6,$bfe001
                        bne.w   loop

                        move.w  (a7)+,$1f4-6(a5)
                        move.l  (a7)+,$1ec-6(a5)
                        move.w  (a7)+,d0
                        or.w    #$c000,d0
                        move.w  d0,$9a-6(a5)
                        move.w	#7,$96-6(a5)
                        moveq   #0,d0
                        rts
        else
                        bra.w   loop
        endc

swap_scr:               dc.b    0
logo:                   dc.b    %00001111,%11111110,%01111111,%11000111,%11111111,%00111111,%11100011,%11000000,%00111111,%11100000
                        dc.b    %00001111,%00011110,%01111000,%00000111,%10001111,%00111100,%00000011,%11000000,%00111100,%00000000
                        dc.b    %00001111,%11111110,%01111111,%00000111,%11111111,%00111111,%10000011,%11000000,%00111111,%11111100
                        dc.b    %00001111,%10001111,%01111100,%00000111,%11000111,%10111110,%00000011,%11100000,%00000000,%01111100
                        dc.b    %00001111,%10001111,%01111100,%00000111,%11000111,%10111110,%00000011,%11100000,%00000000,%01111100
                        dc.b    %00001111,%10001111,%01111111,%11110111,%11111111,%10111111,%11111011,%11111111,%10111111,%11111100
                        even

                        section gfxbuffers,bss

screen_buffer:          ds.l    (WIDTH*HEIGHT*4*2)
temp_buf:               ds.l    (WIDTH*HEIGHT*4)
                        end
