;compile with sjasm
	device zxspectrum128

	org $6500-13
tap_b:
;name
	db $22,"NONAME",$22
;type
	db "M"
;program length
	dw end-begin
;load point
	dw begin
;--------------- CODE START ---------------
;	org $6500
begin
;012
;7.3
;654
dxy:
 db -1,00,01,01,01,00,-1,-1
 db -1,-1,-1,00,01,01,01,-1
runi:
;https://www.chibiakumas.com/z80/platform4.php#LessonP33
;  Mode Color         Out     Out     Address
;                   (&FFFF) (&0080)    Range
; Write Red+Green     &07   &20       &C000-&DFFF 
;       Blue+AltGreen &07   &20       &A000-&BFFF 
	macro ScreenDrawAllColors
		exx					;Red/Blue Component
			ld a,07			;%00000111 - Write RGB
			ld bc,$FFFF		
			out (c),a
			ld a,$20		;%00100000 - Write RGB
			ld bc,$0080
			out (c),a
		exx
	endm

;Red	&03	&28	&C000-&DFFF
;Blue	&03	&28	&A000-&BFFF
	macro ScreenDrawRedBlue
		exx					;Red/Blue Component
			ld a,03			;%00000011 - Write Bank 1+2
			ld bc,$FFFF
			out (c),a
			ld a,$28		;%00101000 - Write VRAM, Write RedBlue
			ld bc,$0080
			out (c),a
		exx
	endm

;Green		&05	&24	&C000-&DFFF
;AltGreen	&05	&24	&A000-&BFFF
	macro ScreenDrawGreen
		exx					;Green Component
			ld a,05			;%00000101 - Write Bank 1+3
			ld bc,$FFFF
			out (c),a
			ld a,$24		;%00100100 - Write VRAM, Write Green
			ld bc,$0080
			out (c),a
		exx
	endm

	macro ScreenStopDrawing
		exx					;Turn off drawing
			ld a,0
			ld bc,$FFFF		;Reset Bank writing
			out (c),a
			ld bc,$0080		;Reset Paging
			out (c),a
		exx
	endm
	
	macro ScreenStartDrawing
	endm

	di
;256x247
;	ld hl,0
;	add hl,sp
;	call $2234 ;9FF2
;	jr $
	ld sp,$6500-1
	ld de,$7F7F;Y.X
	
;	ld h,10
;	exx
;	ld h,20
;	exx
;	ld a,5,($625b),a
;	call $1017
;	jr $
;	ld c,7
;	call plot
;	jr $
;;;blue A000-BFFF
;;	ld hl,$2803
;;	call banks
;;	ld a,1,($A000),a
;;;read
;;	ld hl,$A000
;;	call $69
;;;write
;;	ld a,l
;;	or 4
;;	ld hl,$2803
;;	call banks
;;	ld ($A000),a
;;	ld a,$55,($A020),a
;;
;;;red C000-DFFF
;;;write
;;	ld hl,$2803
;;	call banks
;;	ld a,1,($C000),a
;;;read
;;	ld hl,$C000
;;	call $69
;;;write
;;	ld a,l
;;	or 8
;;	ld hl,$2803
;;	call banks
;;	ld ($C000),a
;;	ld a,$55,($C020),a
;;;##############################################
;;;read green C000-DFFF
;;;$FFFF=$60
;;;0080=24
;;;write green C000-DFFF
;;;$FFFF=$05
;;;0080=24
;;;write
;;	ld hl,$2405
;;	call banks
;;	ld a,1,($C000),a
;;
;;;read
;;	ld hl,$C000
;;	call $70 ; ld l,(hl)
;;;debug print
;;;	call $2234
;;;write
;;	ld a,l
;;	or 2
;;	ld hl,$2405
;;	call banks
;;	ld ($C000),a
;;	ld a,$55,($C020),a
;;
;;	jr $

ilp:
	call random
	and 7
	ld c,a
	
	inc ix
	ld a,ixh
	and 7
	ld ($625b),a

	ld b,dxy/256
;+X
	ld a,(bc)
	add a,e
	and 127
	ld e,a
	ld h,a
;+Y
	set 3,c
	ld a,(bc)
	add a,d
	jp p,by1
	ld a,$7E
by1:
	cp $7F
	jr nz,contplot
	xor a
contplot:
	ld d,a

;	ld de,$7f7f
	call pl2

;wait
	ld h,200
	ld bc,$80
wa: in a,(c)
	and 64
	jr z,wa
	dec h
	jr nz,wa
	push de

	call pl3

	ld a,e
	cpl
	ld e,a
	call pl2


	call pl3

	pop de
	jr  ilp

pl3:
	ld a,d
	cpl
	ld d,a
pl2:
	ld h,e
	ld a,d
	exx
	ld h,a
	exx
	jp $1017

random;  LD A,(R1),C,A
R1	ld c,$15
R2  LD A,$70;(R2)
        ADD A,C
        LD C,A
        LD (R1+1),A
R3      LD A,$FD;(R3)
        SUB C
        LD C,A
        LD (R2+1),A
        RRCA
        LD (R3+1),A
        LD A,C
        RET
end

;calc checksum
    LUA
    local checksum
    checksum=0

    for i=sj.get_label("begin"),sj.get_label("end") do
    checksum=checksum+sj.get_byte( i )
    end
--	print("cs:",string.format("%08X",checksum))
	sj.insert_label("CSU", checksum%256)
    ENDLUA

;rest tail
checkd: db CSU,CSU ;checksum LSB two times
;execute point
	dw runi;begin
;high byte of execute point
	db begin/256
tap_e:
	display /d,end-begin
	savebin "rw.tap",tap_b,tap_e-tap_b
;	savebin "hlw.bin",begin,end-begin
