IF  !DEF(HARDWARE_INC)
HARDWARE_INC  SET  1

;*******************************************************************************



;** CPU Types ******************************************************************

CPU_DMG EQU     $01
CPU_SGB	EQU     $01
CPU_GBP	EQU     $FF
CPU_GBC	EQU     $11


;** Screen Info ****************************************************************

TILE_PIXELWIDTH         EQU     8
TILE_PIXELHEIGHT        EQU     8

SCREEN_TILEWIDTH        EQU     20
SCREEN_TILEHEIGHT       EQU     18

SCREEN_PIXELWIDTH       EQU     160
SCREEN_PIXELHEIGHT      EQU     144

MAP_TILEWIDTH   EQU     32
MAP_TILEHEIGHT  EQU     32

SPRITE_XOFFSET  EQU     8
SPRITE_YOFFSET  EQU     16


;** Base Addresses**************************************************************

BASE_RAMG            EQU    $0000    ; $0000->$1FFF
BASE_ROMB0           EQU    $2000    ; $2000->$2FFF
BASE_ROMB1           EQU    $3000    ; $3000->$3FFF
BASE_RAMB            EQU    $4000    ; $4000->$5FFF
BASE_VRAM8000        EQU    $8000    ; $8000->$A000
BASE_VRAM8800        EQU    $8800    ; $8000->$A000
BASE_MAPRAM9800      EQU    $9800    ; $9800->$9BFF
BASE_MAPRAM9C00      EQU    $9C00    ; $9C00->$9FFF
BASE_SAVERAM         EQU    $A000    ; $A000->$BFFF
BASE_INTRAM          EQU    $C000    ; $C000->$DFFF
BASE_INTRAMBANK      EQU    $D000    ; $D000->$DFFF
BASE_OAMRAM          EQU    $FE00    ; $FE00->$FE9F
BASE_AUD3WAVERAM     EQU    $FF30    ; $FF30->$FF3F
BASE_HIGHRAM         EQU    $FF80    ; $FF80->$FFFE


;*** OAM flags *************************************************************************************************************

OAM_F_PRI	EQU	%10000000	; Priority
OAM_F_YFLIP	EQU	%01000000	; Y flip
OAM_F_XFLIP	EQU	%00100000	; X flip
OAM_F_PAL1	EQU	%00010000	; Palette number 0/1
OAM_F_PAL0	EQU	%00000000	; Palette number 0/1


;*** Custom registers ******************************************************************************************************

;*** P1 ($FF00) ************************************************************************************************************
;*   Register for reading joy pad info.   (R/W)
;***************************************************************************************************************************
REG_P1_W	EQU	$FF00
REG_P1	EQU	$00

REG_P1_F_5	EQU	%00100000	; P15 out port
REG_P1_F_4	EQU	%00010000	; P14 out port
REG_P1_F_3	EQU	%00001000	; P13 out port
REG_P1_F_2	EQU	%00000100	; P12 out port
REG_P1_F_1	EQU	%00000010	; P11 out port
REG_P1_F_0	EQU	%00000001	; P10 out port

;*** SB ($FF01) ************************************************************************************************************
;***************************************************************************************************************************
REG_SB_W	EQU	$FF01
REG_SB	EQU	$01

;*** SC ($FF02) ************************************************************************************************************
;***************************************************************************************************************************
REG_SC_W	EQU	$FF02
REG_SC	EQU	$02

;*** DIV ($FF04) ***********************************************************************************************************
;***************************************************************************************************************************
REG_DIV_W	EQU	$FF04
REG_DIV	EQU	$04

;*** TIMA ($FF05) **********************************************************************************************************
;***************************************************************************************************************************
REG_TIMA_W	EQU	$FF05
REG_TIMA	EQU	$05

;*** TMA ($FF06) ***********************************************************************************************************
;***************************************************************************************************************************
REG_TMA_W	EQU	$FF06
REG_TMA	EQU	$06

;*** TAC ($FF07) ***********************************************************************************************************
;***************************************************************************************************************************
REG_TAC_W	EQU	$FF07
REG_TAC	EQU	$07

;*** IF ($FF0F) ************************************************************************************************************
;*   Interrupt Flag   (R/W)
;***************************************************************************************************************************
REG_IF_W	EQU	$FF0F
REG_IF	EQU	$0F

;*** AUD1SWEEP/NR10 ($FF10) ************************************************************************************************
;*   Sweep register   (R/W)
;*
;*   Bit 6-4 - Sweep Time
;*   Bit 3   - Sweep Increase/Decrease
;*             0: Addition    (frequency increases???)
;*             1: Subtraction (frequency increases???)
;*   Bit 2-0 - Number of sweep shift (# 0-7)
;*   Sweep Time: (n*7.8ms)
;***************************************************************************************************************************
REG_NR10_W	EQU	$FF10
REG_NR10	EQU	$10
REG_AUD1SWEEP_W	EQU	REG_NR10_W
REG_AUD1SWEEP	EQU	REG_NR10

;*** AUD1LEN/NR11 ($FF11) **************************************************************************************************
;*   Sound length/Wave pattern duty   (R/W)
;*
;*   Bit 7-6 - Wave Pattern Duty (00:12.5% 01:25% 10:50% 11:75%)
;*   Bit 5-0 - Sound length data (# 0-63)
;***************************************************************************************************************************
REG_NR11_W	EQU	$FF11
REG_NR11	EQU	$11
REG_AUD1LEN_W	EQU	REG_NR11_W
REG_AUD1LEN	EQU	REG_NR11

;*** AUD1ENV/NR12 ($FF12) **************************************************************************************************
;*   Envelope   (R/W)
;*
;*   Bit 7-4 - Initial value of envelope
;*   Bit 3   - Envelope UP/DOWN
;*             0: Decrease
;*             1: Range of increase
;*   Bit 2-0 - Number of envelope sweep (# 0-7)
;***************************************************************************************************************************
REG_NR12_W	EQU	$FF12
REG_NR12	EQU	$12
REG_AUD1ENV_W	EQU	REG_NR12_W
REG_AUD1ENV	EQU	REG_NR12

;*** AUD1LOW/NR13 ($FF13) **************************************************************************************************
;*   Frequency lo (W)
;***************************************************************************************************************************
REG_NR13_W	EQU	$FF13
REG_NR13	EQU	$13
REG_AUD1LOW_W	EQU	REG_NR13_W
REG_AUD1LOW	EQU	REG_NR13

;*** AUD1HIGH/NR14 ($FF14) *************************************************************************************************
;*   Frequency High   (W)
;*
;*   Bit 7   - Initial (when set, sound restarts)
;*   Bit 6   - Counter/consecutive selection
;*   Bit 2-0 - Frequency's higher 3 bits
;***************************************************************************************************************************
REG_NR14_W	EQU	$FF14
REG_NR14	EQU	$14
REG_AUD1HIGH_W	EQU	REG_NR14_W
REG_AUD1HIGH	EQU	REG_NR14

;*** AUD2LEN/NR21 ($FF16) **************************************************************************************************
;*   Sound Length; Wave Pattern Duty   (R/W)
;*
;*   see AUD1LEN for info
;***************************************************************************************************************************
REG_NR21_W	EQU	$FF16
REG_NR21	EQU	$16
REG_AUD2LEN_W	EQU	REG_NR21_W
REG_AUD2LEN	EQU	REG_NR21

;*** AUD2ENV/NR22 ($FF17) **************************************************************************************************
;*   Envelope   (R/W)
;*
;*   see AUD1ENV for info
;***************************************************************************************************************************
REG_NR22_W	EQU	$FF17
REG_NR22	EQU	$17
REG_AUD2ENV_W	EQU	REG_NR22_W
REG_AUD2ENV	EQU	REG_NR22

;*** AUD2LOW/NR23 ($FF18) **************************************************************************************************
;*   Frequency lo   (W)
;***************************************************************************************************************************
REG_NR23_W	EQU	$FF18
REG_NR23	EQU	$18
REG_AUD2LOW_W	EQU	REG_NR23_W
REG_AUD2LOW	EQU	REG_NR23

;*** AUD2HIGH/NR24 ($FF19) *************************************************************************************************
;*   Frequency hi   (W)
;*
;*   see AUD1HIGH for info
;***************************************************************************************************************************
REG_NR24_W	EQU	$FF19
REG_NR24	EQU	$19
REG_AUD2HIGH_W	EQU	REG_NR24_W
REG_AUD2HIGH	EQU	REG_NR24

;*** AUD2ENA/NR30 ($FF1A) **************************************************************************************************
;*   Sound on/off   (R/W)
;*
;*   Bit 7   - Sound ON/OFF (1EQUON,0EQUOFF)
;***************************************************************************************************************************
REG_NR30_W	EQU	$FF1A
REG_NR30	EQU	$1A
REG_AUD3ENA_W	EQU	REG_NR30_W
REG_AUD3ENA	EQU	REG_NR30

;*** AUD3LEN/NR31 ($FF1B) **************************************************************************************************
;*   Sound length   (R/W)
;*
;*   Bit 7-0 - Sound length
;***************************************************************************************************************************
REG_NR31_W	EQU	$FF1B
REG_NR31	EQU	$1B
REG_AUD3LEN_W	EQU	REG_NR31_W
REG_AUD3LEN	EQU	REG_NR31

;*** AUD3LEVEL/NR32 ($FF1C) ************************************************************************************************
;*   Select output level
;*
;*   Bit 6-5 - Select output level
;*             00: 0/1 (mute)
;*             01: 1/1
;*             10: 1/2
;*             11: 1/4
;***************************************************************************************************************************
REG_NR32_W	EQU	$FF1C
REG_NR32	EQU	$1C
REG_AUD3LEVEL_W	EQU	REG_NR32_W
REG_AUD3LEVEL	EQU	REG_NR32

;*** AUD3LOW/NR33 ($FF1D) **************************************************************************************************
;*   Frequency lo   (W)
;*
;*   see AUD1LOW for info
;***************************************************************************************************************************
REG_NR33_W	EQU	$FF1D
REG_NR33	EQU	$1D
REG_AUD3LOW_W	EQU	REG_NR33_W
REG_AUD3LOW	EQU	REG_NR33

;*** AUD3HIGH/NR34 ($FF1E) *************************************************************************************************
;*   Frequency hi   (W)
;*
;*   see AUD1HIGH for info
;***************************************************************************************************************************
REG_NR34_W	EQU	$FF1E
REG_NR34	EQU	$1E
REG_AUD3HIGH_W	EQU	REG_NR34_W
REG_AUD3HIGH	EQU	REG_NR34

;*** AUD4LEN/NR41 ($FF20) **************************************************************************************************
;*   Sound length   (R/W)
;*
;*   Bit 5-0 - Sound length data (# 0-63)
;***************************************************************************************************************************
REG_NR41_W	EQU	$FF20
REG_NR41	EQU	$20
REG_AUD4LEN_W	EQU	REG_NR41_W
REG_AUD4LEN	EQU	REG_NR41

;*** AUD4ENV/NR42 ($FF21) **************************************************************************************************
;*   Envelope   (R/W)
;*
;*   see AUD1ENV for info
;***************************************************************************************************************************
REG_NR42_W	EQU	$FF21
REG_NR42	EQU	$21
REG_AUD4ENV_W	EQU	REG_NR42_W
REG_AUD4ENV	EQU	REG_NR42

;*** AUD4POLY/NR42 ($FF22) *************************************************************************************************
;*   Polynomial counter   (R/W)
;*
;*   Bit 7-4 - Selection of the shift clock frequency of the (scf)
;*             polynomial counter (0000-1101)
;*             freqEQUdrf*1/2^scf (not sure)
;*   Bit 3 -   Selection of the polynomial counter's step
;*             0: 15 steps
;*             1: 7 steps
;*   Bit 2-0 - Selection of the dividing ratio of frequencies (drf)
;*             000: f/4   001: f/8   010: f/16  011: f/24
;*             100: f/32  101: f/40  110: f/48  111: f/56  (fEQU4.194304 Mhz)
;***************************************************************************************************************************
REG_NR42_2_W	EQU	$FF22
REG_NR42_2	EQU	$22
REG_AUD4POLY_W	EQU	REG_NR42_2_W
REG_AUD4POLY	EQU	REG_NR42_2

;*** AUD4GO/NR43 ($FF23) ***************************************************************************************************
;*
;*   Bit 7 -   Inital
;*   Bit 6 -   Counter/consecutive selection
;***************************************************************************************************************************
REG_NR43_W	EQU	$FF23
REG_NR43	EQU	$23
REG_AUD4GO_W	EQU	REG_NR43_W	; silly name!
REG_AUD4GO	EQU	REG_NR43	; silly name!

;*** AUDVOL/NR50 ($FF24) ***************************************************************************************************
;*   Channel control / ON-OFF / Volume   (R/W)
;*
;*   Bit 7   - Vin->SO2 ON/OFF (Vin??)
;*   Bit 6-4 - SO2 output level (volume) (# 0-7)
;*   Bit 3   - Vin->SO1 ON/OFF (Vin??)
;*   Bit 2-0 - SO1 output level (volume) (# 0-7)
;***************************************************************************************************************************
REG_NR50_W	EQU	$FF24
REG_NR50	EQU	$24
REG_AUDVOL_W	EQU	REG_NR50_W
REG_AUDVOL	EQU	REG_NR50

;*** AUDTERM/NR51 ($FF25) **************************************************************************************************
;*   Selection of Sound output terminal   (R/W)
;*
;*   Bit 7   - Output sound 4 to SO2 terminal
;*   Bit 6   - Output sound 3 to SO2 terminal
;*   Bit 5   - Output sound 2 to SO2 terminal
;*   Bit 4   - Output sound 1 to SO2 terminal
;*   Bit 3   - Output sound 4 to SO1 terminal
;*   Bit 2   - Output sound 3 to SO1 terminal
;*   Bit 1   - Output sound 2 to SO1 terminal
;*   Bit 0   - Output sound 0 to SO1 terminal
;***************************************************************************************************************************
REG_NR51_W	EQU	$FF25
REG_NR51	EQU	$25
REG_AUDTERM_W	EQU	REG_NR51_W
REG_AUDTERM	EQU	REG_NR51

;*** AUDENA/NR52 ($FF26) ***************************************************************************************************
;*   Sound on/off   (R/W)
;*
;*   Bit 7   - All sound on/off (sets all audio regs to 0!)
;*   Bit 3   - Sound 4 ON flag (doesn't work!)
;*   Bit 2   - Sound 3 ON flag (doesn't work!)
;*   Bit 1   - Sound 2 ON flag (doesn't work!)
;*   Bit 0   - Sound 1 ON flag (doesn't work!)
;***************************************************************************************************************************
REG_NR52_W	EQU	$FF26
REG_NR52	EQU	$26
REG_AUDENA_W	EQU	REG_NR52_W
REG_AUDENA	EQU	REG_NR52

;*** LCDC ($FF40) **********************************************************************************************************
;*   LCD Control   (R/W)
;*
;*   "Window Character Data Select" follows BG
;***************************************************************************************************************************
REG_LCDC_W	EQU	$FF40
REG_LCDC	EQU	$40

REG_LCDC_F_OFF	EQU	%00000000	; LCD Control Operation
REG_LCDC_F_ON	EQU	%10000000	; LCD Control Operation
REG_LCDC_F_WIN9800	EQU	%00000000	; Window Screen Display Data Select
REG_LCDC_F_WIN9C00	EQU	%01000000	; Window Screen Display Data Select
REG_LCDC_F_WINOFF	EQU	%00000000	; Window Display
REG_LCDC_F_WINON	EQU	%00100000	; Window Display
REG_LCDC_F_BG8800	EQU	%00000000	; BG Character Data Select
REG_LCDC_F_BG8000	EQU	%00010000	; BG Character Data Select
REG_LCDC_F_BG9800	EQU	%00000000	; BG Screen Display Data Select
REG_LCDC_F_BG9C00	EQU	%00001000	; BG Screen Display Data Select
REG_LCDC_F_OBJ8	EQU	%00000000	; OBJ Construction
REG_LCDC_F_OBJ16	EQU	%00000100	; OBJ Construction
REG_LCDC_F_OBJOFF	EQU	%00000000	; OBJ Display
REG_LCDC_F_OBJON	EQU	%00000010	; OBJ Display
REG_LCDC_F_BGOFF	EQU	%00000000	; BG Display
REG_LCDC_F_BGON	EQU	%00000001	; BG Display

;*** STAT ($FF41) **********************************************************************************************************
;*   LCDC Status   (R/W)
;***************************************************************************************************************************
REG_STAT_W	EQU	$FF41
REG_STAT	EQU	$41

REG_STAT_F_LYC	EQU	%01000000	; LYCEQULY Coincidence (Selectable)
REG_STAT_F_MODE10	EQU	%00100000	; Mode 10
REG_STAT_F_MODE01	EQU	%00010000	; Mode 01 (V-Blank)
REG_STAT_F_MODE00	EQU	%00001000	; Mode 00 (H-Blank)
REG_STAT_F_LYCF	EQU	%00000100	; Coincidence Flag
REG_STAT_F_LCD	EQU	%00000011	; Both OAM and VRAM used by system
REG_STAT_F_OAM	EQU	%00000010	; OAM RAM is used by system
REG_STAT_F_VB	EQU	%00000001	; V-Blank
REG_STAT_F_HB	EQU	%00000000	; H-Blank
REG_STAT_F_BUSY	EQU	%00000010	; When set, VRAM access is unsafe

;*** SCY ($FF42) ***********************************************************************************************************
;*   Scroll Y   (R/W)
;***************************************************************************************************************************
REG_SCY_W	EQU	$FF42
REG_SCY	EQU	$42

;*** SCX ($FF43) ***********************************************************************************************************
;*   Scroll X   (R/W)
;***************************************************************************************************************************
REG_SCX_W	EQU	$FF43
REG_SCX	EQU	$43

;*** LY ($FF44) ************************************************************************************************************
;*   LCDC Y-Coordinate   (R)
;*
;*   Values range from 0->153. 144->153 is the VBlank period.
;***************************************************************************************************************************
REG_LY_W	EQU	$FF44
REG_LY	EQU	$44

;*** LYC ($FF45) ***********************************************************************************************************
;*   LY Compare   (R/W)
;*
;*   When LYEQUEQULYC, REG_STAT_F_LYCF will be set in STAT.
;***************************************************************************************************************************
REG_LYC_W	EQU	$FF45
REG_LYC	EQU	$45

;*** DMA ($FF46) ***********************************************************************************************************
;*   DMA Transfer and Start Address   (W)
;***************************************************************************************************************************
REG_DMA_W	EQU	$FF46
REG_DMA	EQU	$46

;*** BGP ($FF47) ***********************************************************************************************************
;*   BG Palette Data   (W)
;*
;*   Bit 7-6 - Intensity for %11
;*   Bit 5-4 - Intensity for %10
;*   Bit 3-2 - Intensity for %01
;*   Bit 1-0 - Intensity for %00
;***************************************************************************************************************************
REG_BGP_W	EQU	$FF47
REG_BGP	EQU	$47

;*** OBP0 ($FF48) **********************************************************************************************************
;*   Object Palette 0 Data   (W)
;*
;*   See BGP ($FF47) for info
;***************************************************************************************************************************
REG_OBP0_W	EQU	$FF48
REG_OBP0	EQU	$48

;*** OBP1 ($FF49) **********************************************************************************************************
;*   Object Palette 1 Data   (W)
;*
;*   See BGP ($FF47) for info
;***************************************************************************************************************************
REG_OBP1_W	EQU	$FF49
REG_OBP1	EQU	$49

;*** WY ($FF4A) ************************************************************************************************************
;*   Window Y Position   (R/W)
;*
;*   0 <= WY <= 143
;***************************************************************************************************************************
REG_WY_W	EQU	$FF4A
REG_WY	EQU	$4A

;*** WX ($FF4B) ************************************************************************************************************
;*   Window X Position   (R/W)
;*
;*   7 <EQU WX <EQU 166
;***************************************************************************************************************************
REG_WX_W	EQU	$FF4B
REG_WX	EQU	$4B

;*** KEY1 ($FF4D) **********************************************************************************************************
;***************************************************************************************************************************
REG_KEY1_W	EQU	$FF4D
REG_KEY1	EQU	$4D

;*** VBK ($FF4F) ***********************************************************************************************************
;*   Select Video RAM Bank   (R/W)
;***************************************************************************************************************************
REG_VBK_W	EQU	$FF4F
REG_VBK	EQU	$4F

;*** HDMA1 ($FF51) *********************************************************************************************************
;*   Horizontal Blanking, General Purpose DMA   (W)
;***************************************************************************************************************************
REG_HDMA1_W	EQU	$FF51
REG_HDMA1	EQU	$51

;*** HDMA2 ($FF52) *********************************************************************************************************
;*   Horizontal Blanking, General Purpose DMA   (W)
;***************************************************************************************************************************
REG_HDMA2_W	EQU	$FF52
REG_HDMA2	EQU	$52

;*** HDMA3 ($FF53) *********************************************************************************************************
;*   Horizontal Blanking, General Purpose DMA   (W)
;***************************************************************************************************************************
REG_HDMA3_W	EQU	$FF53
REG_HDMA3	EQU	$53

;*** HDMA4 ($FF54) *********************************************************************************************************
;*   Horizontal Blanking, General Purpose DMA   (W)
;***************************************************************************************************************************
REG_HDMA4_W	EQU	$FF54
REG_HDMA4	EQU	$54

;*** HDMA5 ($FF55) *********************************************************************************************************
;*   Horizontal Blanking, General Purpose DMA   (W)
;***************************************************************************************************************************
REG_HDMA5_W	EQU	$FF55
REG_HDMA5	EQU	$55

;*** RP ($FF56) ************************************************************************************************************
;***************************************************************************************************************************
REG_RP_W	EQU	$FF56
REG_RP	EQU	$56

;*** BCPS ($FF68) **********************************************************************************************************
;*   Background Color Palette Specification   (R/W)
;***************************************************************************************************************************
REG_BCPS_W	EQU	$FF68
REG_BCPS	EQU	$68

;*** BCPD ($FF69) **********************************************************************************************************
;*   Background Color Palette Data   (R/W)
;***************************************************************************************************************************
REG_BCPD_W	EQU	$FF69
REG_BCPD	EQU	$69

;*** OCPS ($FF6A) **********************************************************************************************************
;*   Object Color Palette Specification   (R/W)
;***************************************************************************************************************************
REG_OCPS_W	EQU	$FF6A
REG_OCPS	EQU	$6A

;*** OCPD ($FF6B) **********************************************************************************************************
;*   Object Color Palette Data   (R/W)
;***************************************************************************************************************************
REG_OCPD_W	EQU	$FF6B
REG_OCPD	EQU	$6B

;*** SVBK ($FF70) **********************************************************************************************************
;*   Select Main RAM Bank   (R/W)
;***************************************************************************************************************************
REG_SVBK_W	EQU	$FF70
REG_SVBK	EQU	$70

;*** IE ($FFFF) ************************************************************************************************************
;*   Interrupt Enable   (R/W)
;***************************************************************************************************************************
REG_IE_W	EQU	$FFFF
REG_IE	EQU	$FF

REG_IE_F_JOYPAD	EQU	%00010000	; Joypad transition from high to low
REG_IE_F_SERIAL	EQU	%00001000	; Serial I/O transfer end
REG_IE_F_TIMER	EQU	%00000100	; Timer Overflow
REG_IE_F_LCDC	EQU	%00000010	; LCDC (see STAT)
REG_IE_F_VBLANK	EQU	%00000001	; V-Blank

;***************************************************************************************************************************
;*   Joypad equates
;***************************************************************************************************************************

; new button EQUates
	RSRESET
BUTTON_NOTPRESSED	RB	1	; button was either released or not pressed
BUTTON_PRESSED	RB	1	; button was pressed and held down
BUTTON_TRIGGERED	RB	1	; initial press of a button

	RSRESET
BUTTON_B_A	RB	1
BUTTON_B_B	RB	1
BUTTON_B_SELECT	RB	1
BUTTON_B_START	RB	1
BUTTON_B_RIGHT	RB	1
BUTTON_B_LEFT	RB	1
BUTTON_B_UP	RB	1
BUTTON_B_DOWN	RB	1

BUTTON_F_A	EQU	%00000001
BUTTON_F_B	EQU	%00000010
BUTTON_F_SELECT	EQU	%00000100
BUTTON_F_START	EQU	%00001000
BUTTON_F_RIGHT	EQU	%00010000
BUTTON_F_LEFT	EQU	%00100000
BUTTON_F_UP	EQU	%01000000
BUTTON_F_DOWN	EQU	%10000000

; legacy EQUates (will become obsolete)
PAD_F_DOWN	EQU	%10000000
PAD_F_UP	EQU	%01000000
PAD_F_LEFT	EQU	%00100000
PAD_F_RIGHT	EQU	%00010000
PAD_F_START	EQU	%00001000
PAD_F_SELECT	EQU	%00000100
PAD_F_B	EQU	%00000010
PAD_F_A	EQU	%00000001
PAD_F_NONE	EQU	%00000000

PAD_B_DOWN	EQU	7
PAD_B_UP	EQU	6
PAD_B_LEFT	EQU	5
PAD_B_RIGHT	EQU	4
PAD_B_START	EQU	3
PAD_B_SELECT	EQU	2
PAD_B_B	EQU	1
PAD_B_A	EQU	0

	ENDC	; HARDWARE_INC
