/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import net.infonode.gui.BackgroundPainter;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.util.Direction;

public class ComponentUtil {
    private ComponentUtil() {
    }

    public static final Component getChildAt(Container container, Point p) {
        Component c = container.getComponentAt(p);
        return c == null || c.getParent() != container ? null : c;
    }

    public static final Component getVisibleChildAt(Container container, Point p) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component c = container.getComponent(i);
            if (!c.isVisible() || !c.contains(p.x - c.getX(), p.y - c.getY())) continue;
            return c;
        }
        return null;
    }

    public static final Component getChildAtLine(Container container, Point p, boolean horizontal) {
        if (horizontal) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component c = container.getComponent(i);
                if (p.x < c.getX() || p.x >= c.getX() + c.getWidth()) continue;
                return c;
            }
        } else {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component c = container.getComponent(i);
                if (p.y < c.getY() || p.y >= c.getY() + c.getHeight()) continue;
                return c;
            }
        }
        return null;
    }

    public static void getComponentTreePosition(Component c, ArrayList pos) {
        if (c.getParent() == null) {
            return;
        }
        ComponentUtil.getComponentTreePosition(c.getParent(), pos);
        pos.add(new Integer(c.getParent().getComponentCount() - ComponentUtil.getComponentIndex(c)));
    }

    public static Component findComponentUnderGlassPaneAt(Point p, Component top) {
        Component c = null;
        if (top.isShowing()) {
            c = top instanceof RootPaneContainer ? ((RootPaneContainer)((Object)top)).getLayeredPane().findComponentAt(SwingUtilities.convertPoint(top, p, ((RootPaneContainer)((Object)top)).getLayeredPane())) : ((Container)top).findComponentAt(p);
        }
        return c;
    }

    public static final int getComponentIndex(Component component) {
        if (component != null && component.getParent() != null) {
            Container c = component.getParent();
            for (int i = 0; i < c.getComponentCount(); ++i) {
                if (c.getComponent(i) != component) continue;
                return i;
            }
        }
        return -1;
    }

    public static final String getBorderLayoutOrientation(Direction d) {
        return d == Direction.UP ? "North" : (d == Direction.LEFT ? "West" : (d == Direction.DOWN ? "South" : "East"));
    }

    public static Color getBackgroundColor(Component component) {
        Color c;
        ComponentPainter painter;
        if (component == null) {
            return null;
        }
        if (component instanceof BackgroundPainter && (painter = ((BackgroundPainter)((Object)component)).getComponentPainter()) != null && (c = painter.getColor(component)) != null) {
            return c;
        }
        return component.isOpaque() ? component.getBackground() : ComponentUtil.getBackgroundColor(component.getParent());
    }

    public static int countComponents(Container c) {
        int num = 1;
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component comp = c.getComponent(i);
            if (comp instanceof Container) {
                num += ComponentUtil.countComponents((Container)comp);
                continue;
            }
            ++num;
        }
        return num;
    }

    public static int getVisibleChildrenCount(Component c) {
        if (c == null || !(c instanceof Container)) {
            return 0;
        }
        int count = 0;
        Container container = (Container)c;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (!container.getComponent(i).isVisible()) continue;
            ++count;
        }
        return count;
    }

    public static Component getTopLevelAncestor(Component c) {
        while (c != null && !(c instanceof Window) && !(c instanceof Applet)) {
            c = c.getParent();
        }
        return c;
    }

    public static boolean hasVisibleChildren(Component c) {
        return ComponentUtil.getVisibleChildrenCount(c) > 0;
    }

    public static boolean isOnlyVisibleComponent(Component c) {
        return c != null && c.isVisible() && ComponentUtil.getVisibleChildrenCount(c.getParent()) == 1;
    }

    public static boolean isOnlyVisibleComponents(Component[] c) {
        if (c != null && c.length > 0) {
            boolean visible;
            boolean bl = visible = ComponentUtil.getVisibleChildrenCount(c[0].getParent()) == c.length;
            if (visible) {
                for (int i = 0; i < c.length; ++i) {
                    visible = visible && c[i].isVisible();
                }
            }
            return visible;
        }
        return false;
    }

    public static Component findFirstComponentOfType(Component comp, Class c) {
        if (c.isInstance(comp)) {
            return comp;
        }
        if (comp instanceof Container) {
            Container container = (Container)comp;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component comp2 = ComponentUtil.findFirstComponentOfType(container.getComponent(i), c);
                if (comp2 == null) continue;
                return comp2;
            }
        }
        return null;
    }

    public static boolean isFocusable(Component c) {
        return c.isFocusable() && c.isDisplayable() && c.isVisible() && c.isEnabled();
    }

    public static boolean requestFocus(Component component) {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == component || component.requestFocusInWindow();
    }

    public static Component smartRequestFocus(Component component) {
        Component focusComponent;
        FocusTraversalPolicy policy;
        if (ComponentUtil.requestFocus(component)) {
            return component;
        }
        if (component instanceof JComponent && (policy = ((JComponent)component).getFocusTraversalPolicy()) != null && (focusComponent = policy.getDefaultComponent((Container)component)) != null && ComponentUtil.requestFocus(focusComponent)) {
            return focusComponent;
        }
        if (component instanceof Container) {
            Component[] children = ((Container)component).getComponents();
            for (int i = 0; i < children.length; ++i) {
                component = ComponentUtil.smartRequestFocus(children[i]);
                if (component == null) continue;
                return component;
            }
        }
        return null;
    }

    public static int getPreferredMaxHeight(Component[] components) {
        int height = 0;
        for (int i = 0; i < components.length; ++i) {
            int k = (int)components[i].getPreferredSize().getHeight();
            if (k <= height) continue;
            height = k;
        }
        return height;
    }

    public static int getPreferredMaxWidth(Component[] components) {
        int width = 0;
        for (int i = 0; i < components.length; ++i) {
            int k = (int)components[i].getPreferredSize().getWidth();
            if (k <= width) continue;
            width = k;
        }
        return width;
    }

    public static void setAllOpaque(Container c, boolean opaque) {
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(opaque);
            for (int i = 0; i < c.getComponentCount(); ++i) {
                Component comp = c.getComponent(i);
                if (!(comp instanceof Container)) continue;
                ComponentUtil.setAllOpaque((Container)comp, opaque);
            }
        }
    }

    public static void validate(JComponent c) {
        c.revalidate();
    }

    public static void validate(Component c) {
        if (c instanceof JComponent) {
            ((JComponent)c).revalidate();
        } else {
            c.validate();
        }
    }
}

