/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalToolTipUI;
import javax.swing.text.View;

public class PgsToolTipUI
extends MetalToolTipUI {
    private Font smallFont;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsToolTipUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Font font = jComponent.getFont();
        this.smallFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
        jComponent.putClientProperty("gradientStart", UIManager.getColor("Tooltip.gradientStart"));
        jComponent.putClientProperty("gradientEnd", UIManager.getColor("Tooltip.gradientEnd"));
    }

    public final void paint(Graphics graphics, JComponent jComponent) {
        PgsUtils.installAntialiasing(graphics);
        JToolTip jToolTip = (JToolTip)jComponent;
        Dimension dimension = jComponent.getSize();
        super.paint(graphics, jComponent);
        PgsUtils.drawGradient(graphics, jComponent);
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = jComponent.getFontMetrics(font);
        String string = this.getAcceleratorString();
        String string2 = jToolTip.getTipText();
        if (string2 == null) {
            string2 = "";
        }
        graphics.setColor(jComponent.getForeground());
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            graphics.drawString(string2, rectangle.x + 3, rectangle.y + fontMetrics.getAscent());
        }
        if (!string.equals("")) {
            graphics.setFont(this.smallFont);
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawString(string, fontMetrics.stringWidth(string2) + 12, 2 + fontMetrics.getAscent());
        }
        PgsUtils.uninstallAntialiasing(graphics);
    }
}

