/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.importPCX;
import classes.importTGA;
import classes.importWEBP;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.monte.ilbmdemo.ILBMViewer;

public class ImageImporter {
    importTGA tga;
    importPCX pcx;
    importWEBP webp;
    ILBMViewer ilbm;
    protected String PBM_HEADER = "PBM";
    protected String ILBM_HEADER = "ILBM";

    public BufferedImage readImage(byte[] data, String name) throws IOException {
        if (this.tga == null) {
            this.tga = new importTGA();
        }
        if (this.pcx == null) {
            this.pcx = new importPCX();
        }
        if (this.ilbm == null) {
            this.ilbm = new ILBMViewer();
        }
        if (this.webp == null) {
            this.webp = new importWEBP();
        }
        if (this.PBM_HEADER.equals(new String(data, 8, this.PBM_HEADER.length()))) {
            System.out.println("Reading amiga PBM");
            return this.ilbm.getAmigaPicture(data);
        }
        if (this.ILBM_HEADER.equals(new String(data, 8, this.ILBM_HEADER.length()))) {
            System.out.println("Reading amiga ILBM");
            return this.ilbm.getAmigaPicture(data);
        }
        if (name.toLowerCase().endsWith(".tga")) {
            return this.tga.getImage(data, false);
        }
        if (name.toLowerCase().endsWith(".pcx")) {
            return importPCX.getImage(data);
        }
        if (name.toLowerCase().endsWith(".webp")) {
            return this.webp.getImage(name);
        }
        return ImageIO.read(new ByteArrayInputStream(data));
    }
}

