/*
 * Decompiled with CFR 0.152.
 */
package JCPC.util.diss;

import JCPC.core.Util;
import JCPC.core.device.memory.Memory;

public abstract class Disassembler {
    protected Object config;
    protected int addrMask = 65535;

    protected int nextAddress(int[] address) {
        int result = address[0];
        address[0] = result + 1 & this.addrMask;
        return result;
    }

    public abstract String disassemble(Memory var1, int[] var2);

    public String disassemble(Memory memory, int[] address, boolean showAddr, int dataPos) {
        int start = address[0];
        String result = (showAddr ? Util.hex((short)start) + ": " : "") + this.disassemble(memory, address);
        if (dataPos != 0) {
            while (result.length() < dataPos) {
                result = result + " ";
            }
            int i = start;
            while (i != address[0]) {
                if (i != start) {
                    result = result + " ";
                }
                result = result + Util.hex((byte)memory.readByte(i, this.config));
                i = i + 1 & 0xFFFF;
            }
        }
        return result;
    }

    public void setMemoryConfiguration(Object value) {
        this.config = value;
    }

    public Object getMemoryConfiguration() {
        return this.config;
    }
}

