/*
 * Decompiled with CFR 0.152.
 */
package JCPC.ui;

import JCPC.core.Util;
import JCPC.core.device.Computer;
import JCPC.core.device.crtc.Basic6845;
import JCPC.system.cpc.CPC;
import JCPC.system.cpc.GateArray;
import JCPC.system.cpc.Samples;
import JCPC.ui.Controller;
import JCPC.ui.Debugger;
import JCPC.ui.Display;
import JCPC.ui.EmuControl;
import JCPC.ui.GX4000Menu;
import JCPC.ui.KeyTranslator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GX4000
extends JApplet
implements ItemListener,
ActionListener,
KeyListener,
FocusListener,
Runnable,
MouseListener,
MouseMotionListener {
    GX4000Menu menu;
    public EmuControl control;
    private ArrayList<DropTarget> dropTargetList;
    public static Debugger debug = null;
    public static boolean hasSkin;
    boolean gifrec = false;
    boolean menupossible = false;
    boolean penonscreen = false;
    protected static boolean developer;
    public boolean URL = false;
    String CRTC = "3";
    boolean alt = false;
    int multiload = 0;
    String cartridge = "none";
    String load = "none";
    String loadb = "none";
    String sna = "none";
    protected Computer computer = null;
    Locale loc;
    String localkeys = "";
    public static boolean isStandalone;
    public Display display = new Display();
    protected boolean started = false;
    protected boolean large = false;
    JInternalFrame emu;
    static boolean toDriveB;
    String disk1 = "";
    String disk2 = "";
    JPanel show;
    protected int loadit = 0;
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GX4000.this.update();
        }
    };
    Timer fireUpdate = new Timer(50, this.update);
    int fram = 0;
    private KeyTranslator translator = new KeyTranslator();
    JFrame fullframe;
    BufferedImage testim = new BufferedImage(768, 544, 1);
    Controller controller;
    boolean ctrl;
    FileDialog loader;
    boolean lightpen = false;
    final URL cursorim = this.getClass().getResource("attachment.gif");
    final Image lightGun = this.getToolkit().getImage(this.cursorim);
    final URL cursorim2 = this.getClass().getResource("lightpen.png");
    final Image lightPen = this.getToolkit().getImage(this.cursorim2);
    Cursor gun = Toolkit.getDefaultToolkit().createCustomCursor(this.lightGun, new Point(1, 1), "gunCursor");
    Cursor pen = Toolkit.getDefaultToolkit().createCustomCursor(this.lightPen, new Point(1, 1), "penCursor");
    int basex = 200;
    int basexmax = 410;
    boolean keepmonitor;
    public static JFrame frame;
    public static boolean asApplet;

    public CPC getCPC() {
        return GateArray.cpc;
    }

    public void showDebugger() {
        try {
            System.out.println("showDebugger");
            if (debug == null) {
                debug = (Debugger)Util.secureConstructor(Debugger.class, new Class[0], new Object[0]);
                debug.setBounds(0, 0, 820, 600);
                debug.setComputer(this.computer);
            }
            System.out.println("Showing Debugger");
            debug.setVisible(true);
            debug.toFront();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.control.controller) {
                this.setupController();
            }
            if (GateArray.cpc != null) {
                if (e.getSource() == this.control.syscart) {
                    if (!CPC.gx4000) {
                        this.loadPlus();
                        this.display.requestFocus();
                    }
                }
                if (e.getSource() == this.control.syscart) {
                    if (CPC.gx4000) {
                        this.loadGX();
                        this.display.requestFocus();
                    }
                }
            }
            if (e.getSource() == this.control.reset) {
                GateArray.cpc.softReset();
                this.display.requestFocus();
            }
            if (e.getSource() == this.control.fullscreen) {
                this.toggleFullscreen();
                this.display.requestFocus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.menu != null) {
            if (e.getSource() == this.menu.jMenuItem1) {
                this.load();
            }
            if (e.getSource() == this.menu.jMenuItem2) {
                this.computer.openCPR();
            }
            if (e.getSource() == this.menu.jMenuItem3) {
                this.controller.setVisible(true);
            }
            if (e.getSource() == this.menu.jMenuItem5) {
                GateArray.cpc.checkCSD();
            }
            if (e.getSource() == this.menu.jMenuItem7) {
                GateArray.cpc.softReset();
            }
            if (e.getSource() == this.menu.jMenuItem8) {
                this.showDebugger();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Dimension d2;
        try {
            if (e.getSource() == this.control.filter) {
                Display.scanlines = this.control.filter.isSelected();
                this.display.requestFocus();
            }
            if (e.getSource() == this.control.lightgun) {
                this.controller.trojan.setSelected(this.control.lightgun.isSelected());
                this.setLightgun(this.controller.trojan.isSelected());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (e.getSource() == this.control.fullsize) {
            if (this.menu != null) {
                this.menu.jCheckBoxMenuItem2.setSelected(this.control.fullsize.isSelected());
                if (this.menu.jCheckBoxMenuItem2.isSelected()) {
                    this.menu.jCheckBoxMenuItem3.setSelected(false);
                }
            }
            this.setFullSize(this.control.fullsize.isSelected());
            System.out.println("Changing display to " + (this.large ? "large size" : "small size"));
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.display.setPreferredSize(this.display.getPreferredSize());
            this.display.setSize(this.display.getPreferredSize());
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (frame != null) {
                frame.pack();
                d2 = Toolkit.getDefaultToolkit().getScreenSize();
                frame.setLocation((d2.width - GX4000.frame.getSize().width) / 2, (d2.height - GX4000.frame.getSize().height) / 2);
            }
            if (this.emu != null) {
                this.emu.pack();
            }
        }
        if (this.menu != null) {
            hasSkin = this.menu.jCheckBoxMenuItem3.getState();
            if (this.menu.jCheckBoxMenuItem1 == e.getSource()) {
                this.display.DEBUG_FPS = this.menu.jCheckBoxMenuItem1.getState();
            }
            if (this.menu.jCheckBoxMenuItem4 == e.getSource()) {
                if (this.menu.jCheckBoxMenuItem4.isSelected()) {
                    if (!this.gifrec) {
                        this.display.startRec();
                        this.gifrec = true;
                    }
                } else if (this.gifrec) {
                    this.display.stopRec();
                    this.gifrec = false;
                }
            }
            if (this.menu.jCheckBoxMenuItem2 == e.getSource()) {
                this.control.fullsize.setSelected(this.menu.jCheckBoxMenuItem2.isSelected());
                this.setFullSize(this.menu.jCheckBoxMenuItem2.isSelected());
                if (this.menu.jCheckBoxMenuItem2.isSelected()) {
                    this.menu.jCheckBoxMenuItem3.setSelected(false);
                }
                System.out.println("Changing display to " + (this.large ? "large size" : "small size"));
                try {
                    Thread.sleep(100L);
                }
                catch (Exception d2) {
                    // empty catch block
                }
                this.display.setPreferredSize(this.display.getPreferredSize());
                this.display.setSize(this.display.getPreferredSize());
                try {
                    Thread.sleep(100L);
                }
                catch (Exception d2) {
                    // empty catch block
                }
                if (frame != null) {
                    frame.pack();
                    d2 = Toolkit.getDefaultToolkit().getScreenSize();
                    frame.setLocation((d2.width - GX4000.frame.getSize().width) / 2, (d2.height - GX4000.frame.getSize().height) / 2);
                }
                if (this.emu != null) {
                    this.emu.pack();
                }
            }
            if (this.menu.jCheckBoxMenuItem3 == e.getSource()) {
                this.keepmonitor = this.menu.jCheckBoxMenuItem3.getState();
                if (this.keepmonitor) {
                    this.menu.jCheckBoxMenuItem2.setSelected(false);
                }
                this.setFullSize(this.menu.jCheckBoxMenuItem2.getState());
                System.out.println("Changing display to " + (this.large ? "large size" : "small size"));
                try {
                    Thread.sleep(100L);
                }
                catch (Exception d3) {
                    // empty catch block
                }
                this.display.setPreferredSize(this.display.getPreferredSize());
                this.display.setSize(this.display.getPreferredSize());
                try {
                    Thread.sleep(100L);
                }
                catch (Exception d3) {
                    // empty catch block
                }
                if (frame != null) {
                    frame.pack();
                    d2 = Toolkit.getDefaultToolkit().getScreenSize();
                    frame.setLocation((d2.width - GX4000.frame.getSize().width) / 2, (d2.height - GX4000.frame.getSize().height) / 2);
                }
                if (this.emu != null) {
                    this.emu.pack();
                }
            }
        }
        if (e.getSource() == this.controller.trojan) {
            this.control.lightgun.setSelected(this.controller.trojan.isSelected());
            this.setLightgun(this.controller.trojan.isSelected());
        }
        if (e.getSource() == this.controller.cart) {
            GateArray.cpc.loadCart(this.controller.cart.getSelectedIndex());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (y < 50) {
            if (Display.showdisks) {
                Display.showtime = 50;
            }
        }
        this.display.updateLightpen(x, y);
        if (this.lightpen) {
            if (this.display.fullscreen) {
                double xx = 768.0 / (double)this.display.getWidth();
                double yy = 544.0 / (double)this.display.getHeight();
                x = (int)((double)x * xx);
                y = (int)((double)y * yy);
            }
            GateArray.cpc.getCRTC().setLightpen(x, y, this.display.large, this.display.fullscreen, this.penonscreen);
        }
        if (this.large) {
            if (this.display.menumode && e.getX() > this.basex && e.getX() < this.basexmax && e.getY() > 50 && e.getY() < 530) {
                this.display.setCursor(new Cursor(12));
            } else if (this.display.menumode && e.getX() > this.basex + 300 && e.getX() < this.basexmax + 300 && e.getY() > 50 && e.getY() < 400) {
                this.display.setCursor(new Cursor(12));
            } else {
                this.menupossible = false;
                if (!this.lightpen) {
                    this.display.setCursor(new Cursor(0));
                } else {
                    this.display.setCursor(this.penonscreen ? this.pen : this.gun);
                }
            }
        } else if (e.getX() > 360 && e.getX() < 390 && e.getY() > 353 && e.getY() < 363) {
            this.display.setCursor(new Cursor(12));
            this.menupossible = true;
        } else if (this.display.menumode && e.getX() > 100 + this.display.xdist && e.getX() < 220 + this.display.xdist && e.getY() > 50 + this.display.ydist && e.getY() < 290 + this.display.ydist) {
            this.display.setCursor(new Cursor(12));
        } else if (this.display.menumode && e.getX() > 250 + this.display.xdist && e.getX() < 370 + this.display.xdist && e.getY() > 50 + this.display.ydist && e.getY() < 214 + this.display.ydist) {
            this.display.setCursor(new Cursor(12));
        } else {
            this.menupossible = false;
            if (!this.lightpen) {
                this.display.setCursor(new Cursor(0));
            } else {
                this.display.setCursor(this.penonscreen ? this.pen : this.gun);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.display.updateLightpen(x, y);
        if (this.lightpen) {
            if (this.display.fullscreen) {
                double xx = 768.0 / (double)this.display.getWidth();
                double yy = 544.0 / (double)this.display.getHeight();
                x = (int)((double)x * xx);
                y = (int)((double)y * yy);
            }
            GateArray.cpc.getCRTC().setLightpen(x, y, this.display.large, this.display.fullscreen, true);
        }
    }

    public String getParameter(String key, String def) {
        try {
            return isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
        }
        catch (Exception e) {
            return def;
        }
    }

    public GX4000() {
        this.enableEvents(8L);
    }

    @Override
    public void init() {
        this.localkeys = this.getLocale().toString().toUpperCase();
        this.display.requestFocus();
        if (isStandalone) {
            this.dropTargetList = new ArrayList();
            DropListener myListener = new DropListener();
            GX4000.registerDropListener(this.dropTargetList, this.display, myListener);
        }
    }

    public void stopMotor() {
        this.computer.stop();
    }

    public void startMotor() {
        this.computer.start();
    }

    public Computer getComputer() {
        return this.computer;
    }

    public JInternalFrame getEmu(GX4000 emul) {
        if (this.emu == null) {
            this.emu = new JInternalFrame("JavaGX4000 - Amstrad CPC+ Emulator - Desktop"){

                @Override
                public void doDefaultCloseAction() {
                    System.out.println("Window closing!");
                    GX4000.this.computer.reset();
                    GX4000.this.computer.stop();
                    super.doDefaultCloseAction();
                }
            };
            this.emu.setDefaultCloseOperation(1);
            this.initMenu();
            this.setJMenuBar(this.getMenu());
            this.emu.setLayout(new BorderLayout());
            this.emu.add((Component)this, "Center");
            this.menu.jMenuItem4.setVisible(false);
            this.emu.pack();
            this.emu.setResizable(false);
            this.emu.setIconifiable(true);
            this.emu.setClosable(true);
        }
        return this.emu;
    }

    public JMenuBar getMenu() {
        this.menu.Menu.setFocusable(false);
        return this.menu.Menu;
    }

    public void init(String locale) {
        this.localkeys = locale;
        this.display.requestFocus();
        this.dropTargetList = new ArrayList();
        DropListener myListener = new DropListener();
        GX4000.registerDropListener(this.dropTargetList, this.display, myListener);
    }

    private static void registerDropListener(ArrayList<DropTarget> list, Container basePanel, DropListener myListener) {
        list.add(new DropTarget(basePanel, myListener));
        Component[] components = basePanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof Container) {
                GX4000.registerDropListener(list, (Container)component, myListener);
                continue;
            }
            list.add(new DropTarget(component, myListener));
        }
    }

    public void init(Locale loc) {
        this.localkeys = loc.toString().toUpperCase();
        this.display.requestFocus();
    }

    public void prepareAutoType(String type) {
        this.computer.prepareAutotype(type);
    }

    public void startEngine(final GX4000 applet) {
        try {
            this.show = new JPanel();
            this.show.setBackground(new Color(39, 39, 39));
            this.show.setLayout(new BorderLayout());
            this.control = new EmuControl();
            this.controller = new Controller();
            this.fram = 0;
            this.disk2 = "";
            this.setLayout(new BorderLayout());
            CPC.cartindex = Integer.parseInt(this.getParameter("GAME", "25"));
            if (CPC.cartindex > 25 || CPC.cartindex < 0) {
                CPC.cartindex = 2;
            }
            this.large = Util.getBoolean(this.getParameter("LARGE", "true"));
            Display.scanlines = Util.getBoolean(this.getParameter("FILTER", "false"));
            this.keepmonitor = Display.drawmonitor = Util.getBoolean(this.getParameter("GUI", "false"));
            this.controller.trojan.addItemListener(this);
            this.controller.cart.setModel(new DefaultComboBoxModel<String>(Display.carts));
            this.controller.cart.setSelectedIndex(CPC.cartindex);
            this.controller.cart.addItemListener(this);
            String url = this.getParameter("URL", "false");
            url = url.toUpperCase();
            if (url.equals("TRUE")) {
                this.URL = true;
            }
            String csd = this.getParameter("CSD", "false");
            csd = csd.toUpperCase();
            CPC.CSD = false;
            if (csd.equals("TRUE")) {
                CPC.CSD = true;
            }
            String type = this.getParameter("AUTOTYPE", null);
            String boot = this.getParameter("BOOT", null);
            this.CRTC = "3";
            this.CRTC = this.getParameter("CRTC", this.CRTC);
            if (this.CRTC.startsWith("1")) {
                this.CRTC = "1";
            }
            if (this.CRTC.startsWith("3")) {
                this.CRTC = "3";
            }
            if (this.CRTC.startsWith("0")) {
                this.CRTC = "0";
            }
            Basic6845.CRTC = Integer.parseInt(this.CRTC);
            this.cartridge = this.getParameter("CPR", "internal");
            if (CPC.CSD) {
                this.cartridge = "none";
            }
            if (this.cartridge.equals("internal")) {
                this.cartridge = "none";
                CPC.internal = true;
            }
            this.setComputer("CPCPLUS", true);
            this.sna = this.load = this.getParameter("SNA", "none");
            this.load = this.getParameter("DISK", this.load);
            if (this.load.startsWith("$")) {
                this.load = "none";
            }
            this.loadb = this.getParameter("DISKB", this.loadb);
            if (this.loadb.startsWith("$")) {
                this.loadb = "none";
            }
            this.disk2 = this.getParameter("DISK2", "");
            if (this.disk2.startsWith("$")) {
                this.disk2 = "";
            }
            Display.showdisks = false;
            if (this.disk2.length() > 1) {
                this.disk1 = this.load;
                Display.showdisks = true;
                Display.showtime = 150;
            }
            this.display.large = this.large;
            if (this.large) {
                this.display.setSize(768, this.display.highlines);
                this.display.divider = 2;
            } else {
                this.display.setSize(384, this.display.lowlines);
            }
            this.show.add((Component)this.display, "Center");
            this.display.setBackground(Color.black);
            this.display.addKeyListener(this);
            this.display.addMouseListener(this);
            this.display.addMouseMotionListener(this);
            this.display.addFocusListener(this);
            this.started = true;
            if (type != null) {
                this.computer.prepareAutotype(type);
            }
            if (boot != null) {
                if (boot.contains("/")) {
                    boot = boot.replace("/", "\"");
                    this.computer.prepareAutotype(boot);
                } else if (boot.equals("tape")) {
                    this.computer.prepareAutotype("|TAPE:RUN\"!\"");
                } else if (boot.startsWith("|")) {
                    this.computer.prepareAutotype(boot);
                } else {
                    this.computer.prepareAutotype("RUN\"" + boot + "\"");
                }
            }
            this.setLightgun(Util.getBoolean(this.getParameter("LIGHTGUN", "false")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!GX4000.this.cartridge.equals("none")) {
                    GX4000.this.loadFile(2, GX4000.this.cartridge, true);
                }
                if (!GX4000.this.load.equals("none") && GX4000.this.sna.equals("none")) {
                    GX4000.this.loadFile(2, GX4000.this.load, true);
                }
                if (GX4000.this.load.equals("none") && !GX4000.this.sna.equals("none")) {
                    GX4000.this.loadit = 1;
                }
                if (!GX4000.this.load.equals("none") && !GX4000.this.sna.equals("none")) {
                    GX4000.this.multiload = 1;
                }
                if (!GX4000.this.loadb.equals("none")) {
                    GX4000.this.computer.setCurrentDrive(1);
                    GX4000.this.loadFile(2, GX4000.this.loadb, true);
                }
                GX4000.this.computer.setCurrentDrive(0);
                if (frame != null) {
                    frame.pack();
                    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                    frame.setLocation((d.width - GX4000.frame.getSize().width) / 2, (d.height - GX4000.frame.getSize().height) / 2);
                }
                if (GX4000.this.emu != null) {
                    GX4000.this.emu.pack();
                }
                GX4000.this.fireUpdate.start();
                GX4000.this.display.DEBUG_SPRITES = Util.getBoolean(GX4000.this.getParameter("SPRITES", GX4000.this.display.DEBUG_SPRITES ? "true" : "false"));
                GX4000.this.display.DEBUG_SCREEN = Util.getBoolean(GX4000.this.getParameter("SCREEN", GX4000.this.display.DEBUG_SCREEN ? "true" : "false"));
                GX4000.this.control.fullsize.setSelected(GX4000.this.large);
                GX4000.this.control.fullsize.addItemListener(applet);
                GX4000.this.control.lightgun.addItemListener(applet);
                GX4000.this.control.controller.addActionListener(applet);
                GX4000.this.control.fullscreen.addActionListener(applet);
                GX4000.this.control.syscart.addActionListener(applet);
                GX4000.this.control.reset.addActionListener(applet);
                GX4000.this.control.filter.addItemListener(applet);
                if (!asApplet && frame != null) {
                    GX4000.this.initMenu();
                    GX4000.this.setJMenuBar(GX4000.this.getMenu());
                }
                GX4000.this.add((Component)GX4000.this.control, "North");
                GX4000.this.add((Component)GX4000.this.show, "Center");
                GX4000.this.display.requestFocus();
            }
        });
    }

    @Override
    public void start() {
        CPC.gx4000 = false;
        this.startEngine(this);
        this.display.requestFocus();
    }

    public void startEmbedded() {
        CPC.gx4000 = true;
        this.startEngine(this);
        this.display.requestFocus();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void waitStart() {
        try {
            while (!this.started) {
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
    }

    @Override
    public void stop() {
        GateArray.cpc.reset();
        GateArray.cpc.getPSG().resetRegisters();
        this.computer.stop();
    }

    public void update() {
        if (this.fram < 1) {
            ++this.fram;
            this.computer.reset();
            this.computer.reSync();
            if (frame != null) {
                frame.pack();
            }
        }
        if (this.loadit > 0) {
            ++this.loadit;
            if (this.loadit > 5) {
                this.loadit = 0;
                this.loadFile(1, this.sna, true);
            }
        }
        if (this.multiload >= 1) {
            ++this.multiload;
            if (this.multiload == 6) {
                this.loadFile(1, this.sna, true);
            }
            if (this.multiload == 8) {
                this.loadFile(1, this.load, true);
                this.multiload = 0;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void setupController() {
        this.controller.setVisible(true);
    }

    @Override
    public void repaint() {
    }

    public void loadPlus() {
        GateArray.cpc.loadSystem();
    }

    public void loadGX() {
        GateArray.cpc.loadGX();
    }

    public void toggleFullscreen() {
        this.alt = false;
        if (this.fullframe == null) {
            this.fullframe = new JFrame();
            this.fullframe.setUndecorated(true);
            this.fullframe.setLayout(new BorderLayout());
            GraphicsConfiguration conf = this.getGraphicsConfiguration();
            int monitors = conf.getDevice().getConfigurations().length;
            int device = 0;
            int h = conf.getDevice().getConfigurations()[device].getBounds().height;
            int w = conf.getDevice().getConfigurations()[device].getBounds().width;
            Dimension d = new Dimension(w, h);
            this.fullframe.setPreferredSize(d);
            this.fullframe.setSize(d);
            Image testit = this.testim.getScaledInstance(d.width, -1, 2);
            this.display.left = new JPanel();
            this.display.right = new JPanel();
            this.display.left.setBackground(Color.black);
            this.display.right.setBackground(Color.black);
            Dimension dd = new Dimension(0, d.height - testit.getHeight(null) >> 1);
            this.display.left.setPreferredSize(dd);
            this.display.right.setPreferredSize(dd);
            if (testit.getHeight(null) > this.getHeight()) {
                testit = this.testim.getScaledInstance(-1, d.height, 2);
                dd = new Dimension(d.width - testit.getWidth(null) >> 1, Toolkit.getDefaultToolkit().getScreenSize().height);
                this.display.left.setPreferredSize(dd);
                this.display.right.setPreferredSize(dd);
                this.display.leftside = new BufferedImage(20, 280, 1);
                this.display.rightside = new BufferedImage(20, 280, 1);
                this.display.leftpixels = new int[5600];
                this.display.rightpixels = new int[5600];
                this.fullframe.add((Component)this.display.left, "West");
                this.fullframe.add((Component)this.display.right, "East");
                this.display.drawborder = true;
            } else {
                this.display.drawborder = false;
                this.fullframe.add((Component)this.display.left, "North");
                this.fullframe.add((Component)this.display.right, "South");
            }
        }
        boolean bl = this.display.fullscreen = !this.display.fullscreen;
        if (this.display.fullscreen) {
            if (frame != null) {
                frame.setVisible(false);
            }
            this.setVisible(false);
            this.show.remove(this.display);
            this.fullframe.add((Component)this.display, "Center");
            this.fullframe.setVisible(true);
        } else {
            this.fullframe.remove(this.display);
            this.show.add((Component)this.display, "Center");
            this.show.repaint();
            this.fullframe.setVisible(false);
            this.setVisible(true);
            if (frame != null) {
                frame.setVisible(true);
                frame.pack();
            }
        }
        this.display.requestFocus();
    }

    public void toggleFilter() {
        Display.scanlines = !Display.scanlines;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 18) {
            this.alt = true;
        }
        if (e.getKeyCode() == 17) {
            this.ctrl = true;
        }
        if (this.alt && e.getKeyCode() == 10 && !this.display.menumode) {
            this.toggleFullscreen();
        }
        if (e.getKeyCode() == 121) {
            e.consume();
            return;
        }
        block8: for (int i = 0; i < 6; ++i) {
            if (e.getKeyCode() != this.controller.keyevents[i]) continue;
            switch (i) {
                case 0: {
                    e.setKeyCode(101);
                    continue block8;
                }
                case 1: {
                    e.setKeyCode(96);
                    continue block8;
                }
                case 2: {
                    e.setKeyCode(104);
                    continue block8;
                }
                case 3: {
                    e.setKeyCode(98);
                    continue block8;
                }
                case 4: {
                    e.setKeyCode(100);
                    continue block8;
                }
                case 5: {
                    e.setKeyCode(102);
                }
            }
        }
        if ((e = this.translator.translate(e, this.localkeys)).getKeyCode() == 123) {
            if (this.ctrl) {
                this.resetComputer();
            } else {
                GateArray.cpc.softReset();
            }
        }
        this.computer.processKeyEvent(e);
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 18) {
            this.alt = false;
        }
        if (e.getKeyCode() == 17) {
            this.ctrl = false;
        }
        block8: for (int i = 0; i < 6; ++i) {
            if (e.getKeyCode() != this.controller.keyevents[i]) continue;
            switch (i) {
                case 0: {
                    e.setKeyCode(101);
                    continue block8;
                }
                case 1: {
                    e.setKeyCode(96);
                    continue block8;
                }
                case 2: {
                    e.setKeyCode(104);
                    continue block8;
                }
                case 3: {
                    e.setKeyCode(98);
                    continue block8;
                }
                case 4: {
                    e.setKeyCode(100);
                    continue block8;
                }
                case 5: {
                    e.setKeyCode(102);
                }
            }
        }
        e = this.translator.translate(e, this.localkeys);
        this.computer.processKeyEvent(e);
        e.consume();
    }

    protected void load() {
        if (this.loader == null) {
            this.loader = new FileDialog((Frame)frame, "Load file", 0);
        }
        this.loader.setVisible(true);
        String filename = this.loader.getFile();
        if (filename != null) {
            filename = this.loader.getDirectory() + this.loader.getFile();
            this.loadFile(1, filename, false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.lightpen) {
            return;
        }
        this.display.requestFocus();
        if (e.getClickCount() == 2 && frame != null && !this.display.fullscreen) {
            if (!CPC.gx4000) {
                Thread b = new Thread(){

                    @Override
                    public void run() {
                        if (GX4000.this.menu != null) {
                            GX4000.this.menu.jCheckBoxMenuItem2.setSelected(!GX4000.this.large);
                            return;
                        }
                        GX4000.this.setFullSize(!GX4000.this.large);
                        System.out.println("Changing display to " + (GX4000.this.large ? "large size" : "small size"));
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        GX4000.this.display.setPreferredSize(GX4000.this.display.getPreferredSize());
                        GX4000.this.display.setSize(GX4000.this.display.getPreferredSize());
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (frame != null) {
                            frame.pack();
                            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                            frame.setLocation((d.width - GX4000.frame.getSize().width) / 2, (d.height - GX4000.frame.getSize().height) / 2);
                        }
                        if (GX4000.this.emu != null) {
                            GX4000.this.emu.pack();
                        }
                    }
                };
                b.start();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.lightpen && !this.display.menumode) {
            if (e.getButton() != 1) {
                this.display.penonscreen = this.penonscreen = !this.penonscreen;
                this.display.setCursor(this.penonscreen ? this.pen : this.gun);
                return;
            }
            int x = e.getX();
            int y = e.getY();
            if (this.display.fullscreen) {
                double xx = 768.0 / (double)this.display.getWidth();
                double yy = 544.0 / (double)this.display.getHeight();
                x = (int)((double)x * xx);
                y = (int)((double)y * yy);
            }
            GateArray.cpc.getCRTC().setLightpen(x, y, this.display.large, this.display.fullscreen, true);
            this.computer.keyPressed(this.penonscreen ? 10 : (CPC.gx4000 ? 17 : 155));
        }
    }

    public void setLightgun(boolean enable) {
        GateArray.cpc.getCRTC().lightgun = this.lightpen = enable;
        if (this.lightpen) {
            this.display.setCursor(this.penonscreen ? this.pen : this.gun);
        } else {
            this.display.setCursor(new Cursor(0));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        block29: {
            int hasIndex;
            int index;
            block34: {
                block33: {
                    int y;
                    int x;
                    block30: {
                        block32: {
                            block31: {
                                block23: {
                                    block28: {
                                        block27: {
                                            block24: {
                                                block26: {
                                                    block25: {
                                                        x = e.getX();
                                                        y = e.getY();
                                                        if (y < 50) {
                                                            Display.showtime = 50;
                                                        }
                                                        if (Display.showtime > 0) {
                                                            int d = this.display.divider;
                                                            d = d == 2 ? 1 : 2;
                                                            if (x > 46 / d && x < 76 / d && y > 6 / d && y < 38 / d) {
                                                                System.out.println("Loading disk 1");
                                                                this.loadFile(2, this.disk1, true);
                                                                Samples.INSERT.play();
                                                            }
                                                            if (x > 80 / d && x < 106 / d && y > 6 / d && y < 38 / d) {
                                                                System.out.println("Loading disk 2");
                                                                this.loadFile(2, this.disk2, true);
                                                                Samples.INSERT.play();
                                                            }
                                                        }
                                                        if (this.menupossible) {
                                                            boolean bl = this.display.menumode = !this.display.menumode;
                                                        }
                                                        if (!this.display.menumode && this.lightpen) {
                                                            this.computer.keyReleased(this.penonscreen ? 10 : (CPC.gx4000 ? 17 : 155));
                                                            GateArray.cpc.getCRTC().releaseGun();
                                                            return;
                                                        }
                                                        if (!this.display.menumode || !this.display.large) break block23;
                                                        if (x <= this.basex || x >= this.basexmax || (y -= this.large ? 50 : 100) >= 480 || y <= 0) break block24;
                                                        index = y / 32;
                                                        if (index < 0) break block25;
                                                        if (index <= Display.carts.length - 1) break block26;
                                                    }
                                                    return;
                                                }
                                                hasIndex = this.controller.cart.getSelectedIndex();
                                                this.controller.cart.setSelectedIndex(index);
                                                if (hasIndex == index) {
                                                    GateArray.cpc.loadCart(index);
                                                }
                                                this.display.menumode = false;
                                            }
                                            if (x <= this.basex + 300 || x >= this.basexmax + 300 || y >= 320 || y <= 0) break block23;
                                            index = 15 + y / 32;
                                            if (index < 0) break block27;
                                            if (index <= Display.carts.length - 1) break block28;
                                        }
                                        return;
                                    }
                                    hasIndex = this.controller.cart.getSelectedIndex();
                                    this.controller.cart.setSelectedIndex(index);
                                    if (hasIndex == index) {
                                        GateArray.cpc.loadCart(index);
                                    }
                                    this.display.menumode = false;
                                }
                                if (!this.display.menumode || this.display.large) break block29;
                                if ((x -= this.display.xdist) <= 100 || x >= 220 || (y -= 50 + this.display.ydist) >= 240 || y <= 0) break block30;
                                index = y / 16;
                                if (index < 0) break block31;
                                if (index <= Display.carts.length - 1) break block32;
                            }
                            return;
                        }
                        hasIndex = this.controller.cart.getSelectedIndex();
                        this.controller.cart.setSelectedIndex(index);
                        if (hasIndex == index) {
                            GateArray.cpc.loadCart(index);
                        }
                        this.display.menumode = false;
                    }
                    if (x <= 250 || x >= 370 || y >= 210 || y <= 0) break block29;
                    index = 15 + y / 16;
                    if (index < 0) break block33;
                    if (index <= Display.carts.length - 1) break block34;
                }
                return;
            }
            hasIndex = this.controller.cart.getSelectedIndex();
            this.controller.cart.setSelectedIndex(index);
            if (hasIndex == index) {
                GateArray.cpc.loadCart(index);
            }
            this.display.menumode = false;
        }
        if (this.display.mCurrFPS < 24) {
            this.computer.reSync();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void loadFile(String name) {
        this.loadFile(0, name, true);
    }

    public void loadDSK(String name) {
        this.loadFile(1, name, true);
    }

    public void loadFile(int type, String name, boolean usePath) {
        if (this.URL) {
            usePath = false;
        }
        try {
            this.computer.stop();
            this.computer.loadFile(type, (usePath ? this.computer.getFilePath() : "") + name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.computer.start();
        this.display.requestFocus();
    }

    public void resetComputer() {
        GateArray.cpc.cprslot = 0;
        this.computer.reset();
    }

    public void loadGame(int slot) {
        GateArray.cpc.loadCart(slot);
    }

    public void setComputer(String name) {
        try {
            this.setComputer(name, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public void setComputer(String name, boolean start) throws Exception {
        if (this.computer == null || !name.equalsIgnoreCase(this.computer.getName())) {
            this.computer = Computer.createComputer(this, name);
            this.setFullSize(this.large);
            this.computer.initialise();
            if (start) {
                this.computer.start();
            }
        }
    }

    void showHideButtons(boolean show) {
        this.control.controller.setVisible(this.large);
        this.control.filter.setVisible(this.large);
        this.control.fullscreen.setVisible(this.large);
    }

    public void setFullSize(boolean value) {
        this.large = value;
        this.showHideButtons(this.large);
        Display.drawmonitor = value ? false : this.keepmonitor;
        this.computer.stop();
        this.display.divider = this.large ? 2 : 1;
        this.display.large = this.large;
        this.computer.setLarge(this.large);
        this.display.setImageSize(this.computer.getDisplaySize(this.large), this.computer.getDisplayScale(this.large));
        this.computer.setDisplay(this.display);
        this.computer.start();
        this.show.repaint();
        this.display.requestFocus();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.computer.displayLostFocus();
        if (this.display.mCurrFPS < 45) {
            this.computer.reSync();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.display.mCurrFPS < 45) {
            this.computer.reSync();
        }
    }

    public void initMenu() {
        this.menu = new GX4000Menu();
        this.menu.setVisible(true);
        this.menu.jMenuItem1.addActionListener(this);
        this.menu.jMenuItem2.addActionListener(this);
        this.menu.jMenuItem3.addActionListener(this);
        this.menu.jMenuItem5.addActionListener(this);
        this.menu.jMenuItem7.addActionListener(this);
        this.menu.jMenuItem8.addActionListener(this);
        this.menu.jCheckBoxMenuItem1.addItemListener(this);
        this.menu.jCheckBoxMenuItem2.addItemListener(this);
        this.menu.jCheckBoxMenuItem3.addItemListener(this);
        this.menu.jCheckBoxMenuItem4.addItemListener(this);
    }

    public static void main(String[] args) {
        asApplet = false;
        CPC.gx4000 = true;
        developer = true;
        GX4000 applet = new GX4000();
        isStandalone = true;
        frame = new JFrame(){

            @Override
            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    System.exit(0);
                }
            }

            @Override
            public synchronized void setTitle(String title) {
                super.setTitle(title);
                this.enableEvents(64L);
            }
        };
        frame.setTitle("JavaGX4000");
        frame.getContentPane().add((Component)applet, "Center");
        applet.initMenu();
        applet.init();
        applet.start();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                frame.setLocation((d.width - 800) / 2, (d.height - 600) / 2);
                frame.setVisible(true);
                frame.setResizable(false);
                frame.pack();
            }
        });
    }

    static {
        developer = false;
        isStandalone = false;
        asApplet = true;
    }

    private class DropListener
    extends DropTargetAdapter {
        private DropListener() {
        }

        @Override
        public void dragExit(DropTargetEvent dtde) {
            GX4000.this.display.showdrives = 0;
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            int x = dtde.getLocation().x;
            int y = dtde.getLocation().y;
            toDriveB = x > 370 / (GX4000.this.display.large ? 1 : 2);
            try {
                Object userObject;
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (userObject = t.getTransferData(DataFlavor.javaFileListFlavor)) instanceof List) {
                    String fileName = ((List)userObject).get(0).toString();
                    GX4000.this.display.showdrives = fileName.toLowerCase().endsWith(".dsk") ? 20 : 0;
                }
            }
            catch (Exception ex) {
                System.out.println("[MainForm::DropListener]" + ex);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.acceptDrop(3);
                    Object userObject = t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (userObject instanceof List) {
                        String filename = ((List)userObject).get(0).toString();
                        if (filename.toLowerCase().endsWith(".dsk")) {
                            int d = GX4000.this.computer.getCurrentDrive();
                            GX4000.this.computer.setCurrentDrive(toDriveB ? 1 : 0);
                            GX4000.this.loadFile(1, filename, false);
                            GX4000.this.computer.setCurrentDrive(d);
                        } else {
                            GX4000.this.loadFile(1, filename, false);
                        }
                    }
                    dtde.dropComplete(true);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

