/*
 * Decompiled with CFR 0.152.
 */
package CPCFileSystem;

import CPCFileSystem.DskMaster;
import CPCFileSystem.DskSector;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DskTrack {
    String header = "Track-Info\r\n";
    private DskMaster master;
    public List<DskSector> sectors = new ArrayList<DskSector>();
    int noTrack;
    int side = 0;
    int sectorSize = 2;
    int nbSectors = 9;
    int gap = 42;
    int fillerByte = 229;

    public DskTrack(DskMaster master) {
        this.master = master;
    }

    public void scan(FileInputStream fis) throws IOException {
        byte[] bufferHeader = new byte[12];
        fis.read(bufferHeader);
        this.header = this.master.arrayToString(bufferHeader);
        fis.read();
        fis.read();
        fis.read();
        fis.read();
        this.noTrack = fis.read();
        this.side = fis.read();
        fis.read();
        fis.read();
        this.sectorSize = fis.read();
        this.nbSectors = fis.read();
        this.gap = fis.read();
        this.fillerByte = fis.read();
    }

    public void scan(FileOutputStream fos) throws IOException {
        fos.write(this.header.getBytes());
        fos.write(0);
        fos.write(0);
        fos.write(0);
        fos.write(0);
        fos.write(this.noTrack);
        fos.write(this.side);
        fos.write(0);
        fos.write(0);
        fos.write(this.sectorSize);
        fos.write(this.nbSectors);
        fos.write(this.gap);
        fos.write(this.fillerByte);
    }

    public String toString() {
        return "Track-Info " + this.noTrack + "\n";
    }
}

