/*
 * Decompiled with CFR 0.152.
 */
package CPCFileSystem;

import CPCFileSystem.DskMaster;
import CPCFileSystem.DskTrack;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DskFile {
    String header = "EXTENDED CPC DSK File\r\nDisk-Info\r\n";
    String creator = "UniPixelViewer";
    int nbTracks = 40;
    int nbSides = 1;
    int sizeOfTrack = 19;
    DskMaster master;
    File file;
    List<DskTrack> tracks = new ArrayList<DskTrack>();

    public DskFile(File currentDir, String fileName) {
        this.master = new DskMaster();
        this.file = new File(currentDir, fileName);
    }

    public DskFile(String fileName) {
        this.master = new DskMaster();
        this.file = new File(fileName);
    }

    public void scan(FileInputStream fis) throws IOException {
        byte[] bufferHeader = new byte[34];
        fis.read(bufferHeader);
        this.header = this.master.arrayToString(bufferHeader);
        byte[] bufferCreator = new byte[14];
        fis.read(bufferCreator);
        this.creator = this.master.arrayToString(bufferCreator);
        this.nbTracks = fis.read();
        this.nbSides = fis.read();
        this.sizeOfTrack = fis.read();
        this.sizeOfTrack += fis.read() * 16;
        this.sizeOfTrack = fis.read();
        fis.skip(this.nbTracks - 1);
        long position = fis.getChannel().position();
        fis.skip(256L - position);
    }

    public void scan(FileOutputStream fos) throws IOException {
        fos.write(this.header.getBytes());
        fos.write(this.creator.getBytes());
        fos.write(this.nbTracks);
        fos.write(this.nbSides);
        fos.write(0);
        fos.write(0);
        int i = 0;
        for (i = 0; i < this.nbTracks * this.nbSides; ++i) {
            fos.write(this.sizeOfTrack);
        }
        while (i < 204) {
            fos.write(0);
            ++i;
        }
    }
}

