	INCLUDE "hardware.inc"
	INCLUDE "gfxlib.inc"
	INCLUDE "macros.inc"

RGB2GBC: MACRO
	DW	((\1 & $1f) | ((\2 & $1f) << 5) | ((\3 & $1f) << 10))
	ENDM

Player_Initialize	EQU	$4000
Player_MusicStart	EQU	$4003
Player_MusicStop	EQU	$4006
Player_SongSelect	EQU	$400c
Player_MusicUpdate	EQU	$4100


DX		EQU	15
DY		EQU	15
DZ		EQU	15

PX		EQU	-30
PY		EQU	58
PZ		EQU	30

NOO		EQU	8

INTROBANK	EQU	2
INTROS		EQU	31
MENUYPOS	EQU	(144-(8*8))
MENUSPEED	EQU	$0040
JUMPSTEPS	EQU	64
GLOBAL	Alphabet
GLOBAL	Bubble
GLOBAL	Header

	SECTION	"Startup",HOME[0]

RST_00:	jp	Main
	DS	5
RST_08:	jp	Main
	DS	5
RST_10:	jp	Main
	DS	5
RST_18:	jp	Main
	DS	5
RST_20:	jp	Main
	DS	5
RST_28:	jp	Main
	DS	5
RST_30:	jp	Main
	DS	5
RST_38:	jp	Main
	DS	5
	jp	irq_VBlank
	DS	5
	jp	irq_LCDC
	DS	5
	jp	irq_Timer
	DS	5
	jp	irq_Serial
	DS	5
	jp	irq_HiLo
	DS	5

	DS	$100-$68

	nop
	jp	Main

	DB	$CE,$ED,$66,$66,$CC,$0D,$00,$0B,$03,$73,$00,$83,$00,$0C,$00,$0D
	DB	$00,$08,$11,$1F,$88,$89,$00,$0E,$DC,$CC,$6E,$E6,$DD,$DD,$D9,$99
	DB	$BB,$BB,$67,$63,$6E,$0E,$EC,$CC,$DD,$DC,$99,$9F,$BB,$B9,$33,$3E

		;0123456789ABCDEF
	DB	"Intro Collector",$80
	DB	0,0,0	;SuperGameboy
	DB	$11	;CARTTYPE
			;--------
			;0 - ROM ONLY
			;1 - ROM+MBC1
			;2 - ROM+MBC1+RAM
			;3 - ROM+MBC1+RAM+BATTERY
			;5 - ROM+MBC2
			;6 - ROM+MBC2+BATTERY

	DB	5	;ROMSIZE
			;-------
			;0 - 256 kBit ( 32 kByte,  2 banks)
			;1 - 512 kBit ( 64 kByte,  4 banks)
			;2 -   1 MBit (128 kByte,  8 banks)
			;3 -   2 MBit (256 kByte, 16 banks)
			;3 -   4 MBit (512 kByte, 32 banks)

	DB	0	;RAMSIZE
			;-------
			;0 - NONE
			;1 -  16 kBit ( 2 kByte, 1 bank )
			;2 -  64 kBit ( 8 kByte, 1 bank )
			;3 - 256 kBit (32 kByte, 4 banks)

	DW	$0000	;Manufacturer

	DB	0	;Version
	DB	0	;Complement check
	DW	0	;Checksum

; --
; -- Main Program
; --

Main::
	ld	hl,BuildMenu
	; we want a stack
	ld	hl,StackTop
	ld	sp,hl

	ld	a,0
	ld	[ofs],a
	ld	[ofs+1],a

	call	WaitButtonRelease
	call	Initialize

	ld	a,1
	ld	[$2000],a
	call	Player_Initialize
	call	Player_MusicStart

.loop
	call	GFX_WaitBlank
	call	GFX_DMAProc
	call	ResetScreen
	call	Player_MusicUpdate

	ld	a,[HeadOfs]
	inc	a
	ld	[HeadOfs],a
	ld	e,a
	ld	d,0
	ld	hl,HeadSin
	add	hl,de
	ld	a,[hl]
	ldh	[rSCX],a

	ld	a,56
	ldh	[rSCY],a

	ld	a,[ofs]
	ld	h,a
	ld	a,[ofs+1]
	ld	l,a
	ld	de,$0100
	add	hl,de
	ld	a,l
	ld	[ofs+1],a
	ld	a,h
	ld	[ofs],a

	call	DoCube

	ld	a,[scrollyColOfs]
	ld	h,a
	ld	a,[scrollyColOfs+1]
	ld	l,a
	ld	bc,$0020
	add	hl,bc
	ld	a,h
	ld	[scrollyColOfs],a
	ld	a,l
	ld	[scrollyColOfs+1],a

	; Do the main stuff
	call	Menu
	call	DoScrolly
	call	RasterEffects

	jp	.loop



DoCube::
	; Calculate and display the cube
	ld	l,a
	ld	h,0
	ld	de,CubeX
	add	hl,de
	ld	a,[hl]
	add	100
	ld	[cubeZP],a
	ld	a,[ofs]
	add	64
	ld	l,a
	ld	h,0
	ld	de,CubeX
	add	hl,de
	ld	a,[hl]
	add	48
	ld	[cubeXP],a

	ld	hl,CubeModel
	ld	de,GFX_OAM
	ld	c,NOO

.bccc	push	bc
	push	de
	ld	a,[hl+]
	ld	b,a
	ld	a,[hl+]
	ld	c,a
	ld	a,[hl+]
	ld	d,a
	ld	a,[ofs]
	push	hl
	call	VectRotX
	ld	a,[ofs]
	call	VectRotY
	ld	a,[ofs]
	call	VectRotZ
	ld	a,[cubeZP]
	add	d
	ld	d,a
	sra	a
	sra	a
;	sra	a
;	sra	a
	and	%11111100
	ld	[temp],a
	ld	a,[cubeXP]
	add	c
	ld	c,a
	call	Persp
	pop	hl
	pop	de

	; Sprite
	; x,y
	ld	a,b
	add	PY
	ld	[de],a
	inc	de
	ld	a,c
	add	PX
	ld	[de],a
	inc	de
	; tile #
	ld	a,[temp]
	ld	[de],a
	inc	de
	inc	de

	ld	a,b
	add	PY+8
	ld	[de],a
	inc	de
	ld	a,c
	add	PX
	ld	[de],a
	inc	de
	ld	a,[temp]
	inc	a
	ld	[temp],a
	ld	[de],a
	inc	de
	inc	de

	ld	a,b
	add	PY
	ld	[de],a
	inc	de
	ld	a,c
	add	PX+8
	ld	[de],a
	inc	de
	ld	a,[temp]
	inc	a
	ld	[temp],a
	ld	[de],a
	inc	de
	inc	de

	ld	a,b
	add	PY+8
	ld	[de],a
	inc	de
	ld	a,c
	add	PX+8
	ld	[de],a
	inc	de
	ld	a,[temp]
	inc	a
	ld	[temp],a
	ld	[de],a
	inc	de
	inc	de


	pop	bc

	dec	c
	jp	nz,.bccc
	ret



; a=Angle, b=x, c=y, d=z
VectRotZ::
	; h=sin(a)
	; l=cos(a)
	ld	l,a
	ld	h,0
	add	64
	push	af
	push	de
	ld	de,SinTable
	add	hl,de
	pop	de
	ld	a,[hl]
	ld	e,a
	pop	af
	ld	l,a
	ld	h,0
	push	de
	ld	de,SinTable
	add	hl,de
	pop	de
	ld	a,[hl]
	ld	l,a
	ld	h,e

	; -- b,c,d intact
	ld	a,b
	ld	[temp+0],a	; x
	ld	a,c
	ld	[temp+1],a	; y
	ld	a,d
	ld	[temp+2],a	; z

	ld	c,l
	push	hl
	call	FastMul
;	sla	d
	pop	hl
	ld	a,d
	ld	[temp+3],a	; x*cos(a)

	ld	a,[temp+1]
	ld	b,a
	ld	c,h
	push	hl
	call	FastMul
	sla	d
	pop	hl
	ld	a,d
	ld	[temp+4],a	; y*sin(a)

	ld	a,[temp+0]
	ld	b,a
	ld	c,h
	push	hl
	call	FastMul
;	sla	d
	pop	hl
	ld	a,d
	ld	[temp+5],a	; x*sin(a)

	ld	a,[temp+1]
	ld	b,a
	ld	c,l
	push	hl
	call	FastMul
;	sla	d
	pop	hl
	ld	a,d
	ld	[temp+6],a	; y*cos(a)

	; x' = x*cos(a)-y*sin(a)
	ld	a,[temp+4]
	ld	e,a
	ld	a,[temp+3]
	sub	e
	ld	b,a
	; y' = x*sin(a)+y*cos(a)
	ld	a,[temp+6]
	ld	e,a
	ld	a,[temp+5]
	add	e
	ld	c,a
	; z' = z
	ld	a,[temp+2]
	ld	d,a

	ret



; a=Angle, b=x, c=y, d=z
VectRotY::
	; h=sin(a)
	; l=cos(a)
	ld	l,a
	ld	h,0
	add	64
	push	af
	push	de
	ld	de,SinTable
	add	hl,de
	pop	de
	ld	a,[hl]
	ld	e,a
	pop	af
	ld	l,a
	ld	h,0
	push	de
	ld	de,SinTable
	add	hl,de
	pop	de
	ld	a,[hl]
	ld	l,a
	ld	h,e

	; -- b,c,d intact
	ld	a,b
	ld	[temp+0],a	; x
	ld	a,c
	ld	[temp+1],a	; y
	ld	a,d
	ld	[temp+2],a	; z

	ld	c,l
	push	hl
	call	FastMul
;	sla	d
	pop	hl
	ld	a,d
	ld	[temp+3],a	; x*cos(a)

	ld	a,[temp+2]
	ld	b,a
	ld	c,h
	push	hl
	call	FastMul
	sla	d
	pop	hl
	ld	a,d
	ld	[temp+4],a	; z*sin(a)

	ld	a,[temp+2]
	ld	b,a
	ld	c,l
	push	hl
	call	FastMul
;	sla	d
	pop	hl
	ld	a,d
	ld	[temp+5],a	; z*cos(a)

	ld	a,[temp+0]
	ld	b,a
	ld	c,h
	push	hl
	call	FastMul
;	sla	d
	pop	hl
	ld	a,d
	ld	[temp+6],a	; x*sin(a)

	; x' = x*cos(a)+z*sin(a)
	ld	a,[temp+3]
	ld	e,a
	ld	a,[temp+4]
	add	e
	ld	b,a
	; z' = z*cos(a)-x*sin(a)
	ld	a,[temp+6]
	ld	e,a
	ld	a,[temp+5]
	sub	e
	ld	d,a
	; y' = y
	ld	a,[temp+1]
	ld	c,a

	ret



; a=Angle, b=x, c=y, d=z
VectRotX::
	; h=sin(a)
	; l=cos(a)
	ld	l,a
	ld	h,0
	add	64
	push	af
	push	de
	ld	de,SinTable
	add	hl,de
	pop	de
	ld	a,[hl]
	ld	e,a
	pop	af
	ld	l,a
	ld	h,0
	push	de
	ld	de,SinTable
	add	hl,de
	pop	de
	ld	a,[hl]
	ld	l,a
	ld	h,e

	; -- b,c,d intact
	ld	a,b
	ld	[temp+0],a	; x
	ld	a,c
	ld	[temp+1],a	; y
	ld	a,d
	ld	[temp+2],a	; z

	; b=b
	; c = y*cos(a) - z*sin(a)
	ld	b,l
	push	hl
	call	FastMul
;	sla	d
	pop	hl
	ld	a,d
	ld	[temp+3],a	; y*cos(a)

	ld	a,[temp+2]
	ld	b,a
	ld	c,h
	push	hl
	call	FastMul
;	sla	d
	pop	hl
	ld	a,d
	ld	[temp+4],a	; z*sin(a)

	ld	a,[temp+1]
	ld	b,a
	ld	c,h
	push	hl
	call	FastMul
;	sla	d
	pop	hl
	ld	a,d
	ld	[temp+5],a	; y*sin(a)

	ld	a,[temp+2]
	ld	b,a
	ld	c,l
	push	hl
	call	FastMul
	sla	d
	pop	hl
	ld	a,d
	ld	[temp+6],a	; z*cos(a)

	; y'=y*cos(a)-z*sin(a)
	ld	a,[temp+4]
	ld	e,a
	ld	a,[temp+3]
	sub	e
	ld	c,a
	; z'=y*sin(a)+z*cos(a)
	ld	a,[temp+5]
	ld	e,a
	ld	a,[temp+6]
	add	e
	ld	d,a
	; x'=x
	ld	a,[temp+0]
	ld	b,a

	ret

; D = ((B*8)/C)
FastMul8::
	ld	a,b
;	xor	c
	push	af
	bit	7,b
	jp	z,.n1
	ld	a,b
	cpl
	inc	a
	ld	b,a
.n1	ld	hl,LogTable
	ld	e,c
	ld	d,0
	add	hl,de
	ld	a,[hl]
	ld	hl,LogTableX
	ld	e,b
	ld	d,0
	add	hl,de
	ld	b,a
	ld	a,[hl]
	sub	b
	ld	hl,AntilogTable
	ld	e,a
	ld	d,0
	add	hl,de
	add	hl,de
	ld	a,[hl]
	ld	d,a

	pop	af
	and	$80
	jp	z,.end
	ld	a,d
	cpl
	inc	a
	ld	d,a
.end	ret






; D  = (B * C)>>8
FastMul::
	ld	a,b
	xor	c
	push	af
	bit	7,b
	jp	z,.n1
	ld	a,b
	cpl
	inc	a
	ld	b,a
.n1	bit	7,c
	jp	z,.n2
	ld	a,c
	cpl
	inc	a
	ld	c,a

.n2	ld	hl,LogTable
	push	hl
	ld	d,0
	ld	e,b
	add	hl,de
	ld	a,[hl]
	pop	hl
	ld	e,c
	add	hl,de
	ld	e,a
	ld	a,[hl]
	ld	h,0
	ld	l,a
	add	hl,de
	slaHL
	ld	de,AntilogTable
	add	hl,de
	ld	a,[hl+]
	ld	e,a
	ld	a,[hl]
	ld	d,a
	pop	af
	and	$80
	jp	z,.end
	ld	a,d
	cpl
	inc	a
	ld	d,a
.end	ret


; b=x, c=y, d=z
Persp::
;	ld	a,255
;	sub	d
;	ld	d,a
	push	bc
	ld	c,d
	push	de
	; b=x, c=z
	call	FastMul8
	pop	af
	pop	bc
	ld	b,c
	ld	c,a
	; b=y, c=z
	push	de
	call	FastMul8
	pop	bc
	ld	c,d
	ret


; DE = B * C
FastMul2::
	ld	a,b
	xor	c
	push	af
	bit	7,b
	jp	z,.n1
	ld	a,b
	cpl
	inc	a
	ld	b,a
.n1	bit	7,c
	jp	z,.n2
	ld	a,c
	cpl
	inc	a
	ld	c,a

.n2	ld	hl,LogTable
	ld	e,b
	ld	d,0
	add	hl,de
	add	hl,de
	ld	a,[hl+]
	ld	d,a
	ld	a,[hl]
	ld	e,a
	ld	b,0
	ld	hl,LogTable
	add	hl,bc
	add	hl,bc
	ld	a,[hl+]
	ld	b,a
	ld	a,[hl]
	ld	l,a
	ld	h,b
	add	hl,de
	add	hl,hl
	ld	bc,AntilogTable
	add	hl,bc
	ld	a,[hl+]
	ld	e,a
	ld	a,[hl]
	ld	d,a
	pop	af
	and	$80
	jp	z,.end
	negDE
.end	ret




irq_VBlank:
	reti

irq_LCDC:
	reti

irq_Timer:
	reti

irq_Serial:
	reti

irq_HiLo:
	reti






	; ********* WaitButtonRelease *********
WaitButtonRelease::
	call	GFX_ReadJoypad
	and	%10110000
	jp	nz,WaitButtonRelease
	ret





	; ********* Initialize ********
Initialize::
	; disable interrupts
	di

	; Select rom bank 1
	ld	a,1
	ld	[$2000],a

	; Get last selection
	ld	a,7
	ld	[$ff70],a
	ld	a,0
	ld	[CurTitle],a
	ld	hl,$dffc
	ld	a,"C"
	cp	[hl]
	jp	nz,.nxt
	inc	hl
	ld	a,"H"
	cp	[hl]
	jp	nz,.nxt
	inc	hl
	ld	a,"N"
	cp	[hl]
	jp	nz,.nxt
	inc	hl
	ld	a,[hl]
	ld	[CurTitle],a
.nxt	ld	a,1
	ld	[$ff70],a

	call	GFX_ScreenOff
	call	DoubleSpeed
	; Sound off
	ld	a, 0
	ldh	[$26],a
	; Copy DMA proc
	call	GFX_CopyDMAProc
	call	GFX_ZeroOAM
	call	GFX_Sprites8x8
	; Interrupts
	ld	a,%11
	ldh	[$ff],a
	ld	a,%00001000
	ldh	[rSTAT],a

	; Upload our font
	ld	a,0
	ldh	[$4f],a
	ld	hl,Alphabet
	ld	de,$8000
	ld	bc,$1000
	call	memcpy_vram
	; Reset VRAM
	ld	a," "
	ld	de,$9800
	ld	bc,$800
	call	memset_vram
	; Upload bubble
	ld	a,1
	ldh	[$4f],a
	ld	hl,Bubble
	ld	de,$8000
	ld	bc,16*4*8
	call	memcpy_vram
	ld	a,0
	ld	de,$9800
	ld	bc,$800
	call	memset_vram

	ld	a,0
	ldh	[$4f],a

	; Reset palette RAM
	ld	hl,0
	call	GFX_SetBGAllColors

	ld	a,%10001000
	ldh	[$68],a
	ld	hl,HeadColors
	ld	c,8
.ccol	ld	a,[hl+]
	ldh	[$69],a
	dec	c
	jr	nz,.ccol

	; Sprite colors
	ld	a,$80
	ldh	[$6a],a
	ld	a,0
	ldh	[$6b],a
	ldh	[$6b],a
	ld	a,$ff
	ldh	[$6b],a
	ld	a,$7f
	ldh	[$6b],a
	; Prepare sprites
	ld	hl,GFX_OAM+3
	ld	a,%10001000
	ld	c,4*NOO
.pspr	ld	[hl+],a
	inc	hl
	inc	hl
	inc	hl
	dec	c
	jp	nz,.pspr

	; Copy header
	ld	a,0
	ldh	[$4f],a
	ld	hl,Header+1
	ld	de,$9800+(7*32)
	ld	c,2*32
.chead1	ld	a,[hl+]
	inc	hl
	ld	[de],a
	inc	de
	dec	c
	jp	nz,.chead1

	ld	a,1
	ldh	[$4f],a
	ld	hl,Header
	ld	de,$9800+(7*32)
	ld	c,2*32
.chead2	ld	a,[hl+]
	inc	hl
	ld	[de],a
	inc	de
	dec	c
	jp	nz,.chead2


	call	GFX_SpritesOn
	call	GFX_WindowOff
	call	GFX_ShowTileMap0

	; Build the menu
	call	BuildMenu

	; Predefine the mem variables
	ld	a,256-(20*8)
	ld	[scrollyX],a
	ld	a,$ff
	ld	[scrollyX+1],a
	ld	[scrollyX+2],a
	ld	a,MENUYPOS+(2*8)
	ld	[Cursor],a

	ld	a,0
	ld	[scrollyColOfs],a
	ld	[scrollyColOfs+1],a
	ld	[scrollyJPos],a
	ld	[scrollyDist],a
	ld	[scrollyDist+1],a
	ld	[scrollyDistOfs],a
	ld	[scrollyWait],a
	ld	[MenuY+1],a
	ld	[MenuDY],a
	ld	[MenuDY+1],a
	ldh	[rSCX],a
	ldh	[rSCY],a
	ld	[scrollySpeed+1],a
	ld	[scrollyX+3],a
	ld	a,1
	ld	[scrollySpeed],a
	ld	[scrollyY],a
	ld	a,8
	ld	[scrollyDistOfs+1],a

	call	GFX_ReadJoypad
	and	%10001100
	ld	[LastJoy],a

	call	GFX_ScreenOn
	ret




	; ******** ResetScreen ********
ResetScreen::
	; Reset scroll x and y
	ld	a,0
	ld	[rSCX],a
	ld	[rSCY],a
	; Switch to bg 0
	ldh	a,[rLCDC]
	and	%11110111
	ldh	[rLCDC],a
	; Reset colors
	WaitVRAM
	ld	a,$80
	ldh	[$68],a
	ld	hl,ColTab+2
	ld	a,0
	ldh	[$69],a
	ldh	[$69],a
	ld	a,[hl+]
	ldh	[$69],a
	ld	a,[hl+]
	ldh	[$69],a
	ret



	; ******** RasterEffects ********
RasterEffects::
	; ** Menu Gradient On **
	ld	a,MENUYPOS
	ld	hl,MenuGradient
	ld	c,8*5
	call	WaitLine
	WaitHRAM

	ldh	a,[rLCDC]
	or	8
	ldh	[rLCDC],a
	ld	a,[MenuY]
	ldh	[rSCY],a
	ld	a,0
	ldh	[rSCX],a

.d1	ld	a,$80
	ldh	[$68],a
	ld	a,[hl+]
	ldh	[$69],a
	ld	a,[hl+]
	ldh	[$69],a
	ld	a,[hl+]
	ldh	[$69],a
	ld	a,[hl+]
	ldh	[$69],a
	call	WaitNextLine
	WaitHRAM
	dec	c
	jp	nz,.d1

	; ** Scrolly Stuff **
	call	WaitNextLine
	WaitHRAM
	; Switch scrolly on
	ldh	a,[rLCDC]
	and	%11110111
	ldh	[rLCDC],a
	ld	a,[scrollyX]
	ldh	[rSCX],a
	ld	a,[scrollyY]
	ld	b,a
	ld	a,16
	sub	b
	ldh	[rSCY],a
	; Scrolly
	ld	a,[scrollyY]
	add	144-(3*8)
	call	WaitLine

	ld	a,[scrollyX]
	ld	h,a
	ld	l,0
	ld	a,[scrollyDist]
	ld	d,a
	ld	a,[scrollyDist+1]
	ld	e,a
	ld	c,7
	WaitHRAM
.nl1	ld	a,h
	ldh	[rSCX],a
	add	hl,de
	push	hl
	push	bc
	ld	a,7
	sub	c
	ld	l,a
	ld	a,[scrollyColOfs]
	add	l
	and	63
	ld	h,0
	ld	l,a
	slaHL
	ld	bc,ScrollyColors
	add	hl,bc
	ld	a,$82
	ldh	[$68],a
	ld	a,[hl+]
	ldh	[$69],a
	ld	a,[hl]
	ldh	[$69],a
	pop	bc
	pop	hl
	call	WaitNextLine
	WaitHRAM
	dec	c
	jp	nz,.nl1

	ld	h,d
	ld	l,e
	ld	a,[scrollyDistOfs]
	ld	d,a
	ld	a,[scrollyDistOfs+1]
	ld	e,a
	add	hl,de
	ld	a,l
	ld	[scrollyDist+1],a
	ld	a,h
	ld	[scrollyDist],a
	bit	7,h
	jp	z,.nneg
	negHL
.nneg	ld	a,h
	cp	1
	jp	nz,.nnnn
	negDE
.nnnn	ld	a,d
	ld	[scrollyDistOfs],a
	ld	a,e
	ld	[scrollyDistOfs+1],a
	ret






	; ******** Menu ********
Menu::
	; Menu scrolling
	ld	a,[MenuDY]
	cp	0
	jp	z,.nn
	ld	b,a
	ld	a,[MenuY]
	add	a,b
	ld	[MenuY],a
	and	7
	jp	nz,.nn

	ld	a,0
	ld	[MenuDY],a
	ld	a,[CurTitle]
	add	a,b
	ld	[CurTitle],a

.nn	call	GFX_ReadJoypad
	ld	b,a

	ld	a,[MenuDY]
	cp	0
	jp	nz,.nem

	ld	a,b
	and	8
	jp	nz,.down
	ld	a,b
	and	4
	jp	nz,.up

.nem
	ld	a,b
	and	%10110000
	call	nz,StartIntro

	ret

.down
	ld	a,[CurTitle]
	cp	INTROS-1
	ret	z

	ld	a,1
	ld	[MenuDY],a


.paint	ld	a,0
	ldh	[$4f],a

	ld	a,[CurTitle]
	add	3
	ld	l,a
	ld	h,0
	slaHL
	slaHL
	slaHL
	slaHL
	slaHL
	ld	bc,Descriptions
	add	hl,bc
	; de = (([CurTitle]+5) * 32) & 0x03ff
	ld	a,[CurTitle]
	add	5
	ld	e,a
	ld	d,0
	slaDE
	slaDE
	slaDE
	slaDE
	slaDE
	ld	a,d
	and	3
	ld	d,a

	push	hl
	push	de
	pop	hl
	pop	de

	ld	bc,$9c00
	add	hl,bc

	push	hl
	push	de
	pop	hl
	pop	de

	ld	bc,32
	push	de
	push	hl
	call	memcpy_vram
	pop	hl
	pop	de
	ld	bc,-6*32
	add	hl,bc
	push	hl
	push	de
	pop	hl
	pop	de
	ld	bc,$6400	;
	add	hl,bc
	ld	bc,-6*32
	add	hl,bc
	ld	a,h
	and	3
	ld	h,a
	ld	bc,$9c00
	add	hl,bc		;
	push	hl
	push	de
	pop	hl
	pop	de
	ld	bc,32
	call	memcpy_vram

	ret
.up
	ld	a,[CurTitle]
	cp	0
	ret	z

	ld	a,-1
	ld	[MenuDY],a

	jp	.paint
	ret



	; ******** WaitLine ********
WaitLine::
	ld	b,a
.w	ldh	a,[$44]
	cp	b
	jp	nz,.w
;	WaitHRAM
	ret

	; ******** WaitNextLine ********
WaitNextLine::
	ldh	a,[$44]
	ld	b,a
.w	ldh	a,[$44]
	cp	b
	jp	z,.w
;	WaitHRAM
	ret





	; ******** BuildMenu ********
BuildMenu::
	ld	a,0
	ldh	[$4f],a

	ld	a,[CurTitle]
	
	ld	l,a
	ld	h,0
	slaHL
	slaHL
	slaHL
	slaHL
	slaHL	; hl*=32
	ld	de,$9c00
	push	hl
	add	hl,de
	ld	d,h
	ld	e,l
	ld	hl,Descriptions
	pop	bc
	add	hl,bc
	ld	bc,-2*32
	add	hl,bc

	ld	c,5
.lop	push	bc

	ld	bc,32
	push	hl
	push	de
	call	memcpy_vram
	pop	de
	ld	hl,32
	add	hl,de
	ld	d,h
	ld	e,l
	ld	a,d
	and	$f0
	cp	$a0
	jp	nz, .cont
	ld	de,$9c00
.cont	pop	hl

	ld	bc,32
	add	hl,bc

	pop	bc
	dec	c
	jp	nz,.lop

	ld	a,[CurTitle]
	sla	a
	sla	a
	sla	a
	sub	MENUYPOS
	ld	[MenuY],a
	ret





	; ******** DoScrolly ********
DoScrolly::
	ld	a,0
	ldh	[$4f],a

	ld	a,[scrollyX+1]
	ld	h,a
	ld	a,[scrollyX+2]
	ld	l,a

	ld	a,[scrollyWait]
	cp	0
	jp	z,.cont
	dec	a
	ld	[scrollyWait],a
	jp	.end

.cont	push	hl
	ld	a,[scrollyX]
	ld	h,a
	push	af
	and	%11111000
	ld	d,a
	pop	af
	and	%00000111
	ld	e,a
	ld	a,[scrollyX+3]
	ld	l,a

	ld	a,[scrollySpeed]
	ld	b,a
	ld	a,[scrollySpeed+1]
	ld	c,a

	add	hl,bc

	ld	a,l
	ld	[scrollyX+3],a
	ld	a,h
	ld	[scrollyX],a

	pop	hl

	push	af
	and	%00000111
	cp	e
	jp	nz,.here
	pop	af
	jp	.cont2
.here	pop	af
	and	%11111000
	cp	d
	jp	z,.n1
	inc	hl

.cont2	ld	bc,ScrollText
.lval	push	hl
	add	hl,bc
	ld	a,[hl]
	pop	hl
	cp	a,0
	jp	nz,.n2
	ld	hl,0
	jp	.lval
.n2	cp	a,1
	jp	nz,.n4
	ld	a,[scrollyX]
	sub	8
	ld	[scrollyX],a
	inc	hl
	push	hl
	add	hl,bc
	ld	a,[hl]
	pop	hl
	ld	[scrollyWait],a
	jp	.n1
.n4	cp	a,2
	jp	nz,.n5
	inc	hl
	push	hl
	add	hl,bc
	ld	a,[hl+]
	ld	[scrollySpeed],a
	ld	a,[hl]
	ld	[scrollySpeed+1],a
	pop	hl
	inc	hl
	inc	hl
	jp	.lval

.n5	push	hl
	push	af

	ld	hl,$9a20
	ld	a,[scrollyX]
	add	20*8
	sra	a
	sra	a
	sra	a
	add	l
	and	$1f
	or	%00100000
	ld	l,a
	WaitVRAM
	pop	af
	ld	[hl],a
	pop	hl
.n1	ld	a,h
	ld	[scrollyX+1],a
	ld	a,l
	ld	[scrollyX+2],a

.end	ld	a,[scrollyJPos]
	ld	e,a
	ld	d,0
	ld	hl,ScrollyJump
	add	hl,de
	ld	a,[hl]
	ld	[scrollyY],a

	ld	a,[scrollyJPos]
	inc	a
	cp	JUMPSTEPS
	jp	nz,.n3
	ld	a,0
.n3	ld	[scrollyJPos],a
	ret





	; ******** DoubleSpeed ********
DoubleSpeed::
	ldh	a,[$4d]
	bit	7,a
	jp	nz,.end

	ld	a,1
	ldh	[$4d],a
	ld	a,$30
	ldh	[0],a
	stop

.end	ret


	; ******** SingleSpeed ********
SingleSpeed::
	ldh	a,[$4d]
	bit	7,a
	jp	z,.end

	ld	a,1
	ldh	[$4d],a
	ld	a,$30
	ldh	[0],a
	stop

.end	ret






	; ******** StartIntro ********
StartIntro::
	di

	call	Player_MusicStop

	call	SingleSpeed

	; Set last selection
	ld	a,7
	ld	[$ff70],a
	ld	a,"C"
	ld	[$dffc],a
	ld	a,"H"
	ld	[$dffd],a
	ld	a,"N"
	ld	[$dffe],a
	ld	a,[CurTitle]
	ld	[$dfff],a
	ld	a,1
	ld	[$ff70],a

	ld	de, $fe00
	ld	bc, $100
	ld	a,0
	call	memset

	ld	hl, %0111111111111111
	call	GFX_SetBGAllColors

	ld	a,1
	ldh	[$4f],a
	ld	a,0
	ld	de,$8000
	ld	bc,$2000
	call	memset_vram
	ld	a,0
	ldh	[$4f],a
	ld	de,$8000
	ld	bc,$2000
	call	memset_vram

	ld	a,[CurTitle]
	ld	l,a
	ld	h,0
	add	INTROBANK
	ld	[$2000], a
	slaHL
	ld	bc, CallTab
	add	hl, bc
	ld	a, [hl]
	inc	hl
	ld	b, a
	ld	a, [hl]
	inc	hl
	ld	h, a
	ld	l, b

	call	GFX_ScreenOff

	ld	a,0
	ldh	[$ff],a

	ei
	jp	[hl]












	SECTION "StartupConstants",HOME[$1000]

ScrollText::
	DB	2,1,0
	DB	"HEY !!!! YEAH, THIS IS THE GBC INTRO COLLECTION..... ... .. ... "
	DB	"I REALLY LOOKED INTO ALL GBC RELEASES AND EXTRACTED THE INTROS "
	DB	"AND MADE THIS CUTE ROM OUT OF THEM... ... SELECT AN INTRO FROM THE MENU AND "
	DB	"PRESS START. YOU CAN RETURN TO THIS MENU BY PRESSING START AGAIN",2,2,0," ... ... ... ... ",2,4,0,"                            "
	DB	2,1,0
	DB	"BY THE WAY, THIS FONT IS FROM THE C= PLUS/4 :-))) CODING AND MUSIC WERE DONE BY CHN AND THE INTROS "
	DB	"BY:           ",2,4,0
	DB	"                    "
	DB	"      CAPITAL       ",1,100
	DB	"                    "
	DB	" DUAL CREW SHINING  ",1,100
	DB	"                    "
	DB	"      PARADOX       ",1,100
	DB	"                    ",2,1,0
	DB	"GREETINGS GO TO: "
	DB	"ACRID",2,0,$80,", ",2,1,0
	DB	"KOJOTE",2,0,$80,", ",2,1,0
	DB	"NORQUE",2,0,$80,", ",2,1,0
	DB	"PEITSCHI",2,0,$80,", ",2,1,0
	DB	"SHEN",2,0,$80,", ",2,1,0
	DB	"SHEEPZ",2,0,$80,", ",2,1,0
	DB	"SUBPORT.ORG",2,0,$80,", ",2,1,0
	DB	"T.REID",2,0,$80," ",2,1,0
	DB	"AND EVERYONE ELSE IN THE GBC/GBA/CONSOLE SCENE !!! SEE YA LATER --CHN--         ",2,4,0
	DB	"          "
	DB	"- SCROLLY RESTARTS - ",1,100,2,4,0
	DB	"                     ",1,100
	DB	0







CallTab::
	DW	$4000, $6000, $6000, $4000
	DW	$4000, $4000, $4000, $4000
	DW	$4000, $4000, $4000, $4000
	DW	$6100, $6000, $6100, $6100
	DW	$6100, $6000, $5d00, $4750
	DW	$5d00, $5d00, $5d00, $5d00
	DW	$5e80, $4000, $4000, $5d00
	DW	$4000, $5000, $4000

ColTab::
	DW	$7fff, $7c00, $001f, $7c1f

HeadColors::
	RGB2GBC 0,0,0
	RGB2GBC	0,0,16
	RGB2GBC	0,0,31
	RGB2GBC	0,31,31

MenuGradient::
	; Top Menu Gradient
	RGB2GBC	0,0,0
	RGB2GBC 0,0,0
	RGB2GBC	5,5,5
	RGB2GBC 5,5,5
	RGB2GBC	10,10,10
	RGB2GBC	10,10,10
	RGB2GBC	14,14,14
	RGB2GBC	14,14,14
	RGB2GBC	19,19,19
	RGB2GBC 19,19,19
	RGB2GBC	23,23,23
	RGB2GBC	14,14,23
	RGB2GBC	28,28,28
	RGB2GBC	10,10,28
	RGB2GBC	31,31,31
	RGB2GBC	5,5,31

	; Cursor Gradient Top
	RGB2GBC	31,28,28
	RGB2GBC	0,4,31
	RGB2GBC	31,24,24
	RGB2GBC	0,8,31
	RGB2GBC	31,20,20
	RGB2GBC	0,12,31
	RGB2GBC	31,16,16
	RGB2GBC	0,16,31
	RGB2GBC	31,12,12
	RGB2GBC	0,20,31
	RGB2GBC	31,8,8
	RGB2GBC	0,24,31
	RGB2GBC	31,4,4
	RGB2GBC	0,28,31
	RGB2GBC	31,0,0
	RGB2GBC	0,31,31

	; Cursor Gradient Middle
	RGB2GBC	31,0,0
	RGB2GBC	8,31,31
	RGB2GBC	31,0,0
	RGB2GBC	16,31,31
	RGB2GBC	31,0,0
	RGB2GBC	24,31,31
	RGB2GBC	31,0,0
	RGB2GBC	31,31,31
	RGB2GBC	31,0,0
	RGB2GBC	31,31,31
	RGB2GBC	31,0,0
	RGB2GBC	24,31,31
	RGB2GBC	31,0,0
	RGB2GBC	16,31,31
	RGB2GBC	31,0,0
	RGB2GBC	8,31,31

	; Cursor Gradient Bottom
	RGB2GBC	31,4,4
	RGB2GBC	0,28,31
	RGB2GBC	31,8,8
	RGB2GBC	0,24,31
	RGB2GBC	31,12,12
	RGB2GBC	0,20,31
	RGB2GBC	31,16,16
	RGB2GBC	0,16,31
	RGB2GBC	31,20,20
	RGB2GBC	0,12,31
	RGB2GBC	31,24,24
	RGB2GBC	0,8,31
	RGB2GBC	31,28,28
	RGB2GBC	0,4,31
	RGB2GBC	31,31,31
	RGB2GBC	0,0,31

	; Bottom Menu Gradient
	RGB2GBC	31,31,31
	RGB2GBC	5,5,31
	RGB2GBC	28,28,28
	RGB2GBC	10,10,28
	RGB2GBC	23,23,23
	RGB2GBC	14,14,23
	RGB2GBC	19,19,19
	RGB2GBC 19,19,19
	RGB2GBC	14,14,14
	RGB2GBC	14,14,14
	RGB2GBC	10,10,10
	RGB2GBC	10,10,10
	RGB2GBC	5,5,5
	RGB2GBC 5,5,5
	RGB2GBC	0,0,0
	RGB2GBC 0,0,0



	; Cycled colors of the scroll text
ScrollyColors:
	RGB2GBC	31,0,0
	RGB2GBC	31,4,4
	RGB2GBC	31,8,8
	RGB2GBC	31,12,12
	RGB2GBC	31,16,16
	RGB2GBC 31,20,20
	RGB2GBC	31,24,24
	RGB2GBC	31,28,28

	RGB2GBC	31,31,31
	RGB2GBC	31,28,28
	RGB2GBC	31,24,24
	RGB2GBC	31,20,20
	RGB2GBC	31,16,16
	RGB2GBC	31,12,12
	RGB2GBC	31,8,8
	RGB2GBC	31,4,4

	RGB2GBC	31,0,0
	RGB2GBC	28,4,0
	RGB2GBC	24,8,0
	RGB2GBC	20,12,0
	RGB2GBC	16,16,0
	RGB2GBC	12,20,0
	RGB2GBC	8,24,0
	RGB2GBC	4,28,0

	RGB2GBC	0,31,0
	RGB2GBC	0,31,4
	RGB2GBC	0,31,8
	RGB2GBC	0,31,12
	RGB2GBC	0,31,16
	RGB2GBC	0,31,20
	RGB2GBC	0,31,24
	RGB2GBC	0,31,28

	RGB2GBC	0,31,31
	RGB2GBC	4,31,28
	RGB2GBC	8,31,24
	RGB2GBC	12,31,20
	RGB2GBC	16,31,16
	RGB2GBC	20,31,12
	RGB2GBC	24,31,8
	RGB2GBC	28,31,4

	RGB2GBC	31,31,0
	RGB2GBC	31,28,4
	RGB2GBC	31,24,8
	RGB2GBC	31,20,12
	RGB2GBC	31,16,16
	RGB2GBC	31,12,20
	RGB2GBC	31,8,24
	RGB2GBC	31,4,28

	RGB2GBC	31,0,31
	RGB2GBC	28,0,31
	RGB2GBC	24,0,31
	RGB2GBC	20,0,31
	RGB2GBC	16,0,31
	RGB2GBC	12,0,31
	RGB2GBC	8,0,31
	RGB2GBC	4,0,31

	RGB2GBC	0,0,31
	RGB2GBC	4,0,28
	RGB2GBC	8,0,24
	RGB2GBC	12,0,20
	RGB2GBC	16,0,16
	RGB2GBC	20,0,12
	RGB2GBC	24,0,8
	RGB2GBC	28,0,4






	DB	"                                "
	DB	"                                "
Descriptions::
	DB	"  01 - 0082 - CPL1              "
	DB	"  02 - 0249 - CPL2              "
	DB	"  03 - 0250 - CPL2              "
	DB	"  04 - 0257 - CPL2              "
	DB	"  05 - 0555 - DCS1              "
	DB	"  06 - 0560 - DCS1              "
	DB	"  07 - 0561 - DCS1              "
	DB	"  08 - 0573 - DCS1              "
	DB	"  09 - 0591 - DCS1              "
	DB	"  10 - 0703 - PDX1              "
	DB	"  11 - 0713 - PDX1              "
	DB	"  12 - 0736 - PDX1              " ; * ?
	DB	"  13 - 0760 - CPL3              "
	DB	"  14 - 0761 - CPL3              "
	DB	"  15 - 0769 - CPL3              "
	DB	"  16 - 0776 - CPL3              "
	DB	"  17 - 0777 - CPL3              "
	DB	"  18 - 0786 - CPL4              "
	DB	"  19 - 0808 - CPL5              "
	DB	"  20 - 0811 - CPL5              "
	DB	"  21 - 0818 - CPL5              "
	DB	"  22 - 0833 - CPL5              "
	DB	"  23 - 0837 - CPL5              "
	DB	"  24 - 0838 - CPL5              "
	DB	"  25 - 0839 - CPL5              "
	DB	"  26 - 0854 - DCS2              "
	DB	"  27 - 0881 - DCS3              "
	DB	"  28 - 0913 - CPL5              "
	DB	"  29 - 0922 - CPL5              "
	DB	"  30 - 0925 - CPL5              "
	DB	"  31 - 1078 - DCS4              "
	DB	"                                "
	DB	"                                "

ScrollyJump::
ANGLE	SET	0.0
REPT	JUMPSTEPS
MYRES	SET	MUL(13,SIN(ANGLE))
IF	MYRES<0
	DB	15- (-MYRES)
ELSE
	DB	15- MYRES
ENDC
ANGLE	SET	ANGLE + (65536.0/JUMPSTEPS)
ENDR

SinTable::
ANGLE	SET	0.0
REPT	256
MYRES	SET	MUL(127,SIN(ANGLE))
	DB	MYRES
ANGLE	SET	ANGLE + 256.0
ENDR

HeadSin::
ANGLE	SET	0.0
REPT	256
MYRES	SET	MUL(48,SIN(ANGLE*2)) + 48
	DB	MYRES
ANGLE	SET	ANGLE + 256.0
ENDR

CubeX::
ANGLE	SET	0.0
REPT	256
	DB	MUL(10,SIN(ANGLE))
ANGLE	SET	ANGLE + 256.0
ENDR

CubeModel::
	DB	-DX,-DY,-DZ
	DB	 DX,-DY,-DZ
	DB	-DX, DY,-DZ
	DB	 DX, DY,-DZ
	DB	-DX,-DY, DZ
	DB	 DX,-DY, DZ
	DB	-DX, DY, DZ
	DB	 DX, DY, DZ
	DB	 0 ,-DY,-DZ
	DB	-DX, 0 ,-DZ


	include	"logx.inc"
	include "log.inc"


	


	SECTION	"StartupVars",BSS
HeadOfs		DS	1
CurTitle	DS	1
LastJoy		DS	1
Cursor		DS	1
MenuY		DS	2
MenuDY		DS	2
scrollyWait	DS	1
scrollyX	DS	4
scrollyY	DS	1
scrollyDist	DS	2
scrollyDistOfs	DS	2
scrollyJPos	DS	1
scrollySpeed	DS	2
scrollyColOfs	DS	2
cubeXP		DS	1
cubeZP		DS	1

temp		DS	8

ofs		DS	2

Stack		DS	$200
StackTop



	SECTION "MUSIC",DATA,BANK[1]
incbin "music.sav"


	SECTION "C0082",DATA,BANK[INTROBANK + 0]
incbin "intros\\0082.bin"

	SECTION "C0249",DATA,BANK[INTROBANK + 1]
incbin "intros\\0249.bin"

	SECTION "C0250",DATA,BANK[INTROBANK + 2]
incbin "intros\\0250.bin"

	SECTION "C0257",DATA,BANK[INTROBANK + 3]
incbin "intros\\0257.bin"

	SECTION "C0555",DATA,BANK[INTROBANK + 4]
incbin "intros\\0555.bin"

	SECTION "C0560",DATA,BANK[INTROBANK + 5]
incbin "intros\\0560.bin"

	SECTION "C0561",DATA,BANK[INTROBANK + 6]
incbin "intros\\0561.bin"

	SECTION "C0573",DATA,BANK[INTROBANK + 7]
incbin "intros\\0573.bin"

	SECTION "C0591",DATA,BANK[INTROBANK + 8]
incbin "intros\\0591.bin"

	SECTION "C0703",DATA,BANK[INTROBANK + 9]
incbin "intros\\0703.bin"

	SECTION "C0713",DATA,BANK[INTROBANK + 10]
incbin "intros\\0713.bin"

	SECTION "C0736",DATA,BANK[INTROBANK + 11]
incbin "intros\\0736.bin"

	SECTION "C0760",DATA,BANK[INTROBANK + 12]
incbin "intros\\0760.bin"

	SECTION "C0761",DATA,BANK[INTROBANK + 13]
incbin "intros\\0761.bin"

	SECTION "C0769",DATA,BANK[INTROBANK + 14]
incbin "intros\\0769.bin"

	SECTION "C0776",DATA,BANK[INTROBANK + 15]
incbin "intros\\0776.bin"

	SECTION "C0777",DATA,BANK[INTROBANK + 16]
incbin "intros\\0777.bin"

	SECTION "C0786",DATA,BANK[INTROBANK + 17]
incbin "intros\\0786.bin"

	SECTION "C0808",DATA,BANK[INTROBANK + 18]
incbin "intros\\0808.bin"

	SECTION "C0811",DATA,BANK[INTROBANK + 19]
incbin "intros\\0811.bin"

	SECTION "C0818",DATA,BANK[INTROBANK + 20]
incbin "intros\\0818.bin"

	SECTION "C0833",DATA,BANK[INTROBANK + 21]
incbin "intros\\0833.bin"

	SECTION "C0837",DATA,BANK[INTROBANK + 22]
incbin "intros\\0837.bin"

	SECTION "C0838",DATA,BANK[INTROBANK + 23]
incbin "intros\\0838.bin"

	SECTION "C0839",DATA,BANK[INTROBANK + 24]
incbin "intros\\0839.bin"

	SECTION "C0854",DATA,BANK[INTROBANK + 25]
incbin "intros\\0854.bin"

	SECTION "C0881",DATA,BANK[INTROBANK + 26]
incbin "intros\\0881.bin"

	SECTION "C0913",DATA,BANK[INTROBANK + 27]
incbin "intros\\0913.bin"

	SECTION "C0922",DATA,BANK[INTROBANK + 28]
incbin "intros\\0922.bin"

	SECTION "C0925",DATA,BANK[INTROBANK + 29]
incbin "intros\\0925.bin"

	SECTION "C1078",DATA,BANK[INTROBANK + 30]
incbin "intros\\1078.bin"

