;================================================================
;  random.s
;               Simple random generator (8 bits)
;
;================================================================
;
; 25thanni, a demo dedicated to the 25th anniversary of the ZX81.
;
; (c)2006 Bodo Wenzel
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License as
; published by the Free Software Foundation; either version 2 of
; the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public
; License along with this program; if not, write to the Free
; Software Foundation Inc., 59 Temple Place, Suite 330, Boston,
; MA 02111-1307 USA
;================================================================

	.module	random

;= Externals ====================================================

	.globl	seed

;= Program code =================================================

	.area	CODE

;- Returns a random number --------------------------------------

random::
	push	hl
	ld	hl,(seed)
	add	hl,hl
	jr	nc,r_quit
	ld	a,l
	xor	#0x03
	ld	l,a
	ld	a,h
	xor	#0x42
	ld	h,a
r_quit:
	ld	(seed),hl
	ld	a,l
	pop	hl
	ret

;= The end ======================================================
