/*================================================================
 *  gen_sine.c
 *               Generate a sine table
 *
 *================================================================
 *
 * 25thanni, a demo dedicated to the 25th anniversary of the ZX81.
 *
 * (c)2006 Bodo Wenzel
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *================================================================
 */

/* This is a classical filter, writing to stdout. The output is
 * ment to be included into an ASxxxx source.
 */

/* Externals ================================================== */

#include <math.h>
#include <stdio.h>

/* Constants ================================================== */

#define MATH_TWO_PI 256
#define MATH_VALUE_SIZE 7

/* Program code =============================================== */

/* Main function ---------------------------------------------- */

int main(void) {
  double pi_4th;
  int    phi_i;

  pi_4th = atan(1);
  for (phi_i = 0; phi_i < MATH_TWO_PI / 4; phi_i++) {
    double phi_d;
    double sin_d;
    int    sin_i;

    phi_d = 8 * pi_4th * (phi_i + (double)0.5) / MATH_TWO_PI;
    sin_d = sin(phi_d);
    sin_i = (int)((1 << MATH_VALUE_SIZE) * sin_d);
    printf("\t.db\t%d\n", sin_i);
  }
  return 0;
}

/* The end ==================================================== */
