;================================================================
;  basic.s
;               Startup code for a ZX81
;
;================================================================
;
; (c)2006 Bodo Wenzel
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License as
; published by the Free Software Foundation; either version 2 of
; the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public
; License along with this program; if not, write to the Free
; Software Foundation Inc., 59 Temple Place, Suite 330, Boston,
; MA 02111-1307 USA
;================================================================

	.module	basic

;= BASIC system variables =======================================

	.area	VAR		; starts at 0x4009

i_reg::
	.db	0		; VERSN
heap_ptr::
	.dw	0		; E_PPC
text_file::
	.dw	dsp		; D_FILE
hrg_file::
	.dw	dsp+1		; DF_CC
show_ptr::
	.dw	var		; VARS
bottom_ptr::
	.dw	0		; DEST
seed::
	.dw	var+1		; E_LINE
frames::
	.dw	last-1		; CH_ADD
break::
	.dw	0		; X_PTR

	.area	SCRATCH	(ovr)

	.dw	last		; STKBOT
	.dw	last		; STKEND
	.db	0		; BERG
	.dw	membot		; MEM
	.db	0		; unused
	.db	2		; DF_SZ
	.dw	0		; S_TOP
	.db	0xFF,0xFF,0xFF	; LAST_K
	.db	55		; MARGIN
	.dw	line2		; NXTLIN (Autostart)
	.dw	0		; OLDPPC
	.db	0		; FLAGX
	.dw	0		; STRLEN
	.dw	0x00C8D		; T_ADDR
	.dw	0xFFFF		; SEED
	.dw	0xFFFF		; FRAMES
	.db	0,0		; COORDS
	.db	0xBC		; PR_CC
	.db	33,24		; S_POSN
	.db	0b01000000	; CDFLAG
	.ds	33		; output buffer
membot:
	.ds	30		; calculation buffer
	.ds	2		; unused

;= BASIC program ================================================

	.area	CODE		; starts at 0x407D

;- The first line contains the machine code ---------------------

line1:
	.db	0,1		; 1
	.dw	line2-0x407D-4	; length
	.db	0xEA		; REM

	; The machine code starts right now... and it never
	; returns! You have to reset the machine.

	.area	TRAILER

	.db	0x76		; N/L

;- The second line contains the call to the machine code --------

line2:
	.db	0,2		; 2
	.dw	dsp-.-2		; length
	.db	0xF9		; RAND
	.db	0xD4		; USR
	.db	0xC5		; VAL
	.db	0x0B		; "
	.db	0x1D		; 1
	.db	0x22		; 6
	.db	0x21		; 5
	.db	0x1D		; 1
	.db	0x20		; 4
	.db	0x0B		; "
	.db	0x76		; N/L

;= Screen buffer ================================================

dsp:
	.db	0x76,0x76,0x76,0x76,0x76,0x76,0x76,0x76,0x76,0x76
	.db	0x76,0x76,0x76,0x76,0x76,0x76,0x76,0x76,0x76,0x76
	.db	0x76,0x76,0x76,0x76,0x76 ; 25 N/Ls

;= BASIC variables ==============================================

var:
	.db	0x80
last:

;= The end ======================================================
