;       Compile with WLA-6510 (http://www.hut.fi/~vhelin/wla.html)

;****************************************************************************
;*****
;*****  VUOKATTI - Downhill skiing game for Minigame Competition 2004
;*****  
;*****  Unexpanded Commodore VIC 20 (PAL only)
;*****
;*****  (c)2004 Aleksi Eeben (aleksi@cncd.fi)
;*****
;****************************************************************************

.INCLUDE "vic.inc"

.ORG $0
.SECTION "BANKHEADER"
        .dw     $1001
.ENDS


.DEFINE scroll          $00             ; screen scroll (pixels)
.DEFINE speed           $01             ; scroll speed

.DEFINE level           $02             ; increasing difficulty

.DEFINE treedraw        $03             ; tree drawing
.DEFINE face            $04             ; skier face
.DEFINE xcoord          $05             ; skier softsprite x-coordinate

.DEFINE shift           $06             ; softsprite bit shifts
.DEFINE count           $07             ; softsprite line count

.DEFINE score1          $08             ; score x1 (bcd)
.DEFINE score100        $09             ; score x100 (bcd)
.DEFINE color           $0a             ; score/hiscore color

.DEFINE rnd0            $fe             ; random number generator
.DEFINE temp            $ff             ; temporary store

.ORG $1001
.SECTION "basic" FORCE
        .DB     $0b,$10,$01,$00,$9e,$34,$31,$30,$37     ; 1 sys4107
        .DB     $00

;-----  start new game

newgame:
        ldx     #$00
        jmp     go
.ENDS

.ORG $1010
.SECTION "gfx" FORCE
        .INCBIN "gfx.bin"
.ENDS


.ORG $1160
.SECTION "main" FORCE

;-----  init

go:
        sei

_inilp
        lda     #$0b                    ; init color memory
        sta     $9600,x                 
        sta     $9700,x

        lda     #$55   
        sta     $1800,x                 ; clear chars $80-$8f
        ;
        sta     xcoord                  ; starting x-coordinate
        lsr
        sta     level                   ; level
        sta     speed                   ; speed

        lda.w   vicsetup-$f0,x          ; vic-i chip setup
        sta     $8f10,x

        lda     #$80                    ; init screen matrix at $0200
        sta     $0200,x                 
        sta     $0300,x
        asl
        sta     $00,x                   ; init zeropage for variables

        txa                             ; copy numbers from char rom
        asl
        tay
        lda     $80f8,x                 ; first copy wrong characters
        sta     $18f1,y                 ; then numbers starting at $8180
        sta     $18f2,y                 ; double height, one pixel offset

        inx
        bne     _inilp


;-----  main loop

mainloop:
        ldx     #$68
_w1
        cpx     $9004                   ; screen sync
        bne     _w1


;-      move skier

        ldy     #$87                    ; wipe softsprite
        jsr     softspritechar

        lda     face                    ; player facing
        lsr
        lsr
        tax

        lda     speed     
        beq     _crashed                ; move nothing if dead

        clc
        adc.w   facespd,x               ; speed up or down according to face
        cmp     #$20
        bcs     _minok
        lda     #$20                    ; min speed = $20
_minok
        cmp     level
        bcc     _spdok
        sbc     #$01                    ; slow down if speed > level
_spdok
        sta     speed
        lsr
        lsr
        adc     #$dc
        sta     $900d                   ; ski noise

        lda.w   faceadd,x
        clc
        adc     xcoord
        cmp     #$fd
        bcc     _notleftside

        ldy     #$0f                    ; bounce back from left side
        lda     #$00
        beq     _sidebounce
_notleftside
        cmp     #$b0
        bcc     _sidesok

        ldy     #$00                    ; bounce back from right side
        lda     #$b0
_sidebounce
        sty     face
_sidesok
        sta     xcoord


;-      check keyboard

        ldy     #$20

        ldx     face
        beq     _notleft

        lda     #$f7                    ; check ','
        jsr     key
        bne     _notleft
        dex
_notleft
        cpx     #$0f
        beq     _notright

        lda     #$ef                    ; check '.'
        jsr     key
        bne     _notright
        inx
_notright
        stx     face
_skierdone


;-      scroll screen

        lda     scroll
        sec
        sbc     speed
        sta     scroll
        bcc     leap

        jsr     frameduty

        jmp     mainloop


;-      crashed, space to start new game

_crashed
        jsr     score

        lda     #$ef
        ldy     #$01
        jsr     key
        bne     _skierdone

        jmp     newgame


;-----  check key

key:
        sta     $9120
        tya
        and     $9121

        rts


;-----  show score and highscore

score:
        ldy     score1
        ldx     score100
        cpx.w   hiscore100
        beq     _checklsb
        bcs     _newhi
        bcc     _nonewhi
_checklsb
        cpy.w   hiscore1
        bcc     _nonewhi

_newhi
        stx.w   hiscore100
        sty.w   hiscore1
_nonewhi

        txa
        ldx     #$01
        jsr     _writesc

        ldx     #$07
        lda.w   hiscore100
        ldy.w   hiscore1
_writesc
        stx     color
        jsr     _writebcd
        tya
_writebcd
        pha

        lsr                             ; write high nybble
        lsr
        lsr
        lsr
        jsr     _write1

        pla                             ; write low nybble
_write1
        and     #$0f
        ora     #$90
        sta     $02c6,x
        lda     color
        sta     $96c6,x
        inx
        rts


;-      leap scroll by 16 pixels

leap:
        sed                             ; add speed to score
        lda     speed
        lsr
        lsr
        lsr
        lsr
        lsr
        adc     score1
        sta     score1
        lda     score100
        bcc     _nolevup

        inc     level                   ; level up every 100 points
        adc     #$00
        sta     score100
_nolevup
        cld

        ldx     #$00
_scr1
        lda     $0210,x                 ; scroll upper half
        sta     $01f8,x
        lda     $9610,x
        sta     $95f8,x
        inx
        bne     _scr1

        lda     scroll
        jsr     frameduty

        ldx     #$00
_scr2
        lda     $0310,x                 ; scroll lower half
        sta     $02f8,x
        lda     $9710,x
        sta     $96f8,x
        inx
        bne     _scr2


        ldx     #$18
_clrl
        lda     #$80                    ; fill bottom line with snow
        sta     $03df,x
        lda     #$0b
        sta     $97df,x
        dex
        bne     _clrl

        ldx     treedraw                ; tree drawing in progress?
        beq     _notree
        ldy     #$00
        sty     treedraw                ; clear tree flag
        beq     _drawobs                ; got draw lower half
_notree
        jsr     random                  ; draw new obstacle?
        cmp     level
        bcs     _noobstacle

        jsr     random                  ; $04 = rock; $08 = bump
        and     #$0c
        bne     _nob
        ora     #$0c                    ; $00/$0c = tree
_nob
        tay                             ; obstacle type in y

        jsr     random                  ; randomize x-coordinate of obstacle
        and     #$0f
        sta     temp
        jsr     random
        and     #$05
        sec
        adc     temp
        tax                             ; x = $01-$15

_drawobs
        lda.w   obstacles,y             ; draw one line of obstacle
        sta     $97e0,x
        sta     $97e1,x
        bmi     _2char                  ; high nybble marks 2 char wide
        sta     $97e2,x
_2char
        lda.w   obstacles+1,y
        sta     $03e0,x
        lda.w   obstacles+2,y
        sta     $03e1,x
        lda.w   obstacles+3,y
        sta     $03e2,x

        cpy     #$0c                    ; started tree drawing?
        bne     _noobstacle

        stx     treedraw                ; tree position for lower half

_noobstacle
        jmp     mainloop


;-----  frame routines

frameduty:
        jsr     smooth


;-      generate skier soft sprite

        ldy     #$5f                    ; wipe skier soft sprite
        lda     #$55
_wipes
        sta     $1810,y
        dey
        bpl     _wipes

        lda     face                    ; offset to skier frame
        asl                             ; number of decimal bits
        asl                             ; defines control sensitivity
        asl
        and     #$e0
        tay

        lda     scroll                  ; offset to first line
        lsr                             ; according to fine scroll
        lsr
        lsr
        lsr
        eor     #$0f
        tax

        lda     xcoord                  ; skier x-coordinate
        lsr                             ; 1 decimal bit
        and     #$03
        sta     shift                   ; shift amount

        lda     #$0f
        sta     count
_copyshift
        lda     $1010,y                 ; copy and shift softsprite
        sta     $1810,x
        lda     $1020,y
        sta     $1830,x

        lda     shift
        beq     _noshift
        sta     temp
_shifts
        sec                             ; shift right and fill with $55
        ror     $1810,x
        ror     $1830,x
        ror     $1850,x
        clc
        ror     $1810,x
        ror     $1830,x
        ror     $1850,x
        dec     temp
        bne     _shifts
_noshift

        inx                             ; next line of softsprite
        iny
        dec     count
        bpl     _copyshift

        ldy     #$81
        ;
        ;
;-      draw soft sprite on screen (y = $87 used to wipe softsprite)

softspritechar:
        ldx     #$03                    ; draw only 2 chars per line
        lda     shift                   ; if last shift value is zero
        bne     _not2c
        dex
_not2c
        stx     count

        lda     xcoord                  ; skier x-coordinate
        lsr                             ; 1 decimal bit
        lsr
        lsr
        tax                             ; skier char column

_scharl
        lda     $0260,x
        jsr     collision
        sta     $0260,x
        iny
        lda     $0278,x
        jsr     collision
        sta     $0278,x

        iny
        inx
        dec     count
        bne     _scharl

;        rts                            ; code below does no harm


;-----  generate random number

random:
        lda     rnd0
        sbc     $9124
        sta     rnd0

        rts


;-      collision check, ok to draw char y?

collision:
        bmi     _nocrash                ; >$7f are softsprite chars

        cmp     #$0e
        bcc     _bump

        pha
        lda     #$10                    ; crash!
        sta     face
        lda     #$00
        sta     speed
        sta     $900d
        pla

        rts

_bump
        lda     #$7f
        sta     speed
        lda     face
        cmp     #$08
        lda     #$0f
        bcs     _bumpleft
        lda     #$00
_bumpleft
        sta     face

_nocrash
        tya                             ; draw char y
        rts


;-----  set screen y-position at one pixel accuracy

smooth:
        lsr                             ; shift out decimal bits
        lsr
        lsr
        lsr
        clc
        adc     #$02                    ; screen y-position $02-$11

        lsr
        tay
        bcs     _o1e
        jsr     _o1e
        dec     $9001
        rts
_o1e
        sty     $9001
        dey
_wsx
        cpy     $9004
        bne     _wsx

        ldy     #$0b                    ; delay for vice compatibility
_wstt
        dey
        bne     _wstt
        rts


;-----  misc data

vicsetup:
        .DB     $0a,$01,$98,$29         ; $9000-$9005
        .DB     $00,$8c
hiscore1:
        .DB     $00                     ; $9006-$9007 / hiscore
hiscore100:
        .DB     $00
        .DB     $00,$00,$00,$00         ; $9008-$900f
        .DB     $00,$00,$81,$09

obstacles:
        .DB     $0d,$13,$14,$15         ; tree lower half
        .DB     $8f,$0e,$0f,$80         ; rock
        .DB     $0b,$0b,$0c,$0d         ; bump
        .DB     $0d,$10,$11,$12         ; tree upper half

faceadd:
        .DB     $fe,$ff,$01,$02         ; face add to x-coordinate
facespd:
        .DB     $ff,$01,$01,$ff         ; face add to speed
.ENDS
