ShapeList:
 dw Hexaedr
 dw Cube
 dw Tetraedr
 dw Star
;-----------------------
tetNorm equ 20
tet     equ 9

Tetraedr
 db 2,0 
 db 4      ;nPoints
 db 4      ;nTriangles
 db 4      ;nFaces                                     

 db $12,$33,-tet, tet,-tet ; 0    0---+
 db $02,$33, tet,-tet,-tet ; 1   /|  /|
 db $01,$33, tet, tet, tet ; 2  | +-2-1
 db $01,$22,-tet,-tet, tet ; 3  |/  |/
                           ;    3---+
TetraedrListTriangles
 db $00,0,1,2,3             ; 0 | format:  db Face           } *how many
 db $01,1,0,2,3             ; 1 |          db Texture        }  triangles
 db $02,2,0,1,3             ; 2 |          db pnt1,pnt2,pnt3 }
 db $03,3,0,1,2             ; 3  

TetraedrListFaces
 db  tetNorm,-tetNorm, tetNorm ; 0
 db -tetNorm, tetNorm, tetNorm ; 1
 db -tetNorm,-tetNorm,-tetNorm ; 2
 db  tetNorm, tetNorm,-tetNorm ; 3

;-----------------------
Star
 db 2,0
 db 7      ;nPoints
 db 6      ;nTriangles
 db 2      ;nFaces                                  

 db $01,$00,  0, 50,0           ; 0     0
 db $01,$00,-47, 15,0           ; 1    / \
 db $01,$00,-29,-40,0           ; 2 1--5 6--4
 db $01,$00, 29,-40,0           ; 3   /   \
 db $01,$00, 47, 15,0           ; 4  2     3
 db $01,$00,-10, 15,0           ; 5
 db $01,$00, 10, 15,0           ; 6
;
 db $00,0,2,5,4
 db $00,0,1,3,6
 db $00,0,0,5,6
;
 db $01,1,2,5,4
 db $01,1,1,3,6
 db $01,1,0,5,6

;
 db 0,0, 20
 db 0,0,-20
;-----------------------
hexNorm equ 20
hex     equ 16

Hexaedr
 db 2,0 
 db 6      ;nPoints
 db 8      ;nTriangles
 db 8      ;nFaces                                     
 db $01,$23, 0  , hex, 0    ; 0     0  2                
 db $03,$47,-hex, 0  , 0    ; 1     | /       points 
 db $01,$45, 0  , 0  ,-hex  ; 2     |/
 db $12,$56, hex, 0  , 0    ; 3  1--+---3
 db $23,$67, 0  , 0  , hex  ; 4    /|
 db $45,$67, 0  ,-hex, 0    ; 5   4 5

HexaedrListTriangles
 db $00,0,0,1,2             ; 0 | format:  db Face           } *how many
 db $01,2,0,2,3             ; 1 |          db Texture        }  triangles
 db $02,1,0,3,4             ; 2 |          db pnt1,pnt2,pnt3 }
 db $03,2,0,1,4             ; 3  
 db $04,2,5,1,2             ; 4  
 db $05,1,5,2,3             ; 5  
 db $06,2,5,3,4             ; 6
 db $07,0,5,1,4             ; 7

HexaedrListFaces
 db -hexNorm, hexNorm,-hexNorm ; 0
 db  hexNorm, hexNorm,-hexNorm ; 1
 db  hexNorm, hexNorm, hexNorm ; 2
 db -hexNorm, hexNorm, hexNorm ; 3
 db -hexNorm,-hexNorm,-hexNorm ; 4
 db  hexNorm,-hexNorm,-hexNorm ; 5
 db  hexNorm,-hexNorm, hexNorm ; 6
 db -hexNorm,-hexNorm, hexNorm ; 7

;-----------------------
kubNorm equ 20
kub     equ 7
kk      equ 0

Cube
 db 2,0 
 db 8      ;nPoints
 db 12     ;nTriangles
 db 6      ;nFaces                                  
 db $02,$44,kk+kub,kk+kub,kub   ; 0  
 db $03,$44,kk+kub,kk-kub,kub   ; 1                   2  4
 db $13,$44,kk-kub,kk-kub,kub   ; 2    3---0          | /       normals
 db $12,$44,kk-kub,kk+kub,kub   ; 3   /|  /|          |/
 db $02,$55,kk+kub,kk+kub,-kub  ; 4  7-2-4-1       1--+---0
 db $03,$55,kk+kub,kk-kub,-kub  ; 5  |/  |/          /|
 db $13,$55,kk-kub,kk-kub,-kub  ; 6  6---5          5 3
 db $12,$55,kk-kub,kk+kub,-kub  ; 7

CubeListTriangles
 db $00,0,4,5,0             ; 0 | format:  db Face           } *how many
 db $00,0,1,5,0             ; 1 |          db Texture        }  triangles
 db $01,0,3,2,6             ; 2 |          db pnt1,pnt2,pnt3 }
 db $01,0,3,7,6             ; 3  
 db $02,1,0,7,3             ; 4  
 db $02,1,0,7,4             ; 5  
 db $03,1,1,2,6             ; 6
 db $03,1,1,5,6             ; 7
 db $04,2,0,1,2             ; 8
 db $04,2,0,3,2             ; 9
 db $05,2,4,5,6             ; 10
 db $05,2,4,7,6             ; 11

CubeListFaces
 db  kubNorm, 0 ,0      ; 0
 db -kubNorm, 0 ,0      ; 1
 db   0, kubNorm,0      ; 2
 db   0,-kubNorm,0      ; 3
 db   0, 0, kubNorm     ; 4
 db   0, 0,-kubNorm     ; 5

