;
ftcir equ 2
scntr equ $303

DrawSphere:
 call LCDoff
 call initFullScreen
 rst  0
;
 call SetSphereTiles
;
 xor  a                     ;  a- index of pal
 ld   b,32                  ;  b- how many colors /32 all
 ld   de,%0111111111111111  ; de- mask of colors: 0bbbbbgg,gggrrrrr
 ld   hl,SpherePal          ; hl- start of monoPalette /only one color-component
 call SetMonoBkgPal
;
 ld   a,4
 ld   hl,RectXYsize
 ld   [hli],a
 ld   [hl],a
 xor  a
 rst  40                
 db   %00111111         ; bc,de,hl
 dw   MapAtr            
 dw   MapChar
 dw   $0+scntr          ; in :  a-attr of tiles /flips,bgpriority/
 db   $5c               ; FillRect

 rst  40
 db   %01110000         ; hl,a
 dw   $4+scntr
 db   %00100000
 db   $5c               ; FillRect

 rst  40
 db   %01110000         ; hl,a
 dw   $400+scntr
 db   %01000000
 db   $5c               ; FillRect

 rst  40
 db   %01110000         ; hl,a
 dw   $404+scntr
 db   %01100000
 db   $5c               ; FillRect
;
 ld   a,%10010011      
 ldio [$40],a 
 call eii
 jr   @-0

SetSphereTiles:
 ld   b,$a
 ld   de,SphereTiles
 ld   hl,ftcir*16+$8000
sst:
 ld   a,[de]
 swap a
 call SetHalfST
 ld   a,[de]
 inc  de
 call SetHalfST
 dec  b
 jr   nz,sst
 ret

SetHalfST:
 push de
 ld   de,$f
 and  e
 ld   c,d
 rra
 jr   nc,@+3
 ld   c,e
 rra
 jr   c,@+3
 ld   e,d
 rra
 jr   nc,@+4
 ld   d,%11110000
 rra
 ld   a,%11110000
 jr   c,@+3
 xor  a
 or   e
 ld   e,a
 ld   a,c
 or   d
 ld   d,a
 ld   c,4
shst:
 waitvblank
 ld   [hl],e
 inc  l
 ld   [hl],d
 inc  hl
 dec  c
 jr   nz,shst
 pop  de
 ret
SphereTiles: 
 db  %00000000 ; 0
 db  %00000010 ; 1
 db  %00001001 ; 2
 db  %00100001 ; 3
 db  %00101001 ; 4
 db  %00100110 ; 5
 db  %00100111 ; 6
 db  %00011010 ; 7
 db  %00011011 ; 8
 db  %01111111 ; 9
SpherePal:
 db  0, 9, 0, 0,  11,16,20, 0,  4,10,14,17, 19,21,22,24
 db 25,26,28, 0,  13,14,19,20, 23,26,24, 0, 28,29,30,31 
;1/4 of circle
;db 00,00,  00,00,  04,10,  13,14
;db 00,00,  00,09,  14,17,  19,20

;db 00,00,  11,16,  19,21,  23,24
;db 00,09,  16,20,  22,24,  26,26

;db 04,14,  19,22,  25,26,  28,28
;db 10,17,  21,24,  26,28,  29,30

;db 13,19,  23,26,  28,29,  30,31
;db 14,20,  24,26,  28,30,  31,31
MapAtr:
;map of palletts
 db 0,0,2,5
 db 0,1,3,6
 db 2,3,4,7
 db 5,6,7,7
MapChar:
;map of char codes
 db ftcir+0,ftcir+1,ftcir+6,ftcir+6
 db ftcir+1,ftcir+4,ftcir+6,ftcir+7
 db ftcir+8,ftcir+8,ftcir+4,ftcir+2
 db ftcir+8,ftcir+5,ftcir+3,ftcir+9