// HeadHunters v2.55
// http://www.planetquake.com/headhunters
// original baseq2/ctf code by id software 
// original hh code (v2.00) by Charlie Zimmerman
// modified code (v2.5x) by Avi "Zung!" Rozen
// 
// hh_vote.c	- voting routines

#include "hh_shared.h"

cvar_t * voting;
cvar_t * vote_time;

int votes[MAX_VOTE_LEVELS+1];

float voting_started = 0.0F;
int vote_levels;


void VOTING_init_cvars (void) 
{
	voting = gi.cvar ("voting", "0", CVAR_LATCH | CVAR_SERVERINFO);
	vote_time = gi.cvar ("vote_time", "30", CVAR_ARCHIVE);
}


qboolean VOTING_in_vote (void) 
{
	return (voting_started != 0);
}

void VOTING_start_vote (void) 
{
	edict_t *guy;
	int i;

	if (number_of_levels == 0) 
	{
   		// End the intermission
		level.exitintermission = true;
		return;
	}

	if (voting->value == 0) 
	{
   		// End the intermission
		level.exitintermission = true;
		return;
	}
	
	for (i=0; i< (MAX_VOTE_LEVELS + 1); i++) 
    	votes[i] = 0;

	vote_levels = number_of_levels;
	if (vote_levels > MAX_VOTE_LEVELS) 
	   	vote_levels = MAX_VOTE_LEVELS;

	voting_started = level.time;

	// find everyone and set vote to 0
	guy = NULL;
	guy = G_Find(guy,FOFS(classname),"player");
	while (guy != NULL) 
	{
		guy->client->vote = 0;
		votes[0] += 1;
   		guy = G_Find(guy,FOFS(classname),"player");
	}
}


void VOTING_clear_vote (void) 
{
	voting_started = 0;
}


void VOTING_select (edict_t *ent) 
{
	votes[ent->client->vote]--;
	ent->client->vote++;
	if (ent->client->vote > vote_levels ) 
   		ent->client->vote = 0;
	votes[ent->client->vote]++;
}


void VOTING_select_down (edict_t *ent) 
{
	votes[ent->client->vote]--;
	ent->client->vote--;
	if (ent->client->vote < 0) 
   		ent->client->vote = vote_levels;
	votes[ent->client->vote]++;
}


void VOTING_check_done (void) 
{
	int i;
	int winner;
	int num_winners;
	int theone;
	int j;
	int index;
	edict_t *guy;

	if (voting_started == 0) 
		return;
	if (level.time > (voting_started + vote_time->value)) 
	{
   		// figure out the next level
     	for (i=0; i< (number_of_levels + 1); i++) 
        	votes[i] = 0;
		guy = NULL;
   		guy = G_Find(guy,FOFS(classname),"player");
   		while (guy != NULL) 
		{
      		// OOPS if the guy is not in the vote and his vote is
			// really bad then dont count it
			if (guy->client->vote < 0) 
         		guy->client->vote = 0;
			if (guy->client->vote > vote_levels) 
         		guy->client->vote = 0;
      		votes[guy->client->vote]++;
			guy->client->vote = 0;
   			guy = G_Find(guy,FOFS(classname),"player");
   		}
		winner = 0;
		num_winners = 0;
     	for (i=1; i< (number_of_levels + 1); i++) 
		{
        	if (votes[i] > winner) 
			{
				winner = votes[i];
				num_winners = 1;
			}
			else if (votes[i] == winner) 
         		num_winners++;
		}
		if (num_winners != 0) 
		{
        	theone = rand() % num_winners;
			j = 0;
			for (i=1 ; i<(number_of_levels + 1); i++) 
			{
          		if (votes[i] == winner) 
				{
            		if (j == theone) 
               			index = i;
              		j++;
				}
			}
			// set the next level to the level at index
			gi.bprintf(PRINT_HIGH,"Winning level - %s\n",level_list[index-1].level_name);
			level.changemap = level_list[index-1].level_name;
		}
		// End the intermission
		level.exitintermission = true;
	}
}


void print_selected_plack (int x, int y, char * string) 
{
	Com_sprintf (string, 64, "xv %i yv %i picn levsel ",x, y);
}


void print_level_plack(int x, int y, char * string) 
{
	Com_sprintf (string, 64, "xv %i yv %i picn level ",x, y);
}


void print_level_data(int x, int y, int i, char * string) 
{
	int index;
	char entry[128];

	if (i == 0) 
	{
		Com_sprintf (entry, sizeof(entry)," %-3i No Vote ", votes[0]);
		Com_sprintf (string, 128, "xv %i yv %i string \"%s\" ", x, y, entry);
	}
	else 
	{
	   	index = i - 1;
		Com_sprintf (entry, sizeof(entry), " %-3i %-10s", votes[i], level_list[index].level_text);
		Com_sprintf (string, 128, "xv %i yv %i string \"%s\" ", x, y, entry);
	}
}


void print_header(int x, int y, char * string) 
{
	char entry[128];

	Com_sprintf (entry, sizeof(entry)," Use [ & ] to vote for the next level. ",time);
	Com_sprintf (string, 128, "xv %i yv %i string2 \"%s\" ", x, y, entry);
}


void print_time_remaining(int x, int y, char * string) 
{
	char entry[128];
	int time;

	time = vote_time->value + voting_started - level.time;

	Com_sprintf (entry, sizeof(entry)," %-3i Seconds Left ", time);
	Com_sprintf (string, 128, "xv %i yv %i string2 \"%s\" ", x, y, entry);
}


void VOTING_set_display(edict_t *ent) 
{
	char	string[1400];
	int		stringlength;
	int		i;
	int		x, y;
	int half,first,last;

	string[0] = 0;
	stringlength = strlen(string);

	// print out the deathmatch scoreboard headings
	x = 0;
	y = 8;
	print_level_plack (x,y,&string[stringlength]);
	stringlength = strlen(string);
	print_header (x,y,&string[stringlength]);
	stringlength = strlen(string);
	half = DISPLAY_AT_ONCE / 2;
	if (vote_levels <= DISPLAY_AT_ONCE) 
	{
		first = 0;
		last = vote_levels;
	}
	else 
	{
   		if (ent->client->vote <= half) 
		{
			first = 0;
			last = DISPLAY_AT_ONCE;
		}
		else if (ent->client->vote >= (vote_levels - half)) 
		{
			first = vote_levels - DISPLAY_AT_ONCE;
			last = vote_levels;
		}
		else 
		{
			first = ent->client->vote - half;
			last = first + DISPLAY_AT_ONCE;
		}
	}
	for (i=first ; i<=last ; i++)
	{
		y += 10;
		if (ent->client->vote == i) 
	      	print_selected_plack(x,y,&string[stringlength]);
		else 
			print_level_plack(x,y,&string[stringlength]);
		stringlength = strlen(string);
		print_level_data(x,y,i,&string[stringlength]);
		stringlength = strlen(string);
 	}
	y += 10;
	print_level_plack(x,y,&string[stringlength]);
	stringlength = strlen(string);
	print_time_remaining(x,y,&string[stringlength]);
	stringlength = strlen(string);

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}
