// HeadHunters v2.55
// http://www.planetquake.com/headhunters
// original baseq2/ctf code by id software 
// original hh code (v2.00) by Charlie Zimmerman
// modified code (v2.5x) by Avi "Zung!" Rozen
// 
// hh_shared.c	- shared stuff

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include "g_local.h"
#include "m_player.h"

#include "stdlog.h"	//	StdLog - Mark Davies
#include "gslog.h"	//	StdLog - Mark Davies

// ent string

#define	MAX_MAP_ENTSTRING	0x40000

// cvars 

extern cvar_t * basedir;

extern cvar_t * hook;
extern cvar_t * grapple;
extern cvar_t * grapple_speed;
extern cvar_t * grapple_pull;
extern cvar_t * pickup_messages;
extern cvar_t * frag_scoring;
extern cvar_t * camp_radius;
extern cvar_t * weapon_change;
extern cvar_t * weapon_recovery;
extern cvar_t * headthieves; // hhctf
extern cvar_t * autogib;
extern cvar_t * zkick;
extern cvar_t * audience;
extern cvar_t * autoprotect;
extern cvar_t * inifilename;
extern cvar_t * voting;
extern cvar_t * vote_time;

// constants
// altar
#define BLOOD_SKINS 9

// teamplay
#define TH_CHANGING		1
#define TH_INVITING		2
#define TH_KICKING		3
#define TH_OPING		4
#define TH_SELECTING	5                  
#define TH_JOINING		6
#define TH_SELECTING2	7
#define TH_SORTING		8
#define TH_PASSING		9

#define MAX_DISPLAY 10

#define MAX_TEAMS 8
#define NUM_TEAMS 6

#define RED_TEAM 		0
#define BLUE_TEAM 		1
#define GREEN_TEAM		2
#define YELLOW_TEAM		3
#define PURPLE_TEAM		4
#define BROWN_TEAM		5
#define ORANGE_TEAM		6
#define WHITE_TEAM		7
#define NO_TEAM 		99

typedef struct {
	char name[32];
	int teamcolor;
	int op;
	int sort;
} team_save_struct  ;

// scoreboard
#define SORT_SCORE		0
#define SORT_PING		1
#define SORT_HEADS		2
#define SORT_ID			3
#define SORT_NAME		4
#define SORT_TIME		5
#define SORT_STAND		6
#define SORT_TEAM		7

// voting
#define MAX_VOTE_LEVELS 24
#define VOTING_DURATION 30
#define DISPLAY_AT_ONCE 8

// ini file 
#define MESSAGES_PER_DEATH 5
#define MAX_DEATHMSG_STRING 64
#define MOTD_LENGTH 400
#define MAX_SECTION_TITLE_LENGTH 64

#define LEVEL_NAME_LENGTH 32
#define LEVEL_TEXT_LENGTH 32
#define MAX_LEVELS 32

#define HELP_STATEMENT_LENGTH 64
#define MAX_HELP_STATEMENTS 16

#define PICKUP_MESSAGE_LENGTH 16
#define MAX_PICKUP_MESSAGES 32

#define SCORING_MESSAGE_LENGTH 64
#define MAX_SCORING_MESSAGES 16

#define PICKUP_VERB_LENGTH 32
#define MAX_PICKUP_VERBS 16

#define PICKUP_NOUN_LENGTH 16
#define MAX_PICKUP_NOUNS 16

#define PICKUP_ADJECTIVE_LENGTH 32
#define MAX_PICKUP_ADJECTIVES 16

typedef struct 
{
	char level_name [LEVEL_NAME_LENGTH];
	char level_text [LEVEL_TEXT_LENGTH];
	int min_players;
	int max_players;
} level_struct;

extern char message_of_the_day[MOTD_LENGTH + 1];
extern level_struct level_list[MAX_LEVELS];
extern int number_of_levels;
extern char help_list[MAX_HELP_STATEMENTS][HELP_STATEMENT_LENGTH];
extern int number_of_helps;
extern char scoring_phrases[MAX_SCORING_MESSAGES][SCORING_MESSAGE_LENGTH];
extern int number_of_scoring_phrases;
extern char pickup_verbs[MAX_PICKUP_VERBS][PICKUP_VERB_LENGTH];
extern int number_of_pickup_verbs;
extern char pickup_nouns[MAX_PICKUP_NOUNS][PICKUP_NOUN_LENGTH];
extern int number_of_pickup_nouns;
extern char pickup_adjectives[MAX_PICKUP_ADJECTIVES][PICKUP_ADJECTIVE_LENGTH];
extern int number_of_pickup_adjectives;

// head history

#define MAX_FORMER_OWNERS	5
#define MAX_HISTORYS		256

struct history_structure 
{
	int in_use;
	int team;
	edict_t * former_owner[MAX_FORMER_OWNERS];
	int num_former_owners;
	history_struct * next;
};

// grapple
typedef enum {
	CTF_GRAPPLE_STATE_FLY,
	CTF_GRAPPLE_STATE_PULL,
	CTF_GRAPPLE_STATE_HANG
} ctfgrapplestate_t;

// hook
#define HOOK_STATE_ON			0x01
#define HOOK_STATE_OFF			0x02
#define HOOK_STATE_FIRE			0x04

#define CTF_GRAPPLE_SPEED					650 // speed of grapple in flight
#define CTF_GRAPPLE_PULL_SPEED				650	// speed player is pulled at


// function prototypes

// g_main.c
edict_t *CreateTargetChangeLevel(char *map);

// g_misc.c
void VelocityForDamage (int damage, vec3_t v);

// g_combat.c
qboolean CheckTeamDamage (edict_t *targ, edict_t *attacker);

// p_client.c
qboolean IsFemale (edict_t *ent);
float PlayersRangeFromSpot (edict_t *spot);

// p_weapon.c
void P_ProjectSource (gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result);
void Weapon_Generic (edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int *fire_frames, void (*fire)(edict_t *ent));

// hh_head.c
void restore_to_altar (edict_t * self);
edict_t *make_head (vec3_t origin, vec3_t vel, int value, int bloody, int ofteam);
void random_throw_head (edict_t * head,vec3_t origin,int power);
void head_remove (edict_t *head);

// hh_teamplay.c
extern char teamcolors[MAX_TEAMS][12];
qboolean TP_teamplay_set (void);
qboolean TP_ClientCommand (char * cmd, edict_t * ent);
qboolean TP_OnSameTeam(edict_t *ent1, edict_t *ent2);
void init_team_help (void);
void TP_clear_teamdisk(edict_t *ent);
void TP_DeathmatchScoreboardMessage (edict_t *ent, edict_t *killer);

// hh_client.c
int HH_calc_score(edict_t *ent);
int HH_deathmatch_score (edict_t *ent);
int HH_teampassing_score (edict_t *ent);
void HH_DropHeads (edict_t *ent,int power, qboolean nopickup);
void HH_ThrowClientHead (edict_t *self, int damage);
void free_heads (edict_t *ent);
void free_history (history_struct * history);
void pickup_head (edict_t *ent, edict_t *head);
history_struct * alloc_history (void);
int get_hidden_heads (edict_t *ent);
int get_num_heads(edict_t *ent);
void HH_Begin(edict_t *ent);
void HH_Think (edict_t *ent, usercmd_t *ucmd);
qboolean HH_ClientCommand (char * cmd, edict_t * ent);
void HH_display_heads (edict_t *ent);
void HH_Respawn (gclient_t *client);
void HH_die_head (edict_t *self, int damage);
void HH_precache (void);
void fixPercentInString (char *s);

// hh_ini.c
void get_ini_file_data (void);

// hh_deathmsg.c
void init_death_messages (void);
void DM_ClientObituary (edict_t *self, edict_t *inflictor, edict_t *attacker);

// hh_ctf.c
void CTFWeapon_Grapple (edict_t *ent);
void CTFPlayerResetGrapple(edict_t *ent);
void CTFGrapplePull(edict_t *self);
void CTFResetGrapple(edict_t *self);
edict_t *SelectCTFSpawnPoint (edict_t *ent);
void HHCTF_DeathmatchScoreboardMessage (edict_t *ent, edict_t *killer);
void CTFHook_Fire (edict_t *ent);

// hh_teamplay.c
int validate_selection(edict_t *ent, edict_t **found_guy);
void TP_save_client_teams (void);
void TP_init_cvars (void) ;
void TP_set_teamdisk (edict_t *ent);
void TP_set_default_team (edict_t *ent);
void TP_restore_client_team (edict_t *ent);
void TP_leave_team (edict_t *ent);
void TP_periodic(edict_t *ent);


// hh_global.c
void HH_init_cvars (void);

// hh_altar.c
extern int hh_altars;
extern int hhctf_red_altars;
extern int hhctf_blue_altars;

char *HH_SpawnEntities (char *mapname, char *entstring);
void HH_replace_dmspot (void);

// hh_edit.c
void Cmd_Altar_f (edict_t *ent);

// hh_vote.c
extern float voting_started;
qboolean VOTING_in_vote (void);
void VOTING_select (edict_t *ent);
void VOTING_select_down (edict_t *ent);
void VOTING_clear_vote (void);
void VOTING_check_done (void);
void VOTING_init_cvars (void);
void VOTING_start_vote (void);
void VOTING_set_display(edict_t *ent);

// hh_levelsel.c
edict_t * HH_level_select (void);

