// HeadHunters v2.55
// http://www.planetquake.com/headhunters
// original baseq2/ctf code by id software 
// original hh code (v2.00) by Charlie Zimmerman
// modified code (v2.5x) by Avi "Zung!" Rozen
// 
// hh_ini.c	- ini file related routines

#include "hh_shared.h"

extern int num_death_messages[50];
extern char death_index[50][32];
extern char death_message[50][MESSAGES_PER_DEATH][MAX_DEATHMSG_STRING];


enum {
	INI_NO_SECTION,
	INI_MOTD,
	INI_LEVELS,
	INI_SCORING_PHRASES,
	INI_PICKUP_NOUNS,
	INI_PICKUP_VERBS,
	INI_PICKUP_ADJECTIVES,
	INI_DEATH_MESSAGES,
	INI_HELP,
	INI_COMMENT
};

// global pickup message.

void init_global_data (void) 
{
	*message_of_the_day = '\0';
	number_of_levels = 0;
	number_of_helps = 0;
	number_of_scoring_phrases = 1;
	strcpy(scoring_phrases[0],"scored at the altar!");
	number_of_pickup_nouns = 1;
	strcpy(pickup_nouns[0],"head");
	number_of_pickup_verbs = 1;
	strcpy(pickup_verbs[0],"found");
	number_of_pickup_adjectives = 1;
	strcpy(pickup_adjectives[0],"putrid");
}


qboolean parse_motd_line (char *line)
{
	char motdline[MAX_STRING_CHARS];

	if (sscanf (line, " \"%[^\"]\" ", motdline) == 1)
		Com_sprintf (message_of_the_day, MOTD_LENGTH, motdline);

	return true;
}


qboolean parse_level (char *line)
{
	char level_name[MAX_STRING_CHARS];
	char level_text[MAX_STRING_CHARS];
	
	if (sscanf (line, " \"%[^\"]\" \"%[^\"]\" ", level_name, level_text) != 2)
	{
		gi.dprintf ("\nsyntax error");
		return false;
	}
	if (number_of_levels >= MAX_LEVELS)
	{
		gi.dprintf ("\ntoo many entries");
		return false;
	}
	Com_sprintf (level_list[number_of_levels].level_name, LEVEL_NAME_LENGTH, level_name);
	Com_sprintf (level_list[number_of_levels].level_text, LEVEL_TEXT_LENGTH, level_text);
	number_of_levels++;
	return true;
}


qboolean parse_scoring_phrase (char *line)
{
	char scoring_phrase[MAX_STRING_CHARS];
	
	if (sscanf (line, " \"%[^\"]\" ", scoring_phrase) != 1)
	{
		gi.dprintf ("\nsyntax error");
		return false;
	}
	if (number_of_scoring_phrases >= MAX_SCORING_MESSAGES)
	{
		gi.dprintf ("\ntoo many entries");
		return false;
	}
	Com_sprintf (scoring_phrases[number_of_scoring_phrases], SCORING_MESSAGE_LENGTH, scoring_phrase);
	number_of_scoring_phrases++;
	return true;
}


qboolean parse_pickup_noun (char *line)
{
	char pickup_noun[MAX_STRING_CHARS];
	
	if (sscanf (line, " \"%[^\"]\" ", pickup_noun) != 1)
	{
		gi.dprintf ("\nsyntax error");
		return false;
	}
	if (number_of_pickup_nouns >= MAX_PICKUP_NOUNS)
	{
		gi.dprintf ("\ntoo many entries");
		return false;
	}
	Com_sprintf (pickup_nouns[number_of_pickup_nouns], PICKUP_NOUN_LENGTH, pickup_noun);
	number_of_pickup_nouns++;
	return true;
}


qboolean parse_pickup_verb (char *line)
{
	char pickup_verb[MAX_STRING_CHARS];
	
	if (sscanf (line, " \"%[^\"]\" ", pickup_verb) != 1)
	{
		gi.dprintf ("\nsyntax error");
		return false;
	}
	if (number_of_pickup_verbs >= MAX_PICKUP_VERBS)
	{
		gi.dprintf ("\ntoo many entries");
		return false;
	}
	Com_sprintf (pickup_verbs[number_of_pickup_verbs], PICKUP_VERB_LENGTH, pickup_verb);
	number_of_pickup_verbs++;
	return true;
}


qboolean parse_pickup_adjective (char *line)
{
	char pickup_adjective[MAX_STRING_CHARS];
	
	if (sscanf (line, " \"%[^\"]\" ", pickup_adjective) != 1)
	{
		gi.dprintf ("\nsyntax error");
		return false;
	}
	if (number_of_pickup_adjectives >= MAX_PICKUP_ADJECTIVES)
	{
		gi.dprintf ("\ntoo many entries");
		return false;
	}
	Com_sprintf (pickup_adjectives[number_of_pickup_adjectives], PICKUP_VERB_LENGTH, pickup_adjective);
	number_of_pickup_adjectives++;
	return true;
}


qboolean parse_death_message (char *line)
{
	char mod[MAX_STRING_CHARS];
	char message[MAX_STRING_CHARS];
	int index;
	
	if (sscanf (line, " \"%[^\"]\" \"%[^\"]\" ", mod, message) != 2)
	{
		gi.dprintf ("\nsyntax error");
		return false;
	}
	for (index = 0; index < 41; index++)
		if (Q_stricmp (mod, death_index[index]) == 0)
			break;
	if (index == 41)
	{
		gi.dprintf ("\nunknown m.o.d - %s", mod);
		return false;
	}
	if (num_death_messages[index] >= MESSAGES_PER_DEATH)
	{
		gi.dprintf ("\ntoo many entries for %s", mod);
		return false;
	}
	Com_sprintf (death_message[index][num_death_messages[index]], MAX_DEATHMSG_STRING, message);
	num_death_messages[index]++;
	return true;
}


qboolean parse_help (char *line)
{
	char help[MAX_STRING_CHARS];
	
	if (sscanf (line, " \"%[^\"]\" ", help) != 1)
	{
		gi.dprintf ("\nsyntax error");
		return false;
	}
	if (number_of_helps >= MAX_HELP_STATEMENTS)
	{
		gi.dprintf ("\ntoo many entries");
		return false;
	}
	Com_sprintf (help_list[number_of_helps], HELP_STATEMENT_LENGTH, help);
	number_of_helps++;
	return true;
}


qboolean parse_line (int section, char *line)
{
	switch (section)
	{
	case INI_MOTD:
		return parse_motd_line (line);
	case INI_LEVELS:
		return parse_level (line);
	case INI_SCORING_PHRASES:
		return parse_scoring_phrase (line);
	case INI_PICKUP_NOUNS:
		return parse_pickup_noun (line);
	case INI_PICKUP_VERBS:
		return parse_pickup_verb (line);
	case INI_PICKUP_ADJECTIVES:
		return parse_pickup_adjective (line);
	case INI_DEATH_MESSAGES:
		return parse_death_message (line);
	case INI_HELP:
		return parse_help (line);
	case INI_COMMENT:
		return true;
	case INI_NO_SECTION:
	default:
		return false;
	}
}


qboolean blank (char *line)
{
	while (*line && (*line) <= ' ') 
		line++;
	return ((*line) == '\0');
}


void get_ini_file_data (void) 
{
	FILE *inifile;
	qboolean ok = true;
	int linenum = 0, section = 0;
	char line[MAX_STRING_CHARS];
	char title[MAX_STRING_CHARS];     // add one for terminator
	char inipath[MAX_OSPATH];
	cvar_t	*game;

	game = gi.cvar("game", "", 0);

	init_global_data ();
	init_death_messages ();
	Com_sprintf (inipath, MAX_OSPATH, "%s/%s/%s.ini", basedir->string, game->string, (inifilename->string[0])? inifilename->string:"hh");
	gi.dprintf ("loading \"%s\" ... ", inipath);
	inifile = fopen (inipath, "rt");

	if (inifile == NULL) 
	{
   		gi.dprintf ("\ncan't open ini file\n");
		return;
	}

	title[0] = '\0';
	section = INI_NO_SECTION;

	while (fgets (line, MAX_STRING_CHARS, inifile)) 
	{
		linenum++;
		if (blank (line))
			continue;
		if (sscanf (line, " [%[^]]] ", title) != 1)
		{
			if (!parse_line (section, line))
			{
				ok = false;
				gi.dprintf ("\nerror at line %d\n", linenum);
				break;
			}
		}
		else
		{
			if (Q_stricmp (title, "motd") == 0)
				section = INI_MOTD;
			else if (Q_stricmp (title, "levels") == 0)
				section = INI_LEVELS;
			else if (Q_stricmp (title, "scoring phrases") == 0)
				section = INI_SCORING_PHRASES;
			else if (Q_stricmp (title, "pickup nouns") == 0)
				section = INI_PICKUP_NOUNS;
			else if (Q_stricmp (title, "pickup verbs") == 0)
				section = INI_PICKUP_VERBS;
			else if (Q_stricmp (title, "pickup adjectives") == 0)
				section = INI_PICKUP_ADJECTIVES;
			else if (Q_stricmp (title, "death messages") == 0)
				section = INI_DEATH_MESSAGES;
			else if (Q_stricmp (title, "help") == 0)
				section = INI_HELP;
			else if (Q_stricmp (title, "comment") == 0)
				section = INI_COMMENT;
			else 
			{
				ok = false;
		  		gi.dprintf ("\nunsupported section - %s\n", title);
				break;
			}
		}
	}
	fclose(inifile);
	if (ok)
		gi.dprintf ("ok\n");
}
