// HeadHunters v2.55
// http://www.planetquake.com/headhunters
// original baseq2/ctf code by id software 
// original hh code (v2.00) by Charlie Zimmerman
// modified code (v2.5x) by Avi "Zung!" Rozen
// 
// hh_client.c	- client related routines

#include "hh_shared.h"

history_struct history_array[MAX_HISTORYS];


char getHexDigit (char hex_char)
{
	if (hex_char >= '0' && hex_char <= '9')
		return hex_char - '0';
	if (hex_char >= 'a' && hex_char <= 'f')
		return hex_char - 'a';
	if (hex_char >= 'A' && hex_char <= 'F')
		return hex_char - 'A';
}


int getHex (char *hex_string, char *hex_number)
{
	*hex_number = 0;
	if ((hex_string[0] >= '0' && hex_string[0] <= '9') ||
		(hex_string[0] >= 'A' && hex_string[0] <= 'F') ||
		(hex_string[0] >= 'a' && hex_string[0] <= 'f'))
	{
		*hex_number = getHexDigit (hex_string[0]);
		if ((hex_string[1] >= '0' && hex_string[1] <= '9') ||
			(hex_string[1] >= 'A' && hex_string[1] <= 'F') ||
			(hex_string[1] >= 'a' && hex_string[1] <= 'f'))
		{
			*hex_number *= 16;
			*hex_number += getHexDigit (hex_string[1]);
			return 2;
		}
		else
			return 1;
	}
	else
		return 0;
}


int getOct (char *oct_string, char *oct_number)
{
	*oct_number = 0;
	if (oct_string[0] >= '0' && oct_string[0] <= '7')
	{
		*oct_number = oct_string[0] - '0';
		if (oct_string[1] >= '0' && oct_string[1] <= '7')
		{
			*oct_number *= 8;
			*oct_number += oct_string[1] - '0';
			if (oct_string[2] >= '0' && oct_string[2] <= '7')
			{
				*oct_number *= 8;
				*oct_number += oct_string[2] - '0';
				return 3;
			}
			else
				return 2;
		}
		else
			return 1;
	}
	else
		return 0;
}


char *highlightText (char *text)
{
	while (*text)
		*text++ |= 0x80;
	return text;
}




char *motd (char *motdstr)
{
	int i = 0;
	qboolean highlight = false;
	static char motdprint[MAX_STRING_CHARS + 1];

	motdprint[0] = '\0';
	while (i < MAX_STRING_CHARS && *motdstr)
	{
		motdprint[i] = *motdstr | ((highlight)? 0x80:0x00);
		if (*motdstr == '\\')
		{
			if (*(motdstr + 1) == 'n')
			{
				motdprint[i] = '\n';
				motdstr++;
			}
			else if (*(motdstr + 1) == '!')
			{
				highlight = !highlight;
				i--;
				motdstr++;
			}
			else if (*(motdstr + 1) == '\"')
			{
				motdprint[i] = '\"' | ((highlight)? 0x80:0x00);
				motdstr++;
			}
			else if (*(motdstr + 1) == '\\')
				motdstr++;
			else if (*(motdstr + 1) == 'x')
			{
				motdstr += getHex (motdstr + 2, &motdprint[i]);
				motdstr++;
			}
			else if (*(motdstr + 1) >= '0' && *(motdstr + 1) <= '7')
				motdstr += getOct (motdstr + 1, &motdprint[i]);
		}
		motdstr++;
		i++;
	}
	if (i == MAX_STRING_CHARS)
		i--;
	motdprint[i] = '\0';
	return motdprint;
}


void HH_precache (void) 
{
	// models
	gi.modelindex ("models/chead/c8h/tris.md2");
	gi.modelindex ("models/chead/c7h/tris.md2");
	gi.modelindex ("models/chead/c6h/tris.md2");
	gi.modelindex ("models/chead/c5h/tris.md2");
	gi.modelindex ("models/chead/c4h/tris.md2");
	gi.modelindex ("models/chead/c3h/tris.md2");
	gi.modelindex ("models/chead/c2h/tris.md2");
	gi.modelindex ("models/chead/c1h/tris.md2");
	gi.modelindex ("models/altar/tris.md2");
	gi.modelindex ("models/altarblood/tris.md2");
	gi.modelindex ("models/heads/2head/tris.md2");
	gi.modelindex ("models/heads/3head/tris.md2");
	gi.modelindex ("models/heads/chead/tris.md2");
	gi.modelindex ("models/heads/rhead/tris.md2");
	if (headthieves->value)
	{
		gi.modelindex ("models/teams/blue/tris.md2");
		gi.modelindex ("models/teams/red/tris.md2");
	} 
	else if (TP_teamplay_set()) 
	{
		gi.modelindex ("models/teams/blue/tris.md2");
		gi.modelindex ("models/teams/brown/tris.md2");
		gi.modelindex ("models/teams/green/tris.md2");
		gi.modelindex ("models/teams/orange/tris.md2");
		gi.modelindex ("models/teams/purple/tris.md2");
		gi.modelindex ("models/teams/red/tris.md2");
		gi.modelindex ("models/teams/white/tris.md2");
		gi.modelindex ("models/teams/yellow/tris.md2");
	}
	// sounds
	gi.soundindex("hh/head/splat1.wav");
	gi.soundindex("hh/head/splat2.wav");
	gi.soundindex("hh/head/splat3.wav");
	gi.soundindex("hh/head/splat4.wav");
	if (TP_teamplay_set()) 
	{
		gi.soundindex("hh/teamplay/bad.wav");
		gi.soundindex("hh/teamplay/boot.wav");
		gi.soundindex("hh/teamplay/invite.wav");
		gi.soundindex("hh/teamplay/join.wav");
	}
	if (audience->value)
	{
		int i, j;

		for (i = 1; i < 4; i++)
		{
			for (j = 1; j < 5; j++)
			{
				gi.soundindex (va ("hh/audience/clap%d%d.wav", i, j));
				gi.soundindex (va ("hh/audience/dang%d%d.wav", i, j));
				gi.soundindex (va ("hh/audience/cheer%d%d.wav", i, j));
			}
		}
		for (i = 1; i < 5; i++)
			gi.soundindex (va ("hh/audience/cheer4%d.wav", i));
		gi.soundindex ("hh/audience/precheer.wav");
	}
	else
	{
		gi.soundindex("hh/altar/score1.wav");
		gi.soundindex("hh/altar/score2.wav");
		gi.soundindex("hh/altar/score3.wav");
		gi.soundindex("hh/altar/score4.wav");
		gi.soundindex("hh/altar/score5.wav");
	}
}


void init_history_array (void) 
{
	int i;

	for (i=0; i++; i< MAX_HISTORYS) 
	{
		history_array[i].num_former_owners = 0;
		history_array[i].in_use = false;
		history_array[i].next = NULL;
	}
}


history_struct * alloc_history (void) 
{
	int i;
	history_struct * temp;

	temp = NULL;
	for (i=0; i<MAX_HISTORYS; i++) 
	{
   		if (history_array[i].in_use == false) 
		{
      		history_array[i].in_use = true;
			temp = &history_array[i];
			temp->num_former_owners = 0;
      		break;
		 }
	}
	return temp;
}


void free_history (history_struct * history) 
{
	history->in_use = false;
	history->num_former_owners = 0;
	history->next = NULL;
}


void clear_history(history_struct * history) 
{
   history->num_former_owners = 0;
}


int count_owners(history_struct *history) 
{
	return history->num_former_owners;
}


void add_owner_to_history (history_struct * history, edict_t * ent) 
{
	int already_owned = false;
	int i;

	if (history == NULL) 
	{
   		gi.error ("add_owner_to_history: NULL history\n");
		return;
	}
	if (history->num_former_owners == 0) 
	{
   		history->team = ent->client->pers.teamcolor;
		history->num_former_owners = 1;
		history->former_owner[0] = ent;
	}
	else 
	{
   		if (ent->client->pers.teamcolor != history->team) 
		{
      		clear_history (history);
	   		history->team = ent->client->pers.teamcolor;
			history->num_former_owners = 1;
   			history->former_owner[0] = ent;
		}
   		else 
		{
      		for (i = 0; i < history->num_former_owners; i++) 
         		if (history->former_owner[i] == ent) 
            		already_owned = true;
			if (!already_owned)	
			{
	      		if ((history->num_former_owners + 1) < MAX_FORMER_OWNERS) 
				{
      				history->former_owner[history->num_former_owners] = ent;
   	      			history->num_former_owners++;
         		}
			}
		}
	}
}


void set_player_head_model(edict_t *ent) 
{
	switch (ent->client->hidden_heads) 
	{
	case 0:
	   	ent->s.modelindex3 = 0;
		break;
	case 1:
	   	ent->s.modelindex3 = gi.modelindex ("models/chead/c1h/tris.md2");
		break;
	case 2:
	   	ent->s.modelindex3 = gi.modelindex ("models/chead/c2h/tris.md2");
		break;
	case 3:
	   	ent->s.modelindex3 = gi.modelindex ("models/chead/c3h/tris.md2");
		break;
	case 4:
	   	ent->s.modelindex3 = gi.modelindex ("models/chead/c4h/tris.md2");
		break;
	case 5:
	   	ent->s.modelindex3 = gi.modelindex ("models/chead/c5h/tris.md2");
		break;
	case 6:
	   	ent->s.modelindex3 = gi.modelindex ("models/chead/c6h/tris.md2");
		break;
	case 7:
	   	ent->s.modelindex3 = gi.modelindex ("models/chead/c7h/tris.md2");
		break;
	default:
	   	ent->s.modelindex3 = gi.modelindex ("models/chead/c8h/tris.md2");
		break;
	}
}


void HH_Respawn(gclient_t *client) 
{
	client->hidden_heads = 0;
	client->num_heads = 0;
	client->head_list = NULL;
	client->in_camp = false;
	client->ps.stats[STAT_HEAD_ICON] = 0;
}


void HH_Begin(edict_t *ent) 
{
	ent->history = NULL;
	ent->client->vote = 0;
	ent->client->motd_delay = (voting_started == 0)? 105:0;
	ent->client->begun = true;
	if (ent->client->pers.just_connected)
	{
		gi.WriteByte (svc_stufftext);
		if (hook->value)
			gi.WriteString ("alias +hook hookon; alias -hook hookoff\n");
		else
			gi.WriteString ("alias +hook \"use grapple; +attack\"; alias -hook \"-attack; weaplast\"\n");
		gi.unicast(ent, true);
		ent->client->pers.just_connected = false;
	}
	HH_Respawn(ent->client);
}


void HH_Think (edict_t *ent, usercmd_t *ucmd) 
{
	// kick zbots
	if (ucmd->impulse) // this is a bot!
	{
		if (zkick->value == 0)
			gi.dprintf ("[ZKick]: %s (id=%d) @ %s is a bot (impulse=%d)\n",
				ent->client->pers.netname, (ent-g_edicts)-1, Info_ValueForKey (ent->client->pers.userinfo, "ip"), ucmd->impulse);
		else
		{
			gi.dprintf ("[ZKick]: %s (id=%d) @ %s was kicked (impulse=%d)\n",
				ent->client->pers.netname, (ent-g_edicts)-1, Info_ValueForKey (ent->client->pers.userinfo,"ip"), ucmd->impulse);
			if (zkick->value > 1)
			{
				gi.AddCommandString (va ("sv addip %s\n", Info_ValueForKey (ent->client->pers.userinfo,"ip")));
				gi.dprintf ("[ZKick]: %s is banned\n", ent->client->pers.netname);
			}
			gi.WriteByte (svc_stufftext);
			gi.WriteString ("quit\n"); // terminate client's session
			gi.unicast(ent, true);
		}
	}
	// show motd
   	if (ent->client->motd_delay > 0 && *message_of_the_day) 
	{
		if ((ent->client->motd_delay % 20) == 0)
   			gi.centerprintf (ent,"Server Message of the Day\n-------------------------\n%s", motd (message_of_the_day));
		ent->client->motd_delay--;
	}
}


int HH_calc_score(edict_t *ent) 
{
   int score;
   int histcount;
   history_struct * temp;

   score = 0;

   if (TP_teamplay_set()) 
   {
   		if (headthieves->value == 1) 
		{
      		score = get_hidden_heads (ent);
			score = (score + 1) * score / 2;
		}
		else 
		{
   			histcount = 0;
      		temp = ent->history;
			while (temp) 
			{
   	   			histcount++;
      			// how many players held this head?
         		score += count_owners(temp);                       
				temp = temp->next;
   			}
      		// since it is possible some heads didnt have histories
			// add them to the score.
   			if (histcount < get_hidden_heads(ent)) 
      			score += (get_hidden_heads(ent) - histcount);
		}
   }
   else 
   {
		score = get_hidden_heads(ent);
		score += get_num_heads(ent);
		// calculate the cool score
   		score = (score + 1) * score / 2;
   }
   return score;
}


int HH_deathmatch_score(edict_t *ent) 
{
	int score;

	score = HH_calc_score (ent);
	ent->client->resp.score += score;
	// Log Altar Score
	if (score) 
		sl_LogScore( &gi,
					 ent->client->pers.netname,
					 NULL,
					 "Altar Score",
					 NULL,
					 score,
					 level.time );
   return score;
}


int HH_teampassing_score (edict_t *ent) 
{
	int score;
	edict_t * guy;
	history_struct * temp;
	int i;

	score = HH_calc_score(ent);
	sl_LogScore( &gi,
				 ent->client->pers.netname,
				 NULL,
				 "Altar Score",
				 NULL,
				 score,
				 level.time );
   
	ent->client->resp.score += score;
	temp = ent->history;
	while (temp) 
	{
		// how many players held this head?
		score = count_owners(temp);
		// now give that score to all the other clients in the hist list
		for (i=0; i<temp->num_former_owners;i++) 
		{
			// find the guy to make sure that he is still in the game
			guy = NULL;
			guy = G_Find(guy,FOFS(classname),"player");
			while (guy != NULL) 
			{
				if ((guy!=ent) && (guy==temp->former_owner[i]) && !guy->client->resp.spectator) 
				{
					gi.centerprintf(guy,"%s scored for you.",ent->client->pers.netname);
					guy->client->resp.score +=score;
					// Log Altar Score
					sl_LogScore( &gi,
								 guy->client->pers.netname,
								 ent->client->pers.netname,
								 "Team Score",
								 NULL,
								 score,
								 level.time );
					break;
				}
				guy = G_Find(guy,FOFS(classname),"player");
			}
		}
		temp = temp->next;
	}
	return get_hidden_heads(ent);
}


void HH_display_heads (edict_t *ent) 
{
	int score;
	edict_t *guy;
	edict_t *your_altar;
	edict_t *their_altar;

	score = HH_calc_score(ent);

	ent->client->ps.stats[STAT_HEADS] = score;
	if (ent->client->in_camp == false) 
		ent->client->ps.stats[STAT_HEAD_ICON] = 0;
	else 
	{
		if (ent->client->start_camping < (level.time - 10)) 
			ent->client->ps.stats[STAT_HEAD_ICON] = gi.imageindex ("campyel");
   		if (ent->client->start_camping < (level.time - 14)) 
			ent->client->ps.stats[STAT_HEAD_ICON] = gi.imageindex ("campred");
	}
	if (headthieves->value) 
	{
		guy = NULL;
		your_altar = NULL;
		their_altar = NULL;
		guy = G_Find(guy,FOFS(classname),"altar");
  		while (guy != NULL) 
		{
			if (guy->ofteam == ent->client->pers.teamcolor) 
				your_altar = guy;
			else 
           		their_altar = guy;
			guy = G_Find(guy,FOFS(classname),"altar");
		}
		if (your_altar) //make score altar score
			ent->client->resp.score = your_altar->stored_heads;
		// setup head thieves stats
		if (ent->client->pers.teamcolor == RED_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_SCORE_ICON] = gi.imageindex ("i_ctf1");
			ent->client->ps.stats[STAT_OTHER_SCORE_ICON] = gi.imageindex ("i_ctf2");
		}
		else 
		{
			ent->client->ps.stats[STAT_TEAM_SCORE_ICON] = gi.imageindex ("i_ctf2");
			ent->client->ps.stats[STAT_OTHER_SCORE_ICON] = gi.imageindex ("i_ctf1");
		}
		ent->client->ps.stats[STAT_OTHER_SCORE] = their_altar->stored_heads;
	}
}


int get_hidden_heads (edict_t *ent)   
{
	return (ent->client->hidden_heads);
} 


int get_num_heads(edict_t *ent) 
{
	return (ent->client->num_heads);
}


void free_heads(edict_t *ent) 
{
	history_struct * hist;
	history_struct * next_hist;

 	ent->client->hidden_heads = 0;
	ent->client->num_heads = 0;
	hist = ent->history;
	while (hist != NULL) 
	{
		next_hist = hist->next;
		free_history(hist);
		hist = next_hist;
	}
	ent->history = NULL;

  	ent->s.modelindex3 = 0;
	gi.linkentity(ent);
}


void HH_DropHeads (edict_t *ent,int power, qboolean nopickup) 
{
	vec3_t	velocity;
	vec3_t	origin;
	edict_t * head;
	int head_value;
	int clusters;
	int heads_left_to_throw;
	history_struct * temp;
	history_struct * next ;

	// Log Drop Event - No points for this
	if (ent->client->hidden_heads > 0) 
		sl_LogScore( &gi,
					 ent->client->pers.netname,
					 NULL,
					 "Head Drop",
					 NULL,
					 ent->client->hidden_heads,
					 level.time );

	// Clear out the history struct.  You can't drop heads and
	// have them count as a pass!  Your team will be pissed.
	if (ent->history != NULL) 
	{
   		temp = ent->history->next;
		free_history (ent->history);
		while (temp != NULL) 
		{
      		next = temp->next;
			free_history(temp);
			temp = next;
		}
		ent->history = NULL;
	}

	// set sizes, origin, velocity for new head
	VectorCopy (ent->s.origin, origin);
	origin[2] += 32;
	VectorCopy (ent->velocity, velocity);

	if (audience->value && ent->client->hidden_heads > 0)
	{
		if (ent->client->hidden_heads < 3)
			gi.sound(ent, CHAN_NO_PHS_ADD | CHAN_AUTO, gi.soundindex(va ("hh/audience/dang1%d.wav", (rand() % 4) + 1)), 1, ATTN_NORM, 0);
		else if (ent->client->hidden_heads < 5)
			gi.sound(ent, CHAN_NO_PHS_ADD | CHAN_AUTO, gi.soundindex(va ("hh/audience/dang2%d.wav", (rand() % 4) + 1)), 1, ATTN_NORM, 0);
		else 
			gi.sound(ent, CHAN_NO_PHS_ADD | CHAN_AUTO, gi.soundindex(va ("hh/audience/dang3%d.wav", (rand() % 4) + 1)), 1, ATTN_NORM, 0);
	}

	if (ent->client->hidden_heads > 15) 
   		ent->client->hidden_heads = 15;
	heads_left_to_throw = ent->client->hidden_heads;
	if (ent->client->hidden_heads > 10) 
	{
   		head_value = 3;
		clusters = 5;
	}
	else if (ent->client->hidden_heads > 5) 
	{
   		head_value = 2;
		clusters = 5;
	}
	else 
	{
   		head_value = 1;
		clusters = ent->client->hidden_heads;
	}
	while (clusters > 0) 
	{
   		// Make a head.
		head = make_head (origin, velocity, head_value, 0, NO_TEAM);
		random_throw_head (head, origin, power);
		// don't allow to pickup
		head->thrower = ent;
		if (nopickup) // stretch the time that the thrower can't pickup
      		head->nextthink += 30;
		gi.linkentity (head);
		clusters--;
		heads_left_to_throw = heads_left_to_throw - head_value;
		if (heads_left_to_throw > (clusters*2)) 
  	 		head_value = 3;
   		else if (heads_left_to_throw > clusters) 
   			head_value = 2;
   		else 
   			head_value = 1;
	}
	ent->client->hidden_heads = 0;

  	set_player_head_model(ent);
	gi.linkentity(ent);
}


void throw_head (edict_t *ent) 
{
	vec3_t	velocity;
	vec3_t	origin;
	edict_t * head;
	vec3_t offset;
	vec3_t forward;
	vec3_t right;
	vec3_t start;
	vec3_t up;
	history_struct * temp;

	if (ent->client->resp.spectator || ent->client->hidden_heads == 0) 
		return;

	// Log Pass Event - No points for this
   	sl_LogScore( &gi,
				 ent->client->pers.netname,
				 NULL,
				 "Head Pass",
				 NULL,
				 0,
				 level.time );

	// Take away from player
	ent->client->hidden_heads -= 1;
	set_player_head_model(ent);
	gi.linkentity(ent);

	// set sizes, origin, velocity for new head
	VectorCopy (ent->s.origin, origin);
	origin[2] += 32;
	VectorCopy (ent->velocity, velocity);

	// Make a head cluster.
	head = make_head(origin, velocity, 1,0 /* not bloody */,NO_TEAM);
	// grab the first history and give it to the head
	if (TP_teamplay_set()) 
	{
		temp = ent->history;
   		if (temp) 
		{
			ent->history = temp->next;
			temp->next = NULL;
   			// since a head has a history when made free it
			// because this is the real history
			if (head->history) 
			{
         		free_history(head->history);
			}
			head->history = temp;
		}
	}
	// Assign the head a thrower so that the thrower cant touch for a little.
	head->thrower = ent;

	// Do the head velocity stuff.
	VectorSet(offset, 0, 8, ent->viewheight-8);
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	G_ProjectSource (ent->s.origin, offset, forward, right, start);
	VectorScale (forward, 600 /*speed*/ , head->velocity);
	VectorMA (head->velocity, 100 + crandom() * 10.0, up, head->velocity);
	VectorMA (head->velocity, crandom() * 10.0, right, head->velocity);
	//VectorSet (head->avelocity, 300, 300, 0);

	// Link it
	gi.linkentity(head);
}


char * get_noun (void) 
{
	int index;

	index = rand() % number_of_pickup_nouns;
	return pickup_nouns[index];
}


char * get_verb (void) 
{
	int index;

	index = rand() % number_of_pickup_verbs;
	return pickup_verbs[index];
}


char * get_adjective (void) 
{
	int index;

	index = rand() % number_of_pickup_adjectives;
	return pickup_adjectives[index];
}


void pickup_head (edict_t *ent, edict_t *head) 
{
	history_struct * temp;

	// Log Pickup Event - No points for this
   	sl_LogScore( &gi,
				 ent->client->pers.netname,
				 NULL,
				 "Head Pickup",
				 NULL,
				 head->value,
				 level.time );

	// In the new version we get rid of head and bump the player modelindex3
	ent->client->hidden_heads += head->value;
	// Add the head history to the player's head history list
	if (head->history) 
	{
		temp = ent->history;
		ent->history = head->history;
		ent->history->next = temp;
		add_owner_to_history(ent->history,ent);
		// take away the history from the head so it doesn't get
		// deallocated on remove
		head->history = NULL;
	}
	head_remove(head);
	if (random() < 0.5) 
		gi.sound(ent, CHAN_VOICE, gi.soundindex("world/flesh1.wav"), 1, ATTN_NORM, 0);
	else 
		gi.sound(ent, CHAN_VOICE, gi.soundindex("world/flesh2.wav"), 1, ATTN_NORM, 0);
   
	set_player_head_model(ent);
	if (pickup_messages->value) 
	{
 	  	if (ent->client->hidden_heads == 1) 
   			gi.bprintf(PRINT_HIGH,"%s %s a %s %s\n",ent->client->pers.netname,get_verb(),get_adjective(),get_noun());
   		else if (ent->client->hidden_heads == 2)
   			gi.bprintf(PRINT_HIGH,"%s %s second %s %s\n",ent->client->pers.netname,get_verb(),get_adjective(),get_noun());
   		else if (ent->client->hidden_heads == 3)
   			gi.bprintf(PRINT_HIGH,"%s %s third %s %s\n",ent->client->pers.netname,get_verb(),get_adjective(),get_noun());
   		else 
   			gi.bprintf(PRINT_HIGH,"%s %s %ith %s %s\n",ent->client->pers.netname,get_verb(),ent->client->hidden_heads,get_adjective(),get_noun());
	}
	if (audience->value)
	{
		if (ent->client->hidden_heads < 3)
			gi.sound(ent, CHAN_NO_PHS_ADD | CHAN_AUTO, gi.soundindex(va ("hh/audience/clap1%d.wav", (rand() % 4) + 1)), 1, ATTN_NORM, 0);
		else if (ent->client->hidden_heads < 5)
			gi.sound(ent, CHAN_NO_PHS_ADD | CHAN_AUTO, gi.soundindex(va ("hh/audience/clap2%d.wav", (rand() % 4) + 1)), 1, ATTN_NORM, 0);
		else 
			gi.sound(ent, CHAN_NO_PHS_ADD | CHAN_AUTO, gi.soundindex(va ("hh/audience/clap3%d.wav", (rand() % 4) + 1)), 1, ATTN_NORM, 0);
	}

	gi.linkentity(ent);
	return;
}


void HH_die_head (edict_t *self, int damage)
{
	vec3_t	vd;
	vec3_t	origin;
	edict_t * head;

	// In headhunters the client doesn't get thrown as a head.
	// Instead a head is spawned and thrown.  Then client is thrown
	// as a GIB.

	// set sizes, origin, velocity for new head
	VectorCopy (self->s.origin, origin);
	origin[2] += 32;
	VelocityForDamage (damage, vd);

	// Make a head.
	head = make_head(origin, vd,1,1,self->ofteam);
	gi.linkentity(head);
}


// This function replaces the ThrowClientHead in head hunters.
// Check p_client.  It is used to throw a pickupable head
// in head hunters
void HH_ThrowClientHead (edict_t *self, int damage)
{
	vec3_t	vd;
	vec3_t	velocity;
	vec3_t	origin;
	char	*gibname;
	edict_t * head;

	// In headhunters the client doesn't get thrown as a head.
	// Instead a head is spawned and thrown.  Then client is thrown
	// as a GIB.

	// set sizes, origin, velocity for new head
	VectorCopy (self->s.origin, origin);
	origin[2] += 32;
	VectorCopy (self->velocity, velocity);
	VelocityForDamage (damage, vd);
	VectorAdd (velocity, vd, velocity);

	// Make a head.
	head = make_head(origin, velocity,1,1,self->client->pers.teamcolor);
	gi.linkentity(head);

	// Now throw the client as a gib

	gibname = "models/objects/gibs/sm_meat/tris.md2";
	self->s.skinnum = 0;

	self->s.origin[2] += 32;
	self->s.frame = 0;
	gi.setmodel (self, gibname);
	VectorSet (self->mins, -16, -16, 0);
	VectorSet (self->maxs, 16, 16, 16);

	self->takedamage = DAMAGE_NO;
	self->solid = SOLID_NOT;
	self->s.effects = EF_GIB;
	self->s.sound = 0;
	self->flags |= FL_NO_KNOCKBACK;

	self->movetype = MOVETYPE_BOUNCE;
	VelocityForDamage (damage, vd);
	VectorAdd (self->velocity, vd, self->velocity);

	gi.linkentity (self);
}


qboolean HH_ClientCommand (char * cmd, edict_t * ent) 
{
	if (Q_stricmp (cmd, "throw") == 0) 
	{
		throw_head(ent);
		return true;
	}
	else if (Q_stricmp (cmd, "altar") == 0) 
	{
		Cmd_Altar_f (ent);
		return true;
	}
	else if ((Q_stricmp (cmd, "grapple") == 0 ||
			  Q_stricmp (cmd, "+grapple") == 0 ||
			  Q_stricmp (cmd, "+whook") == 0 ||
			  Q_stricmp (cmd, "whook") == 0 ||
			  Q_stricmp (cmd, "hook") == 0) &&
			 grapple->value)
	{
		gi.cprintf (ent, PRINT_HIGH, motd ("activate grapple with '\\!+hook\\!' or '\\!use grapple\\!'\n"));
		return true;
	}
	else if ((Q_stricmp (cmd, "-grapple") == 0 ||
			  Q_stricmp (cmd, "-whook") == 0) &&
			 grapple->value)
		return true;
	else if (hook->value && Q_stricmp(cmd, "hookon") == 0)
	{
		ent->client->hookstate = HOOK_STATE_ON;
		return true;
	}
	else if (hook->value && Q_stricmp(cmd, "hookoff") == 0)
	{
		if (ent->client->hookstate & HOOK_STATE_ON)
			ent->client->hookstate |= HOOK_STATE_OFF;
		return true;
	}
	else
	   return TP_ClientCommand (cmd, ent);

   return false;
}


// this highlights % chars inside the string s
// used to prevent server crashing by lame clients
void fixPercentInString (char *s)
{
	while (*s)
	{
		if (*s == '%')
			*s |= 0x80;
		s++;
	}
}
