// HeadHunters v2.55
// http://www.planetquake.com/headhunters
// original baseq2/ctf code by id software 
// original hh code (v2.00) by Charlie Zimmerman
// modified code (v2.5x) by Avi "Zung!" Rozen
// 
// hh_teamplay.c	- teamplay routines

#include "hh_shared.h"

int num_team_saves;
team_save_struct team_save[MAX_CLIENTS];
cvar_t * private_teams;
char * team_help[16];

char teamcolors[MAX_TEAMS][12];

void set_team_icon(edict_t *);
void TP_set_teamdisk(edict_t *);


void init_team_names(void) 
{
	 strcpy(teamcolors[0],"red");
	 strcpy(teamcolors[1],"blue");
	 strcpy(teamcolors[2],"green");
	 strcpy(teamcolors[3],"yellow");
	 strcpy(teamcolors[4],"purple");
	 strcpy(teamcolors[5],"black");
	 strcpy(teamcolors[6],"orange");
	 strcpy(teamcolors[7],"white");
}


void TP_init_cvars (void ) 
{
	private_teams = gi.cvar ("private_teams","1",CVAR_SERVERINFO);
	init_team_names();
}


void TP_save_client_teams (void) 
{
	edict_t * ent;
	int i;

	num_team_saves = 0;
	for (i=0 ; i<game.maxclients ; i++)
	{
		ent = g_edicts + 1 + i;
		if (ent->inuse) 
		{
			strcpy(team_save[num_team_saves].name,ent->client->pers.netname);
			team_save[num_team_saves].teamcolor = ent->client->pers.teamcolor;
			team_save[num_team_saves].op = ent->client->pers.op;
			team_save[num_team_saves].sort = ent->client->pers.sort;
			num_team_saves++;
		}
  	}
}

void TP_restore_client_team(edict_t *ent) 
{
	int i;

	for (i=0; i<num_team_saves; i++) 
	{
   		if (!strcmp(team_save[i].name,ent->client->pers.netname)) 
		{
			// Log Team Change - MarkDavies
    		sl_LogPlayerTeamChange( &gi,
									ent->client->pers.netname,
									teamcolors[ent->client->pers.teamcolor],
									level.time );
			gi.bprintf(PRINT_HIGH,"Restoring %s to team.\n",ent->client->pers.netname);
			ent->client->pers.teamcolor = team_save[i].teamcolor;
			ent->client->pers.op = team_save[i].op ;
			ent->client->pers.sort = team_save[i].sort ;
			set_team_icon(ent);
			TP_set_teamdisk(ent);
			break;
		}
	}
}

void init_team_help (void) 
{
//                             "1234567890123456789012345678901234567890"
	team_help[TH_PASSING] =    "Pass heads using <cmd throw>";
//                             "1234567890123456789012345678901234567890"
	team_help[TH_CHANGING] =   "Form or change teams using <cmd join>";
//                             "1234567890123456789012345678901234567890"
	team_help[TH_INVITING] =   "<cmd invite> invites a selected player";
//                             "1234567890123456789012345678901234567890"
	team_help[TH_KICKING] =    "Kick a teammate using <cmd boot>";
//                             "1234567890123456789012345678901234567890"
	team_help[TH_OPING] =      "Op a selected teammate using <cmd op>";
//                             "1234567890123456789012345678901234567890"
	team_help[TH_SELECTING] =  "Use [ and ] to select a player.";
//                             "1234567890123456789012345678901234567890"
	team_help[TH_SELECTING2] = "Table switches to sort by id on select";
//                             "1234567890123456789012345678901234567890"
	team_help[TH_JOINING] =    "Use <cmd join> to join inviting team.";
//                             "1234567890123456789012345678901234567890"
	team_help[TH_SORTING] =    "<cmd sort> sorts this table by column";
}


char * get_team_help_message(edict_t *ent) 
{
	edict_t *guy;
	qboolean teammate_found;
	int time;

	// if this is deathmatch
	if (!TP_teamplay_set()) 
	{
   		return team_help[TH_SORTING];
	}
	// if you are being invited
	if (ent->client->recruiting_team != NO_TEAM) 
	{
   		return team_help[TH_JOINING];
	}
	time = level.time / 5;
	// if you are an op
	if (ent->client->pers.op) 
	{
		teammate_found = false;
		guy = NULL;
		guy = G_Find(guy,FOFS(classname),"player");
		while (guy) 
		{
      		if (!guy->client->resp.spectator && (guy->client->pers.teamcolor == ent->client->pers.teamcolor) && (guy != ent)) 
			{
         		teammate_found = true;
			}
			guy = G_Find(guy,FOFS(classname),"player");
		}
		if (!teammate_found) 
		{
      		// if you are and op without teammates
			switch (time % 10) 
			{
			case 0:
         	case 1:
		      	return team_help[TH_PASSING];
   	   		case 2:
      		case 3:
		   		return team_help[TH_SELECTING];
	      	case 4:
   			case 5:
			     return team_help[TH_SELECTING2];
      		case 6:
	        case 7:
		      	return team_help[TH_INVITING];
      		case 8:
         	case 9:
			     return team_help[TH_SORTING];
			}
		}
		else 
		{
   			// if you are an op with teammates
      		switch (time % 14) 
			{
      		case 0:
         	case 1:
		      	return team_help[TH_PASSING];
      		case 2:
	        case 3:
				return team_help[TH_SELECTING];
      		case 4:
         	case 5:
		      	return team_help[TH_SELECTING2];
	      	case 6:
   			case 7:
				return team_help[TH_INVITING];
      		case 8:
	        case 9:
		      	return team_help[TH_KICKING];
      		case 10:
         	case 11:
				return team_help[TH_OPING];
	      	case 12:
   			case 13:
			    return team_help[TH_SORTING];
	      }
      }
   }
	// you are not an op
	switch (time % 6) 
	{
	case 0:
	case 1:
		return team_help[TH_CHANGING];
    case 2:
    case 3:
		return team_help[TH_SORTING];
    case 4:
    case 5:
	    return team_help[TH_PASSING];
	}
}


qboolean TP_teamplay_set(void) 
{
	if (!((int)(dmflags->value) & (DF_MODELTEAMS | DF_SKINTEAMS)))
		return false;
	return true;
}


qboolean TP_OnSameTeam(edict_t *ent1, edict_t *ent2) 
{
	if (!ent1->client) 
		return false;
	if (!ent2->client) 
		return false;
	if (ent1->client->resp.spectator || ent2->client->resp.spectator)
		return false;
	if (ent1->client->pers.teamcolor == ent2->client->pers.teamcolor) 
   		return true;
	return false;
}


void set_recruit_icon (edict_t *ent) 
{
	if (ent->client->recruiting_team == RED_TEAM) 
	{
		ent->client->ps.stats[STAT_RECRUIT_ICON] = gi.imageindex ("k_redinv");
    }
	else if (ent->client->recruiting_team == BLUE_TEAM) 
	{
		ent->client->ps.stats[STAT_RECRUIT_ICON] = gi.imageindex ("k_bluinv");
    }
	else if (ent->client->recruiting_team == GREEN_TEAM) 
	{
		ent->client->ps.stats[STAT_RECRUIT_ICON] = gi.imageindex ("k_greinv");
    }
	else if (ent->client->recruiting_team == YELLOW_TEAM) 
	{
		ent->client->ps.stats[STAT_RECRUIT_ICON] = gi.imageindex ("k_yelinv");
    }
	else if (ent->client->recruiting_team == WHITE_TEAM) 
	{
		ent->client->ps.stats[STAT_RECRUIT_ICON] = gi.imageindex ("k_whiinv");
    }
	else if (ent->client->recruiting_team == BROWN_TEAM) 
	{
		ent->client->ps.stats[STAT_RECRUIT_ICON] = gi.imageindex ("k_broinv");
    }
	else if (ent->client->recruiting_team == PURPLE_TEAM) 
	{
		ent->client->ps.stats[STAT_RECRUIT_ICON] = gi.imageindex ("k_purinv");
    }
	else if (ent->client->recruiting_team == ORANGE_TEAM) 
	{
		ent->client->ps.stats[STAT_RECRUIT_ICON] = gi.imageindex ("k_orainv");
    }
}


void set_team_icon (edict_t *ent) 
{
	if (!ent->client->pers.op) 
	{
		if (ent->client->pers.teamcolor == RED_TEAM) 
		{
      		if (headthieves->value) 
			{
				ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("i_ctf1");
      		}
			else 
			{
				ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_redtm");
			}
		}
		else if (ent->client->pers.teamcolor == BLUE_TEAM) 
		{
      		if (headthieves->value) 
			{
				ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("i_ctf2");
      		}
			else 
			{
				ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_blutm");
			}
		}
		else if (ent->client->pers.teamcolor == GREEN_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_gretm");
		}
		else if (ent->client->pers.teamcolor == YELLOW_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_yeltm");
		}
		else if (ent->client->pers.teamcolor == WHITE_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_whitm");
		}
		else if (ent->client->pers.teamcolor == BROWN_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_brotm");
		}
		else if (ent->client->pers.teamcolor == PURPLE_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_purtm");
		}
		else if (ent->client->pers.teamcolor == ORANGE_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_oratm");
		}
	}
	else 
	{
		if (ent->client->pers.teamcolor == RED_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_redop");
		}
		else if (ent->client->pers.teamcolor == BLUE_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_bluop");
		}
		else if (ent->client->pers.teamcolor == GREEN_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_greop");
		}
		else if (ent->client->pers.teamcolor == YELLOW_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_yelop");
		}
		else if (ent->client->pers.teamcolor == WHITE_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_whiop");
		}
		else if (ent->client->pers.teamcolor == BROWN_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_broop");
		}
		else if (ent->client->pers.teamcolor == PURPLE_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_purop");
		}
		else if (ent->client->pers.teamcolor == ORANGE_TEAM) 
		{
			ent->client->ps.stats[STAT_TEAM_ICON] = gi.imageindex ("k_oraop");
		}
	}
}


void TP_set_teamdisk(edict_t *ent) 
{
	if (ent->client->pers.teamcolor == RED_TEAM) {
		ent->s.modelindex4 =  gi.modelindex ("models/teams/red/tris.md2");
   }
	else if (ent->client->pers.teamcolor == BLUE_TEAM) {
		ent->s.modelindex4 =  gi.modelindex ("models/teams/blue/tris.md2");
   }
	else if (ent->client->pers.teamcolor == GREEN_TEAM) {
		ent->s.modelindex4 =  gi.modelindex ("models/teams/green/tris.md2");
   }
	else if (ent->client->pers.teamcolor == YELLOW_TEAM) {
		ent->s.modelindex4 =  gi.modelindex ("models/teams/yellow/tris.md2");
   }
	else if (ent->client->pers.teamcolor == PURPLE_TEAM) {
		ent->s.modelindex4 =  gi.modelindex ("models/teams/purple/tris.md2");
   }
	else if (ent->client->pers.teamcolor == ORANGE_TEAM) {
		ent->s.modelindex4 =  gi.modelindex ("models/teams/orange/tris.md2");
   }
	else if (ent->client->pers.teamcolor == WHITE_TEAM) {
		ent->s.modelindex4 =  gi.modelindex ("models/teams/white/tris.md2");
   }
	else if (ent->client->pers.teamcolor == BROWN_TEAM) {
		ent->s.modelindex4 =  gi.modelindex ("models/teams/brown/tris.md2");
   }
   
   set_recruit_icon(ent);
   set_team_icon(ent);
}

void TP_clear_teamdisk(edict_t *ent) 
{
	ent->s.modelindex4 = 0;
}

void clear_recruit_icon(edict_t *ent) {
	ent->client->ps.stats[STAT_RECRUIT_ICON] = 0;
};


void TP_join_team(edict_t *ent, int team) {
	edict_t * guy;
   int makeop = true;

   //if (!TP_teamplay_set()) return;

   guy = NULL;

   guy = G_Find(guy,FOFS(classname),"player");
   while (guy != NULL) {
   	if (!guy->client->resp.spectator && guy->client->pers.teamcolor == team) {
      	if (guy->client->pers.op == true) {
         	makeop = false;
         }
      }
   	guy = G_Find(guy,FOFS(classname),"player");
   }
   if (makeop && (team > 1) ) { // never op red or blue teams
   	ent->client->pers.op = true;
	}
   else {
   	ent->client->pers.op = false;
   }
	ent->client->pers.teamcolor = team;
   ent->client->recruiting_team = NO_TEAM;
   set_team_icon(ent);
   TP_set_teamdisk(ent);
   ent->client->resp.score = 0;
   gi.linkentity(ent);
  	// Log Team Change - MarkDavies
	sl_LogPlayerTeamChange( &gi,
                            ent->client->pers.netname,
                            teamcolors[ent->client->pers.teamcolor],
                            level.time );
}

void TP_leave_team(edict_t *ent) {
	int team;
   edict_t *guy;
   int makeop = true;

   //if (!TP_teamplay_set()) return;

   guy = NULL;
   team = ent->client->pers.teamcolor;
   guy = G_Find(guy,FOFS(classname),"player");
   while (guy != NULL) {
   	if (guy != ent && !guy->client->resp.spectator)
   	if (guy->client->pers.teamcolor == team) {
      	if (guy->client->pers.op == true) {
         	makeop = false;
         }
      }
   	guy = G_Find(guy,FOFS(classname),"player");
   }
   if (makeop && (team > 1)) { // never op red or blue teams
   	guy = NULL;
		guy = G_Find(guy,FOFS(classname),"player");
 	  	while (guy != NULL) {
      	if (guy != ent && !guy->client->resp.spectator)
  		 	if (guy->client->pers.teamcolor == team) {
      		guy->client->pers.op = true;
				set_team_icon(guy);
            break;
      	}
   		guy = G_Find(guy,FOFS(classname),"player");
	   }
	}
   HH_DropHeads(ent,40,true /* flag indicates that heads can never be recovered */);
}


void TP_set_default_team(edict_t *ent) {
	edict_t * guy;
   int blues, reds;

   //if (!TP_teamplay_set()) return;

   blues = 0;
   reds = 0;

   guy = NULL;

   guy = G_Find(guy,FOFS(classname),"player");
   while (guy != NULL) {
	   if (!guy->client->resp.spectator) {
   	if (guy->client->pers.teamcolor == RED_TEAM) {
      	reds++;
      }
      else if (guy->client->pers.teamcolor == BLUE_TEAM){
      	blues++;
      }
   	guy = G_Find(guy,FOFS(classname),"player");
   }}

   if (reds > blues) {
   	TP_join_team(ent,BLUE_TEAM);
   }
   else {
   	TP_join_team(ent,RED_TEAM);
   }

	ent->client->pers.selection = ent;
}

void join_team(edict_t * ent) {
	char openteams[MAX_TEAMS];
   int i;
   edict_t * guy;

   guy = NULL;

   if (ent->client->recruiting_team == NO_TEAM) {
      // this cycles through teams that are available to the player
		for (i = 2; i < NUM_TEAMS; i++) {
  		 	openteams[i] = 0;
   	}
   	guy = G_Find(guy,FOFS(classname),"player");
     	while (guy != NULL) {
			// fixme: deal with spectators?
			openteams[guy->client->pers.teamcolor] = 1;
  		 	guy = G_Find(guy,FOFS(classname),"player");
   	}
      openteams[RED_TEAM] = 0;
      openteams[BLUE_TEAM] = 0;
      i=ent->client->pers.teamcolor;
  	   i+=1;
      // only allow player to cycle to private team if
      // private teams are allowed.
	if ((!(private_teams->value)) ||
       (headthieves->value))  {
      	if (i>=2) i=0;
      }
      else {
  	 		if (i==NUM_TEAMS) i = 0;
      }
     	while (openteams[i]) {
     		i+=1;
      	if (i==NUM_TEAMS) i = 0;
     	}
     	TP_leave_team(ent);
  		TP_join_team(ent,i);
     	gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/teamplay/join.wav"), 1, ATTN_STATIC, 0);
   }
   else {
   	// This code is for joining a recruiting team
      TP_leave_team(ent);
      TP_join_team(ent,ent->client->recruiting_team);
      clear_recruit_icon(ent);
		// find everyone on team and notify them with this sound
	   guy = NULL;
      guy = G_Find(guy,FOFS(classname),"player");
   	while (guy != NULL) {
   		if (!guy->client->resp.spectator && guy->client->pers.teamcolor == ent->client->pers.teamcolor) {
	       	gi.sound(guy, CHAN_VOICE, gi.soundindex("hh/teamplay/join.wav"), 1, ATTN_STATIC, 0);
         }
	   	guy = G_Find(guy,FOFS(classname),"player");
   	}
   }
}

void invite_to_team(char * cmd, edict_t * ent) {
   edict_t * guy;

   if (!validate_selection(ent,&guy)) {
     	gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/teamplay/bad.wav"), 1, ATTN_STATIC, 0);
   	gi.cprintf(ent,PRINT_HIGH,"Nobody selected");
      return;
   }

   if (ent->client->pers.op) {
   	if (guy->client->recruiting_team == NO_TEAM) {
			if (guy->client->pers.teamcolor != ent->client->pers.teamcolor) {
        		gi.cprintf(ent,PRINT_HIGH,"Inviting Player");
				//gi.sound(ent, CHAN_VOICE, gi.soundindex("world/flesh1.wav"), 1, ATTN_NORM, 0);
        		guy->client->recruiting_team = ent->client->pers.teamcolor;
           	guy->client->recruiting_period_over = level.time + (FRAMETIME * 10 * 12);
				set_recruit_icon(guy);
				gi.sound(guy, CHAN_VOICE, gi.soundindex("hh/teamplay/invite.wav"), 1, ATTN_STATIC, 0);
         }
         else {
     			gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/teamplay/bad.wav"), 1, ATTN_STATIC, 0);
            gi.cprintf(ent,PRINT_HIGH,"The player is already\n on your team.");
         }
      }
      else {
			gi.cprintf(ent,PRINT_HIGH,"The player is currently being recruited.\n  Try again later");
      }
   }
   else {
   	gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/teamplay/bad.wav"), 1, ATTN_STATIC, 0);
      gi.cprintf(ent,PRINT_HIGH,"You must be an OP to invite");
   }
}

void kick_from_team(char * cmd, edict_t * ent) {
   edict_t * guy;

   if (!validate_selection(ent,&guy)) {
		gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/teamplay/bad.wav"), 1, ATTN_STATIC, 0);
     	gi.cprintf(ent,PRINT_HIGH,"Nobody selected");
      return;
   }

   if (ent->client->pers.op) {
      	if (guy->client->pers.op == false) {
				if (guy->client->pers.teamcolor == ent->client->pers.teamcolor) {
   	       	gi.cprintf(ent,PRINT_HIGH,"Kicking Player");
     		     	gi.cprintf(guy,PRINT_HIGH,"%s kicked you.",ent->client->pers.netname);
	      		// this code is for going back to red or blue teams
					gi.sound(guy, CHAN_VOICE, gi.soundindex("hh/teamplay/boot.wav"), 1, ATTN_STATIC, 0);
  		      	TP_leave_team(guy);
            	TP_set_default_team(guy);
	         }
   	      else {
      			gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/teamplay/bad.wav"), 1, ATTN_STATIC, 0);
					gi.cprintf(ent,PRINT_HIGH,"That player is not\n on your team.");
         	}
         }
         else {
         	gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/teamplay/bad.wav"), 1, ATTN_STATIC, 0);
				gi.cprintf(ent,PRINT_HIGH,"You cannot kick an op.");
         }
   }
   else {
   	gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/teamplay/bad.wav"), 1, ATTN_STATIC, 0);
      gi.cprintf(ent,PRINT_HIGH,"You must be an OP to kick.");
   }
}

void op_teammate(edict_t * ent) {
   edict_t * guy;

   if (!validate_selection(ent,&guy)) {
   	gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/teamplay/bad.wav"), 1, ATTN_STATIC, 0);
      gi.cprintf(ent,PRINT_HIGH,"Nobody selected");
      return;
   }

   if (ent->client->pers.op) {
			if (guy->client->pers.teamcolor == ent->client->pers.teamcolor) {
          	gi.cprintf(ent,PRINT_HIGH,"Giving Player Ops");
          	gi.cprintf(guy,PRINT_HIGH,"%s gave you ops.",ent->client->pers.netname);
	      	// this code is for going back to red or blue teams
				guy->client->pers.op = true;
            set_team_icon(guy);
         }
         else {
      		gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/teamplay/bad.wav"), 1, ATTN_STATIC, 0);
				gi.cprintf(ent,PRINT_HIGH,"That player is not\n on your team.");
         }
   }
   else {
   	gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/teamplay/bad.wav"), 1, ATTN_STATIC, 0);
      gi.cprintf(ent,PRINT_HIGH,"You must be an OP\nto give ops.");
   }

}

void rotate_sort_setting (edict_t *ent) {
   if (ent->client->pers.sort == SORT_TEAM) {
   	ent->client->pers.sort = SORT_SCORE;
   }
   else if (ent->client->pers.sort == SORT_SCORE) {
   	ent->client->pers.sort = SORT_ID;
   }
   else if (ent->client->pers.sort == SORT_ID) {
   	ent->client->pers.sort = SORT_HEADS;
   }
   else if (ent->client->pers.sort == SORT_HEADS) {
   	ent->client->pers.sort = SORT_PING;
   }
   else if (ent->client->pers.sort == SORT_PING) {
   	ent->client->pers.sort = SORT_TIME;
   }
   else if (ent->client->pers.sort == SORT_TIME) {
   	ent->client->pers.sort = SORT_STAND;
   }
	else if (ent->client->pers.sort == SORT_STAND) {
	if (TP_teamplay_set()) {
	   	ent->client->pers.sort = SORT_TEAM;
	}
	else {
	   	ent->client->pers.sort = SORT_SCORE;
	}
   }
}

int validate_selection(edict_t *ent,edict_t **found_guy) {
	edict_t *guy;

   guy = NULL;
   guy = G_Find(guy,FOFS(classname),"player");
   while (guy != NULL) {
   	if (!ent->client->resp.spectator && guy == ent->client->pers.selection) {
         *found_guy = guy;
			return true;
      }
   	guy = G_Find(guy,FOFS(classname),"player");
   }
	return false;
}

void change_selection(edict_t *ent) {
	edict_t *guy;

   ent->client->pers.sort = SORT_ID;

	if (ent->client->pers.selection == NULL) {
   	guy = ent;
   }
   else {
   	// find the selection
		if (!validate_selection(ent,&guy)) {
      	ent->client->pers.selection = ent;
         guy = ent;
      }
      // now get the next guy
  		guy = G_Find(guy,FOFS(classname),"player");
		// if the guy is NULL then at end of list
      // go to beginning
  		if (guy == NULL) {
      	guy = G_Find(guy,FOFS(classname),"player");
      }
   }
   ent->client->pers.selection = guy;
}

void change_selection_prev(edict_t *ent) {
	edict_t *guy;
   edict_t *prev;
	edict_t *temp;


   ent->client->pers.sort = SORT_ID;

	if (ent->client->pers.selection == NULL) {
   	prev = ent;
   }
   else {
   	// find the selection
		if (!validate_selection(ent,&guy)) {
      	ent->client->pers.selection = ent;
         guy = ent;
      }
      // now get the prev guy
		prev = NULL;
      temp = NULL;
		temp = G_Find(temp,FOFS(classname),"player");
		while (temp != guy) {
      	prev = temp;
         temp = G_Find(temp,FOFS(classname),"player");
		}
      // if start of list
      // find end of list
      if (prev == NULL) {
      	temp = NULL;
			temp = G_Find(temp,FOFS(classname),"player");
			while (temp != NULL) {
   	   	prev = temp;
      	   temp = G_Find(temp,FOFS(classname),"player");
			}
      }
   }
   ent->client->pers.selection = prev;
}

qboolean TP_ClientCommand (char * cmd,edict_t * ent) 
{

	// allow sorting of dm scoreboard in deathmatch or teamplay

	if (Q_stricmp (cmd, "sort") == 0) {
   		rotate_sort_setting(ent);
   		return true;
	}

   if (!TP_teamplay_set()) return false;

   if (ent->client->resp.spectator) return false;

   if (Q_stricmp (cmd, "join") == 0) {
   	join_team(ent);
   }
   else 	if (Q_stricmp (cmd, "changeteam") == 0) {
   	join_team(ent);
   }
   else 	if (Q_stricmp (cmd, "team") == 0) {
   	join_team(ent);
   }
 	else if (Q_stricmp (cmd, "invite") == 0) {
   	invite_to_team(cmd,ent);
   }
   else 	if (Q_stricmp (cmd, "boot") == 0) {
   	kick_from_team(cmd,ent);
   }
   else 	if (Q_stricmp (cmd, "op") == 0) {
   	op_teammate(ent);
   }
   else if  (Q_stricmp (cmd, "select") == 0) {
   	change_selection(ent);
   }
   else if  (Q_stricmp (cmd, "selnext") == 0) {
   	change_selection(ent);
   }
   else if  (Q_stricmp (cmd, "selprev") == 0) {
   	change_selection_prev(ent);
   }
   else if ((ent->client->showscores) &&
            (Q_stricmp (cmd, "invnext") == 0)) {
   	change_selection(ent);
   }
   else if ((ent->client->showscores) &&
            (Q_stricmp (cmd, "invprev") == 0)) {
   	change_selection_prev(ent);
   }
   else if ((ent->client->showscores) &&
            (Q_stricmp (cmd, "invuse") == 0)) {
   	invite_to_team(cmd,ent);
   }
   else {
   	return false;
   }
   return true;
}

void TP_print_player_plack(int x, int y, edict_t * guy, char * string) {
	if (!TP_teamplay_set()) { // use when not teamplay
			Com_sprintf (string, 64,
				"xv %i yv %i picn dmscore ",x, y);
			return;
	}
	if (guy->client->pers.teamcolor == RED_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn redscore ",x, y);
   }
	else if (guy->client->pers.teamcolor == BLUE_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn bluscore ",x, y);
   }
	else if (guy->client->pers.teamcolor == BROWN_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn broscore ",x, y);
   }
	else if (guy->client->pers.teamcolor == GREEN_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn grescore ",x, y);
   }
	else if (guy->client->pers.teamcolor == YELLOW_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn yelscore ",x, y);
   }
	else if (guy->client->pers.teamcolor == PURPLE_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn purscore ",x, y);
   }
	else if (guy->client->pers.teamcolor == ORANGE_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn orascore ",x, y);
   }
	else if (guy->client->pers.teamcolor == WHITE_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn whiscore ",x, y);
   }

};

void TP_print_selected_plack(int x, int y, edict_t * guy, char * string) {
	if (!TP_teamplay_set()) { // use when not teamplay
			Com_sprintf (string, 64,
				"xv %i yv %i picn dmsinv ",x, y);
			return;
	}
	if (guy->client->pers.teamcolor == RED_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn redsinv ",x, y);
   }
	else if (guy->client->pers.teamcolor == BLUE_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn blusinv ",x, y);
   }
	else if (guy->client->pers.teamcolor == BROWN_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn brosinv ",x, y);
   }
	else if (guy->client->pers.teamcolor == GREEN_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn gresinv ",x, y);
   }
	else if (guy->client->pers.teamcolor == YELLOW_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn yelsinv ",x, y);
   }
	else if (guy->client->pers.teamcolor == PURPLE_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn pursinv ",x, y);
   }
	else if (guy->client->pers.teamcolor == ORANGE_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn orasinv ",x, y);
   }
	else if (guy->client->pers.teamcolor == WHITE_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn whisinv ",x, y);
   }

};

void TP_print_heading_plack(int x, int y, edict_t * guy, char * string) {
	if (guy->client->pers.sort == SORT_TEAM) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn teamhead ",x, y);
   }
	else if (guy->client->pers.sort == SORT_NAME) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn namehead ",x, y);
   }
	else if (guy->client->pers.sort == SORT_ID) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn idhead ",x, y);
   }
	else if (guy->client->pers.sort == SORT_HEADS) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn headhead ",x, y);
   }
	else if (guy->client->pers.sort == SORT_PING) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn pinghead ",x, y);
   }
	else if (guy->client->pers.sort == SORT_TIME) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn timehead ",x, y);
   }
	else if (guy->client->pers.sort == SORT_SCORE) {
			Com_sprintf (string, 64,
				"xv %i yv %i picn scorhead ",x, y);
   }
};

void TP_print_headings(int x, int y, char * string) {
	char entry[128];

		Com_sprintf (entry, sizeof(entry),
			" %-4s %-15s %-2s %-4s %-4s %-4s",
         "Frag",
			"Player Name",
         "Id",
         "Head",
         "Ping",
			"Time");
   	entry[63] = 0;
		Com_sprintf (string, 128,
			"xv %i yv %i string2 \"%s\" ",
         x,y,entry);
};



void TP_print_player_data(int x, int y, edict_t * guy, char * string) {
	char entry[128];
   edict_t *cl_ent;
   int i;
  	int client_id = 0;
   int ping;
   int heads;

   for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;
      if (cl_ent == guy) {
      	client_id = i;
      	break;
      }
  	}

   ping = guy->client->ping;
   if (ping > 999) ping = 999;
   heads = HH_calc_score(guy);

	Com_sprintf (entry, sizeof(entry),
			" %-4i %-15s %-2i %-4i %-4i %-4i",
         guy->client->resp.score,
			guy->client->pers.netname,
         client_id,
         heads,
         ping,
			(level.framenum - guy->client->resp.enterframe)/600);
  	entry[63] = 0;
	Com_sprintf (string, 128,
			"xv %i yv %i string \"%s\" ",
         x,y,entry);
};


void print_help_plack(int x, int y, char * string) {

			Com_sprintf (string, 64,
				"xv %i yv %i picn level ",x, y);
};

void print_help_data(int x, int y, char * string,edict_t *ent) {
	char entry[128];

		Com_sprintf (entry, sizeof(entry),
      " %-32s ",
      get_team_help_message(ent));
		Com_sprintf (string, 128,
				"xv %i yv %i string2 \"%s\" ",
         	x,y,entry);

}


void TP_DeathmatchScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	string[1400];
	int		stringlength;
	edict_t *guy;
	edict_t *cl_ent;
	int		i, j, k;
	int		x, y;
	int play[256];
	int temp;
	int selection,first,last,half;

	// client connected during intermission
	// into voting - do not show scorebaord to prevent
	// "netchan: dumped unreliable message"
	if (voting->value && voting_started)
		return;

   if (headthieves->value) {
		HHCTF_DeathmatchScoreboardMessage(ent,killer);
      return;
   }

   if (ent->client->pers.sort == SORT_STAND) {
		DeathmatchScoreboardMessage(ent,killer);
      return;
   }

  	// print level name and exit rules
	string[0] = 0;
	stringlength = strlen(string);

   // print out the deathmatch scoreboard headings
   x = 0;
  	y = 8;
	TP_print_heading_plack(x,y,ent,string);
   stringlength = strlen(string);
	TP_print_headings(x,y+1,&string[stringlength]);
   stringlength = strlen(string);
	j =0;
   for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse || game.clients[i].resp.spectator)
			continue;
		play[j] = i;
		j++;
  	}

	if (ent->client->pers.sort == SORT_TEAM) {
		for (i=0;i<j;i++) {
      	for (k=i+1; k<j; k++) {
				cl_ent = g_edicts + 1 + play[i];
            guy = g_edicts + 1 + play[k];
            if (cl_ent->client->pers.teamcolor > guy->client->pers.teamcolor) {
            	temp = play[i];
               play[i] = play[k];
               play[k] = temp;
            }
         }
      }
   }
   else if (ent->client->pers.sort == SORT_SCORE) {
   	for (i=0;i<j;i++) {
      	for (k=i+1; k<j; k++) {
				cl_ent = g_edicts + 1 + play[i];
            guy = g_edicts + 1 + play[k];
            if (cl_ent->client->resp.score < guy->client->resp.score) {
            	temp = play[i];
               play[i] = play[k];
               play[k] = temp;
            }
         }
      }
   }
   else if (ent->client->pers.sort == SORT_ID) {
   }
   else if (ent->client->pers.sort == SORT_PING) {
		for (i=0;i<j;i++) {
      	for (k=i+1; k<j; k++) {
				cl_ent = g_edicts + 1 + play[i];
            guy = g_edicts + 1 + play[k];
            if (cl_ent->client->ping > guy->client->ping) {
            	temp = play[i];
               play[i] = play[k];
               play[k] = temp;
            }
         }
      }
   }
   else if (ent->client->pers.sort == SORT_TIME) {
		for (i=0;i<j;i++) {
      	for (k=i+1; k<j; k++) {
				cl_ent = g_edicts + 1 + play[i];
            guy = g_edicts + 1 + play[k];
            if (cl_ent->client->resp.enterframe < guy->client->resp.enterframe) {
            	temp = play[i];
               play[i] = play[k];
               play[k] = temp;
            }
         }
      }
   }
   else if (ent->client->pers.sort == SORT_HEADS) {
		for (i=0;i<j;i++) {
      	for (k=i+1; k<j; k++) {
				cl_ent = g_edicts + 1 + play[i];
            guy = g_edicts + 1 + play[k];
            if (cl_ent->client->hidden_heads < guy->client->hidden_heads) {
            	temp = play[i];
               play[i] = play[k];
               play[k] = temp;
            }
         }
      }
   }
	// determine which player in list is the selected player if any.
   // FIXME - add code to change start of display based on selected player
   // when sort by id.
   if (ent->client->pers.sort == SORT_ID) {
		selection = 0;
      for (i=0; i<j; i++) {
      	guy = g_edicts + 1 + play[i];
      	if (guy == ent->client->pers.selection) {
				selection = i;
            break;
         }
      }
		half = MAX_DISPLAY / 2;
   	if (j <= MAX_DISPLAY) {
   		first = 0;
      	last = j;
   	}
   	else {
   		if (selection <= half) {
      		first = 0;
	         last = MAX_DISPLAY;
   	   }
      	else if (selection >= (j - half)) {
      		first = j - MAX_DISPLAY;
	         last = j;
   	   }
      	else {
      		first = selection - half;
	         last = first + MAX_DISPLAY;
   	   }
   	}
   }
   else {
   	first = 0;
      last = j;
		if (last > MAX_DISPLAY) last = MAX_DISPLAY;
   }
	for (i=first;i<last;i++) {
      guy = g_edicts + 1 + play[i];
      y += 10;
		if (guy != ent->client->pers.selection) {
			TP_print_player_plack(x,y,guy,&string[stringlength]);
		}
		else {
			TP_print_selected_plack(x,y,guy,&string[stringlength]);
		}
  	   stringlength = strlen(string);
		TP_print_player_data(x,y+1,guy,&string[stringlength]);
      stringlength = strlen(string);
	}
   y += 10;
	print_help_plack(x,y,&string[stringlength]);
   stringlength = strlen(string);
	print_help_data(x,y+1,&string[stringlength],ent);
   stringlength = strlen(string);

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

void TP_periodic(edict_t *ent) {
	// reset recruiting team if timeout
   if (level.time > ent->client->recruiting_period_over) {
   	ent->client->recruiting_period_over = 0;
      ent->client->recruiting_team = NO_TEAM;
		clear_recruit_icon(ent);
   }
}



