// HeadHunters v2.55
// http://www.planetquake.com/headhunters
// original baseq2/ctf code by id software 
// original hh code (v2.00) by Charlie Zimmerman
// modified code (v2.5x) by Avi "Zung!" Rozen
// 
// hh_levsel.c	- level selection routines

#include "hh_shared.h"

edict_t * HH_level_select (void) 
{
	qboolean found;
	int i;

	found = false;
	if (number_of_levels > 0) 
	{
		// Try to find the current level
		for (i=0; i<number_of_levels; i++) 
		{
			if (Q_stricmp(level.mapname,level_list[i].level_name) == 0) 
			{
				found = true;
				break;
			}
		}
		// If the level is found then pick the next one.
		if (found) 
		{
			i = i + 1;
			if (i>=number_of_levels) 
				i = 0;
		}
		else // pick the first one
			i = 0;
		return CreateTargetChangeLevel (level_list[i].level_name);
	}
	else // No levels loaded
		return NULL;
}
