// HeadHunters v2.55
// http://www.planetquake.com/headhunters
// original baseq2/ctf code by id software 
// original hh code (v2.00) by Charlie Zimmerman
// modified code (v2.5x) by Avi "Zung!" Rozen
// 
// hh_head.c	- head routines

#include "hh_shared.h"


void head_rot (edict_t *self) 
{
	gi.setmodel (self, "models/objects/gibs/sm_meat/tris.md2");
	self->touch = NULL;
	self->nextthink = level.time + 2;
	self->think = G_FreeEdict;
	self->s.skinnum = 0;
	VectorSet(self->velocity, 0, 0, 15);
	if (self->history) 
	{
   		free_history(self->history);
		self->history = NULL;
	}
	gi.linkentity (self);
}


void restore_to_altar (edict_t * self) 
{
    head_rot(self);
}


void head_allow_thrower_catch (edict_t *self) 
{
	self->nextthink = level.time + 30;
	self->think = head_rot;
	self->thrower = 0;
	gi.linkentity (self);
}


void head_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	float volume;

	if (other == ent->thrower) 
	   	return;
	if (other == ent) 
   		return;

	if (!other->takedamage)
		if (VectorLength(ent->velocity) > 200)
		{
			volume = VectorLength(ent->velocity) / 500;
			if (volume > 1) 
				volume = 1;
			switch (rand() % 4) 
			{
			case 0:
				gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/head/splat1.wav"), volume, ATTN_NORM, 0);
				break;
   			case 1:
				gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/head/splat2.wav"), volume, ATTN_NORM, 0);
				break;
   			case 2:
				gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/head/splat3.wav"), volume, ATTN_NORM, 0);
				break;
   			case 3:
				gi.sound(ent, CHAN_VOICE, gi.soundindex("hh/head/splat4.wav"), volume, ATTN_NORM, 0);
				break;
			}
		}

	if (!strcmp(other->classname,"player"))
	{
		// this is a player touching me.  Let him pick me up
		// by adding me to the players list of heads and by making
		// me not solid.
		if (other->deadflag != DEAD_DEAD && !other->client->resp.spectator) 
		{
			//Check teamplay
			if (TP_teamplay_set()) 
			{
         		// Check if teammate
         		if (headthieves->value == 1) 
				{
					if (ent->from_altar != NULL) 
					{
                  		if (ent->from_altar->ofteam == other->client->pers.teamcolor) 
						{
                       		return;
							//restore_to_altar(ent);
                  		}
						else 
						{
							// Moved decrement of stored heads here
							ent->from_altar->stored_heads -= (other->client->hidden_heads + 1);
							if (ent->from_altar->stored_heads < 0) 
                        		ent->from_altar->stored_heads = 0;
							pickup_head(other,ent);
						}
					}
					else 
						pickup_head(other,ent);
         		}
         		else if (other->client->pers.teamcolor == ent->ofteam) 
				{
               		//rot the head instead of picking up
            	  	head_rot(ent);
				}
                else 
					pickup_head(other,ent);
			}
			else 
				pickup_head(other,ent);
		}
	}
}

edict_t * make_head(vec3_t origin, vec3_t vel, int value, int bloody, int ofteam) 
{
	edict_t * head;
	char * gibname;
	int randval;

	head = G_Spawn();

	head->takedamage = DAMAGE_NO;
	head->solid = SOLID_TRIGGER;
	head->s.effects = EF_GIB;
	head->s.sound = 0;
	head->flags |= FL_NO_KNOCKBACK;
	head->movetype = MOVETYPE_BOUNCE;
	head->value = value;

	// set sizes velocity
	VectorCopy (origin, head->s.origin);
	VectorSet (head->mins, -16, -16, 0);
	VectorSet (head->maxs, 16, 16, 16);
	VectorCopy (vel, head->velocity);

	head->s.frame = 0;
	// set the model
	if (value == 3) 
	{
   		gibname = "models/heads/3head/tris.md2";
		head->s.skinnum = 0;
	}
	else if (value == 2) 
	{
		gibname = "models/heads/2head/tris.md2";
		head->s.skinnum = 0;
	}
	else 
	{
   		randval = rand()%12;
		if (bloody) 
			randval = 99;
		if (rand() % 2) 
		{
      		gibname = "models/heads/rhead/tris.md2";
		}
		else 
		{
			gibname = "models/heads/chead/tris.md2";
		}
		if (randval == 1) 
		{
			head->s.skinnum = 0;		// second skin is player
		}
		else if (randval == 2) 
		{
			head->s.skinnum = 1;		// second skin is player
		}
		else if (randval == 3) 
		{
			head->s.skinnum = 2;		// second skin is player
		}
		else if (randval == 4) 
		{
			head->s.skinnum = 3;		// second skin is player
		}
		else if (randval == 5) 
		{
			head->s.skinnum = 4;		// second skin is player
		}
		else if (randval == 6) 
		{
			head->s.skinnum = 5;		// second skin is player
		}
		else 
		{
	   		if (rand()&1)
			{
				gibname = "models/objects/gibs/head2/tris.md2";
				head->s.skinnum = 1;		// second skin is player
			}
			else
			{
				gibname = "models/objects/gibs/skull/tris.md2";
				head->s.skinnum = 0;
			}
		}
	}
	gi.setmodel (head, gibname);

	head->touch = head_touch;
	head->nextthink = level.time + 0.5;
	head->think = head_allow_thrower_catch;
	head->dmg = 0;
	head->classname = "head";
	head->thrower = 0;  // THIS can be set after return to make head
						// untouchable by a player for a little bit.
						// Typically the thrower of the head should not
						// be able to retouch to allow it to clear the bounding
						// box of his body before touched.  Avoid recatches.
	if (TP_teamplay_set()) 
	{
		// When teamplay take the ofteam and give it to the head
		// When touched that head will rot instead of being picked up if
		// touched by a teammate
		head->history = alloc_history();
		head->ofteam = ofteam;
	}
	else 
	{
		head->ofteam = NO_TEAM;
	}
	head->from_altar = NULL;
	return (head);
}


void random_throw_head(edict_t * head,vec3_t origin,int power) 
{
	power = abs(power);
	VectorCopy (origin, head->s.origin);
	VectorSet (head->velocity,(random()-0.5)*power*25,(random()-0.5)*power*25,(random()+0.01)*power*12.5);
}


void make_head_touchable(edict_t * head) 
{
	head->solid = SOLID_TRIGGER;
	head->movetype = MOVETYPE_BOUNCE;
	head->touch = head_touch;
	head->nextthink = level.time + 45;
	head->think = head_rot;
}


void make_head_untouchable(edict_t * head) 
{
	head->solid = SOLID_NOT;
	head->movetype = MOVETYPE_NOCLIP;
	head->touch = NULL;
	head->nextthink = -1;
	head->think = NULL;
	VectorSet(head->velocity,0,0,0);
}


void head_remove(edict_t *head) 
{
	if (head->history) 
	{
       free_history(head->history);
       head->history = NULL;
    }
	G_FreeEdict(head);
}

