// HeadHunters v2.55
// http://www.planetquake.com/headhunters
// original baseq2/ctf code by id software 
// original hh code (v2.00) by Charlie Zimmerman
// modified code (v2.5x) by Avi "Zung!" Rozen
// 
// hh_edit.c	- edit altars

#include "hh_shared.h"

extern char current_mapname[MAX_STRING_CHARS];
extern char original_entstring[MAX_MAP_ENTSTRING];
extern qboolean altar_red_found;
extern qboolean altar_blue_found;
extern vec3_t altar_red_pos;
extern vec3_t altar_blue_pos;
extern int hh_altars;

edict_t *current_altar = NULL;


char *altar_append (char *save_entstring, char *entstring)
{
	edict_t *altar;
	char entry[MAX_STRING_CHARS];

	altar = G_Find (NULL, FOFS(classname), "altar");
	strcpy (save_entstring, entstring);
	if (altar || altar_red_found || altar_blue_found)
	{
		if (altar_red_found)
		{
			sprintf (entry, 
				"\n{\n\"classname\" \"info_altar_red\"\n\"origin\" \"%i %i %i\"\n}",
				(int) altar_red_pos[0],
				(int) altar_red_pos[1],
				(int) altar_red_pos[2]);
			if (strlen (save_entstring) + strlen(entry) < MAX_MAP_ENTSTRING)
				strcat (save_entstring, entry);
			else
				return save_entstring;
		}
		if (altar_blue_found)
		{
			sprintf (entry, 
				"\n{\n\"classname\" \"info_altar_blue\"\n\"origin\" \"%i %i %i\"\n}",
				(int) altar_blue_pos[0],
				(int) altar_blue_pos[1],
				(int) altar_blue_pos[2]);
			if (strlen (save_entstring) + strlen(entry) < MAX_MAP_ENTSTRING)
				strcat (save_entstring, entry);
			else
				return save_entstring;
		}
		while (altar)
		{
			sprintf (entry, 
				"\n{\n\"classname\" \"info_altar\"\n\"origin\" \"%i %i %i\"\n}",
				(int) altar->s.origin[0],
				(int) altar->s.origin[1],
				(int) altar->s.origin[2]);
			if (strlen (save_entstring) + strlen(entry) < MAX_MAP_ENTSTRING)
				strcat (save_entstring, entry);
			else
				return save_entstring;
			altar = G_Find (altar, FOFS(classname), "altar");
		}
	}
	return save_entstring;
}

void EditAltar_Save_f (edict_t *ent)
{
	if (original_entstring)
	{
		FILE *entfile;
		char path[MAX_OSPATH];
		char save_entstring[MAX_MAP_ENTSTRING];
		cvar_t	*game;

		game = gi.cvar("game", "", 0);

		// create the file
		// assume that ents folder already exists
		sprintf (path, 
				 "%s/%s/ents/%s.ent", 
				 basedir->string, 
				 (strlen (game->string))? game->string:"baseq2",
				 current_mapname);
		entfile = fopen (path, "wb");
		if (entfile == NULL)
		{
			gi.dprintf ("can't open \"%s\"\n", path);
			return;
		}
		altar_append (save_entstring, original_entstring);
		if (fwrite (save_entstring, strlen (save_entstring), 1, entfile) != 1)
			gi.dprintf ("can't write to \"%s\"\n", path);
		else
			gi.dprintf ("ents saved to \"%s\"\n", path);
		fclose (entfile);
	}
	else
		gi.dprintf ("%s is not a map\n", current_mapname);
}


void altar_remove (edict_t *altar)
{
	edict_t *blood;

	blood = G_Find (NULL, FOFS(classname), "altarblood");
	while (blood && blood->owner != altar)
		blood = G_Find (blood, FOFS(classname), "altarblood");
	if (blood && blood->owner == altar)
		G_FreeEdict (blood);
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (altar-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (altar->s.origin, MULTICAST_PVS);
	G_FreeEdict (altar);
}

void EditAltar_Clear_f (edict_t *ent)
{
	edict_t *altar;

	current_altar = NULL;
	altar = G_Find (NULL, FOFS(classname), "altar");
	while (altar)
	{
		altar_remove (altar);
		altar = G_Find (altar, FOFS(classname), "altar");
	}
	hh_altars = 0;
	gi.dprintf ("all dm altars removed\n");
}


void SP_info_altar (edict_t *ent);

void EditAltar_Add_f (edict_t *ent)
{
	edict_t *altar;

	altar = G_Spawn ();
	VectorCopy (ent->s.origin, altar->s.origin);
	SP_info_altar (altar);
	current_altar = altar;
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGIN);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
}


void EditAltar_Remove_f (edict_t *ent)
{
	edict_t *altar;
	edict_t *altar_next;

	if (!current_altar)
	{
		gi.dprintf ("no altar selected\n");
		return;
	}
	
	altar = G_Find (NULL, FOFS(classname), "altar");
	altar_next = G_Find (current_altar, FOFS(classname), "altar");
	if (!altar_next)
		altar_next = altar;
	if (altar_next == current_altar)
		altar_next = NULL;
	altar_remove (current_altar);
	current_altar = altar_next;
	hh_altars--;
	gi.dprintf ("current altar removed\n");
}


void EditAltar_List_f (edict_t *ent)
{
	int i = 0;
	edict_t *altar;

	altar = G_Find (NULL, FOFS(classname), "altar");
	if (!altar)
	{
		gi.dprintf ("dm altars not defined\n");
		return;
	}
	while (altar)
	{
		i++;
		gi.dprintf ("altar #%d: %s", i, vtos (altar->s.origin));
		if (current_altar && altar == current_altar)
			gi.dprintf (" (current)");
		gi.dprintf ("\n");
		altar = G_Find (altar, FOFS(classname), "altar");
	}
}


void EditAltar_Next_f (edict_t *ent)
{
	edict_t *altar;
	edict_t *altar_next;
	vec3_t pos;

	altar = G_Find (NULL, FOFS(classname), "altar");
	if (!altar)
	{
		gi.dprintf ("dm altars not defined\n");
		return;
	}
	altar_next = G_Find (current_altar, FOFS(classname), "altar");
	if (altar_next)
		current_altar = altar_next;
	else
		current_altar = altar;

	CTFPlayerResetGrapple (ent);

	// unlink to make sure it can't possibly interfere with KillBox
	gi.unlinkentity (ent);

	VectorCopy (ent->s.origin, pos);
	VectorCopy (current_altar->s.origin, ent->s.origin);
	VectorCopy (current_altar->s.origin, ent->s.old_origin);
	ent->s.origin[2] += 10;

	// clear the velocity and hold them in place briefly
	VectorClear (ent->velocity);
	ent->client->ps.pmove.pm_time = 160>>3;		// hold time
	ent->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;

	ent->s.event = EV_PLAYER_TELEPORT;

	// kill anything at the destination
	KillBox (ent);

	gi.linkentity (ent);
}


void Cmd_Altar_f (edict_t *ent)
{
	char	*cmd;

	if (dedicated->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "can't edit altars on dedicated server\n");
		return;
	}

	if ((ent-g_edicts)-1 != 0 || sv_cheats->value == 0)
	{
		gi.cprintf (ent, PRINT_HIGH, "you can't edit altars!\n");
		return;
	}

	if (headthieves->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "can't edit: set hhctf to 0 first\n");
		return;
	}

	if (gi.argc() < 2)
	{
		gi.dprintf ("Usage: altar <action>\n");
		return;
	}
	cmd = gi.argv(1);
	if (Q_stricmp (cmd, "save") == 0)
		EditAltar_Save_f (ent);
	else if (Q_stricmp (cmd, "clear") == 0)
		EditAltar_Clear_f (ent);
	else if (Q_stricmp (cmd, "add") == 0)
		EditAltar_Add_f (ent);
	else if (Q_stricmp (cmd, "remove") == 0)
		EditAltar_Remove_f (ent);
	else if (Q_stricmp (cmd, "list") == 0)
		EditAltar_List_f (ent);
	else if (Q_stricmp (cmd, "next") == 0)
		EditAltar_Next_f (ent);
	else 
		gi.dprintf ("unknown action - \"%s\"\n", cmd);
}

