// HeadHunters v2.55
// http://www.planetquake.com/headhunters
// original baseq2/ctf code by id software 
// original hh code (v2.00) by Charlie Zimmerman
// modified code (v2.5x) by Avi "Zung!" Rozen
// 
// hh_deathmsg.c	- death messages

#include "hh_shared.h"

int num_death_messages[50];
char death_index[50][32];
char death_message[50][MESSAGES_PER_DEATH][MAX_DEATHMSG_STRING];


void init_death_messages (void) 
{
	num_death_messages[0]=1;
	strcpy(death_index[0],"MOD_SUICIDE");
	strcpy(death_message[0][0],"suicides");

	num_death_messages[1]=1;
	strcpy(death_index[1],"MOD_FALLING");
	strcpy(death_message[1][0],"cratered");

	num_death_messages[2]=1;
	strcpy(death_index[2],"MOD_CRUSH");
	strcpy(death_message[2][0],"was squished");

	num_death_messages[3]=1;
	strcpy(death_index[3],"MOD_WATER");
	strcpy(death_message[3][0],"sank like a rock");

	num_death_messages[4]=1;
	strcpy(death_index[4],"MOD_SLIME");
	strcpy(death_message[4][0],"melted");

	num_death_messages[5]=1;
	strcpy(death_index[5],"MOD_LAVA");
	strcpy(death_message[5][0],"does a back flip into the lava");

	num_death_messages[6]=1;
	strcpy(death_index[6],"MOD_EXPLOSIVE");
	strcpy(death_message[6][0],"blew up");

	num_death_messages[7]=1;
	strcpy(death_index[7],"MOD_BARREL");
	strcpy(death_message[7][0],"blew up");

	num_death_messages[8]=1;
	strcpy(death_index[8],"MOD_EXPLOSIVE");
	strcpy(death_message[8][0],"blew up");

	num_death_messages[9]=1;
	strcpy(death_index[9],"MOD_EXIT");
	strcpy(death_message[9][0],"found a way out");

	num_death_messages[10]=1;
	strcpy(death_index[10],"MOD_TARGET_LASER");
	strcpy(death_message[10][0],"saw the light");

	num_death_messages[11]=1;
	strcpy(death_index[11],"MOD_TARGET_BLASTER");
	strcpy(death_message[11][0],"got blasted");

	num_death_messages[12]=1;
	strcpy(death_index[12],"MOD_BOMB");
	strcpy(death_message[12][0],"was in the wrong place");

	num_death_messages[13]=1;
	strcpy(death_index[13],"MOD_SPLASH");
	strcpy(death_message[13][0],"was in the wrong place");

	num_death_messages[14]=1;
	strcpy(death_index[14],"MOD_TRIGGER_HURT");
	strcpy(death_message[14][0],"was in the wrong place");

	num_death_messages[15]=1;
	strcpy(death_index[15],"MOD_HELD_GRENADE/SELF");
	strcpy(death_message[15][0],"tried to put the pin back in");

	num_death_messages[16]=1;
	strcpy(death_index[16],"MOD_HG_SPLASH/SELF");
	strcpy(death_message[16][0],"tripped over a grenade");

	num_death_messages[17]=1;
	strcpy(death_index[17],"MOD_G_SPLASH/SELF");
	strcpy(death_message[17][0],"tripped over a grenade");

	num_death_messages[18]=1;
	strcpy(death_index[18],"MOD_R_SPLASH/SELF");
	strcpy(death_message[18][0],"blew up");

	num_death_messages[19]=1;
	strcpy(death_index[19],"MOD_G_SPLASH/SELF");
	strcpy(death_message[19][0],"tripped over a grenade");

	num_death_messages[20]=1;
	strcpy(death_index[20],"MOD_BFG_BLAST/SELF");
	strcpy(death_message[20][0],"should have used a smaller gun");

	num_death_messages[21]=1;
	strcpy(death_index[21],"MOD_BLASTER");
	strcpy(death_message[21][0],"was blasted by");

	num_death_messages[22]=1;
	strcpy(death_index[22],"MOD_SHOTGUN");
	strcpy(death_message[22][0],"was gunned down by");

	num_death_messages[23]=1;
	strcpy(death_index[23],"MOD_SSHOTGUN");
	strcpy(death_message[23][0],"was blown away by");

	num_death_messages[24]=1;
	strcpy(death_index[24],"MOD_MACHINEGUN");
	strcpy(death_message[24][0],"was machinegunned by");

	num_death_messages[25]=1;
	strcpy(death_index[25],"MOD_CHAINGUN");
	strcpy(death_message[25][0],"was cut in half by");

	num_death_messages[26]=1;
	strcpy(death_index[26],"MOD_GRENADE");
	strcpy(death_message[26][0],"was popped by");

	num_death_messages[27]=1;
	strcpy(death_index[27],"MOD_G_SPLASH");
	strcpy(death_message[27][0],"was shredded by");

	num_death_messages[28]=1;
	strcpy(death_index[28],"MOD_ROCKET");
	strcpy(death_message[28][0],"ate");

	num_death_messages[29]=1;
	strcpy(death_index[29],"MOD_R_SPLASH");
	strcpy(death_message[29][0],"almost dodged");

	num_death_messages[30]=1;
	strcpy(death_index[30],"MOD_HYPERBLASTER");
	strcpy(death_message[30][0],"was melted by");

	num_death_messages[31]=1;
	strcpy(death_index[31],"MOD_RAILGUN");
	strcpy(death_message[31][0],"was railed by");

	num_death_messages[32]=1;
	strcpy(death_index[32],"MOD_BFG_LASER");
	strcpy(death_message[32][0],"saw the pretty lights from");

	num_death_messages[33]=1;
	strcpy(death_index[33],"MOD_BFG_BLAST");
	strcpy(death_message[33][0],"was disintegrated by");

	num_death_messages[34]=1;
	strcpy(death_index[34],"MOD_BFG_EFFECT");
	strcpy(death_message[34][0],"couldn't hide from");

	num_death_messages[35]=1;
	strcpy(death_index[35],"MOD_HANDGRENADE");
	strcpy(death_message[35][0],"caught");

	num_death_messages[36]=1;
	strcpy(death_index[36],"MOD_HG_SPLASH");
	strcpy(death_message[36][0],"didn't see");

	num_death_messages[37]=1;
	strcpy(death_index[37],"MOD_HELD_GRENADE");
	strcpy(death_message[37][0],"feels");

	num_death_messages[38]=1;
	strcpy(death_index[38],"MOD_TELEFRAG");
	strcpy(death_message[38][0],"tried to invade");

	num_death_messages[39]=1;
	strcpy(death_index[39],"MOD_ALTAR");
	strcpy(death_message[39][0],"camped to death");

	num_death_messages[40]=1;
	strcpy(death_index[40],"MOD_GRAPPLE");
	strcpy(death_message[40][0],"was caught by");
}


char * get_message(char * index) 
{
	char * temp = " ";
	int i;
	int j;

	for (i=0;i<41;i++) 
	{
		if (!strcmp(death_index[i],index)) 
		{
			j = rand();
			j = j % num_death_messages[i];
			temp = death_message[i][j];
			break;
		}
	}
	return temp;
}


void DM_ClientObituary (edict_t *self, edict_t *inflictor, edict_t *attacker)
{
	int			mod;
	char		*message;
	char		*message2;
	qboolean	ff;

	if (coop->value && attacker->client)
		meansOfDeath |= MOD_FRIENDLY_FIRE;

	if (deathmatch->value || coop->value)
	{
		ff = meansOfDeath & MOD_FRIENDLY_FIRE;
		mod = meansOfDeath & ~MOD_FRIENDLY_FIRE;
		message = NULL;
		message2 = "";

		switch (mod)
		{
		case MOD_SUICIDE:
			message = get_message("MOD_SUICIDE");
			break;
		case MOD_FALLING:
			message = get_message("MOD_FALLING");
			break;
		case MOD_CRUSH:
			message = get_message("MOD_CRUSH");
			break;
		case MOD_WATER:
			message = get_message("MOD_WATER");
			break;
		case MOD_SLIME:
			message = get_message("MOD_SLIME");
			break;
		case MOD_LAVA:
			message = get_message("MOD_LAVA");
			break;
		case MOD_EXPLOSIVE:
			message = get_message("MOD_EXPLOSIVE");
			break;
		case MOD_BARREL:
			message = get_message("MOD_BARREL");
			break;
		case MOD_EXIT:
			message = get_message("MOD_EXIT");
			break;
		case MOD_TARGET_LASER:
			message = get_message("MOD_TARGET_LASER");
			break;
		case MOD_TARGET_BLASTER:
			message = get_message("MOD_TARGET_BLASTER");
			break;
		case MOD_BOMB:
			message = get_message("MOD_BOMB");
			break;
		case MOD_SPLASH:
			message = get_message("MOD_SPLASH");
			break;
		case MOD_TRIGGER_HURT:
			message = get_message("MOD_TRIGGER_HURT");
			break;
		case MOD_ALTAR:
			message = get_message("MOD_ALTAR");
			break;
		}
		if (attacker == self)
		{
			switch (mod)
			{
			case MOD_HELD_GRENADE:
				message = get_message("MOD_HELD_GRENADE/SELF");
				break;
			case MOD_HG_SPLASH:
				message = get_message("MOD_HG_SPLASH/SELF");
				break;
			case MOD_G_SPLASH:
				message = get_message("MOD_G_SPLASH/SELF");
				break;
			case MOD_R_SPLASH:
				message = get_message("MOD_R_SPLASH/SELF");
				break;
			case MOD_BFG_BLAST:
				message = get_message("MOD_BFG_BLAST/SELF");
				break;
			default:
				if (IsFemale(self))
					message = "killed herself";
				else
					message = "killed himself";
				break;
			}
		}
		if (message)
		{
			gi.bprintf (PRINT_MEDIUM, "%s %s.\n", self->client->pers.netname, message);
			if (deathmatch->value)
				self->client->resp.score--;
			self->enemy = NULL;
			return;
		}

		self->enemy = attacker;
		if (attacker && attacker->client)
		{
			switch (mod)
			{
			case MOD_BLASTER:
				message = get_message("MOD_BLASTER");
				break;
			case MOD_SHOTGUN:
				message = get_message("MOD_SHOTGUN");
				message2 = "'s shotgun";
				break;
			case MOD_SSHOTGUN:
				message = get_message("MOD_SSHOTGUN");
				message2 = "'s super shotgun";
				break;
			case MOD_MACHINEGUN:
				message = get_message("MOD_MACHINEGUN");
				break;
			case MOD_CHAINGUN:
				message = get_message("MOD_CHAINGUN");
				message2 = "'s chaingun";
				break;
			case MOD_GRENADE:
				message = get_message("MOD_GRENADE");
				message2 = "'s grenade";
				break;
			case MOD_G_SPLASH:
				message = get_message("MOD_G_SPLASH");
				message2 = "'s shrapnel";
				break;
			case MOD_ROCKET:
				message = get_message("MOD_ROCKET");
				message2 = "'s rocket";
				break;
			case MOD_R_SPLASH:
				message = get_message("MOD_R_SPLASH");
				message2 = "'s rocket";
				break;
			case MOD_HYPERBLASTER:
				message = get_message("MOD_HYPERBLASTER");
				message2 = "'s hyperblaster";
				break;
			case MOD_RAILGUN:
				message = get_message("MOD_RAILGUN");
				break;
			case MOD_BFG_LASER:
				message = get_message("MOD_BFG_LASER");
				message2 = "'s BFG";
				break;
			case MOD_BFG_BLAST:
				message = get_message("MOD_BFG_BLAST");
				message2 = "'s BFG blast";
				break;
			case MOD_BFG_EFFECT:
				message = get_message("MOD_BFG_EFFECT");
				message2 = "'s BFG";
				break;
			case MOD_HANDGRENADE:
				message = get_message("MOD_HANDGRENADE");
				message2 = "'s handgrenade";
				break;
			case MOD_HG_SPLASH:
				message = get_message("MOD_HG_SPLASH");
				message2 = "'s handgrenade";
				break;
			case MOD_HELD_GRENADE:
				message = get_message("MOD_HELD_GRENADE");
				message2 = "'s pain";
				break;
			case MOD_TELEFRAG:
				message = get_message("MOD_TELEFRAG");
				message2 = "'s personal space";
				break;
			case MOD_GRAPPLE:
				message = get_message("MOD_GRAPPLE");
				message2 = "'s grapple";
				break;
			}
			if (message)
			{
				gi.bprintf (PRINT_MEDIUM,"%s %s %s%s\n", self->client->pers.netname, message, attacker->client->pers.netname, message2);
				if (deathmatch->value)
				{
					if (ff)
						attacker->client->resp.score--;
					else
						if (frag_scoring->value)
							attacker->client->resp.score++;
				}
				return;
			}
		}
	}

	gi.bprintf (PRINT_MEDIUM,"%s died.\n", self->client->pers.netname);
	if (deathmatch->value)
		self->client->resp.score--;
}

