// HeadHunters v2.55
// http://www.planetquake.com/headhunters
// original baseq2/ctf code by id software 
// original hh code (v2.00) by Charlie Zimmerman
// modified code (v2.5x) by Avi "Zung!" Rozen
// 
// hh_altar.c	- altar related routines

#include "hh_shared.h"

int hh_altars = 0;
int hhctf_red_altars = 0;
int hhctf_blue_altars = 0;
qboolean altar_red_found = false;
qboolean altar_blue_found = false;
vec3_t altar_red_pos;
vec3_t altar_blue_pos;


void altar_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	int score = 0;
	int track;
	int phrase;

	if (strcmp (other->classname, "player") || other->client->resp.spectator)
		return;

   	if (TP_teamplay_set()) 
	{
      	if (headthieves->value == 1) 
		{
         	if (other->client->pers.teamcolor != ent->ofteam) 
				return;
			score = HH_deathmatch_score (other);
			ent->stored_heads += score;
		 }
		 else 
			score = HH_teampassing_score (other);
	}
	else 
      	score = HH_deathmatch_score (other);
	free_heads (other);
	if (score > 0) 
	{
		phrase = rand() % number_of_scoring_phrases;
		gi.bprintf(PRINT_HIGH, "%s %s\n", other->client->pers.netname, scoring_phrases[phrase]);
		// Finish with Some Fireworks
		ent->extra_strength = 10;
		if (!audience->value)
		{
			track = rand() % 6;
			switch (track)
			{
			case 1:
				gi.sound(ent, CHAN_ITEM, gi.soundindex("hh/altar/score1.wav"), 1, ATTN_NORM, 0);
				break;
			case 2:
				gi.sound(ent, CHAN_ITEM, gi.soundindex("hh/altar/score2.wav"), 1, ATTN_NORM, 0);
				break;
			case 3:
				gi.sound(ent, CHAN_ITEM, gi.soundindex("hh/altar/score3.wav"), 1, ATTN_NORM, 0);
				break;
			case 4:
				gi.sound(ent, CHAN_ITEM, gi.soundindex("hh/altar/score4.wav"), 1, ATTN_NORM, 0);
				break;
			case 5:
				gi.sound(ent, CHAN_ITEM, gi.soundindex("hh/altar/score5.wav"), 1, ATTN_NORM, 0);
				break;
			default:
				gi.sound(ent, CHAN_ITEM, gi.soundindex("hh/altar/score2.wav"), 1, ATTN_NORM, 0);
				break;
			}
		}
		else
		{
			if (score < 7)
				gi.sound(ent, CHAN_ITEM, gi.soundindex(va ("hh/audience/cheer1%d.wav", (rand() % 4) + 1)), 1, ATTN_NORM, 0);
			else if (score < 16)
				gi.sound(ent, CHAN_ITEM, gi.soundindex(va ("hh/audience/cheer2%d.wav", (rand() % 4) + 1)), 1, ATTN_NORM, 0);
			else if (score < 29)
				gi.sound(ent, CHAN_ITEM, gi.soundindex(va ("hh/audience/cheer3%d.wav", (rand() % 4) + 1)), 1, ATTN_NORM, 0);
			else
				gi.sound(ent, CHAN_ITEM, gi.soundindex(va ("hh/audience/cheer4%d.wav", (rand() % 4) + 1)), 1, ATTN_NORM, 0);
		}
	}
}


void found_camper (edict_t *altar, edict_t * guy, int how) 
{
	vec3_t dir;

	if (sv_cheats->value)
		return;

	VectorSet(dir, 0, 0, 100);
	if (guy->client->in_camp == false) 
	{
		guy->client->in_camp = true;
		guy->client->camping_altar = altar;
		guy->client->start_camping = level.time;
	}
	// hurt camper after a while
	if (guy->client->start_camping < (level.time - 15)) 
	{
		T_Damage (guy, altar, altar, dir, guy->s.origin, vec3_origin, 10, 0, DAMAGE_NO_PROTECTION, MOD_ALTAR);
		guy->client->start_camping++;
	}
}


void blood_think (edict_t * self) 
{
	self->s.skinnum++;
	if (self->s.skinnum == BLOOD_SKINS) 
    	self->s.skinnum = 0;

	// handle altar sounds
	// (handled here because altar thinks at random intervals)
	if (audience->value)
	{
		edict_t *altar = self->owner;

		if (altar->altar_precheer_time < level.time)
		{
			int heads = 0;
			edict_t *guy;

			altar->altar_precheer_time = 0;
			guy = G_Find (NULL, FOFS(classname), "player");
			while (guy)
			{
				vec3_t vDiff;

				VectorSubtract (guy->s.origin, altar->s.origin, vDiff);
				if (guy->deadflag == DEAD_NO &&
					!guy->client->resp.spectator &&
					guy->client->hidden_heads > heads &&
					VectorLength (vDiff) < 400 &&
					(!headthieves->value ||
					 (headthieves->value && guy->client->pers.teamcolor == altar->ofteam)))
					heads = guy->client->hidden_heads;
				guy = G_Find (guy, FOFS(classname), "player");
			}
			// precheer will always sound if cheats is set to 1 and
			// the player carries heads (used for debugging)
			if ((sv_cheats->value && heads) || heads > 3)
			{
				if (sv_cheats->value || (random () > (1 - ((heads - 3) * 0.1))))
				{
					gi.sound(altar, CHAN_AUTO, gi.soundindex ("hh/audience/precheer.wav"), 1, ATTN_NORM, 0);
					altar->altar_precheer_time = level.time + 3; // allow 3 seconds for sound
				}
			}
		}
	}

	gi.linkentity(self);
	self->nextthink = level.time + 0.2;
}


void altar_think (edict_t * self) 
{
	edict_t * head;
	char * gibname;
	edict_t * guy;
	vec3_t temp;
	vec3_t view_origin;
	vec3_t target_origin;
	trace_t trace;
	int proved_camp;
	int distance;

	// check for campers
	if (!headthieves->value)
	{
	   if (!level.intermissiontime) 
	   {
			guy = NULL;
			guy = G_Find (guy, FOFS(classname), "player");
			while (guy != NULL) 
			{
				if (guy->deadflag == DEAD_NO && !guy->client->resp.spectator) 
				{
					if (!((guy->client->in_camp) && (guy->client->camping_altar != self))) 
					{
						proved_camp = false;
						VectorCopy (self->s.origin, view_origin);
						VectorCopy (guy->s.origin, target_origin);
						target_origin[2] += 30;
						view_origin[2] += 30;
						VectorClear (temp);
						// Can I direct line see this bozo
						trace = gi.trace(view_origin, vec3_origin, vec3_origin, target_origin, self, MASK_SOLID);
						if (trace.fraction == 1) 
						{
							found_camper(self, guy, 1);
							proved_camp = true;
							VectorCopy(target_origin, guy->client->camp_lastseen);
						}
						if (!proved_camp) 
						{
							view_origin[2] += 1000;
							trace = gi.trace (self->s.origin, vec3_origin, vec3_origin, view_origin, self, MASK_SOLID);
							VectorCopy (trace.endpos, view_origin);
							trace = gi.trace (view_origin, vec3_origin, vec3_origin, target_origin, self, MASK_SOLID);
							if (trace.fraction == 1) 
							{
								found_camper(self,guy,2);
								proved_camp = true;
								VectorCopy(target_origin,guy->client->camp_lastseen);
							}
						}
						if (!proved_camp) 
						{
							if (guy->client->in_camp) 
							{
								// he was just recently camping.
								// he better have cleared out and not be standing near something
								VectorSubtract (self->s.origin, target_origin, temp);
								distance = VectorLength (temp);
								if (VectorLength(temp) < camp_radius->value) 
								{
									// the fuck is still around.  Camp him
									found_camper(self,guy,3);
									proved_camp = true;
								}
							}
						}
						if (!proved_camp) 
							guy->client->in_camp = false;
					}
				}
				guy = G_Find (guy, FOFS(classname), "player");
			} // end while
	   }
	}

	// spawn head
	if ((headthieves->value == 0) || ((random()*6) < 5)) 
	{
		head = G_Spawn();

		head->takedamage = DAMAGE_NO;
		head->solid = SOLID_TRIGGER;
		head->s.effects = EF_GIB;
		head->s.effects |= EF_BFG;
		head->s.sound = 0;
		head->flags |= FL_NO_KNOCKBACK;
		head->movetype = MOVETYPE_BOUNCE;
		// set the model
		if (rand() &1)
		{
			gibname = "models/objects/gibs/head2/tris.md2";
			head->s.skinnum = 1;		// second skin is player
		}
		else
		{
			gibname = "models/objects/gibs/skull/tris.md2";
			head->s.skinnum = 0;
		}
		head->s.frame = 0;
		gi.setmodel (head, gibname);

 		VectorSet (head->avelocity, random()*400-200, random()*400-200, random()*400-200);
		head->touch = NULL;
		head->nextthink = level.time + random() + 2;
		head->think = G_FreeEdict;
		head->dmg = 0;
		head->classname = "none";
	}
	else 
	{
   		if (self->stored_heads == 0) 
		{
      		self->nextthink = level.time + random();
			return;
		}
		head = make_head (self->s.origin, temp, 1, 0, self->ofteam);
		head->from_altar = self;
		head->nextthink = level.time + random() + 2;
		head->think = restore_to_altar;
	}

	// set sizes velocity
	VectorCopy (self->s.origin, head->s.origin);
	VectorSet (temp,random()*32-16,random()*32-16,0);
	VectorAdd (head->s.origin,temp,head->s.origin);
	VectorSet (head->mins, -16, -16, 0);
	VectorSet (head->maxs, 16, 16, 16);
	VectorSet (head->velocity,random()*64-32,random()*64-32,random()*200+300);
	if (self->extra_strength) 
	{
   		if (!(headthieves->value)) 
		{
			VectorSet (temp,random()*320-160,random()*320-160,random()*400+400);
   			VectorAdd(head->velocity,temp,head->velocity);
		}
		self->extra_strength --;
	}

	gi.linkentity(head);

	self->nextthink = level.time + random();
}


void altar_firstthink (edict_t * altar) 
{
	edict_t *blood;

	blood = G_Spawn();
	VectorCopy (altar->s.origin, blood->s.origin);
	blood->classname = "altarblood";
	blood->nextthink = level.time + .1;
	blood->think = blood_think;
	blood->touch = NULL;
	gi.setmodel (blood, "models/altarblood/tris.md2");
	blood->s.skinnum = 1;
	blood->solid = SOLID_NOT;
	blood->owner = altar;
	VectorSet (blood->mins, -32, -32, -24);
	VectorSet (blood->maxs, 32, 32, -16);
	VectorSet (blood->avelocity, 100, 0, 0);
	gi.linkentity (blood);
	altar->think = altar_think;
	altar->nextthink = level.time + .1;
}


void altar_create (edict_t *altar, int ofteam) 
{
  	altar->classname = "altar";
	altar->nextthink = level.time + 1;
	altar->think = altar_firstthink;
	altar->touch = altar_touch;
	gi.setmodel (altar, "models/altar/tris.md2");
	altar->s.skinnum = 0;
	altar->solid = SOLID_BBOX;
	altar->stored_heads = 0;
	altar->ofteam = ofteam;
	altar->altar_precheer_time = 0;
	VectorSet (altar->mins, -32, -32, -24);
	VectorSet (altar->maxs, 32, 32, -16);
	VectorSet (altar->avelocity, 100, 0, 0);
	gi.linkentity (altar);
}


void SP_info_altar (edict_t *ent) 
{
	if (headthieves->value)
		G_FreeEdict (ent);
	else
	{
		hh_altars++;
		altar_create (ent, NO_TEAM);
	}
}


void SP_info_altar_red (edict_t *ent) 
{
	altar_red_found = true;
	VectorCopy (ent->s.origin, altar_red_pos);

	if (headthieves->value) 
	{
		hhctf_red_altars++;
		altar_create (ent, RED_TEAM);
	}
	else 
		G_FreeEdict (ent);
}


void SP_info_altar_blue (edict_t *ent) 
{
	altar_blue_found = true;
	VectorCopy (ent->s.origin, altar_blue_pos);

	if (headthieves->value) 
	{
		hhctf_blue_altars++;
		altar_create (ent, BLUE_TEAM);
	}
	else 
		G_FreeEdict (ent);
}


void SP_item_flag_team1(edict_t *ent) 
{
	if (headthieves->value) 
	{
		hhctf_red_altars++;
		altar_create (ent, RED_TEAM);
	}
	else 
		G_FreeEdict (ent);
}


void SP_item_flag_team2(edict_t *ent) 
{
	if (headthieves->value) 
	{
		hhctf_blue_altars++;
		altar_create (ent, BLUE_TEAM);
	}
	else 
		G_FreeEdict (ent);
}


char current_mapname[MAX_STRING_CHARS];
char original_entstring[MAX_MAP_ENTSTRING];
char new_entstring[MAX_MAP_ENTSTRING];

char *HH_SpawnEntities (char *mapname, char *entstring)
{
	strcpy (current_mapname, mapname);
	memset (new_entstring, 0, MAX_MAP_ENTSTRING * sizeof (char));
	if (!strstr (mapname, ".")) // is this a map?
	{
		FILE *entfile;
		char path[MAX_OSPATH];
		cvar_t	*game;

		game = gi.cvar("game", "", 0);

		// save original entstring for later
		strncpy (original_entstring, entstring, MAX_MAP_ENTSTRING);

		// load modified entstring from file
		sprintf (path, 
				 "%s/%s/ents/%s.ent", 
				 basedir->string, 
				 (strlen (game->string))? game->string:"baseq2",
				 current_mapname);
		entfile = fopen (path, "rb");
		if (entfile != NULL)
		{
			gi.dprintf ("loading ents from \"%s\"\n",path);
			if (!fread (new_entstring, sizeof(char), MAX_MAP_ENTSTRING, entfile))
			{
				gi.dprintf ("can't read entities\n");
				new_entstring[0] = '\0';
			}
			fclose (entfile);
		}
	} 
	// return ent string
	if (new_entstring[0])
		return new_entstring;
	else
		return entstring;
}


void HH_replace_dmspot (void)
{
	int dmspot_count = 0;
	edict_t *dmspot;

	// we need to create altars randomly:
	// find a few dm spots and replace them with altars
	
	gi.dprintf ("HH: creating random altars\n");

	// count'em
	dmspot = G_Find (NULL, FOFS(classname), "info_player_deathmatch");
	while (dmspot)
	{
		dmspot_count++;
		dmspot = G_Find (dmspot, FOFS(classname), "info_player_deathmatch");
	}

	// make sure we have at least two dm spots
	if (dmspot_count > 1)
	{
		int altars = (dmspot_count < 6)? 1: ((dmspot_count / 6) + 1);

		gi.dprintf ("%d dm spots found\ncreating %d altars\n", dmspot_count, altars);
		for (; altars; altars--)
		{
			int select = rand () % dmspot_count;

			dmspot = G_Find (NULL, FOFS(classname), "info_player_deathmatch");
			while (dmspot)
			{
				if (select)
				{
					select--;
					dmspot = G_Find (dmspot, FOFS(classname), "info_player_deathmatch");
				}
				else
				{
					vec3_t dest;
					trace_t tr;

					// replace dm spot with altar
					hh_altars++;
					altar_create (dmspot, NO_TEAM);
					// make sure altar is not in solid
					VectorCopy (dmspot->s.origin, dest);
					dmspot->s.origin[2] += 17;
					tr = gi.trace (dmspot->s.origin, dmspot->mins, dmspot->maxs, dest, dmspot, MASK_SOLID);
					// if trace fails for some reason
					// make altar float, but not too high, so as to
					// allow players to climb over it like stairs
					if (tr.allsolid)
						dmspot->s.origin[2] -= 9;
					else
						VectorCopy (tr.endpos, dmspot->s.origin);
					gi.linkentity (dmspot);
					gi.dprintf ("altar created at %s\n", vtos (dmspot->s.origin));
					break;
				}
			}
			dmspot_count--;
		}
	}
	else
		gi.dprintf ("HH: warning! can't create altars on map\n");
}