// EntZ v1.01 - map entity replacement proxy game module for Quake II
// Copyright (c) 1998, by Avi Rozen (Zung!)
// e-mail: zungbang@telefragged.com

// entz_spawn.c	-- SpawnEntities

#include "entz.h"

char current_mapname[MAX_STRING_CHARS];
char *original_entstring = NULL;
char *new_entstring = NULL;


void SpawnEntities (char *mapname, char *entstring, char *spawnpoint)
{
	strcpy (current_mapname, mapname);
	if (original_entstring)
	{
		pmi.TagFree (original_entstring);
		original_entstring = NULL;
	}
	if (new_entstring)
	{
		pmi.TagFree (new_entstring);
		new_entstring = NULL;
	}
	if (!strstr (mapname, ".")) // is this a map?
	{
		FILE *entfile;
		char path[MAX_OSPATH];

		// save original entstring for later
		original_entstring = (char *) pmi.TagMalloc (strlen (entstring), TAG_GAME);
		if (original_entstring == NULL)
		{
			pmi.error ("SpawnEntities: can't allocate original_entstring.\n");
			return;
		}
		strcpy (original_entstring, entstring);
		// load modified entstring from file
		sprintf (path, 
				 "%s/%s/ents/%s.ent", 
				 basedir->string, 
				 (strlen (game->string))? game->string:"baseq2",
				 current_mapname);
		entfile = fopen (path, "rb");
		if (entfile != NULL)
		{
			pmi.dprintf ("loading ents from \"%s\"\n",path);
			if (!fseek (entfile, 0L, SEEK_END))
			{
				long entfile_length;

				entfile_length = ftell (entfile);
				if (entfile_length > 0)
				{
					new_entstring = (char *) pmi.TagMalloc (entfile_length + 1, TAG_GAME);
					if (new_entstring == NULL)
					{
						pmi.error ("SpawnEntities: can't allocate new_entstring.\n");
						return;
					}
					rewind (entfile);
					if (fread (new_entstring, entfile_length, 1, entfile) != 1)
					{
						pmi.TagFree (new_entstring);
						new_entstring = NULL;
						pmi.dprintf ("can't read entities\n");
					}
					else
						new_entstring[entfile_length] = '\0';
				}
				else
					pmi.dprintf ("can't determine file size\n");
			}
			else
				pmi.dprintf ("can't find EOF\n");
			fclose (entfile);
		}
	} 
	// call game export function
	if (new_entstring)
		ge.SpawnEntities (mapname, new_entstring, spawnpoint);
	else
		ge.SpawnEntities (mapname, entstring, spawnpoint);
}
