#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define MAX_STRING_CHARS 1024
#define MAX_INFO_VALUE 64

int main (int argc, char *argv[])
{
	char name[MAX_INFO_VALUE];
	int x, y, z, pitch, yaw, roll, fov;
	char line[MAX_STRING_CHARS];

	if (argc != 1)
	{
		fprintf (stderr, "Usage: dca2cam [< dcafile] [> camfile]\n");
		return EXIT_FAILURE;
	}
	while (fgets (line, MAX_STRING_CHARS, stdin))
	{
		int count;

		count = sscanf (line, " \"%[^\"]\" x=%d y=%d z=%d pitch=%d yaw=%d roll=%d fov=%d ", name, &x, &y, &z, &pitch, &yaw, &roll, &fov);
		if (count == 7)
			fov = 90;
		if (count == 7 || count == 8)
		{
			fprintf (stdout, "{\n"
							 "\"classname\" \"info_camera\"\n"
							 "\"name\" \"%s\"\n"
							 "\"origin\" \"%d %d %d\"\n"
							 "\"angles\" \"%d %d %d\"\n"
							 "\"fov\" \"%d\"\n"
							 "}\n",
							 name, x, y, z, pitch, yaw, roll, fov);
		}
	}
	return EXIT_SUCCESS;
}