
#ifndef _WAD3_H_
#define _WAD3_H_

// WAD3 (Half-Life) Header and mip structs

#define WAD3_TYPE_MIP	0x43
#define WAD3_ID			('W' | 'A' << 8 | 'D' << 16 | '3' << 24)

#define GET_MIP_DATA_SIZE(WIDTH, HEIGHT) (sizeof(WAD3MIP) + (WIDTH * HEIGHT) + (WIDTH * HEIGHT / 4) + (WIDTH * HEIGHT / 16) + (WIDTH * HEIGHT / 64))


////////////////////////////////////////////////////////////////////////////////
// WAD3 pseudo-structure:
/*

	WAD3 Header		
	Mip section
		First mip
			Mip header			
			First mip (width * height)
			Second mip (width * height / 4)
			Third mip (width * height / 16)
			Fourth mip (width * height / 64)
			Palette size (WORD)
			Palette (Palette size * 3)
			Padding (WORD)			
		[...]
		Last mip	
	Lump table
		First lump entry
			Lump header
		[...]
		Last lump entry
*/
////////////////////////////////////////////////////////////////////////////////

typedef struct
{
  unsigned long identification;
  unsigned long numlumps;
  unsigned long infotableofs;	      // Lump table
} WAD3HEAD;

typedef struct
{
  unsigned long filepos;
  unsigned long disksize;
  unsigned long size;		     // uncompressed
  char type;
  char compression;
  char pad1, pad2;
  char name[16];                     // must be null terminated
} WAD3LUMP;

typedef struct
{
  char name[16];
  unsigned long width, height;
  unsigned long offsets[4];	    // four mip maps stored
} WAD3MIP;

int EnumerateImages( char *FileName, char *OutputFolder);

#endif		// #ifndef _WAD3_H_

