//////////////////////////////////////////////////////////////////////////////////////////
//      The quick and dirty Linux port by of WAD3-to-PCX converter from Wally.
//
//      Author: Holger Kremss (holger_kremss@web.de)
//
//      01/20/2001
//
//      No restrictions. Do whatever you want with. Feel free to improve it.
//
//      I know nothing about Windows and not much more about C++ and thats why I deleted
//      all, what made no sense to me, converted the types in random order, drunk some
//      beer and learned much about WAD3. And that was the reason for this. Well, that
//      little piece of code is not nice. But it works! ;-)
//
//      NO WARRANTY - IN NO EVENT I AM LIABLE TO YOU FOR DAMAGES, INCLUDING ANY
//      GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE
//      OF THIS PROGRAM... No, No, No! Never! :-)
//
//      Now the original file header:

//////////////////////////////////////////////////////////////////////////////////////////
//
//	Wally dudes:  ty@wwa.com, neal_white_iii@hotmail.com
//
//	01/08/2001
//
//	Restrictions:  None... do whatever you want with this!
//
//	This is a basic WAD3 reader.  It converts all of the images in a WAD to PCX files.
//	Assumes the current working directory for output, but the function supports any old
//	directory.  I didn't want to bother with checking for the silly backslashes and such,
//	so that's your fun part :)
//
//	This code is completely unsupported, and was written purely for other people to
//	learn the WAD3 structure.  That said, it *does* work and is a useful tool all by
//	itself.  Of course the really cool stuff we do inside Wally, but that wouldn't be
//	so easy to duplicate here.  I will answer any reasonable questions about the 
//	format, or even anything else in this code, but I make no warranties about using
//	this as the base for another program.  IE, test the crap out of what you're 
//	coding and really make sure it's working the way it should be.  
//
//	I put this together in a short amount of time, so there may be bugs or such.  
//	It's also not very optimized, but it runs fast enough to not bother me too 
//	much :)  I am doing a *lot* of bounds checking, so make sure you keep that stuff 
//	in there.  It is always better to be safe than sorry, and you never know when 
//	something might be corrupt.
//
//	Since this code only reads data and doesn't actually write a WAD file (that's 
//	for you to play with <g>) it doesn't bother looking at some important items.  
//	Specifically, the WORD padding at the very end of a mip's data block.  This WORD 
//	padding isn't used for anything, but it HAS to be there.  Check out the pseudocode 
//	structure in the header file for more details there.  If you come up with a WAD3
//	creation utility, just make sure Wally and WorldCraft can load your WAD, and you'll
//	be good to go.
//
//	- Ty
//
//////////////////////////////////////////////////////////////////////////////////////////


#include "wad3.h"
#include "pcx.h"
#include "tools.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>

int EnumerateImages( char *FileName, char *OutputFolder)
{
  // wad
  FILE *File;
  struct stat FileStat;
  WAD3HEAD wh;
  WAD3LUMP wl;
  WAD3MIP wm;

  // pcx
  PCXENCODE pcxEncode;
  unsigned long PaletteOffset;

  // common
  unsigned long i, j, fpos, mippos, ret;

  // make sure the file is there.
  if ((File = fopen(FileName, "rb"))==NULL) {
    printf("File not found : %s\n", FileName);
    return 1;
  }
    
  if (stat(FileName, &FileStat))
    {
      printf("Could not stat file : %s\n", FileName);
      fclose(File);
      return 1;
    }

  printf("Filesize : %ld\n", FileStat.st_size);

  // Make sure it's at least big enough
  if (FileStat.st_size < sizeof(WAD3HEAD))
    {
      printf("WAD3 file is malformed.\n");
      fclose(File);
      return 1;
    }

  wh.identification = get4(File);
  wh.numlumps = get4(File);
  wh.infotableofs = get4(File);
  
  if (wh.identification != WAD3_ID)
    {
      printf("Invalid WAD3 header id.\n");
      fclose(File);
      return 1;
    }

  // Make sure our table is really there
  if ( ((wh.numlumps * sizeof(WAD3LUMP)) + wh.infotableofs) > FileStat.st_size)
    {
      printf("WAD3 file is malformed.\n");
      fclose(File);
      return 1;
    }

  // seek the first table entry
  fpos = wh.infotableofs;
  
  for (j = 0; j < wh.numlumps; j++, fpos+=sizeof(WAD3LUMP))
    {		
      fseek(File, fpos, SEEK_SET);
      
      // read the lump data
      wl.filepos = get4(File);
      wl.disksize = get4(File);
      wl.size = get4(File);
      wl.type = getc(File);
      wl.compression = getc(File);
      wl.pad1 = getc(File);
      wl.pad2 = getc(File);
      for (i = 0; i<16; i++) wl.name[i] = getc(File);

      // printf("LUMP %d %s\n", j, wl.name);
      
      if (wl.type == WAD3_TYPE_MIP)
	{
	  // Find out where the MIP actually is
	  mippos = wl.filepos;
	  
	  // Make sure it's in bounds
	  if ( mippos >= FileStat.st_size)
	    {
	      printf("Invalid lump entry; filepos (MIP) is malformed.\n");
	      fclose(File);
	      return 1;
	    }

	  // Point at the mip
	  fseek(File, mippos, SEEK_SET);
	  
	  // read the mip data
	  for (i = 0; i<16; i++) wm.name[i] = getc(File);
	  wm.width = get4(File);
	  wm.height = get4(File);
	  wm.offsets[0] = get4(File);
	  wm.offsets[1] = get4(File);
	  wm.offsets[2] = get4(File);
	  wm.offsets[3] = get4(File);

	  // printf("width %d\n", wm.width);
	  // printf("height %d\n", wm.height);

	  // Ok, wir haben alles was wichtig ist. Nun beginnt das Erstellen
	  // des PCX-Files

	  // Set these
	  pcxEncode.Width = wm.width;
	  pcxEncode.Height = wm.height;
	  
	  // Platz fuer den Filename. 2048 muss reichen!
	  pcxEncode.FileName = (char *) malloc(2048);

	  if (pcxEncode.FileName == NULL )
	    {
	      printf("Out of memory (FileName).\n");
	      fclose(File);
	      return 1;
	    }

	  sprintf( pcxEncode.FileName, "%s%s.pcx", OutputFolder, wm.name);

	  // First find the size of the palette (should be 256, but you never know.)
	  // The size of the palette is a WORD entry, located 
	  // directly after the very last mip (or is *supposed* to be there.) 
	  // Immediately following the palette size entry is the palette
	  // itself.  After the palette is another WORD entry that contains no useful data...
	  // it is used just to pad the mip

	  PaletteOffset = GET_MIP_DATA_SIZE( wm.width, wm.height);
	  fseek(File, mippos + PaletteOffset, SEEK_SET);
	  pcxEncode.PaletteSize = get2(File);
	  
	  // *3 weil R+G+B je ein Byte
	  pcxEncode.Palette = malloc(pcxEncode.PaletteSize*3);

	  if (pcxEncode.Palette == NULL )
	    {
	      printf("Out of memory (Palette).\n");
	      free(pcxEncode.FileName);
	      fclose(File);
	      return 1;
	    }

	  // Read Data
	  for (i=0;i < pcxEncode.PaletteSize*3;i++) pcxEncode.Palette[i]=getc(File);

	  // Now for the mip data. The first mip (the largest one, width * height in size)
	  // should always be the first offset, followed in order by the other three mips,
	  // descending in size. Each successive mip is 1/2 the width and 1/2 the height of
	  // the previous one, or 1/4 the total size. Since I'm only working with the largest
	  // one here, it doesn't really matter. But if you're trying to look at all 4 mips,
	  // you'll need to point at each offset and handle them. The first mip should always
	  // start immediately after the mip header, hence the sizeof(WAD3MIP). Here's a
	  // sample image:
	  //
	  // width = 128  height = 128
	  // datasize[0] = width * height = 16384
	  // datasize[1] = width * height / 4 = 4096
	  // datasize[2] = width * height / 16 = 1024
	  // datasize[3] = width * height / 64 = 256
	  // offset[0] = sizeof(WAD3_MIP)
	  // offset[1] = sizeof(WAD3_MIP) + datasize[0]
	  // offset[2] = sizeof(WAD3_MIP) + datasize[0] + datasize[1]
	  // offset[3] = sizeof(WAD3_MIP) + datasize[0] + datasize[1] + datasize[2]
	  
	  // Make sure we've got the data there (bad things happen otherwise!)
	  if ( (mippos + wm.offsets[0] + (wm.width * wm.height)) > FileStat.st_size)
	    {
	      printf("Invalid mip entry; offsets[0] is malformed.\n");
	      free(pcxEncode.Palette);
	      free(pcxEncode.FileName);
	      fclose(File);
	      return 1;
	    }

	  fseek(File, mippos + wm.offsets[0], SEEK_SET);

	  pcxEncode.ImageData = malloc(wm.width * wm.height);

	  if (pcxEncode.ImageData == NULL )
	    {
	      printf("Out of memory (ImageData).\n");
	      free(pcxEncode.Palette);
	      free(pcxEncode.FileName);
	      fclose(File);
	      return 1;
	    }

	  // Read Data
	  for (i=0;i<(wm.width * wm.height);i++) pcxEncode.ImageData[i]=getc(File);

	  ret = (long)EncodePCX( &pcxEncode);

	  free(pcxEncode.ImageData);
	  free(pcxEncode.Palette);
	  free(pcxEncode.FileName);

	  if (!ret)
	    {
	      printf("Something went wrong...\n");
	      fclose(File);
	      return 0;
	    }
	  
	}
    }

    printf("\n");

    fclose(File);

    return 0;
}


int main(int argc, char* argv[])
{
  if (argc != 2)
    {
      printf("USAGE:  WAD3 filename.wad\n");
      return 1;
    }

  return EnumerateImages( argv[1], "./");			
}

