// get4(), get2() and put4(), put2() are help functions to load or
// save byte by byte for either endian platforms. It works.

#include <stdio.h>

// get 4 bytes as unsigned short
unsigned long get4(FILE *fp)
{
  unsigned long foo, foo1, foo2, foo3;
  foo = getc(fp);  
  foo1 = getc(fp);  
  foo2 = getc(fp);  
  foo3 = getc(fp);
  return ((unsigned long) foo) +   
    (((unsigned long) foo1) << 8) + 
    (((unsigned long) foo2) << 16) +
    (((unsigned long) foo3) << 24);
}


// get 2 bytes as unsigned short
unsigned short get2(FILE *fp)
{
  unsigned short foo, foo1;
  foo = getc(fp);  
  foo1 = getc(fp);
  return ((unsigned short) foo) + (((unsigned short) foo1) << 8);
}


// put a unsigned long as 4 bytes
void put4(unsigned long foo, FILE *fp)
{
  putc((unsigned char)foo, fp);
  putc((unsigned char)(foo >> 8), fp);
  putc((unsigned char)(foo >> 16), fp);
  putc((unsigned char)(foo >> 24), fp);
}


// put a unsigned short as 2 bytes
void put2(unsigned short foo, FILE *fp)
{
  putc((unsigned char)foo, fp);
  putc((unsigned char)(foo >> 8), fp);
}

