
#include "pcx.h"
#include "wad3.h"
#include "tools.h"

#include <stdio.h>

int EncodePCX( PCXENCODE *Encode )
{
  FILE *File;
  unsigned long i, j;
  unsigned char LastByte, ThisByte, RunLength;
  char *ImageData;

  // open outputfile
  if ((File = fopen(Encode->FileName, "w"))==NULL) {
    printf("Could not create : %s\n", Encode->FileName);
    return 0;
  }

  printf("%s (%ldx%ld)\n", Encode->FileName, Encode->Width, Encode->Height);

  putc(0x0A, File);                                   // ZSoft PCX file id (10 decimal)
  putc(5, File);                                      // (Vserion) 5 = 256 color (with palette)
  putc(1, File);                                      // (Encoding) 1 = standard run-length encoding
  putc(8, File);                                      // (BitsPerPixelPlane) 8 = 256 color
  put2(0, File);                                      // (wXmin) 0
  put2(0, File);                                      // (wYmin) 0
  put2((unsigned short)(Encode->Width - 1), File);    // (Width) 0
  put2((unsigned short)(Encode->Height - 1), File);   // (Height) 0
  put2(92, File);                                     // horizontal dpi
  put2(92, File);                                     // vertical dpi
  for (i=0; i<48;i++) putc(0, File);                  // palette (ignored)
  putc(0, File);                                      // monitor VMode (ignored)
  putc(1, File);                                      // number of planes in image
  put2((unsigned short)Encode->Width, File);          // bytes per line per plane
  put2(1, File);                                      // grayscale/color flag (obsolete)
  put2(0, File);                                      // horizontal screen size (ignored)
  put2(0, File);                                      // vertical screen size (ignored)
  for (i=0; i<PCXFILLER;i++) putc(0, File);           // fill space up to 128 bytes

  ImageData = Encode->ImageData;

  for (i = 0; i < Encode->Height; i++)
    {		
      LastByte = *(ImageData);
      RunLength = 1;

      for (j = 1; j < Encode->Width; j++)
	{
	  if (j < Encode->Width)
	    {
	      ThisByte = *(++ImageData);
	    }
	  // else, just repeat previous pixel (for WORD padding)
			
	  if (ThisByte == LastByte)
	    {
	      RunLength++;
	      
	      if (RunLength == 63)
		{
		  putc(0xC0 | RunLength, File);
		  putc(LastByte, File);
		  RunLength = 0;					
		}
	    }
	  else
	    {
	      if (RunLength)
		{
		  // If there's only one byte, and it's less than 192, just move it in
		  // as no coded runlength
		  if ((RunLength == 1) && ((LastByte & 0xC0) != 0xC0))
		    {
		      putc(LastByte, File);
		    }
		  else
		    {				
		      putc(0xC0 | RunLength, File);
		      putc(LastByte, File);
		    }
		}
	      
	      LastByte = ThisByte;
	      RunLength = 1;
	    }
	  
	}


      if (RunLength)
	{				
	  // If there's only one byte, and it's less than 192, just move it in
	  // as no coded runlength
	  
	  if ((RunLength == 1) && ((LastByte & 0xc0) != 0xc0))
	    {
	      putc(LastByte, File);
	    }
	  else
	    {				
	      putc(0xC0 | RunLength, File);
	      putc(LastByte, File);
	    }	
	}	

      ImageData++;
    }


  // write the palette
  putc(0x0C, File);	// palette ID byte
	
  for (i=0;i < Encode->PaletteSize*3;i++) putc(Encode->Palette[i], File);

  // Set the rest to black
  if (Encode->PaletteSize != 256)
    for (i=0;i < (768 - (Encode->PaletteSize*3));i++) putc(0, File);

  fclose(File);

  return 1;
}

