// WADDisplayDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WADDisplay.h"
#include "WADDisplayDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWADDisplayDlg dialog

CWADDisplayDlg::CWADDisplayDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWADDisplayDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWADDisplayDlg)
	m_strWADFile = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWADDisplayDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWADDisplayDlg)
	DDX_Control(pDX, IDC_LIST_IMAGES, m_lstImages);
	DDX_Control(pDX, IDC_WADDISPLAY_CTRL, m_WADDisplay);
	DDX_Text(pDX, IDC_EDIT_WAD_FILE, m_strWADFile);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWADDisplayDlg, CDialog)
	//{{AFX_MSG_MAP(CWADDisplayDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_SELECT, OnButtonSelect)
	ON_LBN_SELCHANGE(IDC_LIST_IMAGES, OnSelchangeListImages)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWADDisplayDlg message handlers

BOOL CWADDisplayDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	if( m_WADDisplay.GetVersion() < 1.0 )
	{
		AfxMessageBox( "Unsupported version of WADDisplay.", MB_ICONSTOP );
	}
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWADDisplayDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWADDisplayDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWADDisplayDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CWADDisplayDlg::OnButtonSelect() 
{
	// Build some strings based on the String Table entries
	CString strWildCard ("WAD Files (*.wad)|*.wad||");
	CString strTitle( "Select your WAD file" );	
	CString strFileName("");
	CString strImageName("");
	BOOL bImage = FALSE;
		
	// Create a CFileDialog, init with our strings
	CFileDialog	dlgOpen( TRUE, NULL, NULL, OFN_FILEMUSTEXIST | 
		OFN_PATHMUSTEXIST, strWildCard, NULL );	
	
	dlgOpen.m_ofn.lpstrTitle = strTitle;	
	
	if( dlgOpen.DoModal() == IDOK )
	{
		m_lstImages.ResetContent();
		strFileName = dlgOpen.GetPathName();
		m_WADDisplay.SetWADFile( strFileName );
		m_WADDisplay.RedrawWindow( NULL );
		
		if( m_WADDisplay.GetError().GetLength() > 0 )
		{
			AfxMessageBox( m_WADDisplay.GetError(), MB_ICONSTOP );
		}
		else
		{
			m_strWADFile = strFileName;
			UpdateData( FALSE );
		
			strImageName = m_WADDisplay.GetFirstImage();

			while( strImageName.GetLength() > 0 )
			{
				bImage = TRUE;
				m_lstImages.AddString( strImageName );
				strImageName = m_WADDisplay.GetNextImage();
			}

			if( bImage )
			{
				m_lstImages.SetCurSel( 0 );
				OnSelchangeListImages();
			}
		}
	}
		
}

void CWADDisplayDlg::OnSelchangeListImages() 
{
	int iCurSel = m_lstImages.GetCurSel();
	CString strImage("");

	if( iCurSel != LB_ERR )
	{	
		m_lstImages.GetText( iCurSel, strImage );
		SetCurrentImage( strImage );
	}
}


void CWADDisplayDlg::SetCurrentImage( LPCTSTR szImage )
{
	m_WADDisplay.SetSelectedImage( szImage );
}