export Com_Clamp
code
proc Com_Clamp 0 0
file "..\q_shared.c"
line 6
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// q_shared.c -- stateless support routines that are included in each code dll
;4:#include "q_shared.h"
;5:
;6:float Com_Clamp( float min, float max, float value ) {
line 7
;7:	if ( value < min ) {
ADDRFP4 8
INDIRF4
ADDRFP4 0
INDIRF4
GEF4 $18
line 8
;8:		return min;
ADDRFP4 0
INDIRF4
RETF4
ADDRGP4 $17
JUMPV
LABELV $18
line 10
;9:	}
;10:	if ( value > max ) {
ADDRFP4 8
INDIRF4
ADDRFP4 4
INDIRF4
LEF4 $20
line 11
;11:		return max;
ADDRFP4 4
INDIRF4
RETF4
ADDRGP4 $17
JUMPV
LABELV $20
line 13
;12:	}
;13:	return value;
ADDRFP4 8
INDIRF4
RETF4
LABELV $17
endproc Com_Clamp 0 0
export COM_SkipPath
proc COM_SkipPath 4 0
line 23
;14:}
;15:
;16:
;17:/*
;18:============
;19:COM_SkipPath
;20:============
;21:*/
;22:char *COM_SkipPath (char *pathname)
;23:{
line 26
;24:	char	*last;
;25:	
;26:	last = pathname;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $24
JUMPV
LABELV $23
line 28
;27:	while (*pathname)
;28:	{
line 29
;29:		if (*pathname=='/')
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 47
NEI4 $26
line 30
;30:			last = pathname+1;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
LABELV $26
line 31
;31:		pathname++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 32
;32:	}
LABELV $24
line 27
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $23
line 33
;33:	return last;
ADDRLP4 0
INDIRP4
RETP4
LABELV $22
endproc COM_SkipPath 4 0
export COM_StripExtension
proc COM_StripExtension 12 0
line 41
;34:}
;35:
;36:/*
;37:============
;38:COM_StripExtension
;39:============
;40:*/
;41:void COM_StripExtension( const char *in, char *out ) {
ADDRGP4 $30
JUMPV
LABELV $29
line 42
;42:	while ( *in && *in != '.' ) {
line 43
;43:		*out++ = *in++;
ADDRLP4 0
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 8
CNSTI4 1
ASGNI4
ADDRFP4 4
ADDRLP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ASGNP4
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI1
ASGNI1
line 44
;44:	}
LABELV $30
line 42
ADDRLP4 0
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $32
ADDRLP4 0
INDIRI4
CNSTI4 46
NEI4 $29
LABELV $32
line 45
;45:	*out = 0;
ADDRFP4 4
INDIRP4
CNSTI1 0
ASGNI1
line 46
;46:}
LABELV $28
endproc COM_StripExtension 12 0
export COM_DefaultExtension
proc COM_DefaultExtension 76 20
line 54
;47:
;48:
;49:/*
;50:==================
;51:COM_DefaultExtension
;52:==================
;53:*/
;54:void COM_DefaultExtension (char *path, int maxSize, const char *extension ) {
line 62
;55:	char	oldPath[MAX_QPATH];
;56:	char    *src;
;57:
;58://
;59:// if path doesn't have a .EXT, append extension
;60:// (extension should include the .)
;61://
;62:	src = path + strlen(path) - 1;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 0
ADDRLP4 68
INDIRU4
ADDRFP4 0
INDIRP4
ADDP4
CNSTI4 -1
ADDP4
ASGNP4
ADDRGP4 $35
JUMPV
LABELV $34
line 64
;63:
;64:	while (*src != '/' && src != path) {
line 65
;65:		if ( *src == '.' ) {
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 46
NEI4 $37
line 66
;66:			return;                 // it has an extension
ADDRGP4 $33
JUMPV
LABELV $37
line 68
;67:		}
;68:		src--;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 -1
ADDP4
ASGNP4
line 69
;69:	}
LABELV $35
line 64
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 47
EQI4 $39
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRFP4 0
INDIRP4
CVPU4 4
NEU4 $34
LABELV $39
line 71
;70:
;71:	Q_strncpyz( oldPath, path, sizeof( oldPath ) );
ADDRLP4 4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 72
;72:	Com_sprintf( path, maxSize, "%s%s", oldPath, extension );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 $40
ARGP4
ADDRLP4 4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 73
;73:}
LABELV $33
endproc COM_DefaultExtension 76 20
export BigShort
proc BigShort 4 4
ADDRFP4 0
ADDRFP4 0
INDIRI4
CVII2 4
ASGNI2
line 92
;74:
;75:/*
;76:============================================================================
;77:
;78:					BYTE ORDER FUNCTIONS
;79:
;80:============================================================================
;81:*/
;82:
;83:// can't just use function pointers, or dll linkage can
;84:// mess up when qcommon is included in multiple places
;85:static short	(*_BigShort) (short l);
;86:static short	(*_LittleShort) (short l);
;87:static int		(*_BigLong) (int l);
;88:static int		(*_LittleLong) (int l);
;89:static float	(*_BigFloat) (float l);
;90:static float	(*_LittleFloat) (float l);
;91:
;92:short	BigShort(short l){return _BigShort(l);}
ADDRFP4 0
INDIRI2
CVII4 2
ARGI4
ADDRLP4 0
ADDRGP4 _BigShort
INDIRP4
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CVII2 4
CVII4 2
RETI4
LABELV $41
endproc BigShort 4 4
export LittleShort
proc LittleShort 4 4
ADDRFP4 0
ADDRFP4 0
INDIRI4
CVII2 4
ASGNI2
line 93
;93:short	LittleShort(short l) {return _LittleShort(l);}
ADDRFP4 0
INDIRI2
CVII4 2
ARGI4
ADDRLP4 0
ADDRGP4 _LittleShort
INDIRP4
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CVII2 4
CVII4 2
RETI4
LABELV $42
endproc LittleShort 4 4
export BigLong
proc BigLong 4 4
line 94
;94:int		BigLong (int l) {return _BigLong(l);}
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 0
ADDRGP4 _BigLong
INDIRP4
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
RETI4
LABELV $43
endproc BigLong 4 4
export LittleLong
proc LittleLong 4 4
line 95
;95:int		LittleLong (int l) {return _LittleLong(l);}
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 0
ADDRGP4 _LittleLong
INDIRP4
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
RETI4
LABELV $44
endproc LittleLong 4 4
export BigFloat
proc BigFloat 4 4
line 96
;96:float	BigFloat (float l) {return _BigFloat(l);}
ADDRFP4 0
INDIRF4
ARGF4
ADDRLP4 0
ADDRGP4 _BigFloat
INDIRP4
CALLF4
ASGNF4
ADDRLP4 0
INDIRF4
RETF4
LABELV $45
endproc BigFloat 4 4
export LittleFloat
proc LittleFloat 4 4
line 97
;97:float	LittleFloat (float l) {return _LittleFloat(l);}
ADDRFP4 0
INDIRF4
ARGF4
ADDRLP4 0
ADDRGP4 _LittleFloat
INDIRP4
CALLF4
ASGNF4
ADDRLP4 0
INDIRF4
RETF4
LABELV $46
endproc LittleFloat 4 4
export ShortSwap
proc ShortSwap 2 0
ADDRFP4 0
ADDRFP4 0
INDIRI4
CVII2 4
ASGNI2
line 100
;98:
;99:short   ShortSwap (short l)
;100:{
line 103
;101:	byte    b1,b2;
;102:
;103:	b1 = l&255;
ADDRLP4 0
ADDRFP4 0
INDIRI2
CVII4 2
CNSTI4 255
BANDI4
CVIU4 4
CVUU1 4
ASGNU1
line 104
;104:	b2 = (l>>8)&255;
ADDRLP4 1
ADDRFP4 0
INDIRI2
CVII4 2
CNSTI4 8
RSHI4
CNSTI4 255
BANDI4
CVIU4 4
CVUU1 4
ASGNU1
line 106
;105:
;106:	return (b1<<8) + b2;
ADDRLP4 0
INDIRU1
CVUI4 1
CNSTI4 8
LSHI4
ADDRLP4 1
INDIRU1
CVUI4 1
ADDI4
CVII2 4
CVII4 2
RETI4
LABELV $47
endproc ShortSwap 2 0
export ShortNoSwap
proc ShortNoSwap 0 0
ADDRFP4 0
ADDRFP4 0
INDIRI4
CVII2 4
ASGNI2
line 110
;107:}
;108:
;109:short	ShortNoSwap (short l)
;110:{
line 111
;111:	return l;
ADDRFP4 0
INDIRI2
CVII4 2
RETI4
LABELV $48
endproc ShortNoSwap 0 0
export LongSwap
proc LongSwap 4 0
line 115
;112:}
;113:
;114:int    LongSwap (int l)
;115:{
line 118
;116:	byte    b1,b2,b3,b4;
;117:
;118:	b1 = l&255;
ADDRLP4 0
ADDRFP4 0
INDIRI4
CNSTI4 255
BANDI4
CVIU4 4
CVUU1 4
ASGNU1
line 119
;119:	b2 = (l>>8)&255;
ADDRLP4 1
ADDRFP4 0
INDIRI4
CNSTI4 8
RSHI4
CNSTI4 255
BANDI4
CVIU4 4
CVUU1 4
ASGNU1
line 120
;120:	b3 = (l>>16)&255;
ADDRLP4 2
ADDRFP4 0
INDIRI4
CNSTI4 16
RSHI4
CNSTI4 255
BANDI4
CVIU4 4
CVUU1 4
ASGNU1
line 121
;121:	b4 = (l>>24)&255;
ADDRLP4 3
ADDRFP4 0
INDIRI4
CNSTI4 24
RSHI4
CNSTI4 255
BANDI4
CVIU4 4
CVUU1 4
ASGNU1
line 123
;122:
;123:	return ((int)b1<<24) + ((int)b2<<16) + ((int)b3<<8) + b4;
ADDRLP4 0
INDIRU1
CVUI4 1
CNSTI4 24
LSHI4
ADDRLP4 1
INDIRU1
CVUI4 1
CNSTI4 16
LSHI4
ADDI4
ADDRLP4 2
INDIRU1
CVUI4 1
CNSTI4 8
LSHI4
ADDI4
ADDRLP4 3
INDIRU1
CVUI4 1
ADDI4
RETI4
LABELV $49
endproc LongSwap 4 0
export LongNoSwap
proc LongNoSwap 0 0
line 127
;124:}
;125:
;126:int	LongNoSwap (int l)
;127:{
line 128
;128:	return l;
ADDRFP4 0
INDIRI4
RETI4
LABELV $50
endproc LongNoSwap 0 0
export FloatSwap
proc FloatSwap 8 0
line 132
;129:}
;130:
;131:float FloatSwap (float f)
;132:{
line 140
;133:	union
;134:	{
;135:		float	f;
;136:		byte	b[4];
;137:	} dat1, dat2;
;138:	
;139:	
;140:	dat1.f = f;
ADDRLP4 0
ADDRFP4 0
INDIRF4
ASGNF4
line 141
;141:	dat2.b[0] = dat1.b[3];
ADDRLP4 4
ADDRLP4 0+3
INDIRU1
ASGNU1
line 142
;142:	dat2.b[1] = dat1.b[2];
ADDRLP4 4+1
ADDRLP4 0+2
INDIRU1
ASGNU1
line 143
;143:	dat2.b[2] = dat1.b[1];
ADDRLP4 4+2
ADDRLP4 0+1
INDIRU1
ASGNU1
line 144
;144:	dat2.b[3] = dat1.b[0];
ADDRLP4 4+3
ADDRLP4 0
INDIRU1
ASGNU1
line 145
;145:	return dat2.f;
ADDRLP4 4
INDIRF4
RETF4
LABELV $51
endproc FloatSwap 8 0
export FloatNoSwap
proc FloatNoSwap 0 0
line 149
;146:}
;147:
;148:float FloatNoSwap (float f)
;149:{
line 150
;150:	return f;
ADDRFP4 0
INDIRF4
RETF4
LABELV $59
endproc FloatNoSwap 0 0
lit
align 1
LABELV $61
byte 1 1
byte 1 0
export Swap_Init
code
proc Swap_Init 2 0
line 159
;151:}
;152:
;153:/*
;154:================
;155:Swap_Init
;156:================
;157:*/
;158:void Swap_Init (void)
;159:{
line 160
;160:	byte	swaptest[2] = {1,0};
ADDRLP4 0
ADDRGP4 $61
INDIRB
ASGNB 2
line 163
;161:
;162:// set the byte swapping variables in a portable manner	
;163:	if ( *(short *)swaptest == 1)
ADDRLP4 0
INDIRI2
CVII4 2
CNSTI4 1
NEI4 $62
line 164
;164:	{
line 165
;165:		_BigShort = ShortSwap;
ADDRGP4 _BigShort
ADDRGP4 ShortSwap
ASGNP4
line 166
;166:		_LittleShort = ShortNoSwap;
ADDRGP4 _LittleShort
ADDRGP4 ShortNoSwap
ASGNP4
line 167
;167:		_BigLong = LongSwap;
ADDRGP4 _BigLong
ADDRGP4 LongSwap
ASGNP4
line 168
;168:		_LittleLong = LongNoSwap;
ADDRGP4 _LittleLong
ADDRGP4 LongNoSwap
ASGNP4
line 169
;169:		_BigFloat = FloatSwap;
ADDRGP4 _BigFloat
ADDRGP4 FloatSwap
ASGNP4
line 170
;170:		_LittleFloat = FloatNoSwap;
ADDRGP4 _LittleFloat
ADDRGP4 FloatNoSwap
ASGNP4
line 171
;171:	}
ADDRGP4 $63
JUMPV
LABELV $62
line 173
;172:	else
;173:	{
line 174
;174:		_BigShort = ShortNoSwap;
ADDRGP4 _BigShort
ADDRGP4 ShortNoSwap
ASGNP4
line 175
;175:		_LittleShort = ShortSwap;
ADDRGP4 _LittleShort
ADDRGP4 ShortSwap
ASGNP4
line 176
;176:		_BigLong = LongNoSwap;
ADDRGP4 _BigLong
ADDRGP4 LongNoSwap
ASGNP4
line 177
;177:		_LittleLong = LongSwap;
ADDRGP4 _LittleLong
ADDRGP4 LongSwap
ASGNP4
line 178
;178:		_BigFloat = FloatNoSwap;
ADDRGP4 _BigFloat
ADDRGP4 FloatNoSwap
ASGNP4
line 179
;179:		_LittleFloat = FloatSwap;
ADDRGP4 _LittleFloat
ADDRGP4 FloatSwap
ASGNP4
line 180
;180:	}
LABELV $63
line 182
;181:
;182:}
LABELV $60
endproc Swap_Init 2 0
export COM_BeginParseSession
proc COM_BeginParseSession 0 0
line 197
;183:
;184:
;185:/*
;186:============================================================================
;187:
;188:PARSING
;189:
;190:============================================================================
;191:*/
;192:
;193:static	char	com_token[MAX_TOKEN_CHARS];
;194:static	int		com_lines;
;195:
;196:void COM_BeginParseSession( void )
;197:{
line 198
;198:	com_lines = 0;
ADDRGP4 com_lines
CNSTI4 0
ASGNI4
line 199
;199:}
LABELV $64
endproc COM_BeginParseSession 0 0
export COM_GetCurrentParseLine
proc COM_GetCurrentParseLine 0 0
line 202
;200:
;201:int COM_GetCurrentParseLine( void )
;202:{
line 203
;203:	return com_lines;
ADDRGP4 com_lines
INDIRI4
RETI4
LABELV $65
endproc COM_GetCurrentParseLine 0 0
export COM_Parse
proc COM_Parse 4 8
line 207
;204:}
;205:
;206:char *COM_Parse( char **data_p )
;207:{
line 208
;208:	return COM_ParseExt( data_p, qtrue );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 0
ADDRGP4 COM_ParseExt
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
RETP4
LABELV $66
endproc COM_Parse 4 8
proc SkipWhitespace 8 0
line 224
;209:}
;210:
;211:
;212:/*
;213:==============
;214:COM_Parse
;215:
;216:Parse a token out of a string
;217:Will never return NULL, just empty strings
;218:
;219:If "allowLineBreaks" is qtrue then an empty
;220:string will be returned if the next token is
;221:a newline.
;222:==============
;223:*/
;224:static char *SkipWhitespace( char *data, qboolean *hasNewLines ) {
ADDRGP4 $69
JUMPV
LABELV $68
line 227
;225:	int c;
;226:
;227:	while( (c = *data) <= ' ') {
line 228
;228:		if( !c ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $71
line 229
;229:			return NULL;
CNSTP4 0
RETP4
ADDRGP4 $67
JUMPV
LABELV $71
line 231
;230:		}
;231:		if( c == '\n' ) {
ADDRLP4 0
INDIRI4
CNSTI4 10
NEI4 $73
line 232
;232:			com_lines++;
ADDRLP4 4
ADDRGP4 com_lines
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 233
;233:			*hasNewLines = qtrue;
ADDRFP4 4
INDIRP4
CNSTI4 1
ASGNI4
line 234
;234:		}
LABELV $73
line 235
;235:		data++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 236
;236:	}
LABELV $69
line 227
ADDRLP4 4
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 0
ADDRLP4 4
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 32
LEI4 $68
line 238
;237:
;238:	return data;
ADDRFP4 0
INDIRP4
RETP4
LABELV $67
endproc SkipWhitespace 8 0
export COM_ParseExt
proc COM_ParseExt 36 8
line 242
;239:}
;240:
;241:char *COM_ParseExt( char **data_p, qboolean allowLineBreaks )
;242:{
line 243
;243:	int c = 0, len;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 244
;244:	qboolean hasNewLines = qfalse;
ADDRLP4 12
CNSTI4 0
ASGNI4
line 247
;245:	char *data;
;246:
;247:	data = *data_p;
ADDRLP4 0
ADDRFP4 0
INDIRP4
INDIRP4
ASGNP4
line 248
;248:	len = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
line 249
;249:	com_token[0] = 0;
ADDRGP4 com_token
CNSTI1 0
ASGNI1
line 252
;250:
;251:	// make sure incoming data is valid
;252:	if ( !data )
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $79
line 253
;253:	{
line 254
;254:		*data_p = NULL;
ADDRFP4 0
INDIRP4
CNSTP4 0
ASGNP4
line 255
;255:		return com_token;
ADDRGP4 com_token
RETP4
ADDRGP4 $75
JUMPV
LABELV $78
line 259
;256:	}
;257:
;258:	while ( 1 )
;259:	{
line 261
;260:		// skip whitespace
;261:		data = SkipWhitespace( data, &hasNewLines );
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 16
ADDRGP4 SkipWhitespace
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 16
INDIRP4
ASGNP4
line 262
;262:		if ( !data )
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $81
line 263
;263:		{
line 264
;264:			*data_p = NULL;
ADDRFP4 0
INDIRP4
CNSTP4 0
ASGNP4
line 265
;265:			return com_token;
ADDRGP4 com_token
RETP4
ADDRGP4 $75
JUMPV
LABELV $81
line 267
;266:		}
;267:		if ( hasNewLines && !allowLineBreaks )
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRLP4 12
INDIRI4
ADDRLP4 20
INDIRI4
EQI4 $83
ADDRFP4 4
INDIRI4
ADDRLP4 20
INDIRI4
NEI4 $83
line 268
;268:		{
line 269
;269:			*data_p = data;
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRP4
ASGNP4
line 270
;270:			return com_token;
ADDRGP4 com_token
RETP4
ADDRGP4 $75
JUMPV
LABELV $83
line 273
;271:		}
;272:
;273:		c = *data;
ADDRLP4 4
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
line 276
;274:
;275:		// skip double slash comments
;276:		if ( c == '/' && data[1] == '/' )
ADDRLP4 24
CNSTI4 47
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 24
INDIRI4
NEI4 $85
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
ADDRLP4 24
INDIRI4
NEI4 $85
line 277
;277:		{
ADDRGP4 $88
JUMPV
LABELV $87
line 279
;278:			while (*data && *data != '\n')
;279:				data++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
LABELV $88
line 278
ADDRLP4 28
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 0
EQI4 $90
ADDRLP4 28
INDIRI4
CNSTI4 10
NEI4 $87
LABELV $90
line 280
;280:		}
ADDRGP4 $86
JUMPV
LABELV $85
line 282
;281:		// skip /* */ comments
;282:		else if ( c=='/' && data[1] == '*' ) 
ADDRLP4 4
INDIRI4
CNSTI4 47
NEI4 $80
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
CNSTI4 42
NEI4 $80
line 283
;283:		{
ADDRGP4 $94
JUMPV
LABELV $93
line 285
;284:			while ( *data && ( *data != '*' || data[1] != '/' ) ) 
;285:			{
line 286
;286:				data++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 287
;287:			}
LABELV $94
line 284
ADDRLP4 32
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 32
INDIRI4
CNSTI4 0
EQI4 $96
ADDRLP4 32
INDIRI4
CNSTI4 42
NEI4 $93
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
CNSTI4 47
NEI4 $93
LABELV $96
line 288
;288:			if ( *data ) 
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $92
line 289
;289:			{
line 290
;290:				data += 2;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 2
ADDP4
ASGNP4
line 291
;291:			}
line 292
;292:		}
line 294
;293:		else
;294:		{
line 295
;295:			break;
LABELV $92
LABELV $86
line 297
;296:		}
;297:	}
LABELV $79
line 258
ADDRGP4 $78
JUMPV
LABELV $80
line 300
;298:
;299:	// handle quoted strings
;300:	if (c == '\"')
ADDRLP4 4
INDIRI4
CNSTI4 34
NEI4 $99
line 301
;301:	{
line 302
;302:		data++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRGP4 $102
JUMPV
LABELV $101
line 304
;303:		while (1)
;304:		{
line 305
;305:			c = *data++;
ADDRLP4 16
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 16
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 4
ADDRLP4 16
INDIRP4
INDIRI1
CVII4 1
ASGNI4
line 306
;306:			if (c=='\"' || !c)
ADDRLP4 4
INDIRI4
CNSTI4 34
EQI4 $106
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $104
LABELV $106
line 307
;307:			{
line 308
;308:				com_token[len] = 0;
ADDRLP4 8
INDIRI4
ADDRGP4 com_token
ADDP4
CNSTI1 0
ASGNI1
line 309
;309:				*data_p = ( char * ) data;
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRP4
ASGNP4
line 310
;310:				return com_token;
ADDRGP4 com_token
RETP4
ADDRGP4 $75
JUMPV
LABELV $104
line 312
;311:			}
;312:			if (len < MAX_TOKEN_CHARS)
ADDRLP4 8
INDIRI4
CNSTI4 1024
GEI4 $107
line 313
;313:			{
line 314
;314:				com_token[len] = c;
ADDRLP4 8
INDIRI4
ADDRGP4 com_token
ADDP4
ADDRLP4 4
INDIRI4
CVII1 4
ASGNI1
line 315
;315:				len++;
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 316
;316:			}
LABELV $107
line 317
;317:		}
LABELV $102
line 303
ADDRGP4 $101
JUMPV
line 318
;318:	}
LABELV $99
LABELV $109
line 322
;319:
;320:	// parse a regular word
;321:	do
;322:	{
line 323
;323:		if (len < MAX_TOKEN_CHARS)
ADDRLP4 8
INDIRI4
CNSTI4 1024
GEI4 $112
line 324
;324:		{
line 325
;325:			com_token[len] = c;
ADDRLP4 8
INDIRI4
ADDRGP4 com_token
ADDP4
ADDRLP4 4
INDIRI4
CVII1 4
ASGNI1
line 326
;326:			len++;
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 327
;327:		}
LABELV $112
line 328
;328:		data++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 329
;329:		c = *data;
ADDRLP4 4
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
line 330
;330:		if ( c == '\n' )
ADDRLP4 4
INDIRI4
CNSTI4 10
NEI4 $114
line 331
;331:			com_lines++;
ADDRLP4 16
ADDRGP4 com_lines
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $114
line 332
;332:	} while (c>32);
LABELV $110
ADDRLP4 4
INDIRI4
CNSTI4 32
GTI4 $109
line 334
;333:
;334:	if (len == MAX_TOKEN_CHARS)
ADDRLP4 8
INDIRI4
CNSTI4 1024
NEI4 $116
line 335
;335:	{
line 337
;336://		Com_Printf ("Token exceeded %i chars, discarded.\n", MAX_TOKEN_CHARS);
;337:		len = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
line 338
;338:	}
LABELV $116
line 339
;339:	com_token[len] = 0;
ADDRLP4 8
INDIRI4
ADDRGP4 com_token
ADDP4
CNSTI1 0
ASGNI1
line 341
;340:
;341:	*data_p = ( char * ) data;
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRP4
ASGNP4
line 342
;342:	return com_token;
ADDRGP4 com_token
RETP4
LABELV $75
endproc COM_ParseExt 36 8
export COM_MatchToken
proc COM_MatchToken 12 16
line 406
;343:}
;344:
;345:
;346:#if 0
;347:// no longer used
;348:/*
;349:===============
;350:COM_ParseInfos
;351:===============
;352:*/
;353:int COM_ParseInfos( char *buf, int max, char infos[][MAX_INFO_STRING] ) {
;354:	char	*token;
;355:	int		count;
;356:	char	key[MAX_TOKEN_CHARS];
;357:
;358:	count = 0;
;359:
;360:	while ( 1 ) {
;361:		token = COM_Parse( &buf );
;362:		if ( !token[0] ) {
;363:			break;
;364:		}
;365:		if ( strcmp( token, "{" ) ) {
;366:			Com_Printf( "Missing { in info file\n" );
;367:			break;
;368:		}
;369:
;370:		if ( count == max ) {
;371:			Com_Printf( "Max infos exceeded\n" );
;372:			break;
;373:		}
;374:
;375:		infos[count][0] = 0;
;376:		while ( 1 ) {
;377:			token = COM_ParseExt( &buf, qtrue );
;378:			if ( !token[0] ) {
;379:				Com_Printf( "Unexpected end of info file\n" );
;380:				break;
;381:			}
;382:			if ( !strcmp( token, "}" ) ) {
;383:				break;
;384:			}
;385:			Q_strncpyz( key, token, sizeof( key ) );
;386:
;387:			token = COM_ParseExt( &buf, qfalse );
;388:			if ( !token[0] ) {
;389:				strcpy( token, "<NULL>" );
;390:			}
;391:			Info_SetValueForKey( infos[count], key, token );
;392:		}
;393:		count++;
;394:	}
;395:
;396:	return count;
;397:}
;398:#endif
;399:
;400:
;401:/*
;402:==================
;403:COM_MatchToken
;404:==================
;405:*/
;406:void COM_MatchToken( char **buf_p, char *match ) {
line 409
;407:	char	*token;
;408:
;409:	token = COM_Parse( buf_p );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 410
;410:	if ( strcmp( token, match ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
EQI4 $119
line 411
;411:		Com_Error( ERR_DROP, "MatchToken: %s != %s", token, match );
CNSTI4 1
ARGI4
ADDRGP4 $121
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 Com_Error
CALLV
pop
line 412
;412:	}
LABELV $119
line 413
;413:}
LABELV $118
endproc COM_MatchToken 12 16
export SkipBracedSection
proc SkipBracedSection 12 8
line 425
;414:
;415:
;416:/*
;417:=================
;418:SkipBracedSection
;419:
;420:The next token should be an open brace.
;421:Skips until a matching close brace is found.
;422:Internal brace depths are properly skipped.
;423:=================
;424:*/
;425:void SkipBracedSection (char **program) {
line 429
;426:	char			*token;
;427:	int				depth;
;428:
;429:	depth = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $123
line 430
;430:	do {
line 431
;431:		token = COM_ParseExt( program, qtrue );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 8
ADDRGP4 COM_ParseExt
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 432
;432:		if( token[1] == 0 ) {
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $126
line 433
;433:			if( token[0] == '{' ) {
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 123
NEI4 $128
line 434
;434:				depth++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 435
;435:			}
ADDRGP4 $129
JUMPV
LABELV $128
line 436
;436:			else if( token[0] == '}' ) {
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 125
NEI4 $130
line 437
;437:				depth--;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 438
;438:			}
LABELV $130
LABELV $129
line 439
;439:		}
LABELV $126
line 440
;440:	} while( depth && *program );
LABELV $124
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $132
ADDRFP4 0
INDIRP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $123
LABELV $132
line 441
;441:}
LABELV $122
endproc SkipBracedSection 12 8
export SkipRestOfLine
proc SkipRestOfLine 16 0
line 448
;442:
;443:/*
;444:=================
;445:SkipRestOfLine
;446:=================
;447:*/
;448:void SkipRestOfLine ( char **data ) {
line 452
;449:	char	*p;
;450:	int		c;
;451:
;452:	p = *data;
ADDRLP4 4
ADDRFP4 0
INDIRP4
INDIRP4
ASGNP4
ADDRGP4 $135
JUMPV
LABELV $134
line 453
;453:	while ( (c = *p++) != 0 ) {
line 454
;454:		if ( c == '\n' ) {
ADDRLP4 0
INDIRI4
CNSTI4 10
NEI4 $137
line 455
;455:			com_lines++;
ADDRLP4 8
ADDRGP4 com_lines
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 456
;456:			break;
ADDRGP4 $136
JUMPV
LABELV $137
line 458
;457:		}
;458:	}
LABELV $135
line 453
ADDRLP4 8
ADDRLP4 4
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 12
ADDRLP4 8
INDIRP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 0
ADDRLP4 12
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
NEI4 $134
LABELV $136
line 460
;459:
;460:	*data = p;
ADDRFP4 0
INDIRP4
ADDRLP4 4
INDIRP4
ASGNP4
line 461
;461:}
LABELV $133
endproc SkipRestOfLine 16 0
export Parse1DMatrix
proc Parse1DMatrix 16 8
line 464
;462:
;463:
;464:void Parse1DMatrix (char **buf_p, int x, float *m) {
line 468
;465:	char	*token;
;466:	int		i;
;467:
;468:	COM_MatchToken( buf_p, "(" );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRGP4 COM_MatchToken
CALLV
pop
line 470
;469:
;470:	for (i = 0 ; i < x ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $144
JUMPV
LABELV $141
line 471
;471:		token = COM_Parse(buf_p);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ASGNP4
line 472
;472:		m[i] = atof(token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 atof
CALLF4
ASGNF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 8
INDIRP4
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
line 473
;473:	}
LABELV $142
line 470
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $144
ADDRLP4 0
INDIRI4
ADDRFP4 4
INDIRI4
LTI4 $141
line 475
;474:
;475:	COM_MatchToken( buf_p, ")" );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $145
ARGP4
ADDRGP4 COM_MatchToken
CALLV
pop
line 476
;476:}
LABELV $139
endproc Parse1DMatrix 16 8
export Parse2DMatrix
proc Parse2DMatrix 8 12
line 478
;477:
;478:void Parse2DMatrix (char **buf_p, int y, int x, float *m) {
line 481
;479:	int		i;
;480:
;481:	COM_MatchToken( buf_p, "(" );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRGP4 COM_MatchToken
CALLV
pop
line 483
;482:
;483:	for (i = 0 ; i < y ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $150
JUMPV
LABELV $147
line 484
;484:		Parse1DMatrix (buf_p, x, m + i * x);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRFP4 8
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
MULI4
CNSTI4 2
LSHI4
ADDRFP4 12
INDIRP4
ADDP4
ARGP4
ADDRGP4 Parse1DMatrix
CALLV
pop
line 485
;485:	}
LABELV $148
line 483
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $150
ADDRLP4 0
INDIRI4
ADDRFP4 4
INDIRI4
LTI4 $147
line 487
;486:
;487:	COM_MatchToken( buf_p, ")" );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $145
ARGP4
ADDRGP4 COM_MatchToken
CALLV
pop
line 488
;488:}
LABELV $146
endproc Parse2DMatrix 8 12
export Parse3DMatrix
proc Parse3DMatrix 12 16
line 490
;489:
;490:void Parse3DMatrix (char **buf_p, int z, int y, int x, float *m) {
line 493
;491:	int		i;
;492:
;493:	COM_MatchToken( buf_p, "(" );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRGP4 COM_MatchToken
CALLV
pop
line 495
;494:
;495:	for (i = 0 ; i < z ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $155
JUMPV
LABELV $152
line 496
;496:		Parse2DMatrix (buf_p, y, x, m + i * x*y);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRFP4 8
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 8
ADDRFP4 12
INDIRI4
ASGNI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
ADDRLP4 4
INDIRI4
MULI4
CNSTI4 2
LSHI4
ADDRFP4 16
INDIRP4
ADDP4
ARGP4
ADDRGP4 Parse2DMatrix
CALLV
pop
line 497
;497:	}
LABELV $153
line 495
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $155
ADDRLP4 0
INDIRI4
ADDRFP4 4
INDIRI4
LTI4 $152
line 499
;498:
;499:	COM_MatchToken( buf_p, ")" );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $145
ARGP4
ADDRGP4 COM_MatchToken
CALLV
pop
line 500
;500:}
LABELV $151
endproc Parse3DMatrix 12 16
export Q_isprint
proc Q_isprint 4 0
line 512
;501:
;502:
;503:/*
;504:============================================================================
;505:
;506:					LIBRARY REPLACEMENT FUNCTIONS
;507:
;508:============================================================================
;509:*/
;510:
;511:int Q_isprint( int c )
;512:{
line 513
;513:	if ( c >= 0x20 && c <= 0x7E )
ADDRLP4 0
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $157
ADDRLP4 0
INDIRI4
CNSTI4 126
GTI4 $157
line 514
;514:		return ( 1 );
CNSTI4 1
RETI4
ADDRGP4 $156
JUMPV
LABELV $157
line 515
;515:	return ( 0 );
CNSTI4 0
RETI4
LABELV $156
endproc Q_isprint 4 0
export Q_islower
proc Q_islower 4 0
line 519
;516:}
;517:
;518:int Q_islower( int c )
;519:{
line 520
;520:	if (c >= 'a' && c <= 'z')
ADDRLP4 0
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 97
LTI4 $160
ADDRLP4 0
INDIRI4
CNSTI4 122
GTI4 $160
line 521
;521:		return ( 1 );
CNSTI4 1
RETI4
ADDRGP4 $159
JUMPV
LABELV $160
line 522
;522:	return ( 0 );
CNSTI4 0
RETI4
LABELV $159
endproc Q_islower 4 0
export Q_isupper
proc Q_isupper 4 0
line 526
;523:}
;524:
;525:int Q_isupper( int c )
;526:{
line 527
;527:	if (c >= 'A' && c <= 'Z')
ADDRLP4 0
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 65
LTI4 $163
ADDRLP4 0
INDIRI4
CNSTI4 90
GTI4 $163
line 528
;528:		return ( 1 );
CNSTI4 1
RETI4
ADDRGP4 $162
JUMPV
LABELV $163
line 529
;529:	return ( 0 );
CNSTI4 0
RETI4
LABELV $162
endproc Q_isupper 4 0
export Q_isalpha
proc Q_isalpha 8 0
line 533
;530:}
;531:
;532:int Q_isalpha( int c )
;533:{
line 534
;534:	if ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'))
ADDRLP4 0
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 97
LTI4 $169
ADDRLP4 0
INDIRI4
CNSTI4 122
LEI4 $168
LABELV $169
ADDRLP4 4
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 65
LTI4 $166
ADDRLP4 4
INDIRI4
CNSTI4 90
GTI4 $166
LABELV $168
line 535
;535:		return ( 1 );
CNSTI4 1
RETI4
ADDRGP4 $165
JUMPV
LABELV $166
line 536
;536:	return ( 0 );
CNSTI4 0
RETI4
LABELV $165
endproc Q_isalpha 8 0
export Q_strrchr
proc Q_strrchr 12 0
line 540
;537:}
;538:
;539:char* Q_strrchr( const char* string, int c )
;540:{
line 541
;541:	char cc = c;
ADDRLP4 4
ADDRFP4 4
INDIRI4
CVII1 4
ASGNI1
line 543
;542:	char *s;
;543:	char *sp=(char *)0;
ADDRLP4 8
CNSTP4 0
ASGNP4
line 545
;544:
;545:	s = (char*)string;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $172
JUMPV
LABELV $171
line 548
;546:
;547:	while (*s)
;548:	{
line 549
;549:		if (*s == cc)
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ADDRLP4 4
INDIRI1
CVII4 1
NEI4 $174
line 550
;550:			sp = s;
ADDRLP4 8
ADDRLP4 0
INDIRP4
ASGNP4
LABELV $174
line 551
;551:		s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 552
;552:	}
LABELV $172
line 547
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $171
line 553
;553:	if (cc == 0)
ADDRLP4 4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $176
line 554
;554:		sp = s;
ADDRLP4 8
ADDRLP4 0
INDIRP4
ASGNP4
LABELV $176
line 556
;555:
;556:	return sp;
ADDRLP4 8
INDIRP4
RETP4
LABELV $170
endproc Q_strrchr 12 0
export Q_strncpyz
proc Q_strncpyz 0 12
line 566
;557:}
;558:
;559:/*
;560:=============
;561:Q_strncpyz
;562: 
;563:Safe strncpy that ensures a trailing zero
;564:=============
;565:*/
;566:void Q_strncpyz( char *dest, const char *src, int destsize ) {
line 567
;567:	if ( !src ) {
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $179
line 568
;568:		Com_Error( ERR_FATAL, "Q_strncpyz: NULL src" );
CNSTI4 0
ARGI4
ADDRGP4 $181
ARGP4
ADDRGP4 Com_Error
CALLV
pop
line 569
;569:	}
LABELV $179
line 570
;570:	if ( destsize < 1 ) {
ADDRFP4 8
INDIRI4
CNSTI4 1
GEI4 $182
line 571
;571:		Com_Error(ERR_FATAL,"Q_strncpyz: destsize < 1" ); 
CNSTI4 0
ARGI4
ADDRGP4 $184
ARGP4
ADDRGP4 Com_Error
CALLV
pop
line 572
;572:	}
LABELV $182
line 574
;573:
;574:	strncpy( dest, src, destsize-1 );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
CVIU4 4
ARGU4
ADDRGP4 strncpy
CALLP4
pop
line 575
;575:    dest[destsize-1] = 0;
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
ADDRFP4 0
INDIRP4
ADDP4
CNSTI1 0
ASGNI1
line 576
;576:}
LABELV $178
endproc Q_strncpyz 0 12
export Q_stricmpn
proc Q_stricmpn 32 0
line 578
;577:                 
;578:int Q_stricmpn (const char *s1, const char *s2, int n) {
LABELV $186
line 581
;579:	int		c1, c2;
;580:	
;581:	do {
line 582
;582:		c1 = *s1++;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 8
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
INDIRI1
CVII4 1
ASGNI4
line 583
;583:		c2 = *s2++;
ADDRLP4 12
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 4
ADDRLP4 12
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 4
ADDRLP4 12
INDIRP4
INDIRI1
CVII4 1
ASGNI4
line 585
;584:
;585:		if (!n--) {
ADDRLP4 16
ADDRFP4 8
INDIRI4
ASGNI4
ADDRFP4 8
ADDRLP4 16
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 0
NEI4 $189
line 586
;586:			return 0;		// strings are equal until end point
CNSTI4 0
RETI4
ADDRGP4 $185
JUMPV
LABELV $189
line 589
;587:		}
;588:		
;589:		if (c1 != c2) {
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
EQI4 $191
line 590
;590:			if (c1 >= 'a' && c1 <= 'z') {
ADDRLP4 0
INDIRI4
CNSTI4 97
LTI4 $193
ADDRLP4 0
INDIRI4
CNSTI4 122
GTI4 $193
line 591
;591:				c1 -= ('a' - 'A');
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 32
SUBI4
ASGNI4
line 592
;592:			}
LABELV $193
line 593
;593:			if (c2 >= 'a' && c2 <= 'z') {
ADDRLP4 4
INDIRI4
CNSTI4 97
LTI4 $195
ADDRLP4 4
INDIRI4
CNSTI4 122
GTI4 $195
line 594
;594:				c2 -= ('a' - 'A');
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 32
SUBI4
ASGNI4
line 595
;595:			}
LABELV $195
line 596
;596:			if (c1 != c2) {
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
EQI4 $197
line 597
;597:				return c1 < c2 ? -1 : 1;
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
GEI4 $200
ADDRLP4 28
CNSTI4 -1
ASGNI4
ADDRGP4 $201
JUMPV
LABELV $200
ADDRLP4 28
CNSTI4 1
ASGNI4
LABELV $201
ADDRLP4 28
INDIRI4
RETI4
ADDRGP4 $185
JUMPV
LABELV $197
line 599
;598:			}
;599:		}
LABELV $191
line 600
;600:	} while (c1);
LABELV $187
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $186
line 602
;601:	
;602:	return 0;		// strings are equal
CNSTI4 0
RETI4
LABELV $185
endproc Q_stricmpn 32 0
export Q_strncmp
proc Q_strncmp 24 0
line 605
;603:}
;604:
;605:int Q_strncmp (const char *s1, const char *s2, int n) {
LABELV $203
line 608
;606:	int		c1, c2;
;607:	
;608:	do {
line 609
;609:		c1 = *s1++;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 8
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
INDIRI1
CVII4 1
ASGNI4
line 610
;610:		c2 = *s2++;
ADDRLP4 12
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 4
ADDRLP4 12
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 4
ADDRLP4 12
INDIRP4
INDIRI1
CVII4 1
ASGNI4
line 612
;611:
;612:		if (!n--) {
ADDRLP4 16
ADDRFP4 8
INDIRI4
ASGNI4
ADDRFP4 8
ADDRLP4 16
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 0
NEI4 $206
line 613
;613:			return 0;		// strings are equal until end point
CNSTI4 0
RETI4
ADDRGP4 $202
JUMPV
LABELV $206
line 616
;614:		}
;615:		
;616:		if (c1 != c2) {
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
EQI4 $208
line 617
;617:			return c1 < c2 ? -1 : 1;
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
GEI4 $211
ADDRLP4 20
CNSTI4 -1
ASGNI4
ADDRGP4 $212
JUMPV
LABELV $211
ADDRLP4 20
CNSTI4 1
ASGNI4
LABELV $212
ADDRLP4 20
INDIRI4
RETI4
ADDRGP4 $202
JUMPV
LABELV $208
line 619
;618:		}
;619:	} while (c1);
LABELV $204
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $203
line 621
;620:	
;621:	return 0;		// strings are equal
CNSTI4 0
RETI4
LABELV $202
endproc Q_strncmp 24 0
export Q_stricmp
proc Q_stricmp 4 12
line 624
;622:}
;623:
;624:int Q_stricmp (const char *s1, const char *s2) {
line 625
;625:	return Q_stricmpn (s1, s2, 99999);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 99999
ARGI4
ADDRLP4 0
ADDRGP4 Q_stricmpn
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
RETI4
LABELV $213
endproc Q_stricmp 4 12
export Q_strlwr
proc Q_strlwr 12 4
line 629
;626:}
;627:
;628:
;629:char *Q_strlwr( char *s1 ) {
line 632
;630:    char	*s;
;631:
;632:    s = s1;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $216
JUMPV
LABELV $215
line 633
;633:	while ( *s ) {
line 634
;634:		*s = tolower(*s);
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 8
ADDRGP4 tolower
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 8
INDIRI4
CVII1 4
ASGNI1
line 635
;635:		s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 636
;636:	}
LABELV $216
line 633
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $215
line 637
;637:    return s1;
ADDRFP4 0
INDIRP4
RETP4
LABELV $214
endproc Q_strlwr 12 4
export Q_strupr
proc Q_strupr 12 4
line 640
;638:}
;639:
;640:char *Q_strupr( char *s1 ) {
line 643
;641:    char	*s;
;642:
;643:    s = s1;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $220
JUMPV
LABELV $219
line 644
;644:	while ( *s ) {
line 645
;645:		*s = toupper(*s);
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 8
ADDRGP4 toupper
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 8
INDIRI4
CVII1 4
ASGNI1
line 646
;646:		s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 647
;647:	}
LABELV $220
line 644
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $219
line 648
;648:    return s1;
ADDRFP4 0
INDIRP4
RETP4
LABELV $218
endproc Q_strupr 12 4
export Q_strcat
proc Q_strcat 12 12
line 653
;649:}
;650:
;651:
;652:// never goes past bounds or leaves without a terminating 0
;653:void Q_strcat( char *dest, int size, const char *src ) {
line 656
;654:	int		l1;
;655:
;656:	l1 = strlen( dest );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 0
ADDRLP4 4
INDIRU4
CVUI4 4
ASGNI4
line 657
;657:	if ( l1 >= size ) {
ADDRLP4 0
INDIRI4
ADDRFP4 4
INDIRI4
LTI4 $223
line 658
;658:		Com_Error( ERR_FATAL, "Q_strcat: already overflowed" );
CNSTI4 0
ARGI4
ADDRGP4 $225
ARGP4
ADDRGP4 Com_Error
CALLV
pop
line 659
;659:	}
LABELV $223
line 660
;660:	Q_strncpyz( dest + l1, src, size - l1 );
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 4
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 661
;661:}
LABELV $222
endproc Q_strcat 12 12
export Q_PrintStrlen
proc Q_PrintStrlen 20 0
line 664
;662:
;663:
;664:int Q_PrintStrlen( const char *string ) {
line 668
;665:	int			len;
;666:	const char	*p;
;667:
;668:	if( !string ) {
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $227
line 669
;669:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $226
JUMPV
LABELV $227
line 672
;670:	}
;671:
;672:	len = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 673
;673:	p = string;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $230
JUMPV
LABELV $229
line 674
;674:	while( *p ) {
line 675
;675:		if( Q_IsColorString( p ) ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $232
ADDRLP4 12
CNSTI4 94
ASGNI4
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ADDRLP4 12
INDIRI4
NEI4 $232
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 0
EQI4 $232
ADDRLP4 16
INDIRI4
ADDRLP4 12
INDIRI4
EQI4 $232
line 676
;676:			p += 2;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 2
ADDP4
ASGNP4
line 677
;677:			continue;
ADDRGP4 $230
JUMPV
LABELV $232
line 679
;678:		}
;679:		p++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 680
;680:		len++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 681
;681:	}
LABELV $230
line 674
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $229
line 683
;682:
;683:	return len;
ADDRLP4 4
INDIRI4
RETI4
LABELV $226
endproc Q_PrintStrlen 20 0
export Q_CleanStr
proc Q_CleanStr 32 0
line 687
;684:}
;685:
;686:
;687:char *Q_CleanStr( char *string ) {
line 692
;688:	char*	d;
;689:	char*	s;
;690:	int		c;
;691:
;692:	s = string;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
line 693
;693:	d = string;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $236
JUMPV
LABELV $235
line 694
;694:	while ((c = *s) != 0 ) {
line 695
;695:		if ( Q_IsColorString( s ) ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $238
ADDRLP4 16
CNSTI4 94
ASGNI4
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ADDRLP4 16
INDIRI4
NEI4 $238
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 0
EQI4 $238
ADDRLP4 20
INDIRI4
ADDRLP4 16
INDIRI4
EQI4 $238
line 696
;696:			s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 697
;697:		}		
ADDRGP4 $239
JUMPV
LABELV $238
line 698
;698:		else if ( c >= 0x20 && c <= 0x7E ) {
ADDRLP4 4
INDIRI4
CNSTI4 32
LTI4 $240
ADDRLP4 4
INDIRI4
CNSTI4 126
GTI4 $240
line 699
;699:			*d++ = c;
ADDRLP4 28
ADDRLP4 8
INDIRP4
ASGNP4
ADDRLP4 8
ADDRLP4 28
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 4
INDIRI4
CVII1 4
ASGNI1
line 700
;700:		}
LABELV $240
LABELV $239
line 701
;701:		s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 702
;702:	}
LABELV $236
line 694
ADDRLP4 12
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 4
ADDRLP4 12
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
NEI4 $235
line 703
;703:	*d = '\0';
ADDRLP4 8
INDIRP4
CNSTI1 0
ASGNI1
line 705
;704:
;705:	return string;
ADDRFP4 0
INDIRP4
RETP4
LABELV $234
endproc Q_CleanStr 32 0
export Com_sprintf
proc Com_sprintf 32012 12
line 709
;706:}
;707:
;708:
;709:void QDECL Com_sprintf( char *dest, int size, const char *fmt, ...) {
line 714
;710:	int		len;
;711:	va_list		argptr;
;712:	char	bigbuffer[32000];	// big, but small enough to fit in PPC stack
;713:
;714:	va_start (argptr,fmt);
ADDRLP4 4
ADDRFP4 8+4
ASGNP4
line 715
;715:	len = vsprintf (bigbuffer,fmt,argptr);
ADDRLP4 8
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 32008
ADDRGP4 vsprintf
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 32008
INDIRI4
ASGNI4
line 716
;716:	va_end (argptr);
ADDRLP4 4
CNSTP4 0
ASGNP4
line 717
;717:	if ( len >= sizeof( bigbuffer ) ) {
ADDRLP4 0
INDIRI4
CVIU4 4
CNSTU4 32000
LTU4 $244
line 718
;718:		Com_Error( ERR_FATAL, "Com_sprintf: overflowed bigbuffer" );
CNSTI4 0
ARGI4
ADDRGP4 $246
ARGP4
ADDRGP4 Com_Error
CALLV
pop
line 719
;719:	}
LABELV $244
line 720
;720:	if (len >= size) {
ADDRLP4 0
INDIRI4
ADDRFP4 4
INDIRI4
LTI4 $247
line 721
;721:		Com_Printf ("Com_sprintf: overflow of %i in %i\n", len, size);
ADDRGP4 $249
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 Com_Printf
CALLV
pop
line 722
;722:	}
LABELV $247
line 723
;723:	Q_strncpyz (dest, bigbuffer, size );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 724
;724:}
LABELV $242
endproc Com_sprintf 32012 12
bss
align 1
LABELV $251
skip 64000
data
align 4
LABELV $252
byte 4 0
export va
code
proc va 12 12
line 736
;725:
;726:
;727:/*
;728:============
;729:va
;730:
;731:does a varargs printf into a temp buffer, so I don't need to have
;732:varargs versions of all text functions.
;733:FIXME: make this buffer size safe someday
;734:============
;735:*/
;736:char	* QDECL va( char *format, ... ) {
line 742
;737:	va_list		argptr;
;738:	static char		string[2][32000];	// in case va is called by nested functions
;739:	static int		index = 0;
;740:	char	*buf;
;741:
;742:	buf = string[index & 1];
ADDRLP4 4
CNSTI4 32000
ADDRGP4 $252
INDIRI4
CNSTI4 1
BANDI4
MULI4
ADDRGP4 $251
ADDP4
ASGNP4
line 743
;743:	index++;
ADDRLP4 8
ADDRGP4 $252
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 745
;744:
;745:	va_start (argptr, format);
ADDRLP4 0
ADDRFP4 0+4
ASGNP4
line 746
;746:	vsprintf (buf, format,argptr);
ADDRLP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 vsprintf
CALLI4
pop
line 747
;747:	va_end (argptr);
ADDRLP4 0
CNSTP4 0
ASGNP4
line 749
;748:
;749:	return buf;
ADDRLP4 4
INDIRP4
RETP4
LABELV $250
endproc va 12 12
bss
align 1
LABELV $255
skip 2048
data
align 4
LABELV $256
byte 4 0
export Info_ValueForKey
code
proc Info_ValueForKey 1052 8
line 770
;750:}
;751:
;752:
;753:/*
;754:=====================================================================
;755:
;756:  INFO STRINGS
;757:
;758:=====================================================================
;759:*/
;760:
;761:/*
;762:===============
;763:Info_ValueForKey
;764:
;765:Searches the string for the given
;766:key and returns the associated value, or an empty string.
;767:FIXME: overflow check?
;768:===============
;769:*/
;770:char *Info_ValueForKey( const char *s, const char *key ) {
line 777
;771:	char	pkey[MAX_INFO_KEY];
;772:	static	char value[2][MAX_INFO_VALUE];	// use two buffers so compares
;773:											// work without stomping on each other
;774:	static	int	valueindex = 0;
;775:	char	*o;
;776:	
;777:	if ( !s || !key ) {
ADDRLP4 1028
CNSTU4 0
ASGNU4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRLP4 1028
INDIRU4
EQU4 $259
ADDRFP4 4
INDIRP4
CVPU4 4
ADDRLP4 1028
INDIRU4
NEU4 $257
LABELV $259
line 778
;778:		return "";
ADDRGP4 $260
RETP4
ADDRGP4 $254
JUMPV
LABELV $257
line 781
;779:	}
;780:
;781:	if ( strlen( s ) >= MAX_INFO_STRING ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1032
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1032
INDIRU4
CNSTU4 1024
LTU4 $261
line 782
;782:		Com_Error( ERR_DROP, "Info_ValueForKey: oversize infostring" );
CNSTI4 1
ARGI4
ADDRGP4 $263
ARGP4
ADDRGP4 Com_Error
CALLV
pop
line 783
;783:	}
LABELV $261
line 785
;784:
;785:	valueindex ^= 1;
ADDRLP4 1036
ADDRGP4 $256
ASGNP4
ADDRLP4 1036
INDIRP4
ADDRLP4 1036
INDIRP4
INDIRI4
CNSTI4 1
BXORI4
ASGNI4
line 786
;786:	if (*s == '\\')
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 92
NEI4 $267
line 787
;787:		s++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRGP4 $267
JUMPV
LABELV $266
line 789
;788:	while (1)
;789:	{
line 790
;790:		o = pkey;
ADDRLP4 0
ADDRLP4 4
ASGNP4
ADDRGP4 $270
JUMPV
LABELV $269
line 792
;791:		while (*s != '\\')
;792:		{
line 793
;793:			if (!*s)
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $272
line 794
;794:				return "";
ADDRGP4 $260
RETP4
ADDRGP4 $254
JUMPV
LABELV $272
line 795
;795:			*o++ = *s++;
ADDRLP4 1040
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 1048
CNSTI4 1
ASGNI4
ADDRLP4 0
ADDRLP4 1040
INDIRP4
ADDRLP4 1048
INDIRI4
ADDP4
ASGNP4
ADDRLP4 1044
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 1044
INDIRP4
ADDRLP4 1048
INDIRI4
ADDP4
ASGNP4
ADDRLP4 1040
INDIRP4
ADDRLP4 1044
INDIRP4
INDIRI1
ASGNI1
line 796
;796:		}
LABELV $270
line 791
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 92
NEI4 $269
line 797
;797:		*o = 0;
ADDRLP4 0
INDIRP4
CNSTI1 0
ASGNI1
line 798
;798:		s++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 800
;799:
;800:		o = value[valueindex];
ADDRLP4 0
ADDRGP4 $256
INDIRI4
CNSTI4 10
LSHI4
ADDRGP4 $255
ADDP4
ASGNP4
ADDRGP4 $275
JUMPV
LABELV $274
line 803
;801:
;802:		while (*s != '\\' && *s)
;803:		{
line 804
;804:			*o++ = *s++;
ADDRLP4 1040
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 1048
CNSTI4 1
ASGNI4
ADDRLP4 0
ADDRLP4 1040
INDIRP4
ADDRLP4 1048
INDIRI4
ADDP4
ASGNP4
ADDRLP4 1044
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 1044
INDIRP4
ADDRLP4 1048
INDIRI4
ADDP4
ASGNP4
ADDRLP4 1040
INDIRP4
ADDRLP4 1044
INDIRP4
INDIRI1
ASGNI1
line 805
;805:		}
LABELV $275
line 802
ADDRLP4 1040
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 1040
INDIRI4
CNSTI4 92
EQI4 $277
ADDRLP4 1040
INDIRI4
CNSTI4 0
NEI4 $274
LABELV $277
line 806
;806:		*o = 0;
ADDRLP4 0
INDIRP4
CNSTI1 0
ASGNI1
line 808
;807:
;808:		if (!Q_stricmp (key, pkey) )
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 1044
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1044
INDIRI4
CNSTI4 0
NEI4 $278
line 809
;809:			return value[valueindex];
ADDRGP4 $256
INDIRI4
CNSTI4 10
LSHI4
ADDRGP4 $255
ADDP4
RETP4
ADDRGP4 $254
JUMPV
LABELV $278
line 811
;810:
;811:		if (!*s)
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $280
line 812
;812:			break;
ADDRGP4 $268
JUMPV
LABELV $280
line 813
;813:		s++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 814
;814:	}
LABELV $267
line 788
ADDRGP4 $266
JUMPV
LABELV $268
line 816
;815:
;816:	return "";
ADDRGP4 $260
RETP4
LABELV $254
endproc Info_ValueForKey 1052 8
export Info_NextPair
proc Info_NextPair 20 0
line 827
;817:}
;818:
;819:
;820:/*
;821:===================
;822:Info_NextPair
;823:
;824:Used to itterate through all the key/value pairs in an info string
;825:===================
;826:*/
;827:void Info_NextPair( const char **head, char key[MAX_INFO_KEY], char value[MAX_INFO_VALUE] ) {
line 831
;828:	char	*o;
;829:	const char	*s;
;830:
;831:	s = *head;
ADDRLP4 0
ADDRFP4 0
INDIRP4
INDIRP4
ASGNP4
line 833
;832:
;833:	if ( *s == '\\' ) {
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 92
NEI4 $283
line 834
;834:		s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 835
;835:	}
LABELV $283
line 836
;836:	key[0] = 0;
ADDRFP4 4
INDIRP4
CNSTI1 0
ASGNI1
line 837
;837:	value[0] = 0;
ADDRFP4 8
INDIRP4
CNSTI1 0
ASGNI1
line 839
;838:
;839:	o = key;
ADDRLP4 4
ADDRFP4 4
INDIRP4
ASGNP4
ADDRGP4 $286
JUMPV
LABELV $285
line 840
;840:	while ( *s != '\\' ) {
line 841
;841:		if ( !*s ) {
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $288
line 842
;842:			*o = 0;
ADDRLP4 4
INDIRP4
CNSTI1 0
ASGNI1
line 843
;843:			*head = s;
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRP4
ASGNP4
line 844
;844:			return;
ADDRGP4 $282
JUMPV
LABELV $288
line 846
;845:		}
;846:		*o++ = *s++;
ADDRLP4 8
ADDRLP4 4
INDIRP4
ASGNP4
ADDRLP4 16
CNSTI4 1
ASGNI4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
ASGNP4
ADDRLP4 12
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 12
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI1
ASGNI1
line 847
;847:	}
LABELV $286
line 840
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 92
NEI4 $285
line 848
;848:	*o = 0;
ADDRLP4 4
INDIRP4
CNSTI1 0
ASGNI1
line 849
;849:	s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 851
;850:
;851:	o = value;
ADDRLP4 4
ADDRFP4 8
INDIRP4
ASGNP4
ADDRGP4 $291
JUMPV
LABELV $290
line 852
;852:	while ( *s != '\\' && *s ) {
line 853
;853:		*o++ = *s++;
ADDRLP4 8
ADDRLP4 4
INDIRP4
ASGNP4
ADDRLP4 16
CNSTI4 1
ASGNI4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
ASGNP4
ADDRLP4 12
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 12
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI1
ASGNI1
line 854
;854:	}
LABELV $291
line 852
ADDRLP4 8
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 92
EQI4 $293
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $290
LABELV $293
line 855
;855:	*o = 0;
ADDRLP4 4
INDIRP4
CNSTI1 0
ASGNI1
line 857
;856:
;857:	*head = s;
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRP4
ASGNP4
line 858
;858:}
LABELV $282
endproc Info_NextPair 20 0
export Info_RemoveKey
proc Info_RemoveKey 2076 8
line 866
;859:
;860:
;861:/*
;862:===================
;863:Info_RemoveKey
;864:===================
;865:*/
;866:void Info_RemoveKey( char *s, const char *key ) {
line 872
;867:	char	*start;
;868:	char	pkey[MAX_INFO_KEY];
;869:	char	value[MAX_INFO_VALUE];
;870:	char	*o;
;871:
;872:	if ( strlen( s ) >= MAX_INFO_STRING ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 2056
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 2056
INDIRU4
CNSTU4 1024
LTU4 $295
line 873
;873:		Com_Error( ERR_DROP, "Info_RemoveKey: oversize infostring" );
CNSTI4 1
ARGI4
ADDRGP4 $297
ARGP4
ADDRGP4 Com_Error
CALLV
pop
line 874
;874:	}
LABELV $295
line 876
;875:
;876:	if (strchr (key, '\\')) {
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 92
ARGI4
ADDRLP4 2060
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 2060
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $301
line 877
;877:		return;
ADDRGP4 $294
JUMPV
LABELV $300
line 881
;878:	}
;879:
;880:	while (1)
;881:	{
line 882
;882:		start = s;
ADDRLP4 1028
ADDRFP4 0
INDIRP4
ASGNP4
line 883
;883:		if (*s == '\\')
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 92
NEI4 $303
line 884
;884:			s++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
LABELV $303
line 885
;885:		o = pkey;
ADDRLP4 0
ADDRLP4 4
ASGNP4
ADDRGP4 $306
JUMPV
LABELV $305
line 887
;886:		while (*s != '\\')
;887:		{
line 888
;888:			if (!*s)
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $308
line 889
;889:				return;
ADDRGP4 $294
JUMPV
LABELV $308
line 890
;890:			*o++ = *s++;
ADDRLP4 2064
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 2072
CNSTI4 1
ASGNI4
ADDRLP4 0
ADDRLP4 2064
INDIRP4
ADDRLP4 2072
INDIRI4
ADDP4
ASGNP4
ADDRLP4 2068
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 2068
INDIRP4
ADDRLP4 2072
INDIRI4
ADDP4
ASGNP4
ADDRLP4 2064
INDIRP4
ADDRLP4 2068
INDIRP4
INDIRI1
ASGNI1
line 891
;891:		}
LABELV $306
line 886
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 92
NEI4 $305
line 892
;892:		*o = 0;
ADDRLP4 0
INDIRP4
CNSTI1 0
ASGNI1
line 893
;893:		s++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 895
;894:
;895:		o = value;
ADDRLP4 0
ADDRLP4 1032
ASGNP4
ADDRGP4 $311
JUMPV
LABELV $310
line 897
;896:		while (*s != '\\' && *s)
;897:		{
line 898
;898:			if (!*s)
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $313
line 899
;899:				return;
ADDRGP4 $294
JUMPV
LABELV $313
line 900
;900:			*o++ = *s++;
ADDRLP4 2064
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 2072
CNSTI4 1
ASGNI4
ADDRLP4 0
ADDRLP4 2064
INDIRP4
ADDRLP4 2072
INDIRI4
ADDP4
ASGNP4
ADDRLP4 2068
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 2068
INDIRP4
ADDRLP4 2072
INDIRI4
ADDP4
ASGNP4
ADDRLP4 2064
INDIRP4
ADDRLP4 2068
INDIRP4
INDIRI1
ASGNI1
line 901
;901:		}
LABELV $311
line 896
ADDRLP4 2064
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 2064
INDIRI4
CNSTI4 92
EQI4 $315
ADDRLP4 2064
INDIRI4
CNSTI4 0
NEI4 $310
LABELV $315
line 902
;902:		*o = 0;
ADDRLP4 0
INDIRP4
CNSTI1 0
ASGNI1
line 904
;903:
;904:		if (!strcmp (key, pkey) )
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 2068
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 2068
INDIRI4
CNSTI4 0
NEI4 $316
line 905
;905:		{
line 906
;906:			strcpy (start, s);	// remove this part
ADDRLP4 1028
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 907
;907:			return;
ADDRGP4 $294
JUMPV
LABELV $316
line 910
;908:		}
;909:
;910:		if (!*s)
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $318
line 911
;911:			return;
ADDRGP4 $294
JUMPV
LABELV $318
line 912
;912:	}
LABELV $301
line 880
ADDRGP4 $300
JUMPV
line 914
;913:
;914:}
LABELV $294
endproc Info_RemoveKey 2076 8
export Info_Validate
proc Info_Validate 8 8
line 925
;915:
;916:
;917:/*
;918:==================
;919:Info_Validate
;920:
;921:Some characters are illegal in info strings because they
;922:can mess up the server's parsing
;923:==================
;924:*/
;925:qboolean Info_Validate( const char *s ) {
line 926
;926:	if ( strchr( s, '\"' ) ) {
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 34
ARGI4
ADDRLP4 0
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $321
line 927
;927:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $320
JUMPV
LABELV $321
line 929
;928:	}
;929:	if ( strchr( s, ';' ) ) {
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 59
ARGI4
ADDRLP4 4
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $323
line 930
;930:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $320
JUMPV
LABELV $323
line 932
;931:	}
;932:	return qtrue;
CNSTI4 1
RETI4
LABELV $320
endproc Info_Validate 8 8
export Info_SetValueForKey
proc Info_SetValueForKey 1068 20
line 942
;933:}
;934:
;935:/*
;936:==================
;937:Info_SetValueForKey
;938:
;939:Changes or adds a key/value pair
;940:==================
;941:*/
;942:void Info_SetValueForKey( char *s, const char *key, const char *value ) {
line 945
;943:	char	newi[MAX_INFO_STRING];
;944:
;945:	if ( strlen( s ) >= MAX_INFO_STRING ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1024
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1024
INDIRU4
CNSTU4 1024
LTU4 $326
line 946
;946:		Com_Error( ERR_DROP, "Info_SetValueForKey: oversize infostring" );
CNSTI4 1
ARGI4
ADDRGP4 $328
ARGP4
ADDRGP4 Com_Error
CALLV
pop
line 947
;947:	}
LABELV $326
line 949
;948:
;949:	if (strchr (key, '\\') || strchr (value, '\\'))
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 92
ARGI4
ADDRLP4 1028
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 1028
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $331
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 92
ARGI4
ADDRLP4 1032
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 1032
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $329
LABELV $331
line 950
;950:	{
line 951
;951:		Com_Printf ("Can't use keys or values with a \\\n");
ADDRGP4 $332
ARGP4
ADDRGP4 Com_Printf
CALLV
pop
line 952
;952:		return;
ADDRGP4 $325
JUMPV
LABELV $329
line 955
;953:	}
;954:
;955:	if (strchr (key, ';') || strchr (value, ';'))
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 59
ARGI4
ADDRLP4 1036
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 1036
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $335
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 59
ARGI4
ADDRLP4 1040
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 1040
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $333
LABELV $335
line 956
;956:	{
line 957
;957:		Com_Printf ("Can't use keys or values with a semicolon\n");
ADDRGP4 $336
ARGP4
ADDRGP4 Com_Printf
CALLV
pop
line 958
;958:		return;
ADDRGP4 $325
JUMPV
LABELV $333
line 961
;959:	}
;960:
;961:	if (strchr (key, '\"') || strchr (value, '\"'))
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 34
ARGI4
ADDRLP4 1044
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 1044
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $339
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 34
ARGI4
ADDRLP4 1048
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 1048
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $337
LABELV $339
line 962
;962:	{
line 963
;963:		Com_Printf ("Can't use keys or values with a \"\n");
ADDRGP4 $340
ARGP4
ADDRGP4 Com_Printf
CALLV
pop
line 964
;964:		return;
ADDRGP4 $325
JUMPV
LABELV $337
line 967
;965:	}
;966:
;967:	Info_RemoveKey (s, key);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 Info_RemoveKey
CALLV
pop
line 968
;968:	if (!value || !strlen(value))
ADDRLP4 1052
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 1052
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $343
ADDRLP4 1052
INDIRP4
ARGP4
ADDRLP4 1056
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1056
INDIRU4
CNSTU4 0
NEU4 $341
LABELV $343
line 969
;969:		return;
ADDRGP4 $325
JUMPV
LABELV $341
line 971
;970:
;971:	Com_sprintf (newi, sizeof(newi), "\\%s\\%s", key, value);
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $344
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 973
;972:
;973:	if (strlen(newi) + strlen(s) > MAX_INFO_STRING)
ADDRLP4 0
ARGP4
ADDRLP4 1060
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1064
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1060
INDIRU4
ADDRLP4 1064
INDIRU4
ADDU4
CNSTU4 1024
LEU4 $345
line 974
;974:	{
line 975
;975:		Com_Printf ("Info string length exceeded on %s\n", key);
ADDRGP4 $347
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 Com_Printf
CALLV
pop
line 976
;976:		return;
ADDRGP4 $325
JUMPV
LABELV $345
line 979
;977:	}
;978:
;979:	strcat (s, newi);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 strcat
CALLP4
pop
line 980
;980:}
LABELV $325
endproc Info_SetValueForKey 1068 20
bss
align 4
LABELV com_lines
skip 4
align 1
LABELV com_token
skip 1024
align 4
LABELV _LittleFloat
skip 4
align 4
LABELV _BigFloat
skip 4
align 4
LABELV _LittleLong
skip 4
align 4
LABELV _BigLong
skip 4
align 4
LABELV _LittleShort
skip 4
align 4
LABELV _BigShort
skip 4
import Com_Printf
import Com_Error
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $347
byte 1 73
byte 1 110
byte 1 102
byte 1 111
byte 1 32
byte 1 115
byte 1 116
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 108
byte 1 101
byte 1 110
byte 1 103
byte 1 116
byte 1 104
byte 1 32
byte 1 101
byte 1 120
byte 1 99
byte 1 101
byte 1 101
byte 1 100
byte 1 101
byte 1 100
byte 1 32
byte 1 111
byte 1 110
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $344
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $340
byte 1 67
byte 1 97
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 117
byte 1 115
byte 1 101
byte 1 32
byte 1 107
byte 1 101
byte 1 121
byte 1 115
byte 1 32
byte 1 111
byte 1 114
byte 1 32
byte 1 118
byte 1 97
byte 1 108
byte 1 117
byte 1 101
byte 1 115
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 97
byte 1 32
byte 1 34
byte 1 10
byte 1 0
align 1
LABELV $336
byte 1 67
byte 1 97
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 117
byte 1 115
byte 1 101
byte 1 32
byte 1 107
byte 1 101
byte 1 121
byte 1 115
byte 1 32
byte 1 111
byte 1 114
byte 1 32
byte 1 118
byte 1 97
byte 1 108
byte 1 117
byte 1 101
byte 1 115
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 97
byte 1 32
byte 1 115
byte 1 101
byte 1 109
byte 1 105
byte 1 99
byte 1 111
byte 1 108
byte 1 111
byte 1 110
byte 1 10
byte 1 0
align 1
LABELV $332
byte 1 67
byte 1 97
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 117
byte 1 115
byte 1 101
byte 1 32
byte 1 107
byte 1 101
byte 1 121
byte 1 115
byte 1 32
byte 1 111
byte 1 114
byte 1 32
byte 1 118
byte 1 97
byte 1 108
byte 1 117
byte 1 101
byte 1 115
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 97
byte 1 32
byte 1 92
byte 1 10
byte 1 0
align 1
LABELV $328
byte 1 73
byte 1 110
byte 1 102
byte 1 111
byte 1 95
byte 1 83
byte 1 101
byte 1 116
byte 1 86
byte 1 97
byte 1 108
byte 1 117
byte 1 101
byte 1 70
byte 1 111
byte 1 114
byte 1 75
byte 1 101
byte 1 121
byte 1 58
byte 1 32
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 115
byte 1 105
byte 1 122
byte 1 101
byte 1 32
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 115
byte 1 116
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $297
byte 1 73
byte 1 110
byte 1 102
byte 1 111
byte 1 95
byte 1 82
byte 1 101
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 75
byte 1 101
byte 1 121
byte 1 58
byte 1 32
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 115
byte 1 105
byte 1 122
byte 1 101
byte 1 32
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 115
byte 1 116
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $263
byte 1 73
byte 1 110
byte 1 102
byte 1 111
byte 1 95
byte 1 86
byte 1 97
byte 1 108
byte 1 117
byte 1 101
byte 1 70
byte 1 111
byte 1 114
byte 1 75
byte 1 101
byte 1 121
byte 1 58
byte 1 32
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 115
byte 1 105
byte 1 122
byte 1 101
byte 1 32
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 115
byte 1 116
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $260
byte 1 0
align 1
LABELV $249
byte 1 67
byte 1 111
byte 1 109
byte 1 95
byte 1 115
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 102
byte 1 58
byte 1 32
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 102
byte 1 108
byte 1 111
byte 1 119
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 105
byte 1 110
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $246
byte 1 67
byte 1 111
byte 1 109
byte 1 95
byte 1 115
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 102
byte 1 58
byte 1 32
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 102
byte 1 108
byte 1 111
byte 1 119
byte 1 101
byte 1 100
byte 1 32
byte 1 98
byte 1 105
byte 1 103
byte 1 98
byte 1 117
byte 1 102
byte 1 102
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $225
byte 1 81
byte 1 95
byte 1 115
byte 1 116
byte 1 114
byte 1 99
byte 1 97
byte 1 116
byte 1 58
byte 1 32
byte 1 97
byte 1 108
byte 1 114
byte 1 101
byte 1 97
byte 1 100
byte 1 121
byte 1 32
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 102
byte 1 108
byte 1 111
byte 1 119
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $184
byte 1 81
byte 1 95
byte 1 115
byte 1 116
byte 1 114
byte 1 110
byte 1 99
byte 1 112
byte 1 121
byte 1 122
byte 1 58
byte 1 32
byte 1 100
byte 1 101
byte 1 115
byte 1 116
byte 1 115
byte 1 105
byte 1 122
byte 1 101
byte 1 32
byte 1 60
byte 1 32
byte 1 49
byte 1 0
align 1
LABELV $181
byte 1 81
byte 1 95
byte 1 115
byte 1 116
byte 1 114
byte 1 110
byte 1 99
byte 1 112
byte 1 121
byte 1 122
byte 1 58
byte 1 32
byte 1 78
byte 1 85
byte 1 76
byte 1 76
byte 1 32
byte 1 115
byte 1 114
byte 1 99
byte 1 0
align 1
LABELV $145
byte 1 41
byte 1 0
align 1
LABELV $140
byte 1 40
byte 1 0
align 1
LABELV $121
byte 1 77
byte 1 97
byte 1 116
byte 1 99
byte 1 104
byte 1 84
byte 1 111
byte 1 107
byte 1 101
byte 1 110
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 33
byte 1 61
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $40
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 0
