export Weapon_Fist
code
proc Weapon_Fist 0 0
file "..\g_weapon.c"
line 21
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// g_weapon.c 
;4:// perform the server side effects of a weapon firing
;5:
;6:#include "g_local.h"
;7:
;8:static	float	s_quadFactor;
;9:static	vec3_t	forward, right, up;
;10:static	vec3_t	muzzle;
;11:
;12:
;13:/*
;14:======================================================================
;15:
;16:GAUNTLET
;17:
;18:======================================================================
;19:*/
;20:
;21:void Weapon_Fist( gentity_t *ent ) {
line 23
;22:
;23:}
LABELV $46
endproc Weapon_Fist 0 0
export Weapon_Gauntlet
proc Weapon_Gauntlet 0 0
line 25
;24:
;25:void Weapon_Gauntlet( gentity_t *ent ) {
line 27
;26:
;27:}
LABELV $47
endproc Weapon_Gauntlet 0 0
export CheckMeleeAttack
proc CheckMeleeAttack 108 32
line 34
;28:
;29:/*
;30:===============
;31:CheckGauntletAttack
;32:===============
;33:*/
;34:qboolean CheckMeleeAttack( gentity_t *ent ) {
line 42
;35:	trace_t		tr;
;36:	vec3_t		end;
;37:	gentity_t	*tent;
;38:	gentity_t	*traceEnt;
;39:	int			damage;
;40:
;41:	// set aiming directions
;42:	AngleVectors (ent->client->ps.viewangles, forward, right, up);
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 152
ADDP4
ARGP4
ADDRGP4 forward
ARGP4
ADDRGP4 right
ARGP4
ADDRGP4 up
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 44
;43:
;44:	CalcMuzzlePoint ( ent, forward, right, up, muzzle, end );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 forward
ARGP4
ADDRGP4 right
ARGP4
ADDRGP4 up
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRLP4 60
ARGP4
ADDRGP4 CalcMuzzlePoint
CALLV
pop
line 46
;45:
;46:	VectorMA (muzzle, 32, forward, end);
ADDRLP4 80
CNSTF4 1107296256
ASGNF4
ADDRLP4 60
ADDRGP4 muzzle
INDIRF4
ADDRLP4 80
INDIRF4
ADDRGP4 forward
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 60+4
ADDRGP4 muzzle+4
INDIRF4
ADDRLP4 80
INDIRF4
ADDRGP4 forward+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 60+8
ADDRGP4 muzzle+8
INDIRF4
CNSTF4 1107296256
ADDRGP4 forward+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 48
;47:
;48:	trap_Trace (&tr, muzzle, NULL, NULL, end, ent->s.number, MASK_SHOT);
ADDRLP4 4
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRLP4 84
CNSTP4 0
ASGNP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRLP4 60
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 49
;49:	if ( tr.surfaceFlags & SURF_NOIMPACT ) {
ADDRLP4 4+44
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $55
line 50
;50:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $48
JUMPV
LABELV $55
line 53
;51:	}
;52:
;53:	traceEnt = &g_entities[ tr.entityNum ];
ADDRLP4 0
CNSTI4 792
ADDRLP4 4+52
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 56
;54:
;55:	// send blood impact
;56:	if ( traceEnt->takedamage && traceEnt->client ) {		
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
EQI4 $59
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $59
line 57
;57:		if(traceEnt->client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS)		
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $61
line 58
;58:			tent = G_TempEntity( tr.endpos, EV_MISSILE_HIT );
ADDRLP4 4+12
ARGP4
CNSTI4 49
ARGI4
ADDRLP4 92
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 92
INDIRP4
ASGNP4
ADDRGP4 $62
JUMPV
LABELV $61
line 60
;59:		else
;60:			tent = G_TempEntity( tr.endpos, EV_MISSILE_HIT_ROBOT );		
ADDRLP4 4+12
ARGP4
CNSTI4 71
ARGI4
ADDRLP4 96
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 96
INDIRP4
ASGNP4
LABELV $62
line 61
;61:		tent->s.otherEntityNum = traceEnt->s.number;
ADDRLP4 72
INDIRP4
CNSTI4 140
ADDP4
ADDRLP4 0
INDIRP4
INDIRI4
ASGNI4
line 62
;62:		tent->s.eventParm = DirToByte( tr.plane.normal );
ADDRLP4 4+24
ARGP4
ADDRLP4 100
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRLP4 72
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 100
INDIRI4
ASGNI4
line 63
;63:		tent->s.weapon = ent->s.weapon;
ADDRLP4 104
CNSTI4 192
ASGNI4
ADDRLP4 72
INDIRP4
ADDRLP4 104
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 104
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 64
;64:	}
LABELV $59
line 66
;65:
;66:	if ( !traceEnt->takedamage) {
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
NEI4 $66
line 67
;67:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $48
JUMPV
LABELV $66
line 70
;68:	}
;69:
;70:	if (ent->client->ps.powerups[PW_QUAD] ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 316
ADDP4
INDIRI4
CNSTI4 0
EQI4 $68
line 71
;71:		G_AddEvent( ent, EV_POWERUP_QUAD, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 59
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 72
;72:		s_quadFactor = g_quadfactor.value;
ADDRGP4 s_quadFactor
ADDRGP4 g_quadfactor+8
INDIRF4
ASGNF4
line 73
;73:	} else {
ADDRGP4 $69
JUMPV
LABELV $68
line 74
;74:		s_quadFactor = 1;
ADDRGP4 s_quadFactor
CNSTF4 1065353216
ASGNF4
line 75
;75:	}
LABELV $69
line 77
;76:
;77:	if(ent->s.weapon == WP_GAUNTLET)
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 1
NEI4 $71
line 78
;78:	{
line 79
;79:		damage = 25 * s_quadFactor;
ADDRLP4 76
CNSTF4 1103626240
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 80
;80:		G_Damage( traceEnt, ent, ent, forward, tr.endpos, damage, 0, MOD_GAUNTLET );
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRGP4 forward
ARGP4
ADDRLP4 4+12
ARGP4
ADDRLP4 76
INDIRI4
ARGI4
CNSTI4 0
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 81
;81:		if(ent->client->ps.ammo[WP_GAUNTLET] > 0)
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 380
ADDP4
INDIRI4
CNSTI4 0
LEI4 $72
line 82
;82:			G_Damage( traceEnt, ent, ent, forward, tr.endpos, damage, DAMAGE_NO_BLEEDING, MOD_GAUNTLET );
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 96
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 96
INDIRP4
ARGP4
ADDRLP4 96
INDIRP4
ARGP4
ADDRGP4 forward
ARGP4
ADDRLP4 4+12
ARGP4
ADDRLP4 76
INDIRI4
ARGI4
CNSTI4 16
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 83
;83:	}
ADDRGP4 $72
JUMPV
LABELV $71
line 84
;84:	else if(ent->s.weapon == WP_NONE)
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 0
NEI4 $77
line 85
;85:	{
line 86
;86:		damage = 10 * s_quadFactor;
ADDRLP4 76
CNSTF4 1092616192
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 87
;87:		G_Damage( traceEnt, ent, ent, forward, tr.endpos, damage, DAMAGE_NO_BLEEDING, MOD_GAUNTLET );
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRGP4 forward
ARGP4
ADDRLP4 4+12
ARGP4
ADDRLP4 76
INDIRI4
ARGI4
CNSTI4 16
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 88
;88:	}
LABELV $77
LABELV $72
line 90
;89:
;90:	return qtrue;
CNSTI4 1
RETI4
LABELV $48
endproc CheckMeleeAttack 108 32
export SnapVectorTowards
proc SnapVectorTowards 12 0
line 112
;91:}
;92:
;93:
;94:/*
;95:======================================================================
;96:
;97:MACHINEGUN
;98:
;99:======================================================================
;100:*/
;101:
;102:/*
;103:======================
;104:SnapVectorTowards
;105:
;106:Round a vector to integers for more efficient network
;107:transmission, but make sure that it rounds towards a given point
;108:rather than blindly truncating.  This prevents it from truncating 
;109:into a wall.
;110:======================
;111:*/
;112:void SnapVectorTowards( vec3_t v, vec3_t to ) {
line 115
;113:	int		i;
;114:
;115:	for ( i = 0 ; i < 3 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $81
line 116
;116:		if ( to[i] <= v[i] ) {
ADDRLP4 4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 4
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
GTF4 $85
line 117
;117:			v[i] = (int)v[i];
ADDRLP4 8
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 118
;118:		} else {
ADDRGP4 $86
JUMPV
LABELV $85
line 119
;119:			v[i] = (int)v[i] + 1;
ADDRLP4 8
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CVFI4 4
CNSTI4 1
ADDI4
CVIF4 4
ASGNF4
line 120
;120:		}
LABELV $86
line 121
;121:	}
LABELV $82
line 115
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $81
line 122
;122:}
LABELV $80
endproc SnapVectorTowards 12 0
export Bullet_Fire
proc Bullet_Fire 144 32
line 128
;123:
;124:#define MACHINEGUN_SPREAD	200
;125:#define	MACHINEGUN_DAMAGE	7
;126:#define	MACHINEGUN_TEAM_DAMAGE	5		// wimpier MG in teamplay
;127:
;128:void Bullet_Fire (gentity_t *ent, float spread, int damage ) {
line 136
;129:	trace_t		tr;
;130:	vec3_t		end;
;131:	float		r;
;132:	float		u;
;133:	gentity_t		*tent;
;134:	gentity_t		*traceEnt;
;135:
;136:	damage *= s_quadFactor;
ADDRFP4 8
ADDRFP4 8
INDIRI4
CVIF4 4
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 138
;137:
;138:	r = crandom()*spread;
ADDRLP4 84
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 76
CNSTF4 1073741824
ADDRLP4 84
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 4
INDIRF4
MULF4
ASGNF4
line 139
;139:	u = crandom()*spread;
ADDRLP4 88
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 80
CNSTF4 1073741824
ADDRLP4 88
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 4
INDIRF4
MULF4
ASGNF4
line 140
;140:	VectorMA (muzzle, 8192, forward, end);
ADDRLP4 92
CNSTF4 1174405120
ASGNF4
ADDRLP4 4
ADDRGP4 muzzle
INDIRF4
ADDRLP4 92
INDIRF4
ADDRGP4 forward
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+4
ADDRGP4 muzzle+4
INDIRF4
ADDRLP4 92
INDIRF4
ADDRGP4 forward+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+8
ADDRGP4 muzzle+8
INDIRF4
CNSTF4 1174405120
ADDRGP4 forward+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 141
;141:	VectorMA (end, r, right, end);
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRGP4 right
INDIRF4
ADDRLP4 76
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 4+4
INDIRF4
ADDRGP4 right+4
INDIRF4
ADDRLP4 76
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
ADDRGP4 right+8
INDIRF4
ADDRLP4 76
INDIRF4
MULF4
ADDF4
ASGNF4
line 142
;142:	VectorMA (end, u, up, end);
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRGP4 up
INDIRF4
ADDRLP4 80
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 4+4
INDIRF4
ADDRGP4 up+4
INDIRF4
ADDRLP4 80
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
ADDRGP4 up+8
INDIRF4
ADDRLP4 80
INDIRF4
MULF4
ADDF4
ASGNF4
line 144
;143:
;144:	trap_Trace (&tr, muzzle, NULL, NULL, end, ent->s.number, MASK_SHOT);
ADDRLP4 20
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRLP4 104
CNSTP4 0
ASGNP4
ADDRLP4 104
INDIRP4
ARGP4
ADDRLP4 104
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 145
;145:	if ( tr.surfaceFlags & SURF_NOIMPACT ) {
ADDRLP4 20+44
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $106
line 146
;146:		return;
ADDRGP4 $87
JUMPV
LABELV $106
line 149
;147:	}
;148:
;149:	traceEnt = &g_entities[ tr.entityNum ];
ADDRLP4 16
CNSTI4 792
ADDRLP4 20+52
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 152
;150:
;151:	// snap the endpos to integers, but nudged towards the line
;152:	SnapVectorTowards( tr.endpos, muzzle );
ADDRLP4 20+12
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRGP4 SnapVectorTowards
CALLV
pop
line 155
;153:
;154:	// send bullet impact
;155:	if ( traceEnt->takedamage && traceEnt->client ) {
ADDRLP4 16
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
EQI4 $111
ADDRLP4 16
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $111
line 156
;156:		if(traceEnt->client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS)		
ADDRLP4 16
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $113
line 157
;157:			tent = G_TempEntity( tr.endpos, EV_BULLET_HIT_FLESH );
ADDRLP4 20+12
ARGP4
CNSTI4 47
ARGI4
ADDRLP4 112
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 112
INDIRP4
ASGNP4
ADDRGP4 $114
JUMPV
LABELV $113
line 159
;158:		else
;159:			tent = G_TempEntity( tr.endpos, EV_BULLET_HIT_ROBOT );
ADDRLP4 20+12
ARGP4
CNSTI4 70
ARGI4
ADDRLP4 116
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 116
INDIRP4
ASGNP4
LABELV $114
line 160
;160:		tent->s.eventParm = traceEnt->s.number;
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 16
INDIRP4
INDIRI4
ASGNI4
line 161
;161:		if( LogAccuracyHit( traceEnt, ent ) ) {
ADDRLP4 16
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 120
ADDRGP4 LogAccuracyHit
CALLI4
ASGNI4
ADDRLP4 120
INDIRI4
CNSTI4 0
EQI4 $112
line 162
;162:			ent->client->ps.persistant[PERS_ACCURACY_HITS]++;
ADDRLP4 124
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 300
ADDP4
ASGNP4
ADDRLP4 124
INDIRP4
ADDRLP4 124
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 163
;163:		}
line 164
;164:	} else {
ADDRGP4 $112
JUMPV
LABELV $111
line 165
;165:		if(traceEnt->takedamage == -1)
ADDRLP4 16
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 -1
NEI4 $119
line 166
;166:			tent = G_TempEntity( tr.endpos, EV_BULLET_HIT_CORPSE );
ADDRLP4 20+12
ARGP4
CNSTI4 69
ARGI4
ADDRLP4 112
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 112
INDIRP4
ASGNP4
ADDRGP4 $120
JUMPV
LABELV $119
line 168
;167:		else
;168:			tent = G_TempEntity( tr.endpos, EV_BULLET_HIT_WALL );
ADDRLP4 20+12
ARGP4
CNSTI4 48
ARGI4
ADDRLP4 116
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 116
INDIRP4
ASGNP4
LABELV $120
line 169
;169:		tent->s.eventParm = DirToByte( tr.plane.normal );
ADDRLP4 20+24
ARGP4
ADDRLP4 120
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 120
INDIRI4
ASGNI4
line 170
;170:	}
LABELV $112
line 171
;171:	tent->s.otherEntityNum = ent->s.number;
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 173
;172:
;173:	VectorCopy( muzzle, tent->s.origin2 );
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ADDRGP4 muzzle
INDIRB
ASGNB 12
line 175
;174:	// move origin a bit to come closer to the drawn gun muzzle
;175:	VectorMA( tent->s.origin2, 4, right, tent->s.origin2 );
ADDRLP4 112
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 112
INDIRP4
ADDRLP4 112
INDIRP4
INDIRF4
CNSTF4 1082130432
ADDRGP4 right
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 116
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 116
INDIRP4
ADDRLP4 116
INDIRP4
INDIRF4
CNSTF4 1082130432
ADDRGP4 right+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 120
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
ASGNP4
ADDRLP4 120
INDIRP4
ADDRLP4 120
INDIRP4
INDIRF4
CNSTF4 1082130432
ADDRGP4 right+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 176
;176:	VectorMA( tent->s.origin2, -1, up, tent->s.origin2 );
ADDRLP4 124
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 124
INDIRP4
ADDRLP4 124
INDIRP4
INDIRF4
CNSTF4 3212836864
ADDRGP4 up
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 128
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 128
INDIRP4
ADDRLP4 128
INDIRP4
INDIRF4
CNSTF4 3212836864
ADDRGP4 up+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 132
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
ASGNP4
ADDRLP4 132
INDIRP4
ADDRLP4 132
INDIRP4
INDIRF4
CNSTF4 3212836864
ADDRGP4 up+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 178
;177:
;178:	tent->s.clientNum = ent->s.clientNum;
ADDRLP4 136
CNSTI4 168
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 136
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 136
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 181
;179:
;180:
;181:	if ( traceEnt->takedamage) {
ADDRLP4 16
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
EQI4 $128
line 182
;182:		G_Damage( traceEnt, ent, ent, forward, tr.endpos,
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 140
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 140
INDIRP4
ARGP4
ADDRLP4 140
INDIRP4
ARGP4
ADDRGP4 forward
ARGP4
ADDRLP4 20+12
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
CNSTI4 0
ARGI4
CNSTI4 3
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 184
;183:			damage, 0, MOD_MACHINEGUN);
;184:	}
LABELV $128
line 185
;185:}
LABELV $87
endproc Bullet_Fire 144 32
export BFG_Fire
proc BFG_Fire 16 12
line 196
;186:
;187:
;188:/*
;189:======================================================================
;190:
;191:BFG
;192:
;193:======================================================================
;194:*/
;195:
;196:void BFG_Fire ( gentity_t *ent ) {
line 199
;197:	gentity_t	*m;
;198:
;199:	m = fire_bfg (ent, muzzle, forward);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRGP4 forward
ARGP4
ADDRLP4 4
ADDRGP4 fire_bfg
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 200
;200:	m->damage *= s_quadFactor;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CVIF4 4
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 201
;201:	m->splashDamage *= s_quadFactor;
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CVIF4 4
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 204
;202:
;203://	VectorAdd( m->s.pos.trDelta, ent->client->ps.velocity, m->s.pos.trDelta );	// "real" physics
;204:}
LABELV $131
endproc BFG_Fire 16 12
export ShotgunPellet
proc ShotgunPellet 80 32
line 215
;205:
;206:
;207:/*
;208:======================================================================
;209:
;210:SHOTGUN
;211:
;212:======================================================================
;213:*/
;214:
;215:qboolean ShotgunPellet( vec3_t start, vec3_t end, gentity_t *ent ) {
line 220
;216:	trace_t		tr;
;217:	int			damage;
;218:	gentity_t		*traceEnt;
;219:
;220:	trap_Trace (&tr, start, NULL, NULL, end, ent->s.number, MASK_SHOT);
ADDRLP4 4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 64
CNSTP4 0
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 221
;221:	traceEnt = &g_entities[ tr.entityNum ];
ADDRLP4 0
CNSTI4 792
ADDRLP4 4+52
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 224
;222:
;223:	// send bullet impact
;224:	if (  tr.surfaceFlags & SURF_NOIMPACT ) {
ADDRLP4 4+44
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $134
line 225
;225:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $132
JUMPV
LABELV $134
line 228
;226:	}
;227:
;228:	if ( traceEnt->takedamage) {
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
EQI4 $137
line 229
;229:		damage = DEFAULT_SHOTGUN_DAMAGE * s_quadFactor;
ADDRLP4 60
CNSTF4 1082130432
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 231
;230:
;231:		G_Damage( traceEnt, ent, ent, forward, tr.endpos,
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 68
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRGP4 forward
ARGP4
ADDRLP4 4+12
ARGP4
ADDRLP4 60
INDIRI4
ARGI4
CNSTI4 0
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 234
;232:			damage, 0, MOD_SHOTGUN);
;233:		
;234:		if(traceEnt->client && (traceEnt->client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS))
ADDRLP4 72
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $140
ADDRLP4 72
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $140
line 235
;235:			G_AddEvent(traceEnt, EV_BLOOD, damage);
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRLP4 60
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
LABELV $140
line 237
;236:		
;237:		if( LogAccuracyHit( traceEnt, ent ) ) 
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 76
ADDRGP4 LogAccuracyHit
CALLI4
ASGNI4
ADDRLP4 76
INDIRI4
CNSTI4 0
EQI4 $142
line 238
;238:			return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $132
JUMPV
LABELV $142
line 240
;239:		
;240:	}
LABELV $137
line 241
;241:	return qfalse;
CNSTI4 0
RETI4
LABELV $132
endproc ShotgunPellet 80 32
export ShotgunPattern
proc ShotgunPattern 104 12
line 245
;242:}
;243:
;244:// this should match CG_ShotgunPattern
;245:void ShotgunPattern( vec3_t origin, vec3_t origin2, int seed, gentity_t *ent ) {
line 251
;246:	int			i;
;247:	float		r, u;
;248:	vec3_t		end;
;249:	vec3_t		forward, right, up;
;250:	int			oldScore;
;251:	qboolean	hitClient = qfalse;
ADDRLP4 60
CNSTI4 0
ASGNI4
line 255
;252:
;253:	// derive the right and up vectors from the forward vector, because
;254:	// the client won't have any other information
;255:	VectorNormalize2( origin2, forward );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 20
ARGP4
ADDRGP4 VectorNormalize2
CALLF4
pop
line 256
;256:	PerpendicularVector( right, forward );
ADDRLP4 32
ARGP4
ADDRLP4 20
ARGP4
ADDRGP4 PerpendicularVector
CALLV
pop
line 257
;257:	CrossProduct( forward, right, up );
ADDRLP4 20
ARGP4
ADDRLP4 32
ARGP4
ADDRLP4 44
ARGP4
ADDRGP4 CrossProduct
CALLV
pop
line 259
;258:
;259:	oldScore = ent->client->ps.persistant[PERS_SCORE];
ADDRLP4 64
ADDRFP4 12
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 248
ADDP4
INDIRI4
ASGNI4
line 262
;260:
;261:	// generate the "random" spread pattern
;262:	for ( i = 0 ; i < DEFAULT_SHOTGUN_COUNT ; i++ ) {
ADDRLP4 56
CNSTI4 0
ASGNI4
LABELV $145
line 264
;263:		
;264:		r = Q_crandom(&seed) * DEFAULT_SHOTGUN_SPREAD;
ADDRFP4 8
ARGP4
ADDRLP4 68
ADDRGP4 Q_crandom
CALLF4
ASGNF4
ADDRLP4 12
CNSTF4 1145569280
ADDRLP4 68
INDIRF4
MULF4
ASGNF4
line 265
;265:		u = Q_crandom(&seed) * DEFAULT_SHOTGUN_SPREAD;
ADDRFP4 8
ARGP4
ADDRLP4 72
ADDRGP4 Q_crandom
CALLF4
ASGNF4
ADDRLP4 16
CNSTF4 1145569280
ADDRLP4 72
INDIRF4
MULF4
ASGNF4
line 267
;266:		
;267:		VectorMA( origin, 8192, forward, end);
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 80
CNSTF4 1174405120
ASGNF4
ADDRLP4 0
ADDRLP4 76
INDIRP4
INDIRF4
ADDRLP4 80
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 76
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 80
INDIRF4
ADDRLP4 20+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 1174405120
ADDRLP4 20+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 268
;268:		VectorMA (end, r, right, end);
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 32
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 32+4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 32+8
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 269
;269:		VectorMA (end, u, up, end);
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 44
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 44+4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 44+8
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 271
;270:
;271:		if( ShotgunPellet( origin, end, ent ) && !hitClient ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 92
ADDRGP4 ShotgunPellet
CALLI4
ASGNI4
ADDRLP4 96
CNSTI4 0
ASGNI4
ADDRLP4 92
INDIRI4
ADDRLP4 96
INDIRI4
EQI4 $165
ADDRLP4 60
INDIRI4
ADDRLP4 96
INDIRI4
NEI4 $165
line 272
;272:			hitClient = qtrue;
ADDRLP4 60
CNSTI4 1
ASGNI4
line 273
;273:			ent->client->ps.persistant[PERS_ACCURACY_HITS]++;
ADDRLP4 100
ADDRFP4 12
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 300
ADDP4
ASGNP4
ADDRLP4 100
INDIRP4
ADDRLP4 100
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 274
;274:		}
LABELV $165
line 275
;275:	}
LABELV $146
line 262
ADDRLP4 56
ADDRLP4 56
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 32
LTI4 $145
line 276
;276:}
LABELV $144
endproc ShotgunPattern 104 12
export weapon_supershotgun_fire
proc weapon_supershotgun_fire 20 16
line 279
;277:
;278:
;279:void weapon_supershotgun_fire (gentity_t *ent) {
line 283
;280:	gentity_t		*tent;
;281:
;282:	// send shotgun blast
;283:	tent = G_TempEntity( muzzle, EV_SHOTGUN );
ADDRGP4 muzzle
ARGP4
CNSTI4 52
ARGI4
ADDRLP4 4
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 284
;284:	VectorScale( forward, 4096, tent->s.origin2 );
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
CNSTF4 1166016512
ADDRGP4 forward
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
CNSTF4 1166016512
ADDRGP4 forward+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
CNSTF4 1166016512
ADDRGP4 forward+8
INDIRF4
MULF4
ASGNF4
line 285
;285:	SnapVector( tent->s.origin2 );
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 286
;286:	tent->s.eventParm = rand() & 255;		// seed for spread pattern
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 8
INDIRI4
CNSTI4 255
BANDI4
ASGNI4
line 287
;287:	tent->s.otherEntityNum = ent->s.number;
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 289
;288:
;289:	ShotgunPattern( tent->s.pos.trBase, tent->s.origin2, tent->s.eventParm, ent );
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ShotgunPattern
CALLV
pop
line 290
;290:}
LABELV $167
endproc weapon_supershotgun_fire 20 16
export weapon_grenadelauncher_fire
proc weapon_grenadelauncher_fire 24 12
line 301
;291:
;292:
;293:/*
;294:======================================================================
;295:
;296:GRENADE LAUNCHER
;297:
;298:======================================================================
;299:*/
;300:
;301:void weapon_grenadelauncher_fire (gentity_t *ent) {
line 305
;302:	gentity_t	*m;
;303:
;304:	// extra vertical velocity
;305:	forward[2] += 0.2;
ADDRLP4 4
ADDRGP4 forward+8
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
CNSTF4 1045220557
ADDF4
ASGNF4
line 306
;306:	VectorNormalize( forward );
ADDRGP4 forward
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 308
;307:
;308:	m = fire_grenade (ent, muzzle, forward);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRGP4 forward
ARGP4
ADDRLP4 8
ADDRGP4 fire_grenade
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 309
;309:	m->damage *= s_quadFactor;
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CVIF4 4
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 310
;310:	m->splashDamage *= s_quadFactor;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CVIF4 4
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 311
;311:	if(s_quadFactor > 1)
ADDRGP4 s_quadFactor
INDIRF4
CNSTF4 1065353216
LEF4 $172
line 312
;312:		m->s.powerups |= 1 << PW_QUAD;
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 188
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
LABELV $172
line 315
;313:
;314://	VectorAdd( m->s.pos.trDelta, ent->client->ps.velocity, m->s.pos.trDelta );	// "real" physics
;315:}
LABELV $170
endproc weapon_grenadelauncher_fire 24 12
export Weapon_RocketLauncher_Fire
proc Weapon_RocketLauncher_Fire 20 12
line 325
;316:
;317:/*
;318:======================================================================
;319:
;320:ROCKET
;321:
;322:======================================================================
;323:*/
;324:
;325:void Weapon_RocketLauncher_Fire (gentity_t *ent) {
line 328
;326:	gentity_t	*m;
;327:
;328:	m = fire_rocket (ent, muzzle, forward);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRGP4 forward
ARGP4
ADDRLP4 4
ADDRGP4 fire_rocket
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 329
;329:	m->damage *= s_quadFactor;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CVIF4 4
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 330
;330:	m->splashDamage *= s_quadFactor;
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CVIF4 4
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 331
;331:	if(s_quadFactor > 1)
ADDRGP4 s_quadFactor
INDIRF4
CNSTF4 1065353216
LEF4 $175
line 332
;332:		m->s.powerups |= 1 << PW_QUAD;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 188
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
LABELV $175
line 335
;333:
;334://	VectorAdd( m->s.pos.trDelta, ent->client->ps.velocity, m->s.pos.trDelta );	// "real" physics
;335:}
LABELV $174
endproc Weapon_RocketLauncher_Fire 20 12
export Weapon_Plasmagun_Fire
proc Weapon_Plasmagun_Fire 20 12
line 346
;336:
;337:
;338:/*
;339:======================================================================
;340:
;341:PLASMA GUN
;342:
;343:======================================================================
;344:*/
;345:
;346:void Weapon_Plasmagun_Fire (gentity_t *ent) {
line 349
;347:	gentity_t	*m;
;348:
;349:	m = fire_plasma (ent, muzzle, forward);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRGP4 forward
ARGP4
ADDRLP4 4
ADDRGP4 fire_plasma
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 350
;350:	m->damage *= s_quadFactor;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CVIF4 4
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 351
;351:	m->splashDamage *= s_quadFactor;
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CVIF4 4
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 352
;352:	if(s_quadFactor > 1)
ADDRGP4 s_quadFactor
INDIRF4
CNSTF4 1065353216
LEF4 $178
line 353
;353:		m->s.powerups |= 1 << PW_QUAD;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 188
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
LABELV $178
line 355
;354://	VectorAdd( m->s.pos.trDelta, ent->client->ps.velocity, m->s.pos.trDelta );	// "real" physics
;355:}
LABELV $177
endproc Weapon_Plasmagun_Fire 20 12
export weapon_railgun_fire
proc weapon_railgun_fire 288 32
line 372
;356:
;357:/*
;358:======================================================================
;359:
;360:RAILGUN
;361:
;362:======================================================================
;363:*/
;364:
;365:
;366:/*
;367:=================
;368:weapon_railgun_fire
;369:=================
;370:*/
;371:#define	MAX_RAIL_HITS	32 // four!? what were they thinking?
;372:void weapon_railgun_fire (gentity_t *ent) {
line 384
;373:	vec3_t		end;
;374:	trace_t		trace;
;375:	gentity_t	*tent;
;376:	gentity_t	*traceEnt;
;377:	int			damage;
;378:	int			radiusDamage;
;379:	int			i;
;380:	int			hits;
;381:	int			unlinked;
;382:	gentity_t	*unlinkedEntities[MAX_RAIL_HITS];
;383:
;384:	damage = 100 * s_quadFactor;
ADDRLP4 212
CNSTF4 1120403456
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 385
;385:	radiusDamage = 30 * s_quadFactor;
ADDRLP4 220
CNSTF4 1106247680
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 387
;386:
;387:	VectorMA (muzzle, 8192, forward, end);
ADDRLP4 224
CNSTF4 1174405120
ASGNF4
ADDRLP4 200
ADDRGP4 muzzle
INDIRF4
ADDRLP4 224
INDIRF4
ADDRGP4 forward
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 200+4
ADDRGP4 muzzle+4
INDIRF4
ADDRLP4 224
INDIRF4
ADDRGP4 forward+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 200+8
ADDRGP4 muzzle+8
INDIRF4
CNSTF4 1174405120
ADDRGP4 forward+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 390
;388:
;389:	// trace only against the solids, so the railgun will go through people
;390:	unlinked = 0;
ADDRLP4 60
CNSTI4 0
ASGNI4
line 391
;391:	hits = 0;
ADDRLP4 216
CNSTI4 0
ASGNI4
LABELV $187
line 392
;392:	do {
line 393
;393:		trap_Trace (&trace, muzzle, NULL, NULL, end, ent->s.number, MASK_SHOT );
ADDRLP4 4
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRLP4 228
CNSTP4 0
ASGNP4
ADDRLP4 228
INDIRP4
ARGP4
ADDRLP4 228
INDIRP4
ARGP4
ADDRLP4 200
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 394
;394:		if ( trace.entityNum >= ENTITYNUM_MAX_NORMAL ) {
ADDRLP4 4+52
INDIRI4
CNSTI4 1022
LTI4 $190
line 395
;395:			break;
ADDRGP4 $189
JUMPV
LABELV $190
line 397
;396:		}
;397:		traceEnt = &g_entities[ trace.entityNum ];
ADDRLP4 0
CNSTI4 792
ADDRLP4 4+52
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 398
;398:		if ( traceEnt->takedamage ) {
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
EQI4 $194
line 399
;399:			if( LogAccuracyHit( traceEnt, ent ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 232
ADDRGP4 LogAccuracyHit
CALLI4
ASGNI4
ADDRLP4 232
INDIRI4
CNSTI4 0
EQI4 $196
line 400
;400:				hits++;
ADDRLP4 216
ADDRLP4 216
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 401
;401:			}
LABELV $196
line 402
;402:			G_Damage (traceEnt, ent, ent, forward, trace.endpos, damage, 0, MOD_RAILGUN);
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 236
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 236
INDIRP4
ARGP4
ADDRLP4 236
INDIRP4
ARGP4
ADDRGP4 forward
ARGP4
ADDRLP4 4+12
ARGP4
ADDRLP4 212
INDIRI4
ARGI4
CNSTI4 0
ARGI4
CNSTI4 10
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 403
;403:		}
LABELV $194
line 404
;404:		if ( trace.contents & CONTENTS_SOLID ) {
ADDRLP4 4+48
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $199
line 406
;405:
;406:			break;		// we hit something solid enough to stop the beam
ADDRGP4 $189
JUMPV
LABELV $199
line 409
;407:		}
;408:		// unlink this entity, so the next trace will go past it
;409:		trap_UnlinkEntity( traceEnt );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 410
;410:		unlinkedEntities[unlinked] = traceEnt;
ADDRLP4 60
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 68
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 411
;411:		unlinked++;
ADDRLP4 60
ADDRLP4 60
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 412
;412:	} while ( unlinked < MAX_RAIL_HITS );
LABELV $188
ADDRLP4 60
INDIRI4
CNSTI4 32
LTI4 $187
LABELV $189
line 415
;413:
;414:	// link back in any entities we unlinked
;415:	for ( i = 0 ; i < unlinked ; i++ ) {
ADDRLP4 64
CNSTI4 0
ASGNI4
ADDRGP4 $205
JUMPV
LABELV $202
line 416
;416:		trap_LinkEntity( unlinkedEntities[i] );
ADDRLP4 64
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 68
ADDP4
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 417
;417:	}
LABELV $203
line 415
ADDRLP4 64
ADDRLP4 64
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $205
ADDRLP4 64
INDIRI4
ADDRLP4 60
INDIRI4
LTI4 $202
line 422
;418:
;419:	// the final trace endpos will be the terminal point of the rail trail
;420:
;421:	// snap the endpos to integers to save net bandwidth, but nudged towards the line
;422:	SnapVectorTowards( trace.endpos, muzzle );
ADDRLP4 4+12
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRGP4 SnapVectorTowards
CALLV
pop
line 425
;423:
;424:	// send railgun beam effect
;425:	tent = G_TempEntity( trace.endpos, EV_RAILTRAIL );
ADDRLP4 4+12
ARGP4
CNSTI4 51
ARGI4
ADDRLP4 228
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 196
ADDRLP4 228
INDIRP4
ASGNP4
line 428
;426:
;427:	// set player number for custom colors on the railtrail
;428:	tent->s.clientNum = ent->s.clientNum;
ADDRLP4 232
CNSTI4 168
ASGNI4
ADDRLP4 196
INDIRP4
ADDRLP4 232
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 232
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 430
;429:
;430:	VectorCopy( muzzle, tent->s.origin2 );
ADDRLP4 196
INDIRP4
CNSTI4 104
ADDP4
ADDRGP4 muzzle
INDIRB
ASGNB 12
line 432
;431:	// move origin a bit to come closer to the drawn gun muzzle
;432:	VectorMA( tent->s.origin2, 4, right, tent->s.origin2 );
ADDRLP4 236
ADDRLP4 196
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 236
INDIRP4
ADDRLP4 236
INDIRP4
INDIRF4
CNSTF4 1082130432
ADDRGP4 right
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 240
ADDRLP4 196
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 240
INDIRP4
ADDRLP4 240
INDIRP4
INDIRF4
CNSTF4 1082130432
ADDRGP4 right+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 244
ADDRLP4 196
INDIRP4
CNSTI4 112
ADDP4
ASGNP4
ADDRLP4 244
INDIRP4
ADDRLP4 244
INDIRP4
INDIRF4
CNSTF4 1082130432
ADDRGP4 right+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 433
;433:	VectorMA( tent->s.origin2, -1, up, tent->s.origin2 );
ADDRLP4 248
ADDRLP4 196
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 248
INDIRP4
ADDRLP4 248
INDIRP4
INDIRF4
CNSTF4 3212836864
ADDRGP4 up
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 252
ADDRLP4 196
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 252
INDIRP4
ADDRLP4 252
INDIRP4
INDIRF4
CNSTF4 3212836864
ADDRGP4 up+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 256
ADDRLP4 196
INDIRP4
CNSTI4 112
ADDP4
ASGNP4
ADDRLP4 256
INDIRP4
ADDRLP4 256
INDIRP4
INDIRF4
CNSTF4 3212836864
ADDRGP4 up+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 436
;434:
;435:	// no explosion at end if SURF_NOIMPACT, but still make the trail
;436:	if ( trace.surfaceFlags & SURF_NOIMPACT ) {
ADDRLP4 4+44
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $212
line 437
;437:		tent->s.eventParm = 255;	// don't make the explosion at the end
ADDRLP4 196
INDIRP4
CNSTI4 184
ADDP4
CNSTI4 255
ASGNI4
line 438
;438:	} else {
ADDRGP4 $213
JUMPV
LABELV $212
line 439
;439:		tent->s.eventParm = DirToByte( trace.plane.normal );
ADDRLP4 4+24
ARGP4
ADDRLP4 260
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRLP4 196
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 260
INDIRI4
ASGNI4
line 440
;440:	}
LABELV $213
line 441
;441:	tent->s.clientNum = ent->s.clientNum;
ADDRLP4 260
CNSTI4 168
ASGNI4
ADDRLP4 196
INDIRP4
ADDRLP4 260
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 260
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 444
;442:
;443:	// give the shooter a reward sound if they have made two railgun hits in a row
;444:	if ( hits == 0 ) {
ADDRLP4 216
INDIRI4
CNSTI4 0
NEI4 $216
line 446
;445:		// complete miss
;446:		ent->client->accurateCount = 0;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 668
ADDP4
CNSTI4 0
ASGNI4
line 447
;447:	} else {
ADDRGP4 $217
JUMPV
LABELV $216
line 449
;448:		// check for "impressive" reward sound
;449:		ent->client->accurateCount += hits;
ADDRLP4 264
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 668
ADDP4
ASGNP4
ADDRLP4 264
INDIRP4
ADDRLP4 264
INDIRP4
INDIRI4
ADDRLP4 216
INDIRI4
ADDI4
ASGNI4
line 450
;450:		if ( ent->client->accurateCount >= 2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 668
ADDP4
INDIRI4
CNSTI4 2
LTI4 $218
line 451
;451:			ent->client->accurateCount -= 2;
ADDRLP4 268
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 668
ADDP4
ASGNP4
ADDRLP4 268
INDIRP4
ADDRLP4 268
INDIRP4
INDIRI4
CNSTI4 2
SUBI4
ASGNI4
line 452
;452:			ent->client->ps.persistant[PERS_REWARD_COUNT]++;
ADDRLP4 272
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 268
ADDP4
ASGNP4
ADDRLP4 272
INDIRP4
ADDRLP4 272
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 453
;453:			ent->client->ps.persistant[PERS_REWARD] = REWARD_IMPRESSIVE;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 272
ADDP4
CNSTI4 1
ASGNI4
line 454
;454:			ent->client->ps.persistant[PERS_IMPRESSIVE_COUNT]++;
ADDRLP4 276
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 284
ADDP4
ASGNP4
ADDRLP4 276
INDIRP4
ADDRLP4 276
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 457
;455:			
;456:			// add the sprite over the player's head
;457:			ent->client->ps.eFlags &= ~(EF_AWARD_EXCELLENT | EF_AWARD_GAUNTLET );
ADDRLP4 280
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 280
INDIRP4
ADDRLP4 280
INDIRP4
INDIRI4
CNSTI4 -73
BANDI4
ASGNI4
line 458
;458:			ent->client->ps.eFlags |= EF_AWARD_IMPRESSIVE;
ADDRLP4 284
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 284
INDIRP4
ADDRLP4 284
INDIRP4
INDIRI4
CNSTI4 32768
BORI4
ASGNI4
line 459
;459:			ent->client->rewardTime = level.time + REWARD_SPRITE_TIME;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 692
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 2000
ADDI4
ASGNI4
line 460
;460:		}
LABELV $218
line 461
;461:		ent->client->ps.persistant[PERS_ACCURACY_HITS]++;
ADDRLP4 268
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 300
ADDP4
ASGNP4
ADDRLP4 268
INDIRP4
ADDRLP4 268
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 462
;462:	}
LABELV $217
line 464
;463:
;464:}
LABELV $180
endproc weapon_railgun_fire 288 32
export Weapon_GrapplingHook_Fire
proc Weapon_GrapplingHook_Fire 4 12
line 476
;465:
;466:
;467:/*
;468:======================================================================
;469:
;470:GRAPPLING HOOK
;471:
;472:======================================================================
;473:*/
;474:
;475:void Weapon_GrapplingHook_Fire (gentity_t *ent)
;476:{
line 477
;477:	if (!ent->client->fireHeld && !ent->client->hook)
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 704
ADDP4
INDIRI4
CNSTI4 0
NEI4 $222
ADDRLP4 0
INDIRP4
CNSTI4 708
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $222
line 478
;478:		fire_grapple (ent, muzzle, forward);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRGP4 forward
ARGP4
ADDRGP4 fire_grapple
CALLP4
pop
LABELV $222
line 480
;479:
;480:	ent->client->fireHeld = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 704
ADDP4
CNSTI4 1
ASGNI4
line 481
;481:}
LABELV $221
endproc Weapon_GrapplingHook_Fire 4 12
export Weapon_HookFree
proc Weapon_HookFree 4 4
line 484
;482:
;483:void Weapon_HookFree (gentity_t *ent)
;484:{
line 485
;485:	ent->parent->client->hook = NULL;
ADDRFP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 708
ADDP4
CNSTP4 0
ASGNP4
line 486
;486:	ent->parent->client->ps.pm_flags &= ~PMF_GRAPPLE_PULL;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 -2049
BANDI4
ASGNI4
line 487
;487:	G_FreeEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 488
;488:}
LABELV $224
endproc Weapon_HookFree 4 4
export Weapon_HookThink
proc Weapon_HookThink 36 8
line 491
;489:
;490:void Weapon_HookThink (gentity_t *ent)
;491:{
line 492
;492:	if (ent->enemy) {
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $226
line 495
;493:		vec3_t v, oldorigin;
;494:
;495:		VectorCopy(ent->r.currentOrigin, oldorigin);
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
INDIRB
ASGNB 12
line 496
;496:		v[0] = ent->enemy->r.currentOrigin[0] + (ent->enemy->r.mins[0] + ent->enemy->r.maxs[0]) * 0.5;
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 24
INDIRP4
CNSTI4 476
ADDP4
INDIRF4
CNSTF4 1056964608
ADDRLP4 24
INDIRP4
CNSTI4 424
ADDP4
INDIRF4
ADDRLP4 24
INDIRP4
CNSTI4 436
ADDP4
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
line 497
;497:		v[1] = ent->enemy->r.currentOrigin[1] + (ent->enemy->r.mins[1] + ent->enemy->r.maxs[1]) * 0.5;
ADDRLP4 28
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
INDIRP4
ASGNP4
ADDRLP4 0+4
ADDRLP4 28
INDIRP4
CNSTI4 480
ADDP4
INDIRF4
CNSTF4 1056964608
ADDRLP4 28
INDIRP4
CNSTI4 428
ADDP4
INDIRF4
ADDRLP4 28
INDIRP4
CNSTI4 440
ADDP4
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
line 498
;498:		v[2] = ent->enemy->r.currentOrigin[2] + (ent->enemy->r.mins[2] + ent->enemy->r.maxs[2]) * 0.5;
ADDRLP4 32
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 32
INDIRP4
CNSTI4 484
ADDP4
INDIRF4
CNSTF4 1056964608
ADDRLP4 32
INDIRP4
CNSTI4 432
ADDP4
INDIRF4
ADDRLP4 32
INDIRP4
CNSTI4 444
ADDP4
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
line 499
;499:		SnapVectorTowards( v, oldorigin );	// save net bandwidth
ADDRLP4 0
ARGP4
ADDRLP4 12
ARGP4
ADDRGP4 SnapVectorTowards
CALLV
pop
line 501
;500:
;501:		G_SetOrigin( ent, v );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 502
;502:	}
LABELV $226
line 504
;503:
;504:	VectorCopy( ent->r.currentOrigin, ent->parent->client->ps.grapplePoint);
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 92
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
INDIRB
ASGNB 12
line 505
;505:}
LABELV $225
endproc Weapon_HookThink 36 8
export Weapon_LightningFire
proc Weapon_LightningFire 116 32
line 515
;506:
;507:/*
;508:======================================================================
;509:
;510:LIGHTNING GUN
;511:
;512:======================================================================
;513:*/
;514:
;515:void Weapon_LightningFire( gentity_t *ent ) {
line 521
;516:	trace_t		tr;
;517:	vec3_t		end;
;518:	gentity_t	*traceEnt, *tent;
;519:	int			damage;
;520:
;521:	damage = 8 * s_quadFactor;
ADDRLP4 76
CNSTF4 1090519040
ADDRGP4 s_quadFactor
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 523
;522:
;523:	VectorMA( muzzle, LIGHTNING_RANGE, forward, end );
ADDRLP4 80
CNSTF4 1145044992
ASGNF4
ADDRLP4 60
ADDRGP4 muzzle
INDIRF4
ADDRLP4 80
INDIRF4
ADDRGP4 forward
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 60+4
ADDRGP4 muzzle+4
INDIRF4
ADDRLP4 80
INDIRF4
ADDRGP4 forward+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 60+8
ADDRGP4 muzzle+8
INDIRF4
CNSTF4 1145044992
ADDRGP4 forward+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 525
;524:
;525:	trap_Trace( &tr, muzzle, NULL, NULL, end, ent->s.number, MASK_SHOT );
ADDRLP4 4
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRLP4 84
CNSTP4 0
ASGNP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRLP4 60
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 527
;526:
;527:	if ( tr.entityNum == ENTITYNUM_NONE ) {
ADDRLP4 4+52
INDIRI4
CNSTI4 1023
NEI4 $237
line 528
;528:		return;
ADDRGP4 $230
JUMPV
LABELV $237
line 531
;529:	}
;530:
;531:	traceEnt = &g_entities[ tr.entityNum ];
ADDRLP4 0
CNSTI4 792
ADDRLP4 4+52
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 533
;532:
;533:	if ( traceEnt->takedamage && traceEnt->client ) {
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
EQI4 $241
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $241
line 534
;534:		if(traceEnt->client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS)		
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $243
line 535
;535:			tent = G_TempEntity( tr.endpos, EV_MISSILE_HIT );
ADDRLP4 4+12
ARGP4
CNSTI4 49
ARGI4
ADDRLP4 92
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 92
INDIRP4
ASGNP4
ADDRGP4 $244
JUMPV
LABELV $243
line 537
;536:		else
;537:			tent = G_TempEntity( tr.endpos, EV_MISSILE_HIT_ROBOT );
ADDRLP4 4+12
ARGP4
CNSTI4 71
ARGI4
ADDRLP4 96
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 96
INDIRP4
ASGNP4
LABELV $244
line 538
;538:		tent->s.otherEntityNum = traceEnt->s.number;
ADDRLP4 72
INDIRP4
CNSTI4 140
ADDP4
ADDRLP4 0
INDIRP4
INDIRI4
ASGNI4
line 539
;539:		tent->s.eventParm = DirToByte( tr.plane.normal );
ADDRLP4 4+24
ARGP4
ADDRLP4 100
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRLP4 72
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 100
INDIRI4
ASGNI4
line 540
;540:		tent->s.weapon = ent->s.weapon;
ADDRLP4 104
CNSTI4 192
ASGNI4
ADDRLP4 72
INDIRP4
ADDRLP4 104
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 104
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 541
;541:		if( LogAccuracyHit( traceEnt, ent ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 108
ADDRGP4 LogAccuracyHit
CALLI4
ASGNI4
ADDRLP4 108
INDIRI4
CNSTI4 0
EQI4 $242
line 542
;542:			ent->client->ps.persistant[PERS_ACCURACY_HITS]++;
ADDRLP4 112
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 300
ADDP4
ASGNP4
ADDRLP4 112
INDIRP4
ADDRLP4 112
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 543
;543:		}
line 544
;544:	} else if ( !( tr.surfaceFlags & SURF_NOIMPACT ) ) {
ADDRGP4 $242
JUMPV
LABELV $241
ADDRLP4 4+44
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
NEI4 $250
line 545
;545:		tent = G_TempEntity( tr.endpos, EV_MISSILE_MISS );
ADDRLP4 4+12
ARGP4
CNSTI4 50
ARGI4
ADDRLP4 92
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 92
INDIRP4
ASGNP4
line 546
;546:		tent->s.eventParm = DirToByte( tr.plane.normal );
ADDRLP4 4+24
ARGP4
ADDRLP4 96
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRLP4 72
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 96
INDIRI4
ASGNI4
line 547
;547:	}
LABELV $250
LABELV $242
line 549
;548:
;549:	if ( traceEnt->takedamage) {
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
EQI4 $255
line 550
;550:		G_Damage( traceEnt, ent, ent, forward, tr.endpos,
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRGP4 forward
ARGP4
ADDRLP4 4+12
ARGP4
ADDRLP4 76
INDIRI4
ARGI4
CNSTI4 16
ARGI4
CNSTI4 11
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 552
;551:			damage, DAMAGE_NO_BLEEDING, MOD_LIGHTNING);
;552:	}
LABELV $255
line 553
;553:}
LABELV $230
endproc Weapon_LightningFire 116 32
export LogAccuracyHit
proc LogAccuracyHit 4 8
line 563
;554:
;555://======================================================================
;556:
;557:
;558:/*
;559:===============
;560:LogAccuracyHit
;561:===============
;562:*/
;563:qboolean LogAccuracyHit( gentity_t *target, gentity_t *attacker ) {
line 564
;564:	if( !target->takedamage ) {
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
NEI4 $259
line 565
;565:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $258
JUMPV
LABELV $259
line 568
;566:	}
;567:
;568:	if ( target == attacker ) {
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRFP4 4
INDIRP4
CVPU4 4
NEU4 $261
line 569
;569:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $258
JUMPV
LABELV $261
line 572
;570:	}
;571:
;572:	if( !target->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $263
line 573
;573:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $258
JUMPV
LABELV $263
line 576
;574:	}
;575:
;576:	if( !attacker->client ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $265
line 577
;577:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $258
JUMPV
LABELV $265
line 580
;578:	}
;579:
;580:	if( target->client->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
GTI4 $267
line 581
;581:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $258
JUMPV
LABELV $267
line 584
;582:	}
;583:
;584:	if ( OnSameTeam( target, attacker ) ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 OnSameTeam
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $269
line 585
;585:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $258
JUMPV
LABELV $269
line 588
;586:	}
;587:
;588:	return qtrue;
CNSTI4 1
RETI4
LABELV $258
endproc LogAccuracyHit 4 8
export CalcMuzzlePoint
proc CalcMuzzlePoint 116 28
line 599
;589:}
;590:
;591:
;592:/*
;593:===============
;594:CalcMuzzlePoint
;595:
;596:set muzzle location relative to pivoting eye
;597:===============
;598:*/
;599:void CalcMuzzlePoint ( gentity_t *ent, vec3_t forward, vec3_t right, vec3_t up, vec3_t muzzlePoint, vec3_t aimdir ) {
line 601
;600:	
;601:	if(ent->client->muzzle[0] ==  443556)
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 740
ADDP4
INDIRF4
CNSTF4 1222153344
NEF4 $272
line 602
;602:	{
line 603
;603:		VectorCopy( ent->s.pos.trBase, muzzlePoint );
ADDRFP4 16
INDIRP4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 605
;604:
;605:		muzzlePoint[2] += ent->client->ps.viewheight;
ADDRLP4 0
ADDRFP4 16
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 164
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 606
;606:		VectorMA( muzzlePoint, 14, forward, muzzlePoint );
ADDRLP4 4
ADDRFP4 16
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
CNSTF4 1096810496
ADDRFP4 4
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 8
CNSTI4 4
ASGNI4
ADDRLP4 12
ADDRFP4 16
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
CNSTF4 1096810496
ADDRFP4 4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 16
CNSTI4 8
ASGNI4
ADDRLP4 20
ADDRFP4 16
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
CNSTF4 1096810496
ADDRFP4 4
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 607
;607:		VectorCopy(forward, aimdir);
ADDRFP4 20
INDIRP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 608
;608:	}
ADDRGP4 $273
JUMPV
LABELV $272
line 610
;609:	else
;610:	{
line 615
;611:		trace_t tr;	
;612:		vec3_t eyepos, paralax;
;613:		
;614:		
;615:		VectorAdd( ent->s.pos.trBase, ent->client->muzzle, muzzlePoint );
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 16
INDIRP4
ADDRLP4 80
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 80
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 740
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 16
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 84
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 84
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 744
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 88
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 16
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 88
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRLP4 88
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 748
ADDP4
INDIRF4
ADDF4
ASGNF4
line 616
;616:		if(ent->client->pers.AutoAim)
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 588
ADDP4
INDIRI4
CNSTI4 0
EQI4 $274
line 617
;617:		{
line 618
;618:			VectorAdd( ent->s.pos.trBase, ent->client->headpos, eyepos );
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 96
ADDRLP4 92
INDIRP4
CNSTI4 504
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 92
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 96
INDIRP4
INDIRP4
CNSTI4 728
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 92
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 96
INDIRP4
INDIRP4
CNSTI4 732
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 100
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 100
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRLP4 100
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 736
ADDP4
INDIRF4
ADDF4
ASGNF4
line 620
;619:
;620:			VectorMA(eyepos, 8192, forward, paralax);
ADDRLP4 104
CNSTF4 1174405120
ASGNF4
ADDRLP4 108
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 68
ADDRLP4 0
INDIRF4
ADDRLP4 104
INDIRF4
ADDRLP4 108
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 68+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 104
INDIRF4
ADDRLP4 108
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 68+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1174405120
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 621
;621:			trap_Trace( &tr, eyepos, NULL, NULL, paralax, ent->s.number, MASK_SHOT );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 112
CNSTP4 0
ASGNP4
ADDRLP4 112
INDIRP4
ARGP4
ADDRLP4 112
INDIRP4
ARGP4
ADDRLP4 68
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 622
;622:			VectorSubtract(tr.endpos, muzzle, aimdir);
ADDRFP4 20
INDIRP4
ADDRLP4 12+12
INDIRF4
ADDRGP4 muzzle
INDIRF4
SUBF4
ASGNF4
ADDRFP4 20
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 12+12+4
INDIRF4
ADDRGP4 muzzle+4
INDIRF4
SUBF4
ASGNF4
ADDRFP4 20
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 12+12+8
INDIRF4
ADDRGP4 muzzle+8
INDIRF4
SUBF4
ASGNF4
line 623
;623:			VectorNormalize(aimdir);
ADDRFP4 20
INDIRP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 624
;624:		}
ADDRGP4 $275
JUMPV
LABELV $274
line 626
;625:		else
;626:		{
line 627
;627:			VectorCopy(forward, aimdir);
ADDRFP4 20
INDIRP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 628
;628:		}
LABELV $275
line 630
;629:		//G_Printf("?");
;630:	}
LABELV $273
line 632
;631:	// snap to integer coordinates for more efficient network bandwidth usage
;632:	SnapVector( muzzlePoint );
ADDRLP4 0
ADDRFP4 16
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 4
ADDRFP4 16
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 8
ADDRFP4 16
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 635
;633:	
;634:	
;635:}
LABELV $271
endproc CalcMuzzlePoint 116 28
export FireWeapon
proc FireWeapon 24 24
line 644
;636:
;637:
;638:
;639:/*
;640:===============
;641:FireWeapon
;642:===============
;643:*/
;644:void FireWeapon( gentity_t *ent ) {
line 647
;645:	
;646:	vec3_t aimdir;
;647:	if (ent->client->ps.powerups[PW_QUAD] ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 316
ADDP4
INDIRI4
CNSTI4 0
EQI4 $290
line 648
;648:		s_quadFactor = g_quadfactor.value;
ADDRGP4 s_quadFactor
ADDRGP4 g_quadfactor+8
INDIRF4
ASGNF4
line 649
;649:	} else {
ADDRGP4 $291
JUMPV
LABELV $290
line 650
;650:		s_quadFactor = 1;
ADDRGP4 s_quadFactor
CNSTF4 1065353216
ASGNF4
line 651
;651:	}
LABELV $291
line 654
;652:
;653:	// track shots taken for accuracy tracking.  Grapple is not a weapon and gauntet is just not tracked
;654:	if( ent->s.weapon != WP_GRAPPLING_HOOK && ent->s.weapon != WP_GAUNTLET ) {
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 -1
EQI4 $293
ADDRLP4 12
INDIRI4
CNSTI4 1
EQI4 $293
line 655
;655:		ent->client->ps.persistant[PERS_ACCURACY_SHOTS]++;
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 296
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 656
;656:	}
LABELV $293
line 659
;657:
;658:	// set aiming directions
;659:	AngleVectors (ent->client->ps.viewangles, forward, right, up);
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 152
ADDP4
ARGP4
ADDRGP4 forward
ARGP4
ADDRGP4 right
ARGP4
ADDRGP4 up
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 660
;660:	CalcMuzzlePoint ( ent, forward, right, up, muzzle, aimdir );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 forward
ARGP4
ADDRGP4 right
ARGP4
ADDRGP4 up
ARGP4
ADDRGP4 muzzle
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 CalcMuzzlePoint
CALLV
pop
line 661
;661:	VectorCopy(aimdir, forward); // paralax corrected
ADDRGP4 forward
ADDRLP4 0
INDIRB
ASGNB 12
line 664
;662:
;663:	// fire the specific weapon
;664:	switch( ent->s.weapon ) {
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 -1
LTI4 $296
ADDRLP4 16
INDIRI4
CNSTI4 9
GTI4 $296
ADDRLP4 16
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $312+4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $312
address $311
address $298
address $299
address $302
address $301
address $306
address $307
address $300
address $309
address $308
address $310
code
LABELV $298
line 666
;665:	case WP_NONE:
;666:		Weapon_Fist( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Weapon_Fist
CALLV
pop
line 667
;667:		break;
ADDRGP4 $296
JUMPV
LABELV $299
line 669
;668:	case WP_GAUNTLET:
;669:		Weapon_Gauntlet( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Weapon_Gauntlet
CALLV
pop
line 670
;670:		break;
ADDRGP4 $296
JUMPV
LABELV $300
line 672
;671:	case WP_LIGHTNING:
;672:		Weapon_LightningFire( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Weapon_LightningFire
CALLV
pop
line 673
;673:		break;
ADDRGP4 $296
JUMPV
LABELV $301
line 675
;674:	case WP_SHOTGUN:
;675:		weapon_supershotgun_fire( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 weapon_supershotgun_fire
CALLV
pop
line 676
;676:		break;
ADDRGP4 $296
JUMPV
LABELV $302
line 678
;677:	case WP_MACHINEGUN:
;678:		if ( g_gametype.integer != GT_TEAM ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
EQI4 $303
line 679
;679:			Bullet_Fire( ent, MACHINEGUN_SPREAD, MACHINEGUN_DAMAGE );
ADDRFP4 0
INDIRP4
ARGP4
CNSTF4 1128792064
ARGF4
CNSTI4 7
ARGI4
ADDRGP4 Bullet_Fire
CALLV
pop
line 680
;680:		} else {
ADDRGP4 $296
JUMPV
LABELV $303
line 681
;681:			Bullet_Fire( ent, MACHINEGUN_SPREAD, MACHINEGUN_TEAM_DAMAGE );
ADDRFP4 0
INDIRP4
ARGP4
CNSTF4 1128792064
ARGF4
CNSTI4 5
ARGI4
ADDRGP4 Bullet_Fire
CALLV
pop
line 682
;682:		}
line 683
;683:		break;
ADDRGP4 $296
JUMPV
LABELV $306
line 685
;684:	case WP_GRENADE_LAUNCHER:
;685:		weapon_grenadelauncher_fire( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 weapon_grenadelauncher_fire
CALLV
pop
line 686
;686:		break;
ADDRGP4 $296
JUMPV
LABELV $307
line 688
;687:	case WP_ROCKET_LAUNCHER:
;688:		Weapon_RocketLauncher_Fire( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Weapon_RocketLauncher_Fire
CALLV
pop
line 689
;689:		break;
ADDRGP4 $296
JUMPV
LABELV $308
line 691
;690:	case WP_PLASMAGUN:
;691:		Weapon_Plasmagun_Fire( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Weapon_Plasmagun_Fire
CALLV
pop
line 692
;692:		break;
ADDRGP4 $296
JUMPV
LABELV $309
line 694
;693:	case WP_RAILGUN:
;694:		weapon_railgun_fire( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 weapon_railgun_fire
CALLV
pop
line 695
;695:		break;
ADDRGP4 $296
JUMPV
LABELV $310
line 697
;696:	case WP_BFG:
;697:		BFG_Fire( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BFG_Fire
CALLV
pop
line 698
;698:		break;
ADDRGP4 $296
JUMPV
LABELV $311
line 700
;699:	case WP_GRAPPLING_HOOK:
;700:		Weapon_GrapplingHook_Fire( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Weapon_GrapplingHook_Fire
CALLV
pop
line 701
;701:		break;
line 704
;702:	default:
;703:// FIXME		G_Error( "Bad ent->s.weapon" );
;704:		break;
LABELV $296
line 706
;705:	}
;706:}
LABELV $289
endproc FireWeapon 24 24
bss
align 4
LABELV muzzle
skip 12
align 4
LABELV up
skip 12
align 4
LABELV right
skip 12
align 4
LABELV forward
skip 12
align 4
LABELV s_quadFactor
skip 4
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
