export G_FindConfigstringIndex
code
proc G_FindConfigstringIndex 1036 12
file "..\g_utils.c"
line 21
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// g_utils.c -- misc utility functions for game module
;4:
;5:#include "g_local.h"
;6:
;7:/*
;8:=========================================================================
;9:
;10:model / sound configstring indexes
;11:
;12:=========================================================================
;13:*/
;14:
;15:/*
;16:================
;17:G_FindConfigstringIndex
;18:
;19:================
;20:*/
;21:int G_FindConfigstringIndex( char *name, int start, int max, qboolean create ) {
line 25
;22:	int		i;
;23:	char	s[MAX_STRING_CHARS];
;24:
;25:	if ( !name || !name[0] ) {
ADDRLP4 1028
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1028
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $49
ADDRLP4 1028
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $47
LABELV $49
line 26
;26:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $46
JUMPV
LABELV $47
line 29
;27:	}
;28:
;29:	for ( i=1 ; i<max ; i++ ) {
ADDRLP4 1024
CNSTI4 1
ASGNI4
ADDRGP4 $53
JUMPV
LABELV $50
line 30
;30:		trap_GetConfigstring( start + i, s, sizeof( s ) );
ADDRFP4 4
INDIRI4
ADDRLP4 1024
INDIRI4
ADDI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 31
;31:		if ( !s[0] ) {
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $54
line 32
;32:			break;
ADDRGP4 $52
JUMPV
LABELV $54
line 34
;33:		}
;34:		if ( !strcmp( s, name ) ) {
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1032
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 1032
INDIRI4
CNSTI4 0
NEI4 $56
line 35
;35:			return i;
ADDRLP4 1024
INDIRI4
RETI4
ADDRGP4 $46
JUMPV
LABELV $56
line 37
;36:		}
;37:	}
LABELV $51
line 29
ADDRLP4 1024
ADDRLP4 1024
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $53
ADDRLP4 1024
INDIRI4
ADDRFP4 8
INDIRI4
LTI4 $50
LABELV $52
line 39
;38:
;39:	if ( !create ) {
ADDRFP4 12
INDIRI4
CNSTI4 0
NEI4 $58
line 40
;40:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $46
JUMPV
LABELV $58
line 43
;41:	}
;42:
;43:	if ( i == max ) {
ADDRLP4 1024
INDIRI4
ADDRFP4 8
INDIRI4
NEI4 $60
line 44
;44:		G_Error( "G_FindConfigstringIndex: overflow" );
ADDRGP4 $62
ARGP4
ADDRGP4 G_Error
CALLV
pop
line 45
;45:	}
LABELV $60
line 47
;46:
;47:	trap_SetConfigstring( start + i, name );
ADDRFP4 4
INDIRI4
ADDRLP4 1024
INDIRI4
ADDI4
ARGI4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 49
;48:
;49:	return i;
ADDRLP4 1024
INDIRI4
RETI4
LABELV $46
endproc G_FindConfigstringIndex 1036 12
export G_ModelIndex
proc G_ModelIndex 4 16
line 53
;50:}
;51:
;52:
;53:int G_ModelIndex( char *name ) {
line 54
;54:	return G_FindConfigstringIndex (name, CS_MODELS, MAX_MODELS, qtrue);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 32
ARGI4
CNSTI4 256
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 0
ADDRGP4 G_FindConfigstringIndex
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
RETI4
LABELV $63
endproc G_ModelIndex 4 16
export G_SoundIndex
proc G_SoundIndex 4 16
line 57
;55:}
;56:
;57:int G_SoundIndex( char *name ) {
line 58
;58:	return G_FindConfigstringIndex (name, CS_SOUNDS, MAX_SOUNDS, qtrue);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 288
ARGI4
CNSTI4 256
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 0
ADDRGP4 G_FindConfigstringIndex
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
RETI4
LABELV $64
endproc G_SoundIndex 4 16
export G_TeamCommand
proc G_TeamCommand 8 8
line 71
;59:}
;60:
;61://=====================================================================
;62:
;63:
;64:/*
;65:================
;66:G_TeamCommand
;67:
;68:Broadcasts a command to only a specific team
;69:================
;70:*/
;71:void G_TeamCommand( team_t team, char *cmd ) {
line 74
;72:	int		i;
;73:
;74:	for ( i = 0 ; i < level.maxclients ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $69
JUMPV
LABELV $66
line 75
;75:		if ( level.clients[i].pers.connected == CON_CONNECTED ) {
CNSTI4 760
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 2
NEI4 $71
line 76
;76:			if ( level.clients[i].sess.sessionTeam == team ) {
CNSTI4 760
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 592
ADDP4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $73
line 77
;77:				trap_SendServerCommand( i, va("%s", cmd ));
ADDRGP4 $75
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 78
;78:			}
LABELV $73
line 79
;79:		}
LABELV $71
line 80
;80:	}
LABELV $67
line 74
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $69
ADDRLP4 0
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $66
line 81
;81:}
LABELV $65
endproc G_TeamCommand 8 8
export G_Find
proc G_Find 8 8
line 97
;82:
;83:
;84:/*
;85:=============
;86:G_Find
;87:
;88:Searches all active entities for the next one that holds
;89:the matching string at fieldofs (use the FOFS() macro) in the structure.
;90:
;91:Searches beginning at the entity after from, or the beginning if NULL
;92:NULL will be returned if the end of the list is reached.
;93:
;94:=============
;95:*/
;96:gentity_t *G_Find (gentity_t *from, int fieldofs, const char *match)
;97:{
line 100
;98:	char	*s;
;99:
;100:	if (!from)
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $77
line 101
;101:		from = g_entities;
ADDRFP4 0
ADDRGP4 g_entities
ASGNP4
ADDRGP4 $82
JUMPV
LABELV $77
line 103
;102:	else
;103:		from++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 792
ADDP4
ASGNP4
line 105
;104:
;105:	for ( ; from < &g_entities[level.num_entities] ; from++)
ADDRGP4 $82
JUMPV
LABELV $79
line 106
;106:	{
line 107
;107:		if (!from->inuse)
ADDRFP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
NEI4 $84
line 108
;108:			continue;
ADDRGP4 $80
JUMPV
LABELV $84
line 109
;109:		s = *(char **) ((byte *)from + fieldofs);
ADDRLP4 0
ADDRFP4 4
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRP4
ASGNP4
line 110
;110:		if (!s)
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $86
line 111
;111:			continue;
ADDRGP4 $80
JUMPV
LABELV $86
line 112
;112:		if (!Q_stricmp (s, match))
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $88
line 113
;113:			return from;
ADDRFP4 0
INDIRP4
RETP4
ADDRGP4 $76
JUMPV
LABELV $88
line 114
;114:	}
LABELV $80
line 105
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 792
ADDP4
ASGNP4
LABELV $82
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTI4 792
ADDRGP4 level+12
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
CVPU4 4
LTU4 $79
line 116
;115:
;116:	return NULL;
CNSTP4 0
RETP4
LABELV $76
endproc G_Find 8 8
export G_PickTarget
proc G_PickTarget 144 12
line 130
;117:}
;118:
;119:
;120:/*
;121:=============
;122:G_PickTarget
;123:
;124:Selects a random entity from among the targets
;125:=============
;126:*/
;127:#define MAXCHOICES	32
;128:
;129:gentity_t *G_PickTarget (char *targetname)
;130:{
line 131
;131:	gentity_t	*ent = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
line 132
;132:	int		num_choices = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 135
;133:	gentity_t	*choice[MAXCHOICES];
;134:
;135:	if (!targetname)
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $95
line 136
;136:	{
line 137
;137:		G_Printf("G_PickTarget called with NULL targetname\n");
ADDRGP4 $93
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 138
;138:		return NULL;
CNSTP4 0
RETP4
ADDRGP4 $90
JUMPV
LABELV $94
line 142
;139:	}
;140:
;141:	while(1)
;142:	{
line 143
;143:		ent = G_Find (ent, FOFS(targetname), targetname);
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 640
ARGI4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 136
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 136
INDIRP4
ASGNP4
line 144
;144:		if (!ent)
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $97
line 145
;145:			break;
ADDRGP4 $96
JUMPV
LABELV $97
line 146
;146:		choice[num_choices++] = ent;
ADDRLP4 140
ADDRLP4 4
INDIRI4
ASGNI4
ADDRLP4 4
ADDRLP4 140
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 140
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 147
;147:		if (num_choices == MAXCHOICES)
ADDRLP4 4
INDIRI4
CNSTI4 32
NEI4 $99
line 148
;148:			break;
ADDRGP4 $96
JUMPV
LABELV $99
line 149
;149:	}
LABELV $95
line 141
ADDRGP4 $94
JUMPV
LABELV $96
line 151
;150:
;151:	if (!num_choices)
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $101
line 152
;152:	{
line 153
;153:		G_Printf("G_PickTarget: target %s not found\n", targetname);
ADDRGP4 $103
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 154
;154:		return NULL;
CNSTP4 0
RETP4
ADDRGP4 $90
JUMPV
LABELV $101
line 157
;155:	}
;156:
;157:	return choice[rand() % num_choices];
ADDRLP4 136
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 136
INDIRI4
ADDRLP4 4
INDIRI4
MODI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
INDIRP4
RETP4
LABELV $90
endproc G_PickTarget 144 12
export G_UseTargets
proc G_UseTargets 8 12
line 172
;158:}
;159:
;160:
;161:/*
;162:==============================
;163:G_UseTargets
;164:
;165:"activator" should be set to the entity that initiated the firing.
;166:
;167:Search for (string)targetname in all entities that
;168:match (string)self.target and call their .use function
;169:
;170:==============================
;171:*/
;172:void G_UseTargets( gentity_t *ent, gentity_t *activator ) {
line 175
;173:	gentity_t		*t;
;174:	
;175:	if ( !ent ) {
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $105
line 176
;176:		return;
ADDRGP4 $104
JUMPV
LABELV $105
line 178
;177:	}
;178:	if ( !ent->target ) {
ADDRFP4 0
INDIRP4
CNSTI4 636
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $107
line 179
;179:		return;
ADDRGP4 $104
JUMPV
LABELV $107
line 182
;180:	}
;181:
;182:	t = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
ADDRGP4 $110
JUMPV
LABELV $109
line 183
;183:	while ( (t = G_Find (t, FOFS(targetname), ent->target)) != NULL ) {
line 184
;184:		if ( t == ent ) {
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRFP4 0
INDIRP4
CVPU4 4
NEU4 $112
line 185
;185:			G_Printf ("WARNING: Entity used itself.\n");
ADDRGP4 $114
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 186
;186:		} else {
ADDRGP4 $113
JUMPV
LABELV $112
line 187
;187:			if ( t->use ) {
ADDRLP4 0
INDIRP4
CNSTI4 688
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $115
line 188
;188:				t->use (t, ent, activator);
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 688
ADDP4
INDIRP4
CALLV
pop
line 189
;189:			}
LABELV $115
line 190
;190:		}
LABELV $113
line 191
;191:		if ( !ent->inuse ) {
ADDRFP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
NEI4 $117
line 192
;192:			G_Printf("entity was removed while using targets\n");
ADDRGP4 $119
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 193
;193:			return;
ADDRGP4 $104
JUMPV
LABELV $117
line 195
;194:		}
;195:	}
LABELV $110
line 183
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 640
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 636
ADDP4
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $109
line 196
;196:}
LABELV $104
endproc G_UseTargets 8 12
bss
align 4
LABELV $121
skip 4
align 4
LABELV $122
skip 96
export tv
code
proc tv 8 0
line 207
;197:
;198:
;199:/*
;200:=============
;201:TempVector
;202:
;203:This is just a convenience function
;204:for making temporary vectors for function calls
;205:=============
;206:*/
;207:float	*tv( float x, float y, float z ) {
line 214
;208:	static	int		index;
;209:	static	vec3_t	vecs[8];
;210:	float	*v;
;211:
;212:	// use an array so that multiple tempvectors won't collide
;213:	// for a while
;214:	v = vecs[index];
ADDRLP4 0
CNSTI4 12
ADDRGP4 $121
INDIRI4
MULI4
ADDRGP4 $122
ADDP4
ASGNP4
line 215
;215:	index = (index + 1)&7;
ADDRLP4 4
ADDRGP4 $121
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
CNSTI4 7
BANDI4
ASGNI4
line 217
;216:
;217:	v[0] = x;
ADDRLP4 0
INDIRP4
ADDRFP4 0
INDIRF4
ASGNF4
line 218
;218:	v[1] = y;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRFP4 4
INDIRF4
ASGNF4
line 219
;219:	v[2] = z;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRFP4 8
INDIRF4
ASGNF4
line 221
;220:
;221:	return v;
ADDRLP4 0
INDIRP4
RETP4
LABELV $120
endproc tv 8 0
bss
align 4
LABELV $124
skip 4
align 1
LABELV $125
skip 256
export vtos
code
proc vtos 12 24
line 233
;222:}
;223:
;224:
;225:/*
;226:=============
;227:VectorToString
;228:
;229:This is just a convenience function
;230:for printing vectors
;231:=============
;232:*/
;233:char	*vtos( const vec3_t v ) {
line 239
;234:	static	int		index;
;235:	static	char	str[8][32];
;236:	char	*s;
;237:
;238:	// use an array so that multiple vtos won't collide
;239:	s = str[index];
ADDRLP4 0
ADDRGP4 $124
INDIRI4
CNSTI4 5
LSHI4
ADDRGP4 $125
ADDP4
ASGNP4
line 240
;240:	index = (index + 1)&7;
ADDRLP4 4
ADDRGP4 $124
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
CNSTI4 7
BANDI4
ASGNI4
line 242
;241:
;242:	Com_sprintf (s, 32, "(%i %i %i)", (int)v[0], (int)v[1], (int)v[2]);
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 $126
ARGP4
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CVFI4 4
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 244
;243:
;244:	return s;
ADDRLP4 0
INDIRP4
RETP4
LABELV $123
endproc vtos 12 24
data
align 4
LABELV $128
byte 4 0
byte 4 3212836864
byte 4 0
align 4
LABELV $129
byte 4 0
byte 4 0
byte 4 1065353216
align 4
LABELV $130
byte 4 0
byte 4 3221225472
byte 4 0
align 4
LABELV $131
byte 4 0
byte 4 0
byte 4 3212836864
export G_SetMovedir
code
proc G_SetMovedir 16 16
line 258
;245:}
;246:
;247:
;248:/*
;249:===============
;250:G_SetMovedir
;251:
;252:The editor only specifies a single value for angles (yaw),
;253:but we have special constants to generate an up or down direction.
;254:Angles will be cleared, because it is being used to represent a direction
;255:instead of an orientation.
;256:===============
;257:*/
;258:void G_SetMovedir( vec3_t angles, vec3_t movedir ) {
line 264
;259:	static vec3_t VEC_UP		= {0, -1, 0};
;260:	static vec3_t MOVEDIR_UP	= {0, 0, 1};
;261:	static vec3_t VEC_DOWN		= {0, -2, 0};
;262:	static vec3_t MOVEDIR_DOWN	= {0, 0, -1};
;263:
;264:	if ( VectorCompare (angles, VEC_UP) ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $128
ARGP4
ADDRLP4 0
ADDRGP4 VectorCompare
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $132
line 265
;265:		VectorCopy (MOVEDIR_UP, movedir);
ADDRFP4 4
INDIRP4
ADDRGP4 $129
INDIRB
ASGNB 12
line 266
;266:	} else if ( VectorCompare (angles, VEC_DOWN) ) {
ADDRGP4 $133
JUMPV
LABELV $132
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $130
ARGP4
ADDRLP4 4
ADDRGP4 VectorCompare
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $134
line 267
;267:		VectorCopy (MOVEDIR_DOWN, movedir);
ADDRFP4 4
INDIRP4
ADDRGP4 $131
INDIRB
ASGNB 12
line 268
;268:	} else {
ADDRGP4 $135
JUMPV
LABELV $134
line 269
;269:		AngleVectors (angles, movedir, NULL, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 8
CNSTP4 0
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 270
;270:	}
LABELV $135
LABELV $133
line 271
;271:	VectorClear( angles );
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
CNSTF4 0
ASGNF4
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 8
INDIRP4
ADDRLP4 12
INDIRF4
ASGNF4
line 272
;272:}
LABELV $127
endproc G_SetMovedir 16 16
export vectoyaw
proc vectoyaw 20 8
line 275
;273:
;274:
;275:float vectoyaw( const vec3_t vec ) {
line 278
;276:	float	yaw;
;277:	
;278:	if (vec[YAW] == 0 && vec[PITCH] == 0) {
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
CNSTF4 0
ASGNF4
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 8
INDIRF4
NEF4 $137
ADDRLP4 4
INDIRP4
INDIRF4
ADDRLP4 8
INDIRF4
NEF4 $137
line 279
;279:		yaw = 0;
ADDRLP4 0
CNSTF4 0
ASGNF4
line 280
;280:	} else {
ADDRGP4 $138
JUMPV
LABELV $137
line 281
;281:		if (vec[PITCH]) {
ADDRFP4 0
INDIRP4
INDIRF4
CNSTF4 0
EQF4 $139
line 282
;282:			yaw = ( atan2( vec[YAW], vec[PITCH]) * 180 / M_PI );
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ARGF4
ADDRLP4 12
INDIRP4
INDIRF4
ARGF4
ADDRLP4 16
ADDRGP4 atan2
CALLF4
ASGNF4
ADDRLP4 0
CNSTF4 1127481344
ADDRLP4 16
INDIRF4
MULF4
CNSTF4 1078530011
DIVF4
ASGNF4
line 283
;283:		} else if (vec[YAW] > 0) {
ADDRGP4 $140
JUMPV
LABELV $139
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
CNSTF4 0
LEF4 $141
line 284
;284:			yaw = 90;
ADDRLP4 0
CNSTF4 1119092736
ASGNF4
line 285
;285:		} else {
ADDRGP4 $142
JUMPV
LABELV $141
line 286
;286:			yaw = 270;
ADDRLP4 0
CNSTF4 1132920832
ASGNF4
line 287
;287:		}
LABELV $142
LABELV $140
line 288
;288:		if (yaw < 0) {
ADDRLP4 0
INDIRF4
CNSTF4 0
GEF4 $143
line 289
;289:			yaw += 360;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1135869952
ADDF4
ASGNF4
line 290
;290:		}
LABELV $143
line 291
;291:	}
LABELV $138
line 293
;292:
;293:	return yaw;
ADDRLP4 0
INDIRF4
RETF4
LABELV $136
endproc vectoyaw 20 8
export G_InitGentity
proc G_InitGentity 4 0
line 297
;294:}
;295:
;296:
;297:void G_InitGentity( gentity_t *e ) {
line 298
;298:	e->inuse = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 508
ADDP4
CNSTI4 1
ASGNI4
line 299
;299:	e->classname = "noclass";
ADDRFP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $146
ASGNP4
line 300
;300:	e->s.number = e - g_entities;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ASGNI4
line 301
;301:	e->r.ownerNum = ENTITYNUM_NONE;
ADDRFP4 0
INDIRP4
CNSTI4 500
ADDP4
CNSTI4 1023
ASGNI4
line 302
;302:}
LABELV $145
endproc G_InitGentity 4 0
export G_Spawn
proc G_Spawn 16 20
line 319
;303:
;304:/*
;305:=================
;306:G_Spawn
;307:
;308:Either finds a free entity, or allocates a new one.
;309:
;310:  The slots from 0 to MAX_CLIENTS-1 are always reserved for clients, and will
;311:never be used by anything else.
;312:
;313:Try to avoid reusing an entity that was recently freed, because it
;314:can cause the client to think the entity morphed into something else
;315:instead of being removed and recreated, which can cause interpolated
;316:angles and bad trails.
;317:=================
;318:*/
;319:gentity_t *G_Spawn( void ) {
line 323
;320:	int			i, force;
;321:	gentity_t	*e;
;322:
;323:	e = NULL;	// shut up warning
ADDRLP4 0
CNSTP4 0
ASGNP4
line 324
;324:	i = 0;		// shut up warning
ADDRLP4 4
CNSTI4 0
ASGNI4
line 325
;325:	for ( force = 0 ; force < 2 ; force++ ) {
ADDRLP4 8
CNSTI4 0
ASGNI4
LABELV $148
line 328
;326:		// if we go through all entities and can't find one to free,
;327:		// override the normal minimum times before use
;328:		e = &g_entities[MAX_CLIENTS];
ADDRLP4 0
ADDRGP4 g_entities+101376
ASGNP4
line 329
;329:		for ( i = MAX_CLIENTS ; i<level.num_entities ; i++, e++) {
ADDRLP4 4
CNSTI4 128
ASGNI4
ADDRGP4 $156
JUMPV
LABELV $153
line 330
;330:			if ( e->inuse ) {
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
EQI4 $158
line 331
;331:				continue;
ADDRGP4 $154
JUMPV
LABELV $158
line 336
;332:			}
;333:
;334:			// the first couple seconds of server time can involve a lot of
;335:			// freeing and allocating, so relax the replacement policy
;336:			if ( !force && e->freetime > level.startTime + 2000 && level.time - e->freetime < 1000 ) {
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $160
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 536
ADDP4
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
ADDRGP4 level+40
INDIRI4
CNSTI4 2000
ADDI4
LEI4 $160
ADDRGP4 level+32
INDIRI4
ADDRLP4 12
INDIRI4
SUBI4
CNSTI4 1000
GEI4 $160
line 337
;337:				continue;
ADDRGP4 $154
JUMPV
LABELV $160
line 341
;338:			}
;339:
;340:			// reuse this slot
;341:			G_InitGentity( e );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 G_InitGentity
CALLV
pop
line 342
;342:			return e;
ADDRLP4 0
INDIRP4
RETP4
ADDRGP4 $147
JUMPV
LABELV $154
line 329
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 792
ADDP4
ASGNP4
LABELV $156
ADDRLP4 4
INDIRI4
ADDRGP4 level+12
INDIRI4
LTI4 $153
line 344
;343:		}
;344:		if ( i != MAX_GENTITIES ) {
ADDRLP4 4
INDIRI4
CNSTI4 1024
EQI4 $164
line 345
;345:			break;
ADDRGP4 $150
JUMPV
LABELV $164
line 347
;346:		}
;347:	}
LABELV $149
line 325
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 2
LTI4 $148
LABELV $150
line 348
;348:	if ( i == ENTITYNUM_MAX_NORMAL ) {
ADDRLP4 4
INDIRI4
CNSTI4 1022
NEI4 $166
line 349
;349:		G_Error( "G_Spawn: no free entities" );
ADDRGP4 $168
ARGP4
ADDRGP4 G_Error
CALLV
pop
line 350
;350:	}
LABELV $166
line 353
;351:	
;352:	// open up a new slot
;353:	level.num_entities++;
ADDRLP4 12
ADDRGP4 level+12
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 356
;354:
;355:	// let the server system know that there are more entities
;356:	trap_LocateGameData( level.gentities, level.num_entities, sizeof( gentity_t ), 
ADDRGP4 level+4
INDIRP4
ARGP4
ADDRGP4 level+12
INDIRI4
ARGI4
CNSTI4 792
ARGI4
ADDRGP4 level
INDIRP4
ARGP4
CNSTI4 760
ARGI4
ADDRGP4 trap_LocateGameData
CALLV
pop
line 359
;357:		&level.clients[0].ps, sizeof( level.clients[0] ) );
;358:
;359:	G_InitGentity( e );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 G_InitGentity
CALLV
pop
line 360
;360:	return e;
ADDRLP4 0
INDIRP4
RETP4
LABELV $147
endproc G_Spawn 16 20
export G_FreeEntity
proc G_FreeEntity 0 12
line 371
;361:}
;362:
;363:
;364:/*
;365:=================
;366:G_FreeEntity
;367:
;368:Marks the entity as free
;369:=================
;370:*/
;371:void G_FreeEntity( gentity_t *ed ) {
line 372
;372:	trap_UnlinkEntity (ed);		// unlink from world
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 374
;373:
;374:	if ( ed->neverFree ) {
ADDRFP4 0
INDIRP4
CNSTI4 520
ADDP4
INDIRI4
CNSTI4 0
EQI4 $173
line 375
;375:		return;
ADDRGP4 $172
JUMPV
LABELV $173
line 378
;376:	}
;377:
;378:	memset (ed, 0, sizeof(*ed));
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 792
ARGU4
ADDRGP4 memset
CALLP4
pop
line 379
;379:	ed->classname = "freed";
ADDRFP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $175
ASGNP4
line 380
;380:	ed->freetime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 536
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 381
;381:	ed->inuse = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 508
ADDP4
CNSTI4 0
ASGNI4
line 382
;382:}
LABELV $172
endproc G_FreeEntity 0 12
export G_TempEntity
proc G_TempEntity 20 8
line 393
;383:
;384:/*
;385:=================
;386:G_TempEntity
;387:
;388:Spawns an event entity that will be auto-removed
;389:The origin will be snapped to save net bandwidth, so care
;390:must be taken if the origin is right on a surface (snap towards start vector first)
;391:=================
;392:*/
;393:gentity_t *G_TempEntity( vec3_t origin, int event ) {
line 397
;394:	gentity_t		*e;
;395:	vec3_t		snapped;
;396:
;397:	e = G_Spawn();
ADDRLP4 16
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 16
INDIRP4
ASGNP4
line 398
;398:	e->s.eType = ET_EVENTS + event;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRFP4 4
INDIRI4
CNSTI4 12
ADDI4
ASGNI4
line 400
;399:
;400:	e->classname = "tempEntity";
ADDRLP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $178
ASGNP4
line 401
;401:	e->eventTime = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 540
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 402
;402:	e->freeAfterEvent = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 544
ADDP4
CNSTI4 1
ASGNI4
line 404
;403:
;404:	VectorCopy( origin, snapped );
ADDRLP4 4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 405
;405:	SnapVector( snapped );		// save network bandwidth
ADDRLP4 4
ADDRLP4 4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 4+4
ADDRLP4 4+4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 406
;406:	G_SetOrigin( e, snapped );
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 409
;407:
;408:	// find cluster for PVS
;409:	trap_LinkEntity( e );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 411
;410:
;411:	return e;
ADDRLP4 0
INDIRP4
RETP4
LABELV $177
endproc G_TempEntity 20 8
export G_KillBox
proc G_KillBox 4168 32
line 432
;412:}
;413:
;414:
;415:
;416:/*
;417:==============================================================================
;418:
;419:Kill box
;420:
;421:==============================================================================
;422:*/
;423:
;424:/*
;425:=================
;426:G_KillBox
;427:
;428:Kills all entities that would touch the proposed new positioning
;429:of ent.  Ent should be unlinked before calling this!
;430:=================
;431:*/
;432:void G_KillBox (gentity_t *ent) {
line 438
;433:	int			i, num;
;434:	int			touch[MAX_GENTITIES];
;435:	gentity_t	*hit;
;436:	vec3_t		mins, maxs;
;437:
;438:	VectorAdd( ent->client->ps.origin, ent->r.mins, mins );
ADDRLP4 4132
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4136
ADDRLP4 4132
INDIRP4
CNSTI4 504
ADDP4
ASGNP4
ADDRLP4 4108
ADDRLP4 4136
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 4132
INDIRP4
CNSTI4 424
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4108+4
ADDRLP4 4136
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 4132
INDIRP4
CNSTI4 428
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4140
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4108+8
ADDRLP4 4140
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 4140
INDIRP4
CNSTI4 432
ADDP4
INDIRF4
ADDF4
ASGNF4
line 439
;439:	VectorAdd( ent->client->ps.origin, ent->r.maxs, maxs );
ADDRLP4 4144
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4148
ADDRLP4 4144
INDIRP4
CNSTI4 504
ADDP4
ASGNP4
ADDRLP4 4120
ADDRLP4 4148
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 4144
INDIRP4
CNSTI4 436
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4120+4
ADDRLP4 4148
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 4144
INDIRP4
CNSTI4 440
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4152
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4120+8
ADDRLP4 4152
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 4152
INDIRP4
CNSTI4 444
ADDP4
INDIRF4
ADDF4
ASGNF4
line 440
;440:	num = trap_EntitiesInBox( mins, maxs, touch, MAX_GENTITIES );
ADDRLP4 4108
ARGP4
ADDRLP4 4120
ARGP4
ADDRLP4 12
ARGP4
CNSTI4 1024
ARGI4
ADDRLP4 4156
ADDRGP4 trap_EntitiesInBox
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 4156
INDIRI4
ASGNI4
line 442
;441:
;442:	for (i=0 ; i<num ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $192
JUMPV
LABELV $189
line 443
;443:		hit = &g_entities[touch[i]];
ADDRLP4 4
CNSTI4 792
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 12
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 444
;444:		if ( !hit->client ) {
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $193
line 445
;445:			continue;
ADDRGP4 $190
JUMPV
LABELV $193
line 449
;446:		}
;447:
;448:		// nail it
;449:		G_Damage ( hit, ent, ent, NULL, NULL,
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 4160
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4160
INDIRP4
ARGP4
ADDRLP4 4160
INDIRP4
ARGP4
ADDRLP4 4164
CNSTP4 0
ASGNP4
ADDRLP4 4164
INDIRP4
ARGP4
ADDRLP4 4164
INDIRP4
ARGP4
CNSTI4 100000
ARGI4
CNSTI4 32
ARGI4
CNSTI4 18
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 451
;450:			100000, DAMAGE_NO_PROTECTION, MOD_TELEFRAG);
;451:	}
LABELV $190
line 442
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $192
ADDRLP4 0
INDIRI4
ADDRLP4 8
INDIRI4
LTI4 $189
line 453
;452:
;453:}
LABELV $184
endproc G_KillBox 4168 32
export G_AddPredictableEvent
proc G_AddPredictableEvent 0 12
line 466
;454:
;455://==============================================================================
;456:
;457:/*
;458:===============
;459:G_AddPredictableEvent
;460:
;461:Use for non-pmove events that would also be predicted on the
;462:client side: jumppads and item pickups
;463:Adds an event+parm and twiddles the event counter
;464:===============
;465:*/
;466:void G_AddPredictableEvent( gentity_t *ent, int event, int eventParm ) {
line 467
;467:	if ( !ent->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $196
line 468
;468:		return;
ADDRGP4 $195
JUMPV
LABELV $196
line 470
;469:	}
;470:	BG_AddPredictableEventToPlayerstate( event, eventParm, &ent->client->ps );
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRI4
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ARGP4
ADDRGP4 BG_AddPredictableEventToPlayerstate
CALLV
pop
line 471
;471:}
LABELV $195
endproc G_AddPredictableEvent 0 12
export G_AddEvent
proc G_AddEvent 4 8
line 481
;472:
;473:
;474:/*
;475:===============
;476:G_AddEvent
;477:
;478:Adds an event+parm and twiddles the event counter
;479:===============
;480:*/
;481:void G_AddEvent( gentity_t *ent, int event, int eventParm ) {
line 484
;482:	int		bits;
;483:
;484:	if ( !event ) {
ADDRFP4 4
INDIRI4
CNSTI4 0
NEI4 $199
line 485
;485:		G_Printf( "G_AddEvent: zero event added for entity %i\n", ent->s.number );
ADDRGP4 $201
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
ADDRGP4 G_Printf
CALLV
pop
line 486
;486:		return;
ADDRGP4 $198
JUMPV
LABELV $199
line 490
;487:	}
;488:
;489:	// clients need to add the event in playerState_t instead of entityState_t
;490:	if ( ent->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $202
line 491
;491:		bits = ent->client->ps.externalEvent & EV_EVENT_BITS;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 128
ADDP4
INDIRI4
CNSTI4 768
BANDI4
ASGNI4
line 492
;492:		bits = ( bits + EV_EVENT_BIT1 ) & EV_EVENT_BITS;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 256
ADDI4
CNSTI4 768
BANDI4
ASGNI4
line 493
;493:		ent->client->ps.externalEvent = event | bits;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 128
ADDP4
ADDRFP4 4
INDIRI4
ADDRLP4 0
INDIRI4
BORI4
ASGNI4
line 494
;494:		ent->client->ps.externalEventParm = eventParm;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 132
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 495
;495:		ent->client->ps.externalEventTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 136
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 496
;496:	} else {
ADDRGP4 $203
JUMPV
LABELV $202
line 497
;497:		bits = ent->s.event & EV_EVENT_BITS;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
CNSTI4 768
BANDI4
ASGNI4
line 498
;498:		bits = ( bits + EV_EVENT_BIT1 ) & EV_EVENT_BITS;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 256
ADDI4
CNSTI4 768
BANDI4
ASGNI4
line 499
;499:		ent->s.event = event | bits;
ADDRFP4 0
INDIRP4
CNSTI4 180
ADDP4
ADDRFP4 4
INDIRI4
ADDRLP4 0
INDIRI4
BORI4
ASGNI4
line 500
;500:		ent->s.eventParm = eventParm;
ADDRFP4 0
INDIRP4
CNSTI4 184
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 501
;501:	}
LABELV $203
line 502
;502:	ent->eventTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 540
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 503
;503:}
LABELV $198
endproc G_AddEvent 4 8
export G_Sound
proc G_Sound 8 8
line 511
;504:
;505:
;506:/*
;507:=============
;508:G_Sound
;509:=============
;510:*/
;511:void G_Sound( gentity_t *ent, int channel, int soundIndex ) {
line 514
;512:	gentity_t	*te;
;513:
;514:	te = G_TempEntity( ent->r.currentOrigin, EV_GENERAL_SOUND );
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ARGP4
CNSTI4 45
ARGI4
ADDRLP4 4
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 515
;515:	te->s.eventParm = soundIndex;
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 516
;516:}
LABELV $206
endproc G_Sound 8 8
export G_SetOrigin
proc G_SetOrigin 8 0
line 529
;517:
;518:
;519://==============================================================================
;520:
;521:
;522:/*
;523:================
;524:G_SetOrigin
;525:
;526:Sets the pos trajectory for a fixed position
;527:================
;528:*/
;529:void G_SetOrigin( gentity_t *ent, vec3_t origin ) {
line 530
;530:	VectorCopy( origin, ent->s.pos.trBase );
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 531
;531:	ent->s.pos.trType = TR_STATIONARY;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 0
ASGNI4
line 532
;532:	ent->s.pos.trTime = 0;
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
CNSTI4 0
ASGNI4
line 533
;533:	ent->s.pos.trDuration = 0;
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
CNSTI4 0
ASGNI4
line 534
;534:	VectorClear( ent->s.pos.trDelta );
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 4
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 4
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 4
INDIRF4
ASGNF4
line 536
;535:
;536:	VectorCopy( origin, ent->r.currentOrigin );
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 537
;537:}
LABELV $207
endproc G_SetOrigin 8 0
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_TouchSolids
import G_TouchTriggers
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $201
byte 1 71
byte 1 95
byte 1 65
byte 1 100
byte 1 100
byte 1 69
byte 1 118
byte 1 101
byte 1 110
byte 1 116
byte 1 58
byte 1 32
byte 1 122
byte 1 101
byte 1 114
byte 1 111
byte 1 32
byte 1 101
byte 1 118
byte 1 101
byte 1 110
byte 1 116
byte 1 32
byte 1 97
byte 1 100
byte 1 100
byte 1 101
byte 1 100
byte 1 32
byte 1 102
byte 1 111
byte 1 114
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $178
byte 1 116
byte 1 101
byte 1 109
byte 1 112
byte 1 69
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 0
align 1
LABELV $175
byte 1 102
byte 1 114
byte 1 101
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $168
byte 1 71
byte 1 95
byte 1 83
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 58
byte 1 32
byte 1 110
byte 1 111
byte 1 32
byte 1 102
byte 1 114
byte 1 101
byte 1 101
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 105
byte 1 101
byte 1 115
byte 1 0
align 1
LABELV $146
byte 1 110
byte 1 111
byte 1 99
byte 1 108
byte 1 97
byte 1 115
byte 1 115
byte 1 0
align 1
LABELV $126
byte 1 40
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 41
byte 1 0
align 1
LABELV $119
byte 1 101
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 32
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 114
byte 1 101
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 100
byte 1 32
byte 1 119
byte 1 104
byte 1 105
byte 1 108
byte 1 101
byte 1 32
byte 1 117
byte 1 115
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $114
byte 1 87
byte 1 65
byte 1 82
byte 1 78
byte 1 73
byte 1 78
byte 1 71
byte 1 58
byte 1 32
byte 1 69
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 32
byte 1 117
byte 1 115
byte 1 101
byte 1 100
byte 1 32
byte 1 105
byte 1 116
byte 1 115
byte 1 101
byte 1 108
byte 1 102
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $103
byte 1 71
byte 1 95
byte 1 80
byte 1 105
byte 1 99
byte 1 107
byte 1 84
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 58
byte 1 32
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 110
byte 1 111
byte 1 116
byte 1 32
byte 1 102
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $93
byte 1 71
byte 1 95
byte 1 80
byte 1 105
byte 1 99
byte 1 107
byte 1 84
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 32
byte 1 99
byte 1 97
byte 1 108
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 78
byte 1 85
byte 1 76
byte 1 76
byte 1 32
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 10
byte 1 0
align 1
LABELV $75
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $62
byte 1 71
byte 1 95
byte 1 70
byte 1 105
byte 1 110
byte 1 100
byte 1 67
byte 1 111
byte 1 110
byte 1 102
byte 1 105
byte 1 103
byte 1 115
byte 1 116
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 73
byte 1 110
byte 1 100
byte 1 101
byte 1 120
byte 1 58
byte 1 32
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 102
byte 1 108
byte 1 111
byte 1 119
byte 1 0
