export InitTrigger
code
proc InitTrigger 12 8
file "..\g_trigger.c"
line 6
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:#include "g_local.h"
;4:
;5:
;6:void InitTrigger( gentity_t *self ) {
line 7
;7:	if (!VectorCompare (self->s.angles, vec3_origin))
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRGP4 vec3_origin
ARGP4
ADDRLP4 0
ADDRGP4 VectorCompare
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $47
line 8
;8:		G_SetMovedir (self->s.angles, self->movedir);
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 656
ADDP4
ARGP4
ADDRGP4 G_SetMovedir
CALLV
pop
LABELV $47
line 10
;9:
;10:	trap_SetBrushModel( self, self->model );
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 528
ADDP4
INDIRP4
ARGP4
ADDRGP4 trap_SetBrushModel
CALLV
pop
line 11
;11:	self->r.contents = CONTENTS_TRIGGER;		// replaces the -1 from trap_SetBrushModel
ADDRFP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 1073741824
ASGNI4
line 12
;12:	self->r.svFlags = SVF_NOCLIENT;
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
CNSTI4 1
ASGNI4
line 13
;13:}
LABELV $46
endproc InitTrigger 12 8
export multi_wait
proc multi_wait 0 0
line 17
;14:
;15:
;16:// the wait time has passed, so set back up for another activation
;17:void multi_wait( gentity_t *ent ) {
line 18
;18:	ent->nextthink = 0;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
CNSTI4 0
ASGNI4
line 19
;19:}
LABELV $49
endproc multi_wait 0 0
export multi_trigger
proc multi_trigger 12 8
line 25
;20:
;21:
;22:// the trigger was just activated
;23:// ent->activator should be set to the activator so it can be held through a delay
;24:// so wait for the delay time before firing
;25:void multi_trigger( gentity_t *ent, gentity_t *activator ) {
line 26
;26:	ent->activator = activator;
ADDRFP4 0
INDIRP4
CNSTI4 752
ADDP4
ADDRFP4 4
INDIRP4
ASGNP4
line 27
;27:	if ( ent->nextthink ) {
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
INDIRI4
CNSTI4 0
EQI4 $51
line 28
;28:		return;		// can't retrigger until the wait is over
ADDRGP4 $50
JUMPV
LABELV $51
line 31
;29:	}
;30:
;31:	G_UseTargets (ent, ent->activator);
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 752
ADDP4
INDIRP4
ARGP4
ADDRGP4 G_UseTargets
CALLV
pop
line 33
;32:
;33:	if ( ent->wait > 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
CNSTF4 0
LEF4 $53
line 34
;34:		ent->think = multi_wait;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 multi_wait
ASGNP4
line 35
;35:		ent->nextthink = level.time + ( ent->wait + ent->random * crandom() ) * 1000;
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
CNSTF4 1148846080
ADDRLP4 8
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
CNSTI4 780
ADDP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 4
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 36
;36:	} else {
ADDRGP4 $54
JUMPV
LABELV $53
line 39
;37:		// we can't just remove (self) here, because this is a touch function
;38:		// called while looping through area links...
;39:		ent->touch = 0;
ADDRFP4 0
INDIRP4
CNSTI4 684
ADDP4
CNSTP4 0
ASGNP4
line 40
;40:		ent->nextthink = level.time + FRAMETIME;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 41
;41:		ent->think = G_FreeEntity;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 G_FreeEntity
ASGNP4
line 42
;42:	}
LABELV $54
line 43
;43:}
LABELV $50
endproc multi_trigger 12 8
export Use_Multi
proc Use_Multi 0 8
line 45
;44:
;45:void Use_Multi( gentity_t *ent, gentity_t *other, gentity_t *activator ) {
line 46
;46:	multi_trigger( ent, activator );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 multi_trigger
CALLV
pop
line 47
;47:}
LABELV $57
endproc Use_Multi 0 8
export Touch_Multi
proc Touch_Multi 0 8
line 49
;48:
;49:void Touch_Multi( gentity_t *self, gentity_t *other, trace_t *trace ) {
line 50
;50:	if( !other->client ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $59
line 51
;51:		return;
ADDRGP4 $58
JUMPV
LABELV $59
line 53
;52:	}
;53:	multi_trigger( self, other );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 multi_trigger
CALLV
pop
line 54
;54:}
LABELV $58
endproc Touch_Multi 0 8
export SP_trigger_multiple
proc SP_trigger_multiple 12 12
line 63
;55:
;56:/*QUAKED trigger_multiple (.5 .5 .5) ?
;57:"wait" : Seconds between triggerings, 0.5 default, -1 = one time only.
;58:"random"	wait variance, default is 0
;59:Variable sized repeatable trigger.  Must be targeted at one or more entities.
;60:so, the basic time between firing is a random time between
;61:(wait - random) and (wait + random)
;62:*/
;63:void SP_trigger_multiple( gentity_t *ent ) {
line 64
;64:	G_SpawnFloat( "wait", "0.5", &ent->wait );
ADDRGP4 $62
ARGP4
ADDRGP4 $63
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 65
;65:	G_SpawnFloat( "random", "0", &ent->random );
ADDRGP4 $64
ARGP4
ADDRGP4 $65
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 780
ADDP4
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 67
;66:
;67:	if ( ent->random >= ent->wait && ent->wait >= 0 ) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 780
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
LTF4 $66
ADDRLP4 4
INDIRF4
CNSTF4 0
LTF4 $66
line 68
;68:		ent->random = ent->wait - FRAMETIME;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 780
ADDP4
ADDRLP4 8
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
CNSTF4 1120403456
SUBF4
ASGNF4
line 69
;69:		G_Printf( "trigger_multiple has random >= wait\n" );
ADDRGP4 $68
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 70
;70:	}
LABELV $66
line 72
;71:
;72:	ent->touch = Touch_Multi;
ADDRFP4 0
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 Touch_Multi
ASGNP4
line 73
;73:	ent->use = Use_Multi;
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
ADDRGP4 Use_Multi
ASGNP4
line 75
;74:
;75:	InitTrigger( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitTrigger
CALLV
pop
line 76
;76:	trap_LinkEntity (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 77
;77:}
LABELV $61
endproc SP_trigger_multiple 12 12
export trigger_always_think
proc trigger_always_think 4 8
line 89
;78:
;79:
;80:
;81:/*
;82:==============================================================================
;83:
;84:trigger_always
;85:
;86:==============================================================================
;87:*/
;88:
;89:void trigger_always_think( gentity_t *ent ) {
line 90
;90:	G_UseTargets(ent, ent);
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 G_UseTargets
CALLV
pop
line 91
;91:	G_FreeEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 92
;92:}
LABELV $69
endproc trigger_always_think 4 8
export SP_trigger_always
proc SP_trigger_always 0 0
line 97
;93:
;94:/*QUAKED trigger_always (.5 .5 .5) (-8 -8 -8) (8 8 8)
;95:This trigger will always fire.  It is activated by the world.
;96:*/
;97:void SP_trigger_always (gentity_t *ent) {
line 99
;98:	// we must have some delay to make sure our use targets are present
;99:	ent->nextthink = level.time + 300;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 300
ADDI4
ASGNI4
line 100
;100:	ent->think = trigger_always_think;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 trigger_always_think
ASGNP4
line 101
;101:}
LABELV $70
endproc SP_trigger_always 0 0
export trigger_push_touch
proc trigger_push_touch 8 12
line 112
;102:
;103:
;104:/*
;105:==============================================================================
;106:
;107:trigger_push
;108:
;109:==============================================================================
;110:*/
;111:
;112:void trigger_push_touch (gentity_t *self, gentity_t *other, trace_t *trace ) {
line 113
;113:	if ( !other->client ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $73
line 114
;114:		return;
ADDRGP4 $72
JUMPV
LABELV $73
line 117
;115:	}
;116:
;117:	if ( other->client->ps.pm_type != PM_NORMAL ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 0
EQI4 $75
line 118
;118:		return;
ADDRGP4 $72
JUMPV
LABELV $75
line 120
;119:	}
;120:	if ( other->client->ps.powerups[PW_FLIGHT] ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 336
ADDP4
INDIRI4
CNSTI4 0
EQI4 $77
line 121
;121:		return;
ADDRGP4 $72
JUMPV
LABELV $77
line 124
;122:	}
;123:
;124:	if (other->client && other->client->hook)
ADDRLP4 0
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 4
CNSTU4 0
ASGNU4
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRLP4 4
INDIRU4
EQU4 $79
ADDRLP4 0
INDIRP4
CNSTI4 708
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 4
INDIRU4
EQU4 $79
line 125
;125:		Weapon_HookFree(other->client->hook);
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 708
ADDP4
INDIRP4
ARGP4
ADDRGP4 Weapon_HookFree
CALLV
pop
LABELV $79
line 127
;126:
;127:	if ( other->client->ps.velocity[2] < 100 ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
CNSTF4 1120403456
GEF4 $81
line 129
;128:		// don't play the event sound again if we are in a fat trigger
;129:		G_AddPredictableEvent( other, EV_JUMP_PAD, 0 );
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 13
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddPredictableEvent
CALLV
pop
line 130
;130:	}
LABELV $81
line 131
;131:	VectorCopy (self->s.origin2, other->client->ps.velocity);
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRB
ASGNB 12
line 132
;132:}
LABELV $72
endproc trigger_push_touch 8 12
export AimAtTarget
proc AimAtTarget 72 4
line 142
;133:
;134:
;135:/*
;136:=================
;137:AimAtTarget
;138:
;139:Calculate origin2 so the target apogee will be hit
;140:=================
;141:*/
;142:void AimAtTarget( gentity_t *self ) {
line 148
;143:	gentity_t	*ent;
;144:	vec3_t		origin;
;145:	float		height, gravity, time, forward;
;146:	float		dist;
;147:
;148:	VectorAdd( self->r.absmin, self->r.absmax, origin );
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 36
INDIRP4
CNSTI4 452
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
CNSTI4 464
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 36
INDIRP4
CNSTI4 456
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
CNSTI4 468
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 40
INDIRP4
CNSTI4 460
ADDP4
INDIRF4
ADDRLP4 40
INDIRP4
CNSTI4 472
ADDP4
INDIRF4
ADDF4
ASGNF4
line 149
;149:	VectorScale ( origin, 0.5, origin );
ADDRLP4 44
CNSTF4 1056964608
ASGNF4
ADDRLP4 0
ADDRLP4 44
INDIRF4
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 44
INDIRF4
ADDRLP4 0+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+8
CNSTF4 1056964608
ADDRLP4 0+8
INDIRF4
MULF4
ASGNF4
line 151
;150:
;151:	ent = G_PickTarget( self->target );
ADDRFP4 0
INDIRP4
CNSTI4 636
ADDP4
INDIRP4
ARGP4
ADDRLP4 48
ADDRGP4 G_PickTarget
CALLP4
ASGNP4
ADDRLP4 12
ADDRLP4 48
INDIRP4
ASGNP4
line 152
;152:	if ( !ent ) {
ADDRLP4 12
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $90
line 153
;153:		G_FreeEntity( self );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 154
;154:		return;
ADDRGP4 $83
JUMPV
LABELV $90
line 157
;155:	}
;156:
;157:	height = ent->s.origin[2] - origin[2];
ADDRLP4 28
ADDRLP4 12
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRLP4 0+8
INDIRF4
SUBF4
ASGNF4
line 158
;158:	gravity = g_gravity.value;
ADDRLP4 24
ADDRGP4 g_gravity+8
INDIRF4
ASGNF4
line 159
;159:	time = sqrt( height / ( .5 * gravity ) );
ADDRLP4 28
INDIRF4
CNSTF4 1056964608
ADDRLP4 24
INDIRF4
MULF4
DIVF4
ARGF4
ADDRLP4 52
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 16
ADDRLP4 52
INDIRF4
ASGNF4
line 160
;160:	if ( !time ) {
ADDRLP4 16
INDIRF4
CNSTF4 0
NEF4 $94
line 161
;161:		G_FreeEntity( self );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 162
;162:		return;
ADDRGP4 $83
JUMPV
LABELV $94
line 166
;163:	}
;164:
;165:	// set s.origin2 to the push velocity
;166:	VectorSubtract ( ent->s.origin, origin, self->s.origin2 );
ADDRFP4 0
INDIRP4
CNSTI4 104
ADDP4
ADDRLP4 12
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
ADDRLP4 0
INDIRF4
SUBF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
ADDRLP4 12
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ADDRLP4 0+4
INDIRF4
SUBF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRLP4 12
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRLP4 0+8
INDIRF4
SUBF4
ASGNF4
line 167
;167:	self->s.origin2[2] = 0;
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
CNSTF4 0
ASGNF4
line 168
;168:	dist = VectorNormalize( self->s.origin2);
ADDRFP4 0
INDIRP4
CNSTI4 104
ADDP4
ARGP4
ADDRLP4 56
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 32
ADDRLP4 56
INDIRF4
ASGNF4
line 170
;169:
;170:	forward = dist / time;
ADDRLP4 20
ADDRLP4 32
INDIRF4
ADDRLP4 16
INDIRF4
DIVF4
ASGNF4
line 171
;171:	VectorScale( self->s.origin2, forward, self->s.origin2 );
ADDRLP4 60
ADDRFP4 0
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ASGNF4
ADDRLP4 64
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ASGNF4
ADDRLP4 68
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ASGNF4
line 173
;172:
;173:	self->s.origin2[2] = time * gravity;
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRLP4 16
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ASGNF4
line 174
;174:}
LABELV $83
endproc AimAtTarget 72 4
export SP_trigger_push
proc SP_trigger_push 4 4
line 181
;175:
;176:
;177:/*QUAKED trigger_push (.5 .5 .5) ?
;178:Must point at a target_position, which will be the apex of the leap.
;179:This will be client side predicted, unlike target_push
;180:*/
;181:void SP_trigger_push( gentity_t *self ) {
line 182
;182:	InitTrigger (self);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitTrigger
CALLV
pop
line 185
;183:
;184:	// unlike other triggers, we need to send this one to the client
;185:	self->r.svFlags &= ~SVF_NOCLIENT;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 -2
BANDI4
ASGNI4
line 188
;186:
;187:	// make sure the client precaches this sound
;188:	G_SoundIndex("sound/world/jumppad.wav");
ADDRGP4 $99
ARGP4
ADDRGP4 G_SoundIndex
CALLI4
pop
line 190
;189:
;190:	self->s.eType = ET_PUSH_TRIGGER;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 8
ASGNI4
line 191
;191:	self->touch = trigger_push_touch;
ADDRFP4 0
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 trigger_push_touch
ASGNP4
line 192
;192:	self->think = AimAtTarget;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 AimAtTarget
ASGNP4
line 193
;193:	self->nextthink = level.time + FRAMETIME;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 194
;194:	trap_LinkEntity (self);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 195
;195:}
LABELV $98
endproc SP_trigger_push 4 4
export Use_target_push
proc Use_target_push 0 12
line 198
;196:
;197:
;198:void Use_target_push( gentity_t *self, gentity_t *other, gentity_t *activator ) {
line 199
;199:	if ( !activator->client ) {
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $102
line 200
;200:		return;
ADDRGP4 $101
JUMPV
LABELV $102
line 203
;201:	}
;202:
;203:	if ( activator->client->ps.pm_type != PM_NORMAL ) {
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 0
EQI4 $104
line 204
;204:		return;
ADDRGP4 $101
JUMPV
LABELV $104
line 206
;205:	}
;206:	if ( activator->client->ps.powerups[PW_FLIGHT] ) {
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 336
ADDP4
INDIRI4
CNSTI4 0
EQI4 $106
line 207
;207:		return;
ADDRGP4 $101
JUMPV
LABELV $106
line 210
;208:	}
;209:
;210:	VectorCopy (self->s.origin2, activator->client->ps.velocity);
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRB
ASGNB 12
line 213
;211:
;212:	// play fly sound every 1.5 seconds
;213:	if ( activator->fly_sound_debounce_time < level.time ) {
ADDRFP4 8
INDIRP4
CNSTI4 704
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GEI4 $108
line 214
;214:		activator->fly_sound_debounce_time = level.time + 1500;
ADDRFP4 8
INDIRP4
CNSTI4 704
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1500
ADDI4
ASGNI4
line 215
;215:		G_Sound( activator, CHAN_AUTO, self->noise_index );
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 772
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 216
;216:	}
LABELV $108
line 217
;217:}
LABELV $101
endproc Use_target_push 0 12
export SP_target_push
proc SP_target_push 36 8
line 224
;218:
;219:/*QUAKED target_push (.5 .5 .5) (-8 -8 -8) (8 8 8) bouncepad
;220:Pushes the activator in the direction.of angle, or towards a target apex.
;221:"speed"		defaults to 1000
;222:if "bouncepad", play bounce noise instead of windfly
;223:*/
;224:void SP_target_push( gentity_t *self ) {
line 225
;225:	if (!self->speed) {
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
CNSTF4 0
NEF4 $113
line 226
;226:		self->speed = 1000;
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
CNSTF4 1148846080
ASGNF4
line 227
;227:	}
LABELV $113
line 228
;228:	G_SetMovedir (self->s.angles, self->s.origin2);
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ARGP4
ADDRGP4 G_SetMovedir
CALLV
pop
line 229
;229:	VectorScale (self->s.origin2, self->speed, self->s.origin2);
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
ADDRLP4 4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
ADDRLP4 4
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
ADDRLP4 12
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
ADDRLP4 12
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 24
ADDRLP4 20
INDIRP4
CNSTI4 112
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
MULF4
ASGNF4
line 231
;230:
;231:	if ( self->spawnflags & 1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $115
line 232
;232:		self->noise_index = G_SoundIndex("sound/world/jumppad.wav");
ADDRGP4 $99
ARGP4
ADDRLP4 28
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 772
ADDP4
ADDRLP4 28
INDIRI4
ASGNI4
line 233
;233:	} else {
ADDRGP4 $116
JUMPV
LABELV $115
line 234
;234:		self->noise_index = G_SoundIndex("sound/misc/windfly.wav");
ADDRGP4 $117
ARGP4
ADDRLP4 28
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 772
ADDP4
ADDRLP4 28
INDIRI4
ASGNI4
line 235
;235:	}
LABELV $116
line 236
;236:	if ( self->target ) {
ADDRFP4 0
INDIRP4
CNSTI4 636
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $118
line 237
;237:		VectorCopy( self->s.origin, self->r.absmin );
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTI4 452
ADDP4
ADDRLP4 28
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 238
;238:		VectorCopy( self->s.origin, self->r.absmax );
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
CNSTI4 464
ADDP4
ADDRLP4 32
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 239
;239:		self->think = AimAtTarget;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 AimAtTarget
ASGNP4
line 240
;240:		self->nextthink = level.time + FRAMETIME;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 241
;241:	}
LABELV $118
line 242
;242:	self->use = Use_target_push;
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
ADDRGP4 Use_target_push
ASGNP4
line 243
;243:}
LABELV $112
endproc SP_target_push 36 8
export trigger_teleporter_touch
proc trigger_teleporter_touch 12 12
line 253
;244:
;245:/*
;246:==============================================================================
;247:
;248:trigger_teleport
;249:
;250:==============================================================================
;251:*/
;252:
;253:void trigger_teleporter_touch (gentity_t *self, gentity_t *other, trace_t *trace ) {
line 256
;254:	gentity_t	*dest;
;255:
;256:	if ( !other->client ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $122
line 257
;257:		return;
ADDRGP4 $121
JUMPV
LABELV $122
line 259
;258:	}
;259:	if ( other->client->ps.pm_type == PM_DEAD ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
NEI4 $124
line 260
;260:		return;
ADDRGP4 $121
JUMPV
LABELV $124
line 263
;261:	}
;262:	// Spectators only?
;263:	if ( ( self->spawnflags & 1 ) && 
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $126
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
EQI4 $126
line 264
;264:		other->client->sess.sessionTeam != TEAM_SPECTATOR ) {
line 265
;265:		return;
ADDRGP4 $121
JUMPV
LABELV $126
line 269
;266:	}
;267:
;268:
;269:	dest = 	G_PickTarget( self->target );
ADDRFP4 0
INDIRP4
CNSTI4 636
ADDP4
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 G_PickTarget
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 270
;270:	if (!dest) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $128
line 271
;271:		G_Printf ("Couldn't find teleporter destination\n");
ADDRGP4 $130
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 272
;272:		return;
ADDRGP4 $121
JUMPV
LABELV $128
line 275
;273:	}
;274:
;275:	TeleportPlayer( other, dest->s.origin, dest->s.angles );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRGP4 TeleportPlayer
CALLV
pop
line 276
;276:}
LABELV $121
endproc trigger_teleporter_touch 12 12
export SP_trigger_teleport
proc SP_trigger_teleport 4 4
line 287
;277:
;278:
;279:/*QUAKED trigger_teleport (.5 .5 .5) ? SPECTATOR
;280:Allows client side prediction of teleportation events.
;281:Must point at a target_position, which will be the teleport destination.
;282:
;283:If spectator is set, only spectators can use this teleport
;284:Spectator teleporters are not normally placed in the editor, but are created
;285:automatically near doors to allow spectators to move through them
;286:*/
;287:void SP_trigger_teleport( gentity_t *self ) {
line 288
;288:	InitTrigger (self);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitTrigger
CALLV
pop
line 292
;289:
;290:	// unlike other triggers, we need to send this one to the client
;291:	// unless is a spectator trigger
;292:	if ( self->spawnflags & 1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $132
line 293
;293:		self->r.svFlags |= SVF_NOCLIENT;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
BORI4
ASGNI4
line 294
;294:	} else {
ADDRGP4 $133
JUMPV
LABELV $132
line 295
;295:		self->r.svFlags &= ~SVF_NOCLIENT;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 -2
BANDI4
ASGNI4
line 296
;296:	}
LABELV $133
line 299
;297:
;298:	// make sure the client precaches this sound
;299:	G_SoundIndex("sound/world/jumppad.wav");
ADDRGP4 $99
ARGP4
ADDRGP4 G_SoundIndex
CALLI4
pop
line 301
;300:
;301:	self->s.eType = ET_TELEPORT_TRIGGER;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 9
ASGNI4
line 302
;302:	self->touch = trigger_teleporter_touch;
ADDRFP4 0
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 trigger_teleporter_touch
ASGNP4
line 304
;303:
;304:	trap_LinkEntity (self);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 305
;305:}
LABELV $131
endproc SP_trigger_teleport 4 4
export hurt_use
proc hurt_use 0 4
line 328
;306:
;307:
;308:/*
;309:==============================================================================
;310:
;311:trigger_hurt
;312:
;313:==============================================================================
;314:*/
;315:
;316:/*QUAKED trigger_hurt (.5 .5 .5) ? START_OFF - SILENT NO_PROTECTION SLOW
;317:Any entity that touches this will be hurt.
;318:It does dmg points of damage each server frame
;319:Targeting the trigger will toggle its on / off state.
;320:
;321:SILENT			supresses playing the sound
;322:SLOW			changes the damage rate to once per second
;323:NO_PROTECTION	*nothing* stops the damage
;324:
;325:"dmg"			default 5 (whole numbers only)
;326:
;327:*/
;328:void hurt_use( gentity_t *self, gentity_t *other, gentity_t *activator ) {
line 329
;329:	if ( self->r.linked ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRI4
CNSTI4 0
EQI4 $135
line 330
;330:		trap_UnlinkEntity( self );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 331
;331:	} else {
ADDRGP4 $136
JUMPV
LABELV $135
line 332
;332:		trap_LinkEntity( self );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 333
;333:	}
LABELV $136
line 334
;334:}
LABELV $134
endproc hurt_use 0 4
export hurt_touch
proc hurt_touch 12 32
line 336
;335:
;336:void hurt_touch( gentity_t *self, gentity_t *other, trace_t *trace ) {
line 339
;337:	int		dflags;
;338:
;339:	if ( !other->takedamage ) {
ADDRFP4 4
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
NEI4 $138
line 340
;340:		return;
ADDRGP4 $137
JUMPV
LABELV $138
line 343
;341:	}
;342:
;343:	if ( self->timestamp > level.time ) {
ADDRFP4 0
INDIRP4
CNSTI4 628
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
LEI4 $140
line 344
;344:		return;
ADDRGP4 $137
JUMPV
LABELV $140
line 347
;345:	}
;346:
;347:	if ( self->spawnflags & 16 ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $143
line 348
;348:		self->timestamp = level.time + 1000;
ADDRFP4 0
INDIRP4
CNSTI4 628
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
ADDI4
ASGNI4
line 349
;349:	} else {
ADDRGP4 $144
JUMPV
LABELV $143
line 350
;350:		self->timestamp = level.time + FRAMETIME;
ADDRFP4 0
INDIRP4
CNSTI4 628
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 351
;351:	}
LABELV $144
line 354
;352:
;353:	// play sound
;354:	if ( !(self->spawnflags & 4) ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
NEI4 $147
line 355
;355:		G_Sound( other, CHAN_AUTO, self->noise_index );
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 772
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 356
;356:	}
LABELV $147
line 358
;357:
;358:	if (self->spawnflags & 8)
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $149
line 359
;359:		dflags = DAMAGE_NO_PROTECTION;
ADDRLP4 0
CNSTI4 32
ASGNI4
ADDRGP4 $150
JUMPV
LABELV $149
line 361
;360:	else
;361:		dflags = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $150
line 362
;362:	G_Damage (other, self, self, NULL, NULL, self->damage, dflags, MOD_TRIGGER_HURT);
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 8
CNSTP4 0
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 720
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
CNSTI4 22
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 363
;363:}
LABELV $137
endproc hurt_touch 12 32
export SP_trigger_hurt
proc SP_trigger_hurt 4 4
line 365
;364:
;365:void SP_trigger_hurt( gentity_t *self ) {
line 366
;366:	InitTrigger (self);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitTrigger
CALLV
pop
line 368
;367:
;368:	self->noise_index = G_SoundIndex( "sound/world/electro.wav" );
ADDRGP4 $152
ARGP4
ADDRLP4 0
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 772
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 369
;369:	self->touch = hurt_touch;
ADDRFP4 0
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 hurt_touch
ASGNP4
line 371
;370:
;371:	if ( !self->damage ) {
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
INDIRI4
CNSTI4 0
NEI4 $153
line 372
;372:		self->damage = 5;
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
CNSTI4 5
ASGNI4
line 373
;373:	}
LABELV $153
line 375
;374:
;375:	self->r.contents = CONTENTS_TRIGGER;
ADDRFP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 1073741824
ASGNI4
line 377
;376:
;377:	if ( self->spawnflags & 2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $155
line 378
;378:		self->use = hurt_use;
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
ADDRGP4 hurt_use
ASGNP4
line 379
;379:	}
LABELV $155
line 382
;380:
;381:	// link in to the world if starting active
;382:	if ( ! (self->spawnflags & 1) ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
NEI4 $157
line 383
;383:		trap_LinkEntity (self);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 384
;384:	}
LABELV $157
line 385
;385:}
LABELV $151
endproc SP_trigger_hurt 4 4
export func_timer_think
proc func_timer_think 12 8
line 408
;386:
;387:
;388:/*
;389:==============================================================================
;390:
;391:timer
;392:
;393:==============================================================================
;394:*/
;395:
;396:
;397:/*QUAKED func_timer (0.3 0.1 0.6) (-8 -8 -8) (8 8 8) START_ON
;398:This should be renamed trigger_timer...
;399:Repeatedly fires its targets.
;400:Can be turned on or off by using.
;401:
;402:"wait"			base time between triggering all targets, default is 1
;403:"random"		wait variance, default is 0
;404:so, the basic time between firing is a random time between
;405:(wait - random) and (wait + random)
;406:
;407:*/
;408:void func_timer_think( gentity_t *self ) {
line 409
;409:	G_UseTargets (self, self->activator);
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 752
ADDP4
INDIRP4
ARGP4
ADDRGP4 G_UseTargets
CALLV
pop
line 411
;410:	// set time before next firing
;411:	self->nextthink = level.time + 1000 * ( self->wait + crandom() * self->random );
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
CNSTF4 1148846080
ADDRLP4 8
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 4
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 0
INDIRP4
CNSTI4 780
ADDP4
INDIRF4
MULF4
ADDF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 412
;412:}
LABELV $159
endproc func_timer_think 12 8
export func_timer_use
proc func_timer_use 0 4
line 414
;413:
;414:void func_timer_use( gentity_t *self, gentity_t *other, gentity_t *activator ) {
line 415
;415:	self->activator = activator;
ADDRFP4 0
INDIRP4
CNSTI4 752
ADDP4
ADDRFP4 8
INDIRP4
ASGNP4
line 418
;416:
;417:	// if on, turn it off
;418:	if ( self->nextthink ) {
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
INDIRI4
CNSTI4 0
EQI4 $162
line 419
;419:		self->nextthink = 0;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
CNSTI4 0
ASGNI4
line 420
;420:		return;
ADDRGP4 $161
JUMPV
LABELV $162
line 424
;421:	}
;422:
;423:	// turn it on
;424:	func_timer_think (self);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 func_timer_think
CALLV
pop
line 425
;425:}
LABELV $161
endproc func_timer_use 0 4
export SP_func_timer
proc SP_func_timer 12 12
line 427
;426:
;427:void SP_func_timer( gentity_t *self ) {
line 428
;428:	G_SpawnFloat( "random", "1", &self->random);
ADDRGP4 $64
ARGP4
ADDRGP4 $165
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 780
ADDP4
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 429
;429:	G_SpawnFloat( "wait", "1", &self->wait );
ADDRGP4 $62
ARGP4
ADDRGP4 $165
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 431
;430:
;431:	self->use = func_timer_use;
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
ADDRGP4 func_timer_use
ASGNP4
line 432
;432:	self->think = func_timer_think;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 func_timer_think
ASGNP4
line 434
;433:
;434:	if ( self->random >= self->wait ) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 780
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
LTF4 $166
line 435
;435:		self->random = self->wait - FRAMETIME;
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 780
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
CNSTF4 1120403456
SUBF4
ASGNF4
line 436
;436:		G_Printf( "func_timer at %s has random >= wait\n", vtos( self->s.origin ) );
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRLP4 8
ADDRGP4 vtos
CALLP4
ASGNP4
ADDRGP4 $168
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 437
;437:	}
LABELV $166
line 439
;438:
;439:	if ( self->spawnflags & 1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $169
line 440
;440:		self->nextthink = level.time + FRAMETIME;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 441
;441:		self->activator = self;
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 752
ADDP4
ADDRLP4 4
INDIRP4
ASGNP4
line 442
;442:	}
LABELV $169
line 444
;443:
;444:	self->r.svFlags = SVF_NOCLIENT;
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
CNSTI4 1
ASGNI4
line 445
;445:}
LABELV $164
endproc SP_func_timer 12 12
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $168
byte 1 102
byte 1 117
byte 1 110
byte 1 99
byte 1 95
byte 1 116
byte 1 105
byte 1 109
byte 1 101
byte 1 114
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 104
byte 1 97
byte 1 115
byte 1 32
byte 1 114
byte 1 97
byte 1 110
byte 1 100
byte 1 111
byte 1 109
byte 1 32
byte 1 62
byte 1 61
byte 1 32
byte 1 119
byte 1 97
byte 1 105
byte 1 116
byte 1 10
byte 1 0
align 1
LABELV $165
byte 1 49
byte 1 0
align 1
LABELV $152
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 111
byte 1 114
byte 1 108
byte 1 100
byte 1 47
byte 1 101
byte 1 108
byte 1 101
byte 1 99
byte 1 116
byte 1 114
byte 1 111
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $130
byte 1 67
byte 1 111
byte 1 117
byte 1 108
byte 1 100
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 102
byte 1 105
byte 1 110
byte 1 100
byte 1 32
byte 1 116
byte 1 101
byte 1 108
byte 1 101
byte 1 112
byte 1 111
byte 1 114
byte 1 116
byte 1 101
byte 1 114
byte 1 32
byte 1 100
byte 1 101
byte 1 115
byte 1 116
byte 1 105
byte 1 110
byte 1 97
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 10
byte 1 0
align 1
LABELV $117
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 109
byte 1 105
byte 1 115
byte 1 99
byte 1 47
byte 1 119
byte 1 105
byte 1 110
byte 1 100
byte 1 102
byte 1 108
byte 1 121
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $99
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 111
byte 1 114
byte 1 108
byte 1 100
byte 1 47
byte 1 106
byte 1 117
byte 1 109
byte 1 112
byte 1 112
byte 1 97
byte 1 100
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $68
byte 1 116
byte 1 114
byte 1 105
byte 1 103
byte 1 103
byte 1 101
byte 1 114
byte 1 95
byte 1 109
byte 1 117
byte 1 108
byte 1 116
byte 1 105
byte 1 112
byte 1 108
byte 1 101
byte 1 32
byte 1 104
byte 1 97
byte 1 115
byte 1 32
byte 1 114
byte 1 97
byte 1 110
byte 1 100
byte 1 111
byte 1 109
byte 1 32
byte 1 62
byte 1 61
byte 1 32
byte 1 119
byte 1 97
byte 1 105
byte 1 116
byte 1 10
byte 1 0
align 1
LABELV $65
byte 1 48
byte 1 0
align 1
LABELV $64
byte 1 114
byte 1 97
byte 1 110
byte 1 100
byte 1 111
byte 1 109
byte 1 0
align 1
LABELV $63
byte 1 48
byte 1 46
byte 1 53
byte 1 0
align 1
LABELV $62
byte 1 119
byte 1 97
byte 1 105
byte 1 116
byte 1 0
