export Team_InitGame
code
proc Team_InitGame 4 12
file "..\g_team.c"
line 27
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:
;4:#include <limits.h>
;5:
;6:#include "g_local.h"
;7:
;8:typedef enum _flag_status {
;9:	FLAG_ATBASE = 0,
;10:	FLAG_TAKEN,
;11:	FLAG_DROPPED
;12:} flagStatus_t;
;13:
;14:typedef struct teamgame_s
;15:{
;16:	float last_flag_capture;
;17:	int last_capture_team;
;18:	flagStatus_t redStatus;
;19:	flagStatus_t blueStatus;
;20:} teamgame_t;
;21:
;22:teamgame_t teamgame;
;23:
;24:void Team_SetFlagStatus( int team, flagStatus_t status );
;25:
;26:void Team_InitGame(void)
;27:{
line 28
;28:	memset(&teamgame, 0, sizeof teamgame);
ADDRGP4 teamgame
ARGP4
CNSTI4 0
ARGI4
CNSTU4 16
ARGU4
ADDRGP4 memset
CALLP4
pop
line 29
;29:	teamgame.redStatus = teamgame.blueStatus = -1; // Invalid to force update
ADDRLP4 0
CNSTI4 -1
ASGNI4
ADDRGP4 teamgame+12
ADDRLP4 0
INDIRI4
ASGNI4
ADDRGP4 teamgame+8
ADDRLP4 0
INDIRI4
ASGNI4
line 31
;30:
;31:	Team_SetFlagStatus( TEAM_RED, FLAG_ATBASE );
CNSTI4 1
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 Team_SetFlagStatus
CALLV
pop
line 32
;32:	Team_SetFlagStatus( TEAM_BLUE, FLAG_ATBASE );
CNSTI4 2
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 Team_SetFlagStatus
CALLV
pop
line 33
;33:}
LABELV $46
endproc Team_InitGame 4 12
export OtherTeam
proc OtherTeam 0 0
line 35
;34:
;35:int OtherTeam(int team) {
line 36
;36:	if (team==TEAM_RED)
ADDRFP4 0
INDIRI4
CNSTI4 1
NEI4 $50
line 37
;37:		return TEAM_BLUE;
CNSTI4 2
RETI4
ADDRGP4 $49
JUMPV
LABELV $50
line 38
;38:	else if (team==TEAM_BLUE)
ADDRFP4 0
INDIRI4
CNSTI4 2
NEI4 $52
line 39
;39:		return TEAM_RED;
CNSTI4 1
RETI4
ADDRGP4 $49
JUMPV
LABELV $52
line 40
;40:	return team;
ADDRFP4 0
INDIRI4
RETI4
LABELV $49
endproc OtherTeam 0 0
export TeamName
proc TeamName 0 0
line 43
;41:}
;42:
;43:const char *TeamName(int team)  {
line 44
;44:	if (team==TEAM_RED)
ADDRFP4 0
INDIRI4
CNSTI4 1
NEI4 $55
line 45
;45:		return "RED";
ADDRGP4 $57
RETP4
ADDRGP4 $54
JUMPV
LABELV $55
line 46
;46:	else if (team==TEAM_BLUE)
ADDRFP4 0
INDIRI4
CNSTI4 2
NEI4 $58
line 47
;47:		return "BLUE";
ADDRGP4 $60
RETP4
ADDRGP4 $54
JUMPV
LABELV $58
line 48
;48:	else if (team==TEAM_SPECTATOR)
ADDRFP4 0
INDIRI4
CNSTI4 3
NEI4 $61
line 49
;49:		return "SPECTATOR";
ADDRGP4 $63
RETP4
ADDRGP4 $54
JUMPV
LABELV $61
line 50
;50:	return "FREE";
ADDRGP4 $64
RETP4
LABELV $54
endproc TeamName 0 0
export OtherTeamName
proc OtherTeamName 0 0
line 53
;51:}
;52:
;53:const char *OtherTeamName(int team) {
line 54
;54:	if (team==TEAM_RED)
ADDRFP4 0
INDIRI4
CNSTI4 1
NEI4 $66
line 55
;55:		return "BLUE";
ADDRGP4 $60
RETP4
ADDRGP4 $65
JUMPV
LABELV $66
line 56
;56:	else if (team==TEAM_BLUE)
ADDRFP4 0
INDIRI4
CNSTI4 2
NEI4 $68
line 57
;57:		return "RED";
ADDRGP4 $57
RETP4
ADDRGP4 $65
JUMPV
LABELV $68
line 58
;58:	else if (team==TEAM_SPECTATOR)
ADDRFP4 0
INDIRI4
CNSTI4 3
NEI4 $70
line 59
;59:		return "SPECTATOR";
ADDRGP4 $63
RETP4
ADDRGP4 $65
JUMPV
LABELV $70
line 60
;60:	return "FREE";
ADDRGP4 $64
RETP4
LABELV $65
endproc OtherTeamName 0 0
export TeamColorString
proc TeamColorString 0 0
line 63
;61:}
;62:
;63:const char *TeamColorString(int team) {
line 64
;64:	if (team==TEAM_RED)
ADDRFP4 0
INDIRI4
CNSTI4 1
NEI4 $73
line 65
;65:		return S_COLOR_RED;
ADDRGP4 $75
RETP4
ADDRGP4 $72
JUMPV
LABELV $73
line 66
;66:	else if (team==TEAM_BLUE)
ADDRFP4 0
INDIRI4
CNSTI4 2
NEI4 $76
line 67
;67:		return S_COLOR_BLUE;
ADDRGP4 $78
RETP4
ADDRGP4 $72
JUMPV
LABELV $76
line 68
;68:	else if (team==TEAM_SPECTATOR)
ADDRFP4 0
INDIRI4
CNSTI4 3
NEI4 $79
line 69
;69:		return S_COLOR_YELLOW;
ADDRGP4 $81
RETP4
ADDRGP4 $72
JUMPV
LABELV $79
line 70
;70:	return S_COLOR_WHITE;
ADDRGP4 $82
RETP4
LABELV $72
endproc TeamColorString 0 0
export PrintMsg
proc PrintMsg 1048 12
line 74
;71:}
;72:
;73:// NULL for everyone
;74:void QDECL PrintMsg( gentity_t *ent, const char *fmt, ... ) {
line 79
;75:	char		msg[1024];
;76:	va_list		argptr;
;77:	char		*p;
;78:	
;79:	va_start (argptr,fmt);
ADDRLP4 1028
ADDRFP4 4+4
ASGNP4
line 80
;80:	if (vsprintf (msg, fmt, argptr) > sizeof(msg)) {
ADDRLP4 4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 1028
INDIRP4
ARGP4
ADDRLP4 1032
ADDRGP4 vsprintf
CALLI4
ASGNI4
ADDRLP4 1032
INDIRI4
CVIU4 4
CNSTU4 1024
LEU4 $85
line 81
;81:		G_Error ( "PrintMsg overrun" );
ADDRGP4 $87
ARGP4
ADDRGP4 G_Error
CALLV
pop
line 82
;82:	}
LABELV $85
line 83
;83:	va_end (argptr);
ADDRLP4 1028
CNSTP4 0
ASGNP4
ADDRGP4 $89
JUMPV
LABELV $88
line 87
;84:
;85:	// double quotes are bad
;86:	while ((p = strchr(msg, '"')) != NULL)
;87:		*p = '\'';
ADDRLP4 0
INDIRP4
CNSTI1 39
ASGNI1
LABELV $89
line 86
ADDRLP4 4
ARGP4
CNSTI4 34
ARGI4
ADDRLP4 1036
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 1036
INDIRP4
ASGNP4
ADDRLP4 1036
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $88
line 89
;88:
;89:	trap_SendServerCommand ( ( (ent == NULL) ? -1 : ent-g_entities ), va("print \"%s\"", msg ));
ADDRGP4 $92
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 1044
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $93
ADDRLP4 1040
CNSTI4 -1
ASGNI4
ADDRGP4 $94
JUMPV
LABELV $93
ADDRLP4 1040
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ASGNI4
LABELV $94
ADDRLP4 1040
INDIRI4
ARGI4
ADDRLP4 1044
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 90
;90:}
LABELV $83
endproc PrintMsg 1048 12
export OnSameTeam
proc OnSameTeam 16 0
line 97
;91:
;92:/*
;93:==============
;94:OnSameTeam
;95:==============
;96:*/
;97:qboolean OnSameTeam( gentity_t *ent1, gentity_t *ent2 ) {
line 98
;98:	if ( !ent1->client || !ent2->client ) {
ADDRLP4 0
CNSTI4 504
ASGNI4
ADDRLP4 4
CNSTU4 0
ASGNU4
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 4
INDIRU4
EQU4 $98
ADDRFP4 4
INDIRP4
ADDRLP4 0
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 4
INDIRU4
NEU4 $96
LABELV $98
line 99
;99:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $95
JUMPV
LABELV $96
line 102
;100:	}
;101:
;102:	if ( g_gametype.integer < GT_TEAM ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
GEI4 $99
line 103
;103:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $95
JUMPV
LABELV $99
line 106
;104:	}
;105:
;106:	if ( ent1->client->sess.sessionTeam == ent2->client->sess.sessionTeam ) {
ADDRLP4 8
CNSTI4 504
ASGNI4
ADDRLP4 12
CNSTI4 592
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
NEI4 $102
line 107
;107:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $95
JUMPV
LABELV $102
line 110
;108:	}
;109:
;110:	return qfalse;
CNSTI4 0
RETI4
LABELV $95
endproc OnSameTeam 16 0
export Team_SetFlagStatus
proc Team_SetFlagStatus 12 8
line 114
;111:}
;112:
;113:void Team_SetFlagStatus( int team, flagStatus_t status )
;114:{
line 115
;115:	qboolean modified = qfalse;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 117
;116:
;117:	switch (team) {
ADDRLP4 4
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 1
EQI4 $107
ADDRLP4 4
INDIRI4
CNSTI4 2
EQI4 $112
ADDRGP4 $105
JUMPV
LABELV $107
line 119
;118:	case TEAM_RED :
;119:		if ( teamgame.redStatus != status ) {
ADDRGP4 teamgame+8
INDIRI4
ADDRFP4 4
INDIRI4
EQI4 $106
line 120
;120:			teamgame.redStatus = status;
ADDRGP4 teamgame+8
ADDRFP4 4
INDIRI4
ASGNI4
line 121
;121:			modified = qtrue;
ADDRLP4 0
CNSTI4 1
ASGNI4
line 122
;122:		}
line 123
;123:		break;
ADDRGP4 $106
JUMPV
LABELV $112
line 125
;124:	case TEAM_BLUE :
;125:		if ( teamgame.blueStatus != status ) {
ADDRGP4 teamgame+12
INDIRI4
ADDRFP4 4
INDIRI4
EQI4 $106
line 126
;126:			teamgame.blueStatus = status;
ADDRGP4 teamgame+12
ADDRFP4 4
INDIRI4
ASGNI4
line 127
;127:			modified = qtrue;
ADDRLP4 0
CNSTI4 1
ASGNI4
line 128
;128:		}
line 129
;129:		break;
LABELV $105
LABELV $106
line 132
;130:	}
;131:
;132:	if (modified) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $117
line 135
;133:		char st[4];
;134:
;135:		st[0] = '0' + (int)teamgame.redStatus;
ADDRLP4 8
ADDRGP4 teamgame+8
INDIRI4
CNSTI4 48
ADDI4
CVII1 4
ASGNI1
line 136
;136:		st[1] = '0' + (int)teamgame.blueStatus;
ADDRLP4 8+1
ADDRGP4 teamgame+12
INDIRI4
CNSTI4 48
ADDI4
CVII1 4
ASGNI1
line 137
;137:		st[2] = 0;
ADDRLP4 8+2
CNSTI1 0
ASGNI1
line 139
;138:
;139:		trap_SetConfigstring( CS_FLAGSTATUS, st );
CNSTI4 15
ARGI4
ADDRLP4 8
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 140
;140:	}
LABELV $117
line 141
;141:}
LABELV $104
endproc Team_SetFlagStatus 12 8
export Team_CheckDroppedItem
proc Team_CheckDroppedItem 4 8
line 144
;142:
;143:void Team_CheckDroppedItem( gentity_t *dropped )
;144:{
line 145
;145:	if (dropped->item->giTag == PW_REDFLAG)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 7
NEI4 $124
line 146
;146:		Team_SetFlagStatus( TEAM_RED, FLAG_DROPPED );
CNSTI4 1
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 Team_SetFlagStatus
CALLV
pop
ADDRGP4 $125
JUMPV
LABELV $124
line 147
;147:	else if (dropped->item->giTag == PW_BLUEFLAG)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 8
NEI4 $126
line 148
;148:		Team_SetFlagStatus( TEAM_BLUE, FLAG_DROPPED );
ADDRLP4 0
CNSTI4 2
ASGNI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 Team_SetFlagStatus
CALLV
pop
LABELV $126
LABELV $125
line 149
;149:}
LABELV $123
endproc Team_CheckDroppedItem 4 8
export Team_FragBonuses
proc Team_FragBonuses 256 16
line 162
;150:
;151:
;152:/*
;153:================
;154:Team_FragBonuses
;155:
;156:Calculate the bonuses for flag defense, flag carrier defense, etc.
;157:Note that bonuses are not cumlative.  You get one, they are in importance
;158:order.
;159:================
;160:*/
;161:void Team_FragBonuses(gentity_t *targ, gentity_t *inflictor, gentity_t *attacker)
;162:{
line 167
;163:	int i;
;164:	gentity_t *ent;
;165:	int flag_pw, enemy_flag_pw;
;166:	int otherteam;
;167:	gentity_t *flag, *carrier = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
line 173
;168:	char *c;
;169:	vec3_t v1, v2;
;170:	int team;
;171:
;172:	// no bonus for fragging yourself
;173:	if (!targ->client || !attacker->client || targ == attacker)
ADDRLP4 60
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
CNSTI4 504
ASGNI4
ADDRLP4 68
CNSTU4 0
ASGNU4
ADDRLP4 60
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 68
INDIRU4
EQU4 $132
ADDRLP4 72
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 68
INDIRU4
EQU4 $132
ADDRLP4 60
INDIRP4
CVPU4 4
ADDRLP4 72
INDIRP4
CVPU4 4
NEU4 $129
LABELV $132
line 174
;174:		return;
ADDRGP4 $128
JUMPV
LABELV $129
line 176
;175:
;176:	team = targ->client->sess.sessionTeam;
ADDRLP4 52
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
line 177
;177:	otherteam = OtherTeam(targ->client->sess.sessionTeam);
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ARGI4
ADDRLP4 76
ADDRGP4 OtherTeam
CALLI4
ASGNI4
ADDRLP4 36
ADDRLP4 76
INDIRI4
ASGNI4
line 178
;178:	if (otherteam < 0)
ADDRLP4 36
INDIRI4
CNSTI4 0
GEI4 $133
line 179
;179:		return; // whoever died isn't on a team
ADDRGP4 $128
JUMPV
LABELV $133
line 182
;180:
;181:	// same team, if the flag at base, check to he has the enemy flag
;182:	if (team == TEAM_RED) {
ADDRLP4 52
INDIRI4
CNSTI4 1
NEI4 $135
line 183
;183:		flag_pw = PW_REDFLAG;
ADDRLP4 16
CNSTI4 7
ASGNI4
line 184
;184:		enemy_flag_pw = PW_BLUEFLAG;
ADDRLP4 56
CNSTI4 8
ASGNI4
line 185
;185:	} else {
ADDRGP4 $136
JUMPV
LABELV $135
line 186
;186:		flag_pw = PW_BLUEFLAG;
ADDRLP4 16
CNSTI4 8
ASGNI4
line 187
;187:		enemy_flag_pw = PW_REDFLAG;
ADDRLP4 56
CNSTI4 7
ASGNI4
line 188
;188:	}
LABELV $136
line 191
;189:
;190:	// did the attacker frag the flag carrier?
;191:	if (targ->client->ps.powerups[enemy_flag_pw]) {
ADDRLP4 56
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
CNSTI4 0
EQI4 $137
line 192
;192:		attacker->client->pers.teamState.lastfraggedcarrier = level.time;
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 572
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
ASGNF4
line 193
;193:		AddScore(attacker, CTF_FRAG_CARRIER_BONUS);
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 194
;194:		attacker->client->pers.teamState.fragcarrier++;
ADDRLP4 80
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 552
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 195
;195:		PrintMsg(NULL, "%s" S_COLOR_WHITE " fragged %s's flag carrier!\n",
ADDRLP4 52
INDIRI4
ARGI4
ADDRLP4 84
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $140
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 200
;196:			attacker->client->pers.netname, TeamName(team));
;197:
;198:		// the target had the flag, clear the hurt carrier
;199:		// field on the other team
;200:		for (i = 0; i < g_maxclients.integer; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $144
JUMPV
LABELV $141
line 201
;201:			ent = g_entities + i;
ADDRLP4 12
CNSTI4 792
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 202
;202:			if (ent->inuse && ent->client->sess.sessionTeam == otherteam)
ADDRLP4 12
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
EQI4 $146
ADDRLP4 12
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ADDRLP4 36
INDIRI4
NEI4 $146
line 203
;203:				ent->client->pers.teamState.lasthurtcarrier = 0;
ADDRLP4 12
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 560
ADDP4
CNSTF4 0
ASGNF4
LABELV $146
line 204
;204:		}
LABELV $142
line 200
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $144
ADDRLP4 4
INDIRI4
ADDRGP4 g_maxclients+12
INDIRI4
LTI4 $141
line 205
;205:		return;
ADDRGP4 $128
JUMPV
LABELV $137
line 208
;206:	}
;207:
;208:	if (targ->client->pers.teamState.lasthurtcarrier &&
ADDRLP4 80
CNSTI4 504
ASGNI4
ADDRLP4 84
ADDRFP4 0
INDIRP4
ADDRLP4 80
INDIRI4
ADDP4
INDIRP4
CNSTI4 560
ADDP4
INDIRF4
ASGNF4
ADDRLP4 84
INDIRF4
CNSTF4 0
EQF4 $148
ADDRGP4 level+32
INDIRI4
CVIF4 4
ADDRLP4 84
INDIRF4
SUBF4
CNSTF4 1174011904
GEF4 $148
ADDRLP4 16
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 8
INDIRP4
ADDRLP4 80
INDIRI4
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
CNSTI4 0
NEI4 $148
line 210
;209:		level.time - targ->client->pers.teamState.lasthurtcarrier < CTF_CARRIER_DANGER_PROTECT_TIMEOUT &&
;210:		!attacker->client->ps.powerups[flag_pw]) {
line 213
;211:		// attacker is on the same team as the flag carrier and
;212:		// fragged a guy who hurt our flag carrier
;213:		AddScore(attacker, CTF_CARRIER_DANGER_PROTECT_BONUS);
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 215
;214:
;215:		attacker->client->pers.teamState.carrierdefense++;
ADDRLP4 88
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 544
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 216
;216:		targ->client->pers.teamState.lasthurtcarrier = 0;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 560
ADDP4
CNSTF4 0
ASGNF4
line 218
;217:
;218:		team = attacker->client->sess.sessionTeam;
ADDRLP4 52
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
line 219
;219:		PrintMsg(NULL, "%s" S_COLOR_WHITE " defends %s's flag carrier against an agressive enemy\n",
ADDRLP4 52
INDIRI4
ARGI4
ADDRLP4 92
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $151
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 221
;220:			attacker->client->pers.netname, TeamName(team));
;221:		return;
ADDRGP4 $128
JUMPV
LABELV $148
line 229
;222:	}
;223:
;224:	// flag and flag carrier area defense bonuses
;225:
;226:	// we have to find the flag and carrier entities
;227:
;228:	// find the flag
;229:	switch (attacker->client->sess.sessionTeam) {
ADDRLP4 88
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
ADDRLP4 88
INDIRI4
CNSTI4 1
EQI4 $155
ADDRLP4 88
INDIRI4
CNSTI4 2
EQI4 $157
ADDRGP4 $128
JUMPV
LABELV $155
line 231
;230:	case TEAM_RED:
;231:		c = "team_CTF_redflag";
ADDRLP4 20
ADDRGP4 $156
ASGNP4
line 232
;232:		break;
ADDRGP4 $153
JUMPV
LABELV $157
line 234
;233:	case TEAM_BLUE:
;234:		c = "team_CTF_blueflag";
ADDRLP4 20
ADDRGP4 $158
ASGNP4
line 235
;235:		break;		
line 237
;236:	default:
;237:		return;
LABELV $153
line 240
;238:	}
;239:
;240:	flag = NULL;
ADDRLP4 8
CNSTP4 0
ASGNP4
ADDRGP4 $160
JUMPV
LABELV $159
line 241
;241:	while ((flag = G_Find (flag, FOFS(classname), c)) != NULL) {
line 242
;242:		if (!(flag->flags & FL_DROPPED_ITEM))
ADDRLP4 8
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
NEI4 $162
line 243
;243:			break;
ADDRGP4 $161
JUMPV
LABELV $162
line 244
;244:	}
LABELV $160
line 241
ADDRLP4 8
INDIRP4
ARGP4
CNSTI4 512
ARGI4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 96
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 96
INDIRP4
ASGNP4
ADDRLP4 96
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $159
LABELV $161
line 246
;245:
;246:	if (!flag)
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $164
line 247
;247:		return; // can't find attacker's flag
ADDRGP4 $128
JUMPV
LABELV $164
line 250
;248:
;249:	// find attacker's team's flag carrier
;250:	for (i = 0; i < g_maxclients.integer; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $169
JUMPV
LABELV $166
line 251
;251:		carrier = g_entities + i;
ADDRLP4 0
CNSTI4 792
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 252
;252:		if (carrier->inuse && carrier->client->ps.powerups[flag_pw])
ADDRLP4 104
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
ADDRLP4 104
INDIRI4
EQI4 $171
ADDRLP4 16
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
ADDRLP4 104
INDIRI4
EQI4 $171
line 253
;253:			break;
ADDRGP4 $168
JUMPV
LABELV $171
line 254
;254:		carrier = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
line 255
;255:	}
LABELV $167
line 250
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $169
ADDRLP4 4
INDIRI4
ADDRGP4 g_maxclients+12
INDIRI4
LTI4 $166
LABELV $168
line 260
;256:
;257:	// ok we have the attackers flag and a pointer to the carrier
;258:
;259:	// check to see if we are defending the base's flag
;260:	VectorSubtract(targ->r.currentOrigin, flag->r.currentOrigin, v1);
ADDRLP4 100
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 104
CNSTI4 476
ASGNI4
ADDRLP4 24
ADDRLP4 100
INDIRP4
ADDRLP4 104
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 104
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 112
CNSTI4 480
ASGNI4
ADDRLP4 24+4
ADDRLP4 100
INDIRP4
ADDRLP4 112
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 112
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 116
CNSTI4 484
ASGNI4
ADDRLP4 24+8
ADDRFP4 0
INDIRP4
ADDRLP4 116
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 116
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 261
;261:	VectorSubtract(attacker->r.currentOrigin, flag->r.currentOrigin, v2);
ADDRLP4 120
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 124
CNSTI4 476
ASGNI4
ADDRLP4 40
ADDRLP4 120
INDIRP4
ADDRLP4 124
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 124
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 132
CNSTI4 480
ASGNI4
ADDRLP4 40+4
ADDRLP4 120
INDIRP4
ADDRLP4 132
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 132
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 136
CNSTI4 484
ASGNI4
ADDRLP4 40+8
ADDRFP4 8
INDIRP4
ADDRLP4 136
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 136
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 263
;262:
;263:	if ( ( ( VectorLength(v1) < CTF_TARGET_PROTECT_RADIUS &&
ADDRLP4 24
ARGP4
ADDRLP4 140
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 140
INDIRF4
CNSTF4 1148846080
GEF4 $180
ADDRLP4 144
CNSTI4 476
ASGNI4
ADDRLP4 8
INDIRP4
ADDRLP4 144
INDIRI4
ADDP4
ARGP4
ADDRFP4 0
INDIRP4
ADDRLP4 144
INDIRI4
ADDP4
ARGP4
ADDRLP4 148
ADDRGP4 trap_InPVS
CALLI4
ASGNI4
ADDRLP4 148
INDIRI4
CNSTI4 0
NEI4 $179
LABELV $180
ADDRLP4 40
ARGP4
ADDRLP4 152
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 152
INDIRF4
CNSTF4 1148846080
GEF4 $177
ADDRLP4 156
CNSTI4 476
ASGNI4
ADDRLP4 8
INDIRP4
ADDRLP4 156
INDIRI4
ADDP4
ARGP4
ADDRFP4 8
INDIRP4
ADDRLP4 156
INDIRI4
ADDP4
ARGP4
ADDRLP4 160
ADDRGP4 trap_InPVS
CALLI4
ASGNI4
ADDRLP4 160
INDIRI4
CNSTI4 0
EQI4 $177
LABELV $179
ADDRLP4 164
CNSTI4 504
ASGNI4
ADDRLP4 168
CNSTI4 592
ASGNI4
ADDRFP4 8
INDIRP4
ADDRLP4 164
INDIRI4
ADDP4
INDIRP4
ADDRLP4 168
INDIRI4
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
ADDRLP4 164
INDIRI4
ADDP4
INDIRP4
ADDRLP4 168
INDIRI4
ADDP4
INDIRI4
EQI4 $177
line 267
;264:		trap_InPVS(flag->r.currentOrigin, targ->r.currentOrigin ) ) ||
;265:		( VectorLength(v2) < CTF_TARGET_PROTECT_RADIUS &&
;266:		trap_InPVS(flag->r.currentOrigin, attacker->r.currentOrigin ) ) ) &&
;267:		attacker->client->sess.sessionTeam != targ->client->sess.sessionTeam) {
line 270
;268:
;269:		// we defended the base flag
;270:		AddScore(attacker, CTF_FLAG_DEFENSE_BONUS);
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 271
;271:		attacker->client->pers.teamState.basedefense++;
ADDRLP4 172
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 540
ADDP4
ASGNP4
ADDRLP4 172
INDIRP4
ADDRLP4 172
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 272
;272:		if (flag->r.svFlags & SVF_NOCLIENT) {
ADDRLP4 8
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $181
line 273
;273:			PrintMsg(NULL, "%s" S_COLOR_WHITE " defends the %s base.\n",
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ARGI4
ADDRLP4 176
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $183
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 176
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 276
;274:				attacker->client->pers.netname, 
;275:				TeamName(attacker->client->sess.sessionTeam));
;276:		} else {
ADDRGP4 $128
JUMPV
LABELV $181
line 277
;277:			PrintMsg(NULL, "%s" S_COLOR_WHITE " defends the %s flag.\n",
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ARGI4
ADDRLP4 176
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $184
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 176
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 280
;278:				attacker->client->pers.netname, 
;279:				TeamName(attacker->client->sess.sessionTeam));
;280:		}
line 281
;281:		return;
ADDRGP4 $128
JUMPV
LABELV $177
line 284
;282:	}
;283:
;284:	if (carrier && carrier != attacker) {
ADDRLP4 172
ADDRLP4 0
INDIRP4
CVPU4 4
ASGNU4
ADDRLP4 172
INDIRU4
CNSTU4 0
EQU4 $185
ADDRLP4 172
INDIRU4
ADDRFP4 8
INDIRP4
CVPU4 4
EQU4 $185
line 285
;285:		VectorSubtract(targ->r.currentOrigin, carrier->r.currentOrigin, v1);
ADDRLP4 176
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 180
CNSTI4 476
ASGNI4
ADDRLP4 24
ADDRLP4 176
INDIRP4
ADDRLP4 180
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 180
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 188
CNSTI4 480
ASGNI4
ADDRLP4 24+4
ADDRLP4 176
INDIRP4
ADDRLP4 188
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 188
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 192
CNSTI4 484
ASGNI4
ADDRLP4 24+8
ADDRFP4 0
INDIRP4
ADDRLP4 192
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 192
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 286
;286:		VectorSubtract(attacker->r.currentOrigin, carrier->r.currentOrigin, v1);
ADDRLP4 196
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 200
CNSTI4 476
ASGNI4
ADDRLP4 24
ADDRLP4 196
INDIRP4
ADDRLP4 200
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 200
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 208
CNSTI4 480
ASGNI4
ADDRLP4 24+4
ADDRLP4 196
INDIRP4
ADDRLP4 208
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 208
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 212
CNSTI4 484
ASGNI4
ADDRLP4 24+8
ADDRFP4 8
INDIRP4
ADDRLP4 212
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 212
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 288
;287:
;288:		if ( ( ( VectorLength(v1) < CTF_ATTACKER_PROTECT_RADIUS &&
ADDRLP4 24
ARGP4
ADDRLP4 216
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 216
INDIRF4
CNSTF4 1148846080
GEF4 $194
ADDRLP4 220
CNSTI4 476
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 220
INDIRI4
ADDP4
ARGP4
ADDRFP4 0
INDIRP4
ADDRLP4 220
INDIRI4
ADDP4
ARGP4
ADDRLP4 224
ADDRGP4 trap_InPVS
CALLI4
ASGNI4
ADDRLP4 224
INDIRI4
CNSTI4 0
NEI4 $193
LABELV $194
ADDRLP4 40
ARGP4
ADDRLP4 228
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 228
INDIRF4
CNSTF4 1148846080
GEF4 $191
ADDRLP4 232
CNSTI4 476
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 232
INDIRI4
ADDP4
ARGP4
ADDRFP4 8
INDIRP4
ADDRLP4 232
INDIRI4
ADDP4
ARGP4
ADDRLP4 236
ADDRGP4 trap_InPVS
CALLI4
ASGNI4
ADDRLP4 236
INDIRI4
CNSTI4 0
EQI4 $191
LABELV $193
ADDRLP4 240
CNSTI4 504
ASGNI4
ADDRLP4 244
CNSTI4 592
ASGNI4
ADDRFP4 8
INDIRP4
ADDRLP4 240
INDIRI4
ADDP4
INDIRP4
ADDRLP4 244
INDIRI4
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
ADDRLP4 240
INDIRI4
ADDP4
INDIRP4
ADDRLP4 244
INDIRI4
ADDP4
INDIRI4
EQI4 $191
line 292
;289:			trap_InPVS(carrier->r.currentOrigin, targ->r.currentOrigin ) ) ||
;290:			( VectorLength(v2) < CTF_ATTACKER_PROTECT_RADIUS &&
;291:				trap_InPVS(carrier->r.currentOrigin, attacker->r.currentOrigin ) ) ) &&
;292:			attacker->client->sess.sessionTeam != targ->client->sess.sessionTeam) {
line 293
;293:			AddScore(attacker, CTF_CARRIER_PROTECT_BONUS);
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 294
;294:			attacker->client->pers.teamState.carrierdefense++;
ADDRLP4 248
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 544
ADDP4
ASGNP4
ADDRLP4 248
INDIRP4
ADDRLP4 248
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 295
;295:			PrintMsg(NULL, "%s" S_COLOR_WHITE " defends the %s's flag carrier.\n",
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ARGI4
ADDRLP4 252
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $195
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 252
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 298
;296:				attacker->client->pers.netname, 
;297:				TeamName(attacker->client->sess.sessionTeam));
;298:			return;
LABELV $191
line 300
;299:		}
;300:	}
LABELV $185
line 301
;301:}
LABELV $128
endproc Team_FragBonuses 256 16
export Team_CheckHurtCarrier
proc Team_CheckHurtCarrier 24 0
line 312
;302:
;303:/*
;304:================
;305:Team_CheckHurtCarrier
;306:
;307:Check to see if attacker hurt the flag carrier.  Needed when handing out bonuses for assistance to flag
;308:carrier defense.
;309:================
;310:*/
;311:void Team_CheckHurtCarrier(gentity_t *targ, gentity_t *attacker)
;312:{
line 315
;313:	int flag_pw;
;314:
;315:	if (!targ->client || !attacker->client)
ADDRLP4 4
CNSTI4 504
ASGNI4
ADDRLP4 8
CNSTU4 0
ASGNU4
ADDRFP4 0
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 8
INDIRU4
EQU4 $199
ADDRFP4 4
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 8
INDIRU4
NEU4 $197
LABELV $199
line 316
;316:		return;
ADDRGP4 $196
JUMPV
LABELV $197
line 318
;317:
;318:	if (targ->client->sess.sessionTeam == TEAM_RED)
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 1
NEI4 $200
line 319
;319:		flag_pw = PW_BLUEFLAG;
ADDRLP4 0
CNSTI4 8
ASGNI4
ADDRGP4 $201
JUMPV
LABELV $200
line 321
;320:	else
;321:		flag_pw = PW_REDFLAG;
ADDRLP4 0
CNSTI4 7
ASGNI4
LABELV $201
line 323
;322:
;323:	if (targ->client->ps.powerups[flag_pw] &&
ADDRLP4 12
CNSTI4 504
ASGNI4
ADDRLP4 16
ADDRFP4 0
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRP4
ASGNP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 16
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
CNSTI4 0
EQI4 $202
ADDRLP4 20
CNSTI4 592
ASGNI4
ADDRLP4 16
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
EQI4 $202
line 325
;324:		targ->client->sess.sessionTeam != attacker->client->sess.sessionTeam)
;325:		attacker->client->pers.teamState.lasthurtcarrier = level.time;
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 560
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
ASGNF4
LABELV $202
line 326
;326:}
LABELV $196
endproc Team_CheckHurtCarrier 24 0
export Team_ResetFlag
proc Team_ResetFlag 20 12
line 330
;327:
;328:
;329:gentity_t *Team_ResetFlag(int team)
;330:{
line 332
;331:	char *c;
;332:	gentity_t *ent, *rent = NULL;
ADDRLP4 8
CNSTP4 0
ASGNP4
line 334
;333:
;334:	switch (team) {
ADDRLP4 12
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 1
EQI4 $208
ADDRLP4 12
INDIRI4
CNSTI4 2
EQI4 $209
ADDRGP4 $206
JUMPV
LABELV $208
line 336
;335:	case TEAM_RED:
;336:		c = "team_CTF_redflag";
ADDRLP4 4
ADDRGP4 $156
ASGNP4
line 337
;337:		break;
ADDRGP4 $207
JUMPV
LABELV $209
line 339
;338:	case TEAM_BLUE:
;339:		c = "team_CTF_blueflag";
ADDRLP4 4
ADDRGP4 $158
ASGNP4
line 340
;340:		break;
ADDRGP4 $207
JUMPV
LABELV $206
line 342
;341:	default:
;342:		return NULL;
CNSTP4 0
RETP4
ADDRGP4 $205
JUMPV
LABELV $207
line 345
;343:	}
;344:
;345:	ent = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
ADDRGP4 $211
JUMPV
LABELV $210
line 346
;346:	while ((ent = G_Find (ent, FOFS(classname), c)) != NULL) {
line 347
;347:		if (ent->flags & FL_DROPPED_ITEM)
ADDRLP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $213
line 348
;348:			G_FreeEntity(ent);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
ADDRGP4 $214
JUMPV
LABELV $213
line 349
;349:		else {
line 350
;350:			rent = ent;
ADDRLP4 8
ADDRLP4 0
INDIRP4
ASGNP4
line 351
;351:			RespawnItem(ent);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 RespawnItem
CALLV
pop
line 352
;352:		}
LABELV $214
line 353
;353:	}
LABELV $211
line 346
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 512
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 16
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 16
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $210
line 355
;354:
;355:	Team_SetFlagStatus( team, FLAG_ATBASE );
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 Team_SetFlagStatus
CALLV
pop
line 357
;356:
;357:	return rent;
ADDRLP4 8
INDIRP4
RETP4
LABELV $205
endproc Team_ResetFlag 20 12
export Team_ResetFlags
proc Team_ResetFlags 0 4
line 361
;358:}
;359:
;360:void Team_ResetFlags(void)
;361:{
line 362
;362:	Team_ResetFlag(TEAM_RED);
CNSTI4 1
ARGI4
ADDRGP4 Team_ResetFlag
CALLP4
pop
line 363
;363:	Team_ResetFlag(TEAM_BLUE);
CNSTI4 2
ARGI4
ADDRGP4 Team_ResetFlag
CALLP4
pop
line 364
;364:}
LABELV $215
endproc Team_ResetFlags 0 4
export Team_ReturnFlagSound
proc Team_ReturnFlagSound 20 8
line 367
;365:
;366:void Team_ReturnFlagSound(gentity_t *ent, int team)
;367:{
line 371
;368:	// play powerup spawn sound to all clients
;369:	gentity_t	*te;
;370:
;371:	if (ent == NULL) {
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $217
line 372
;372:		G_Printf ("Warning:  NULL passed to Team_ReturnFlagSound\n");
ADDRGP4 $219
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 373
;373:		return;
ADDRGP4 $216
JUMPV
LABELV $217
line 376
;374:	}
;375:
;376:	te = G_TempEntity( ent->s.pos.trBase, EV_GLOBAL_SOUND );
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
CNSTI4 46
ARGI4
ADDRLP4 4
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 377
;377:	te->s.eventParm = G_SoundIndex( team == TEAM_RED ?
ADDRFP4 4
INDIRI4
CNSTI4 1
NEI4 $223
ADDRLP4 8
ADDRGP4 $220
ASGNP4
ADDRGP4 $224
JUMPV
LABELV $223
ADDRLP4 8
ADDRGP4 $221
ASGNP4
LABELV $224
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 12
INDIRI4
ASGNI4
line 380
;378:		"sound/teamplay/flagret_red.wav" :
;379:		"sound/teamplay/flagret_blu.wav" );
;380:	te->r.svFlags |= SVF_BROADCAST;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 32
BORI4
ASGNI4
line 381
;381:}
LABELV $216
endproc Team_ReturnFlagSound 20 8
export Team_ReturnFlag
proc Team_ReturnFlag 8 12
line 384
;382:
;383:void Team_ReturnFlag(int team)
;384:{
line 385
;385:	Team_ReturnFlagSound(Team_ResetFlag(team), team);
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 0
ADDRGP4 Team_ResetFlag
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 Team_ReturnFlagSound
CALLV
pop
line 386
;386:	PrintMsg(NULL, "The %s flag has returned!\n", TeamName(team));
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 4
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $226
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 387
;387:}
LABELV $225
endproc Team_ReturnFlag 8 12
export Team_FreeEntity
proc Team_FreeEntity 0 4
line 390
;388:
;389:void Team_FreeEntity(gentity_t *ent)
;390:{
line 391
;391:	if (ent->item->giTag == PW_REDFLAG)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 7
NEI4 $228
line 392
;392:		Team_ReturnFlag(TEAM_RED);
CNSTI4 1
ARGI4
ADDRGP4 Team_ReturnFlag
CALLV
pop
ADDRGP4 $229
JUMPV
LABELV $228
line 393
;393:	else if (ent->item->giTag == PW_BLUEFLAG)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 8
NEI4 $230
line 394
;394:		Team_ReturnFlag(TEAM_BLUE);
CNSTI4 2
ARGI4
ADDRGP4 Team_ReturnFlag
CALLV
pop
LABELV $230
LABELV $229
line 395
;395:}
LABELV $227
endproc Team_FreeEntity 0 4
export Team_DroppedFlagThink
proc Team_DroppedFlagThink 8 8
line 407
;396:
;397:/*
;398:==============
;399:Team_DroppedFlagThink
;400:
;401:Automatically set in Launch_Item if the item is one of the flags
;402:
;403:Flags are unique in that if they are dropped, the base flag must be respawned when they time out
;404:==============
;405:*/
;406:void Team_DroppedFlagThink(gentity_t *ent)
;407:{
line 408
;408:	if (ent->item->giTag == PW_REDFLAG)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 7
NEI4 $233
line 409
;409:		Team_ReturnFlagSound(Team_ResetFlag(TEAM_RED), TEAM_RED);
CNSTI4 1
ARGI4
ADDRLP4 0
ADDRGP4 Team_ResetFlag
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 Team_ReturnFlagSound
CALLV
pop
ADDRGP4 $234
JUMPV
LABELV $233
line 410
;410:	else if (ent->item->giTag == PW_BLUEFLAG)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 8
NEI4 $235
line 411
;411:		Team_ReturnFlagSound(Team_ResetFlag(TEAM_BLUE), TEAM_BLUE);
CNSTI4 2
ARGI4
ADDRLP4 4
ADDRGP4 Team_ResetFlag
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRGP4 Team_ReturnFlagSound
CALLV
pop
LABELV $235
LABELV $234
line 413
;412:	// Reset Flag will delete this entity
;413:}
LABELV $232
endproc Team_DroppedFlagThink 8 8
export Team_TouchOurFlag
proc Team_TouchOurFlag 76 16
line 415
;414:
;415:int Team_TouchOurFlag( gentity_t *ent, gentity_t *other, int team ) {
line 418
;416:	int i;
;417:	gentity_t *player;
;418:	gclient_t *cl = other->client;
ADDRLP4 8
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 422
;419:	int our_flag, enemy_flag;
;420:	gentity_t	*te;
;421:
;422:	if (cl->sess.sessionTeam == TEAM_RED) {
ADDRLP4 8
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 1
NEI4 $238
line 423
;423:		our_flag = PW_REDFLAG;
ADDRLP4 20
CNSTI4 7
ASGNI4
line 424
;424:		enemy_flag = PW_BLUEFLAG;
ADDRLP4 12
CNSTI4 8
ASGNI4
line 425
;425:	} else {
ADDRGP4 $239
JUMPV
LABELV $238
line 426
;426:		our_flag = PW_BLUEFLAG;
ADDRLP4 20
CNSTI4 8
ASGNI4
line 427
;427:		enemy_flag = PW_REDFLAG;
ADDRLP4 12
CNSTI4 7
ASGNI4
line 428
;428:	}
LABELV $239
line 430
;429:
;430:	if ( ent->flags & FL_DROPPED_ITEM ) {
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $240
line 432
;431:		// hey, its not home.  return it by teleporting it back
;432:		PrintMsg( NULL, "%s" S_COLOR_WHITE " returned the %s flag!\n", 
ADDRFP4 8
INDIRI4
ARGI4
ADDRLP4 24
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $242
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 434
;433:			cl->pers.netname, TeamName(team));
;434:		AddScore(other, CTF_RECOVERY_BONUS);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 435
;435:		other->client->pers.teamState.flagrecovery++;
ADDRLP4 28
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 548
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 436
;436:		other->client->pers.teamState.lastreturnedflag = level.time;
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 564
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
ASGNF4
line 438
;437:		//ResetFlag will remove this entity!  We must return zero
;438:		Team_ReturnFlagSound(Team_ResetFlag(team), team);
ADDRFP4 8
INDIRI4
ARGI4
ADDRLP4 32
ADDRGP4 Team_ResetFlag
CALLP4
ASGNP4
ADDRLP4 32
INDIRP4
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
ADDRGP4 Team_ReturnFlagSound
CALLV
pop
line 439
;439:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $237
JUMPV
LABELV $240
line 444
;440:	}
;441:
;442:	// the flag is at home base.  if the player has the enemy
;443:	// flag, he's just won!
;444:	if (!cl->ps.powerups[enemy_flag])
ADDRLP4 12
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
CNSTI4 0
NEI4 $244
line 445
;445:		return 0; // We don't have the flag
CNSTI4 0
RETI4
ADDRGP4 $237
JUMPV
LABELV $244
line 447
;446:
;447:	PrintMsg( NULL, "%s" S_COLOR_WHITE " captured the %s flag!\n",
ADDRFP4 8
INDIRI4
ARGI4
ADDRLP4 24
ADDRGP4 OtherTeam
CALLI4
ASGNI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 28
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $246
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 450
;448:		cl->pers.netname, TeamName(OtherTeam(team)));
;449:
;450:	cl->ps.powerups[enemy_flag] = 0;
ADDRLP4 12
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
INDIRP4
CNSTI4 312
ADDP4
ADDP4
CNSTI4 0
ASGNI4
line 452
;451:
;452:	teamgame.last_flag_capture = level.time;
ADDRGP4 teamgame
ADDRGP4 level+32
INDIRI4
CVIF4 4
ASGNF4
line 453
;453:	teamgame.last_capture_team = team;
ADDRGP4 teamgame+4
ADDRFP4 8
INDIRI4
ASGNI4
line 456
;454:
;455:	// Increase the team's score
;456:	level.teamScores[ other->client->sess.sessionTeam ]++;
ADDRLP4 32
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 level+44
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 458
;457:
;458:	other->client->pers.teamState.captures++;
ADDRLP4 36
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 536
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 461
;459:
;460:	// other gets another 10 frag bonus
;461:	AddScore(other, CTF_CAPTURE_BONUS);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 5
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 463
;462:
;463:	te = G_TempEntity( ent->s.pos.trBase, EV_GLOBAL_SOUND );
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
CNSTI4 46
ARGI4
ADDRLP4 40
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 16
ADDRLP4 40
INDIRP4
ASGNP4
line 464
;464:	te->s.eventParm = G_SoundIndex( our_flag == PW_REDFLAG ?
ADDRLP4 20
INDIRI4
CNSTI4 7
NEI4 $253
ADDRLP4 44
ADDRGP4 $250
ASGNP4
ADDRGP4 $254
JUMPV
LABELV $253
ADDRLP4 44
ADDRGP4 $251
ASGNP4
LABELV $254
ADDRLP4 44
INDIRP4
ARGP4
ADDRLP4 48
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRLP4 16
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 48
INDIRI4
ASGNI4
line 467
;465:		"sound/teamplay/flagcap_red.wav" :
;466:		"sound/teamplay/flagcap_blu.wav" );
;467:	te->r.svFlags |= SVF_BROADCAST;
ADDRLP4 52
ADDRLP4 16
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRI4
CNSTI4 32
BORI4
ASGNI4
line 470
;468:
;469:	// Ok, let's do the player loop, hand out the bonuses
;470:	for (i = 0; i < g_maxclients.integer; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $258
JUMPV
LABELV $255
line 471
;471:		player = &g_entities[i];
ADDRLP4 0
CNSTI4 792
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 472
;472:		if (!player->inuse)
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
NEI4 $260
line 473
;473:			continue;
ADDRGP4 $256
JUMPV
LABELV $260
line 475
;474:
;475:		if (player->client->sess.sessionTeam !=
ADDRLP4 56
CNSTI4 592
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
INDIRI4
ADDRLP4 8
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
INDIRI4
EQI4 $262
line 476
;476:			cl->sess.sessionTeam) {
line 477
;477:			player->client->pers.teamState.lasthurtcarrier = -5;
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 560
ADDP4
CNSTF4 3231711232
ASGNF4
line 478
;478:		} else if (player->client->sess.sessionTeam ==
ADDRGP4 $263
JUMPV
LABELV $262
ADDRLP4 60
CNSTI4 592
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ADDRLP4 60
INDIRI4
ADDP4
INDIRI4
ADDRLP4 8
INDIRP4
ADDRLP4 60
INDIRI4
ADDP4
INDIRI4
NEI4 $264
line 479
;479:			cl->sess.sessionTeam) {
line 480
;480:			if (player != other)
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRFP4 4
INDIRP4
CVPU4 4
EQU4 $266
line 481
;481:				AddScore(player, CTF_TEAM_BONUS);
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 AddScore
CALLV
pop
LABELV $266
line 483
;482:			// award extra points for capture assists
;483:			if (player->client->pers.teamState.lastreturnedflag + 
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 564
ADDP4
INDIRF4
CNSTF4 1176256512
ADDF4
ADDRGP4 level+32
INDIRI4
CVIF4 4
LEF4 $268
line 484
;484:				CTF_RETURN_FLAG_ASSIST_TIMEOUT > level.time) {
line 485
;485:				PrintMsg( NULL, 
ADDRFP4 8
INDIRI4
ARGI4
ADDRLP4 64
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $271
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 489
;486:						"%s" S_COLOR_WHITE " gets an assist for returning the %s flag!\n", 
;487:						player->client->pers.netname,
;488:						TeamName(team));
;489:				AddScore (player, CTF_RETURN_FLAG_ASSIST_BONUS);
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 490
;490:				other->client->pers.teamState.assists++;
ADDRLP4 68
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 556
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 491
;491:			}
LABELV $268
line 492
;492:			if (player->client->pers.teamState.lastfraggedcarrier + 
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 572
ADDP4
INDIRF4
CNSTF4 1176256512
ADDF4
ADDRGP4 level+32
INDIRI4
CVIF4 4
LEF4 $272
line 493
;493:				CTF_FRAG_CARRIER_ASSIST_TIMEOUT > level.time) {
line 494
;494:				PrintMsg( NULL, "%s" S_COLOR_WHITE " gets an assist for fragging the %s flag carrier!\n", 
ADDRFP4 8
INDIRI4
ARGI4
ADDRLP4 64
ADDRGP4 OtherTeam
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
ARGI4
ADDRLP4 68
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $275
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 497
;495:						player->client->pers.netname,
;496:						TeamName(OtherTeam(team)));
;497:				AddScore(player, CTF_FRAG_CARRIER_ASSIST_BONUS);
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 498
;498:				other->client->pers.teamState.assists++;
ADDRLP4 72
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 556
ADDP4
ASGNP4
ADDRLP4 72
INDIRP4
ADDRLP4 72
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 499
;499:			}
LABELV $272
line 500
;500:		}
LABELV $264
LABELV $263
line 501
;501:	}
LABELV $256
line 470
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $258
ADDRLP4 4
INDIRI4
ADDRGP4 g_maxclients+12
INDIRI4
LTI4 $255
line 502
;502:	Team_ResetFlags();
ADDRGP4 Team_ResetFlags
CALLV
pop
line 504
;503:
;504:	CalculateRanks();
ADDRGP4 CalculateRanks
CALLV
pop
line 506
;505:
;506:	return 0; // Do not respawn this automatically
CNSTI4 0
RETI4
LABELV $237
endproc Team_TouchOurFlag 76 16
export Team_TouchEnemyFlag
proc Team_TouchEnemyFlag 8 16
line 509
;507:}
;508:
;509:int Team_TouchEnemyFlag( gentity_t *ent, gentity_t *other, int team ) {
line 510
;510:	gclient_t *cl = other->client;
ADDRLP4 0
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 513
;511:
;512:	// hey, its not our flag, pick it up
;513:	PrintMsg (NULL, "%s" S_COLOR_WHITE " got the %s flag!\n",
ADDRFP4 8
INDIRI4
ARGI4
ADDRLP4 4
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $277
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 515
;514:		other->client->pers.netname, TeamName(team));
;515:	AddScore(other, CTF_FLAG_BONUS);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 517
;516:
;517:	if (team == TEAM_RED)
ADDRFP4 8
INDIRI4
CNSTI4 1
NEI4 $278
line 518
;518:		cl->ps.powerups[PW_REDFLAG] = INT_MAX; // flags never expire
ADDRLP4 0
INDIRP4
CNSTI4 340
ADDP4
CNSTI4 2147483647
ASGNI4
ADDRGP4 $279
JUMPV
LABELV $278
line 520
;519:	else
;520:		cl->ps.powerups[PW_BLUEFLAG] = INT_MAX; // flags never expire
ADDRLP4 0
INDIRP4
CNSTI4 344
ADDP4
CNSTI4 2147483647
ASGNI4
LABELV $279
line 522
;521:
;522:	cl->pers.teamState.flagsince = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 568
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
ASGNF4
line 524
;523:
;524:	Team_SetFlagStatus( team, FLAG_TAKEN );
ADDRFP4 8
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 Team_SetFlagStatus
CALLV
pop
line 526
;525:	
;526:	return -1; // Do not respawn this automatically, but do delete it if it was FL_DROPPED
CNSTI4 -1
RETI4
LABELV $276
endproc Team_TouchEnemyFlag 8 16
export Pickup_Team
proc Pickup_Team 28 12
line 529
;527:}
;528:
;529:int Pickup_Team( gentity_t *ent, gentity_t *other ) {
line 531
;530:	int team;
;531:	gclient_t *cl = other->client;
ADDRLP4 4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 534
;532:	
;533:	// figure out what team this flag is
;534:	if (strcmp(ent->classname, "team_CTF_redflag") == 0)
ADDRFP4 0
INDIRP4
CNSTI4 512
ADDP4
INDIRP4
ARGP4
ADDRGP4 $156
ARGP4
ADDRLP4 8
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $282
line 535
;535:		team = TEAM_RED;
ADDRLP4 0
CNSTI4 1
ASGNI4
ADDRGP4 $283
JUMPV
LABELV $282
line 536
;536:	else if (strcmp(ent->classname, "team_CTF_blueflag") == 0)
ADDRFP4 0
INDIRP4
CNSTI4 512
ADDP4
INDIRP4
ARGP4
ADDRGP4 $158
ARGP4
ADDRLP4 12
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
NEI4 $284
line 537
;537:		team = TEAM_BLUE;
ADDRLP4 0
CNSTI4 2
ASGNI4
ADDRGP4 $285
JUMPV
LABELV $284
line 538
;538:	else {
line 539
;539:		PrintMsg ( other, "Don't know what team the flag is on.\n");
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 $286
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 540
;540:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $281
JUMPV
LABELV $285
LABELV $283
line 543
;541:	}
;542:
;543:	return ((team == cl->sess.sessionTeam) ?
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 20
ADDRLP4 0
INDIRI4
ASGNI4
ADDRLP4 20
INDIRI4
ARGI4
ADDRLP4 20
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
NEI4 $288
ADDRLP4 16
ADDRGP4 Team_TouchOurFlag
ASGNP4
ADDRGP4 $289
JUMPV
LABELV $288
ADDRLP4 16
ADDRGP4 Team_TouchEnemyFlag
ASGNP4
LABELV $289
ADDRLP4 24
ADDRLP4 16
INDIRP4
CALLI4
ASGNI4
ADDRLP4 24
INDIRI4
RETI4
LABELV $281
endproc Pickup_Team 28 12
export Team_GetLocation
proc Team_GetLocation 48 8
line 556
;544:		Team_TouchOurFlag : Team_TouchEnemyFlag)
;545:			(ent, other, team);
;546:}
;547:
;548:/*
;549:===========
;550:Team_GetLocation
;551:
;552:Report a location for the player. Uses placed nearby target_location entities
;553:============
;554:*/
;555:gentity_t *Team_GetLocation(gentity_t *ent)
;556:{
line 561
;557:	gentity_t		*eloc, *best;
;558:	float			bestlen, len;
;559:	vec3_t			origin;
;560:
;561:	best = NULL;
ADDRLP4 24
CNSTP4 0
ASGNP4
line 562
;562:	bestlen = 3*8192.0*8192.0;
ADDRLP4 20
CNSTF4 1296039936
ASGNF4
line 564
;563:
;564:	VectorCopy( ent->r.currentOrigin, origin );
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
INDIRB
ASGNB 12
line 566
;565:
;566:	for (eloc = level.locationHead; eloc; eloc = eloc->nextTrain) {
ADDRLP4 0
ADDRGP4 level+4272
INDIRP4
ASGNP4
ADDRGP4 $294
JUMPV
LABELV $291
line 567
;567:		len = ( origin[0] - eloc->r.currentOrigin[0] ) * ( origin[0] - eloc->r.currentOrigin[0] )
ADDRLP4 32
ADDRLP4 4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 36
ADDRLP4 0
INDIRP4
CNSTI4 480
ADDP4
INDIRF4
ASGNF4
ADDRLP4 40
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
INDIRF4
ASGNF4
ADDRLP4 16
ADDRLP4 32
INDIRF4
ADDRLP4 32
INDIRF4
MULF4
ADDRLP4 4+4
INDIRF4
ADDRLP4 36
INDIRF4
SUBF4
ADDRLP4 4+4
INDIRF4
ADDRLP4 36
INDIRF4
SUBF4
MULF4
ADDF4
ADDRLP4 4+8
INDIRF4
ADDRLP4 40
INDIRF4
SUBF4
ADDRLP4 4+8
INDIRF4
ADDRLP4 40
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 571
;568:			+ ( origin[1] - eloc->r.currentOrigin[1] ) * ( origin[1] - eloc->r.currentOrigin[1] )
;569:			+ ( origin[2] - eloc->r.currentOrigin[2] ) * ( origin[2] - eloc->r.currentOrigin[2] );
;570:
;571:		if ( len > bestlen ) {
ADDRLP4 16
INDIRF4
ADDRLP4 20
INDIRF4
LEF4 $300
line 572
;572:			continue;
ADDRGP4 $292
JUMPV
LABELV $300
line 575
;573:		}
;574:
;575:		if ( !trap_InPVS( origin, eloc->r.currentOrigin ) ) {
ADDRLP4 4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
ARGP4
ADDRLP4 44
ADDRGP4 trap_InPVS
CALLI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 0
NEI4 $302
line 576
;576:			continue;
ADDRGP4 $292
JUMPV
LABELV $302
line 579
;577:		}
;578:
;579:		bestlen = len;
ADDRLP4 20
ADDRLP4 16
INDIRF4
ASGNF4
line 580
;580:		best = eloc;
ADDRLP4 24
ADDRLP4 0
INDIRP4
ASGNP4
line 581
;581:	}
LABELV $292
line 566
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRP4
ASGNP4
LABELV $294
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $291
line 583
;582:
;583:	return best;
ADDRLP4 24
INDIRP4
RETP4
LABELV $290
endproc Team_GetLocation 48 8
export Team_GetLocationMsg
proc Team_GetLocationMsg 12 24
line 595
;584:}
;585:
;586:
;587:/*
;588:===========
;589:Team_GetLocation
;590:
;591:Report a location for the player. Uses placed nearby target_location entities
;592:============
;593:*/
;594:qboolean Team_GetLocationMsg(gentity_t *ent, char *loc, int loclen)
;595:{
line 598
;596:	gentity_t *best;
;597:
;598:	best = Team_GetLocation( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 Team_GetLocation
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 600
;599:	
;600:	if (!best)
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $305
line 601
;601:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $304
JUMPV
LABELV $305
line 603
;602:
;603:	if (best->count) {
ADDRLP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 0
EQI4 $307
line 604
;604:		if (best->count < 0)
ADDRLP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 0
GEI4 $309
line 605
;605:			best->count = 0;
ADDRLP4 0
INDIRP4
CNSTI4 740
ADDP4
CNSTI4 0
ASGNI4
LABELV $309
line 606
;606:		if (best->count > 7)
ADDRLP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 7
LEI4 $311
line 607
;607:			best->count = 7;
ADDRLP4 0
INDIRP4
CNSTI4 740
ADDP4
CNSTI4 7
ASGNI4
LABELV $311
line 608
;608:		Com_sprintf(loc, loclen, "%c%c%s" S_COLOR_WHITE, Q_COLOR_ESCAPE, best->count + '0', best->message );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
ADDRGP4 $313
ARGP4
CNSTI4 94
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 48
ADDI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 624
ADDP4
INDIRP4
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 609
;609:	} else
ADDRGP4 $308
JUMPV
LABELV $307
line 610
;610:		Com_sprintf(loc, loclen, "%s", best->message);
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
ADDRGP4 $314
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 624
ADDP4
INDIRP4
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
LABELV $308
line 612
;611:
;612:	return qtrue;
CNSTI4 1
RETI4
LABELV $304
endproc Team_GetLocationMsg 12 24
export SelectRandomTeamSpawnPoint
proc SelectRandomTeamSpawnPoint 88 12
line 626
;613:}
;614:
;615:
;616:/*---------------------------------------------------------------------------*/
;617:
;618:/*
;619:================
;620:SelectRandomDeathmatchSpawnPoint
;621:
;622:go to a random point that doesn't telefrag
;623:================
;624:*/
;625:#define	MAX_TEAM_SPAWN_POINTS	16
;626:gentity_t *SelectRandomTeamSpawnPoint( int teamstate, team_t team ) {
line 633
;627:	gentity_t	*spot;
;628:	int			count;
;629:	int			selection;
;630:	gentity_t	*spots[MAX_TEAM_SPAWN_POINTS];
;631:	char		*classname;
;632:
;633:	if (teamstate == TEAM_BEGIN) {
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $316
line 634
;634:		if (team == TEAM_RED)
ADDRFP4 4
INDIRI4
CNSTI4 1
NEI4 $318
line 635
;635:			classname = "team_CTF_redplayer";
ADDRLP4 8
ADDRGP4 $320
ASGNP4
ADDRGP4 $317
JUMPV
LABELV $318
line 636
;636:		else if (team == TEAM_BLUE)
ADDRFP4 4
INDIRI4
CNSTI4 2
NEI4 $321
line 637
;637:			classname = "team_CTF_blueplayer";
ADDRLP4 8
ADDRGP4 $323
ASGNP4
ADDRGP4 $317
JUMPV
LABELV $321
line 639
;638:		else
;639:			return NULL;
CNSTP4 0
RETP4
ADDRGP4 $315
JUMPV
line 640
;640:	} else {
LABELV $316
line 641
;641:		if (team == TEAM_RED)
ADDRFP4 4
INDIRI4
CNSTI4 1
NEI4 $324
line 642
;642:			classname = "team_CTF_redspawn";
ADDRLP4 8
ADDRGP4 $326
ASGNP4
ADDRGP4 $325
JUMPV
LABELV $324
line 643
;643:		else if (team == TEAM_BLUE)
ADDRFP4 4
INDIRI4
CNSTI4 2
NEI4 $327
line 644
;644:			classname = "team_CTF_bluespawn";
ADDRLP4 8
ADDRGP4 $329
ASGNP4
ADDRGP4 $328
JUMPV
LABELV $327
line 646
;645:		else
;646:			return NULL;
CNSTP4 0
RETP4
ADDRGP4 $315
JUMPV
LABELV $328
LABELV $325
line 647
;647:	}
LABELV $317
line 648
;648:	count = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 650
;649:
;650:	spot = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
ADDRGP4 $331
JUMPV
LABELV $330
line 652
;651:
;652:	while ((spot = G_Find (spot, FOFS(classname), classname)) != NULL) {
line 653
;653:		if ( SpotWouldTelefrag( spot ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 80
ADDRGP4 SpotWouldTelefrag
CALLI4
ASGNI4
ADDRLP4 80
INDIRI4
CNSTI4 0
EQI4 $333
line 654
;654:			continue;
ADDRGP4 $331
JUMPV
LABELV $333
line 656
;655:		}
;656:		spots[ count ] = spot;
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 12
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 657
;657:		if (++count == MAX_TEAM_SPAWN_POINTS)
ADDRLP4 84
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
ADDRLP4 84
INDIRI4
ASGNI4
ADDRLP4 84
INDIRI4
CNSTI4 16
NEI4 $335
line 658
;658:			break;
ADDRGP4 $332
JUMPV
LABELV $335
line 659
;659:	}
LABELV $331
line 652
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 512
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 80
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 80
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $330
LABELV $332
line 661
;660:
;661:	if ( !count ) {	// no spots that won't telefrag
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $337
line 662
;662:		return G_Find( NULL, FOFS(classname), classname);
CNSTP4 0
ARGP4
CNSTI4 512
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 84
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 84
INDIRP4
RETP4
ADDRGP4 $315
JUMPV
LABELV $337
line 665
;663:	}
;664:
;665:	selection = rand() % count;
ADDRLP4 84
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 76
ADDRLP4 84
INDIRI4
ADDRLP4 4
INDIRI4
MODI4
ASGNI4
line 666
;666:	return spots[ selection ];
ADDRLP4 76
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 12
ADDP4
INDIRP4
RETP4
LABELV $315
endproc SelectRandomTeamSpawnPoint 88 12
export SelectCTFSpawnPoint
proc SelectCTFSpawnPoint 12 12
line 676
;667:}
;668:
;669:
;670:/*
;671:===========
;672:SelectCTFSpawnPoint
;673:
;674:============
;675:*/
;676:gentity_t *SelectCTFSpawnPoint ( team_t team, int teamstate, vec3_t origin, vec3_t angles ) {
line 679
;677:	gentity_t	*spot;
;678:
;679:	spot = SelectRandomTeamSpawnPoint ( teamstate, team );
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 4
ADDRGP4 SelectRandomTeamSpawnPoint
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 681
;680:
;681:	if (!spot) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $340
line 682
;682:		return SelectSpawnPoint( vec3_origin, origin, angles );
ADDRGP4 vec3_origin
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 SelectSpawnPoint
CALLP4
ASGNP4
ADDRLP4 8
INDIRP4
RETP4
ADDRGP4 $339
JUMPV
LABELV $340
line 685
;683:	}
;684:
;685:	VectorCopy (spot->s.origin, origin);
ADDRFP4 8
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 686
;686:	origin[2] += 9;
ADDRLP4 8
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CNSTF4 1091567616
ADDF4
ASGNF4
line 687
;687:	VectorCopy (spot->s.angles, angles);
ADDRFP4 12
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRB
ASGNB 12
line 689
;688:
;689:	return spot;
ADDRLP4 0
INDIRP4
RETP4
LABELV $339
endproc SelectCTFSpawnPoint 12 12
proc SortClients 0 0
line 694
;690:}
;691:
;692:/*---------------------------------------------------------------------------*/
;693:
;694:static int QDECL SortClients( const void *a, const void *b ) {
line 695
;695:	return *(int *)a - *(int *)b;
ADDRFP4 0
INDIRP4
INDIRI4
ADDRFP4 4
INDIRP4
INDIRI4
SUBI4
RETI4
LABELV $342
endproc SortClients 0 0
export TeamplayInfoMessage
proc TeamplayInfoMessage 2516 36
line 708
;696:}
;697:
;698:
;699:/*
;700:==================
;701:TeamplayLocationsMessage
;702:
;703:Format:
;704:	clientNum location health armor weapon powerups
;705:
;706:==================
;707:*/
;708:void TeamplayInfoMessage( gentity_t *ent ) {
line 718
;709:	char		entry[1024];
;710:	char		string[1400];
;711:	int			stringlength;
;712:	int			i, j;
;713:	gentity_t	*player;
;714:	int			cnt;
;715:	int			h, a;
;716:	int			clients[TEAM_MAXOVERLAY];
;717:
;718:	if ( ! ent->client->pers.teamInfo )
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 580
ADDP4
INDIRI4
CNSTI4 0
NEI4 $344
line 719
;719:		return;
ADDRGP4 $343
JUMPV
LABELV $344
line 724
;720:
;721:	// figure out what client should be on the display
;722:	// we are limited to 8, but we want to use the top eight players
;723:	// but in client order (so they don't keep changing position on the overlay)
;724:	for (i = 0, cnt = 0; i < g_maxclients.integer && cnt < TEAM_MAXOVERLAY; i++) {
ADDRLP4 2484
CNSTI4 0
ASGNI4
ADDRLP4 4
ADDRLP4 2484
INDIRI4
ASGNI4
ADDRLP4 8
ADDRLP4 2484
INDIRI4
ASGNI4
ADDRGP4 $349
JUMPV
LABELV $346
line 725
;725:		player = g_entities + level.sortedClients[i];
ADDRLP4 0
CNSTI4 792
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 level+84
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 726
;726:		if (player->inuse && player->client->sess.sessionTeam == 
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
EQI4 $352
ADDRLP4 2492
CNSTI4 504
ASGNI4
ADDRLP4 2496
CNSTI4 592
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 2492
INDIRI4
ADDP4
INDIRP4
ADDRLP4 2496
INDIRI4
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
ADDRLP4 2492
INDIRI4
ADDP4
INDIRP4
ADDRLP4 2496
INDIRI4
ADDP4
INDIRI4
NEI4 $352
line 727
;727:			ent->client->sess.sessionTeam ) {
line 728
;728:			clients[cnt++] = level.sortedClients[i];
ADDRLP4 2500
ADDRLP4 8
INDIRI4
ASGNI4
ADDRLP4 8
ADDRLP4 2500
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 2504
CNSTI4 2
ASGNI4
ADDRLP4 2500
INDIRI4
ADDRLP4 2504
INDIRI4
LSHI4
ADDRLP4 2452
ADDP4
ADDRLP4 4
INDIRI4
ADDRLP4 2504
INDIRI4
LSHI4
ADDRGP4 level+84
ADDP4
INDIRI4
ASGNI4
line 729
;729:		}
LABELV $352
line 730
;730:	}
LABELV $347
line 724
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $349
ADDRLP4 4
INDIRI4
ADDRGP4 g_maxclients+12
INDIRI4
GEI4 $355
ADDRLP4 8
INDIRI4
CNSTI4 8
LTI4 $346
LABELV $355
line 733
;731:
;732:	// We have the top eight players, sort them by clientNum
;733:	qsort( clients, cnt, sizeof( clients[0] ), SortClients );
ADDRLP4 2452
ARGP4
ADDRLP4 8
INDIRI4
CVIU4 4
ARGU4
CNSTU4 4
ARGU4
ADDRGP4 SortClients
ARGP4
ADDRGP4 qsort
CALLV
pop
line 736
;734:
;735:	// send the latest information on all clients
;736:	string[0] = 0;
ADDRLP4 1052
CNSTI1 0
ASGNI1
line 737
;737:	stringlength = 0;
ADDRLP4 1044
CNSTI4 0
ASGNI4
line 739
;738:
;739:	for (i = 0, cnt = 0; i < g_maxclients.integer && cnt < TEAM_MAXOVERLAY; i++) {
ADDRLP4 2488
CNSTI4 0
ASGNI4
ADDRLP4 4
ADDRLP4 2488
INDIRI4
ASGNI4
ADDRLP4 8
ADDRLP4 2488
INDIRI4
ASGNI4
ADDRGP4 $359
JUMPV
LABELV $356
line 740
;740:		player = g_entities + i;
ADDRLP4 0
CNSTI4 792
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 741
;741:		if (player->inuse && player->client->sess.sessionTeam == 
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
EQI4 $361
ADDRLP4 2496
CNSTI4 504
ASGNI4
ADDRLP4 2500
CNSTI4 592
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 2496
INDIRI4
ADDP4
INDIRP4
ADDRLP4 2500
INDIRI4
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
ADDRLP4 2496
INDIRI4
ADDP4
INDIRP4
ADDRLP4 2500
INDIRI4
ADDP4
INDIRI4
NEI4 $361
line 742
;742:			ent->client->sess.sessionTeam ) {
line 744
;743:
;744:			h = player->client->ps.stats[STAT_HEALTH];
ADDRLP4 1036
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ASGNI4
line 745
;745:			a = player->client->ps.stats[STAT_ARMOR];
ADDRLP4 1040
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
ASGNI4
line 746
;746:			if (h < 0) h = 0;
ADDRLP4 1036
INDIRI4
CNSTI4 0
GEI4 $363
ADDRLP4 1036
CNSTI4 0
ASGNI4
LABELV $363
line 747
;747:			if (a < 0) a = 0;
ADDRLP4 1040
INDIRI4
CNSTI4 0
GEI4 $365
ADDRLP4 1040
CNSTI4 0
ASGNI4
LABELV $365
line 749
;748:
;749:			Com_sprintf (entry, sizeof(entry),
ADDRLP4 12
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $367
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 2508
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 2508
INDIRP4
CNSTI4 532
ADDP4
INDIRI4
ARGI4
ADDRLP4 1036
INDIRI4
ARGI4
ADDRLP4 1040
INDIRI4
ARGI4
ADDRLP4 2508
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 754
;750:				" %i %i %i %i %i %i", 
;751://				level.sortedClients[i], player->client->pers.teamState.location, h, a, 
;752:				i, player->client->pers.teamState.location, h, a, 
;753:				player->client->ps.weapon, player->s.powerups);
;754:			j = strlen(entry);
ADDRLP4 12
ARGP4
ADDRLP4 2512
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1048
ADDRLP4 2512
INDIRU4
CVUI4 4
ASGNI4
line 755
;755:			if (stringlength + j > sizeof(string))
ADDRLP4 1044
INDIRI4
ADDRLP4 1048
INDIRI4
ADDI4
CVIU4 4
CNSTU4 1400
LEU4 $368
line 756
;756:				break;
ADDRGP4 $358
JUMPV
LABELV $368
line 757
;757:			strcpy (string + stringlength, entry);
ADDRLP4 1044
INDIRI4
ADDRLP4 1052
ADDP4
ARGP4
ADDRLP4 12
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 758
;758:			stringlength += j;
ADDRLP4 1044
ADDRLP4 1044
INDIRI4
ADDRLP4 1048
INDIRI4
ADDI4
ASGNI4
line 759
;759:			cnt++;
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 760
;760:		}
LABELV $361
line 761
;761:	}
LABELV $357
line 739
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $359
ADDRLP4 4
INDIRI4
ADDRGP4 g_maxclients+12
INDIRI4
GEI4 $370
ADDRLP4 8
INDIRI4
CNSTI4 8
LTI4 $356
LABELV $370
LABELV $358
line 763
;762:
;763:	trap_SendServerCommand( ent-g_entities, va("tinfo %i%s", cnt, string) );
ADDRGP4 $371
ARGP4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 1052
ARGP4
ADDRLP4 2492
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 2492
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 764
;764:}
LABELV $343
endproc TeamplayInfoMessage 2516 36
export CheckTeamStatus
proc CheckTeamStatus 24 4
line 767
;765:
;766:void CheckTeamStatus(void)
;767:{
line 771
;768:	int i;
;769:	gentity_t *loc, *ent;
;770:
;771:	if (level.time - level.lastTeamLocationTime > TEAM_LOCATION_UPDATE_TIME) {
ADDRGP4 level+32
INDIRI4
ADDRGP4 level+60
INDIRI4
SUBI4
CNSTI4 1000
LEI4 $373
line 773
;772:
;773:		level.lastTeamLocationTime = level.time;
ADDRGP4 level+60
ADDRGP4 level+32
INDIRI4
ASGNI4
line 775
;774:
;775:		for (i = 0; i < g_maxclients.integer; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $382
JUMPV
LABELV $379
line 776
;776:			ent = g_entities + i;
ADDRLP4 0
CNSTI4 792
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 777
;777:			if (ent->inuse && 
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
EQI4 $384
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 1
EQI4 $386
ADDRLP4 16
INDIRI4
CNSTI4 2
NEI4 $384
LABELV $386
line 779
;778:				(ent->client->sess.sessionTeam == TEAM_RED ||
;779:				ent->client->sess.sessionTeam == TEAM_BLUE)) {
line 780
;780:				loc = Team_GetLocation( ent );
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 Team_GetLocation
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 20
INDIRP4
ASGNP4
line 781
;781:				if (loc)
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $387
line 782
;782:					ent->client->pers.teamState.location = loc->health;
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 532
ADDP4
ADDRLP4 8
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ASGNI4
ADDRGP4 $388
JUMPV
LABELV $387
line 784
;783:				else
;784:					ent->client->pers.teamState.location = 0;
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 532
ADDP4
CNSTI4 0
ASGNI4
LABELV $388
line 785
;785:			}
LABELV $384
line 786
;786:		}
LABELV $380
line 775
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $382
ADDRLP4 4
INDIRI4
ADDRGP4 g_maxclients+12
INDIRI4
LTI4 $379
line 788
;787:
;788:		for (i = 0; i < g_maxclients.integer; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $392
JUMPV
LABELV $389
line 789
;789:			ent = g_entities + i;
ADDRLP4 0
CNSTI4 792
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 790
;790:			if (ent->inuse && 
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
EQI4 $394
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 1
EQI4 $396
ADDRLP4 16
INDIRI4
CNSTI4 2
NEI4 $394
LABELV $396
line 792
;791:				(ent->client->sess.sessionTeam == TEAM_RED ||
;792:				ent->client->sess.sessionTeam == TEAM_BLUE)) {
line 793
;793:				TeamplayInfoMessage( ent );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 TeamplayInfoMessage
CALLV
pop
line 794
;794:			}
LABELV $394
line 795
;795:		}
LABELV $390
line 788
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $392
ADDRLP4 4
INDIRI4
ADDRGP4 g_maxclients+12
INDIRI4
LTI4 $389
line 796
;796:	}
LABELV $373
line 797
;797:}
LABELV $372
endproc CheckTeamStatus 24 4
export SP_team_CTF_redplayer
proc SP_team_CTF_redplayer 0 0
line 804
;798:
;799:/*-----------------------------------------------------------------*/
;800:
;801:/*QUAKED team_CTF_redplayer (1 0 0) (-16 -16 -16) (16 16 32)
;802:Only in CTF games.  Red players spawn here at game start.
;803:*/
;804:void SP_team_CTF_redplayer( gentity_t *ent ) {
line 805
;805:}
LABELV $397
endproc SP_team_CTF_redplayer 0 0
export SP_team_CTF_blueplayer
proc SP_team_CTF_blueplayer 0 0
line 811
;806:
;807:
;808:/*QUAKED team_CTF_blueplayer (0 0 1) (-16 -16 -16) (16 16 32)
;809:Only in CTF games.  Blue players spawn here at game start.
;810:*/
;811:void SP_team_CTF_blueplayer( gentity_t *ent ) {
line 812
;812:}
LABELV $398
endproc SP_team_CTF_blueplayer 0 0
export SP_team_CTF_redspawn
proc SP_team_CTF_redspawn 0 0
line 819
;813:
;814:
;815:/*QUAKED team_CTF_redspawn (1 0 0) (-16 -16 -24) (16 16 32)
;816:potential spawning position for red team in CTF games.
;817:Targets will be fired when someone spawns in on them.
;818:*/
;819:void SP_team_CTF_redspawn(gentity_t *ent) {
line 820
;820:}
LABELV $399
endproc SP_team_CTF_redspawn 0 0
export SP_team_CTF_bluespawn
proc SP_team_CTF_bluespawn 0 0
line 826
;821:
;822:/*QUAKED team_CTF_bluespawn (0 0 1) (-16 -16 -24) (16 16 32)
;823:potential spawning position for blue team in CTF games.
;824:Targets will be fired when someone spawns in on them.
;825:*/
;826:void SP_team_CTF_bluespawn(gentity_t *ent) {
line 827
;827:}
LABELV $400
endproc SP_team_CTF_bluespawn 0 0
bss
export teamgame
align 4
LABELV teamgame
skip 16
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $371
byte 1 116
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 32
byte 1 37
byte 1 105
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $367
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $329
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 115
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 0
align 1
LABELV $326
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 115
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 0
align 1
LABELV $323
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $320
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $314
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $313
byte 1 37
byte 1 99
byte 1 37
byte 1 99
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 0
align 1
LABELV $286
byte 1 68
byte 1 111
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 107
byte 1 110
byte 1 111
byte 1 119
byte 1 32
byte 1 119
byte 1 104
byte 1 97
byte 1 116
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 105
byte 1 115
byte 1 32
byte 1 111
byte 1 110
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $277
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 103
byte 1 111
byte 1 116
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $275
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 103
byte 1 101
byte 1 116
byte 1 115
byte 1 32
byte 1 97
byte 1 110
byte 1 32
byte 1 97
byte 1 115
byte 1 115
byte 1 105
byte 1 115
byte 1 116
byte 1 32
byte 1 102
byte 1 111
byte 1 114
byte 1 32
byte 1 102
byte 1 114
byte 1 97
byte 1 103
byte 1 103
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 99
byte 1 97
byte 1 114
byte 1 114
byte 1 105
byte 1 101
byte 1 114
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $271
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 103
byte 1 101
byte 1 116
byte 1 115
byte 1 32
byte 1 97
byte 1 110
byte 1 32
byte 1 97
byte 1 115
byte 1 115
byte 1 105
byte 1 115
byte 1 116
byte 1 32
byte 1 102
byte 1 111
byte 1 114
byte 1 32
byte 1 114
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $251
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 47
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 99
byte 1 97
byte 1 112
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $250
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 47
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 99
byte 1 97
byte 1 112
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $246
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 99
byte 1 97
byte 1 112
byte 1 116
byte 1 117
byte 1 114
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $242
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 114
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $226
byte 1 84
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 104
byte 1 97
byte 1 115
byte 1 32
byte 1 114
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 101
byte 1 100
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $221
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 47
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 114
byte 1 101
byte 1 116
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $220
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 47
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 114
byte 1 101
byte 1 116
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $219
byte 1 87
byte 1 97
byte 1 114
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 58
byte 1 32
byte 1 32
byte 1 78
byte 1 85
byte 1 76
byte 1 76
byte 1 32
byte 1 112
byte 1 97
byte 1 115
byte 1 115
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 84
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 82
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 83
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $195
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 115
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 39
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 99
byte 1 97
byte 1 114
byte 1 114
byte 1 105
byte 1 101
byte 1 114
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $184
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 115
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $183
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 115
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 98
byte 1 97
byte 1 115
byte 1 101
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $158
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $156
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $151
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 39
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 99
byte 1 97
byte 1 114
byte 1 114
byte 1 105
byte 1 101
byte 1 114
byte 1 32
byte 1 97
byte 1 103
byte 1 97
byte 1 105
byte 1 110
byte 1 115
byte 1 116
byte 1 32
byte 1 97
byte 1 110
byte 1 32
byte 1 97
byte 1 103
byte 1 114
byte 1 101
byte 1 115
byte 1 115
byte 1 105
byte 1 118
byte 1 101
byte 1 32
byte 1 101
byte 1 110
byte 1 101
byte 1 109
byte 1 121
byte 1 10
byte 1 0
align 1
LABELV $140
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 102
byte 1 114
byte 1 97
byte 1 103
byte 1 103
byte 1 101
byte 1 100
byte 1 32
byte 1 37
byte 1 115
byte 1 39
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 99
byte 1 97
byte 1 114
byte 1 114
byte 1 105
byte 1 101
byte 1 114
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $92
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 34
byte 1 0
align 1
LABELV $87
byte 1 80
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 77
byte 1 115
byte 1 103
byte 1 32
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 114
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $82
byte 1 94
byte 1 55
byte 1 0
align 1
LABELV $81
byte 1 94
byte 1 51
byte 1 0
align 1
LABELV $78
byte 1 94
byte 1 52
byte 1 0
align 1
LABELV $75
byte 1 94
byte 1 49
byte 1 0
align 1
LABELV $64
byte 1 70
byte 1 82
byte 1 69
byte 1 69
byte 1 0
align 1
LABELV $63
byte 1 83
byte 1 80
byte 1 69
byte 1 67
byte 1 84
byte 1 65
byte 1 84
byte 1 79
byte 1 82
byte 1 0
align 1
LABELV $60
byte 1 66
byte 1 76
byte 1 85
byte 1 69
byte 1 0
align 1
LABELV $57
byte 1 82
byte 1 69
byte 1 68
byte 1 0
